/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.BulkProcessingOptions;
import com.azure.cosmos.BulkProcessingThresholds;
import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.CosmosClient;
import com.azure.cosmos.CosmosClientBuilder;
import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.implementation.CosmosClientMetadataCachesSnapshot;
import com.azure.cosmos.implementation.CosmosPagedFluxOptions;
import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.implementation.ItemDeserializer;
import com.azure.cosmos.implementation.ResourceResponse;
import com.azure.cosmos.implementation.batch.PartitionScopeThresholds;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.implementation.spark.OperationContextAndListenerTuple;
import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.CosmosItemRequestOptions;
import com.azure.cosmos.models.CosmosItemResponse;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.util.CosmosPagedFlux;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class ImplementationBridgeHelpers {
    private static Logger logger = LoggerFactory.getLogger(ImplementationBridgeHelpers.class);

    private static <T> void ensureClassLoaded(Class<T> classType) {
        try {
            Class.forName(classType.getName());
        }
        catch (ClassNotFoundException e) {
            logger.error("cannot load class {}", (Object)classType.getName());
            throw new RuntimeException(e);
        }
    }

    public static final class CosmosDiagnosticsHelper {
        private static CosmosDiagnosticsAccessor accessor;

        private CosmosDiagnosticsHelper() {
        }

        public static void setCosmosDiagnosticsAccessor(CosmosDiagnosticsAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("CosmosDiagnosticsAccessor already initialized!");
            }
            accessor = newAccessor;
        }

        public static CosmosDiagnosticsAccessor getCosmosDiagnosticsAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("CosmosDiagnosticsAccessor is not initialized yet!");
            }
            return accessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(CosmosDiagnostics.class);
        }

        public static interface CosmosDiagnosticsAccessor {
            public AtomicBoolean isDiagnosticsCapturedInPagedFlux(CosmosDiagnostics var1);
        }
    }

    public static final class BulkProcessingThresholdsHelper {
        private static BulkProcessingThresholdsAccessor accessor;

        private BulkProcessingThresholdsHelper() {
        }

        public static void setBulkProcessingThresholdsAccessor(BulkProcessingThresholdsAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("BulkProcessingThresholds accessor already initialized!");
            }
            accessor = newAccessor;
        }

        public static BulkProcessingThresholdsAccessor getBulkProcessingThresholdsAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("BulkProcessingThresholds accessor is not initialized yet!");
            }
            return accessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(BulkProcessingThresholds.class);
        }

        public static interface BulkProcessingThresholdsAccessor {
            public <T> ConcurrentMap<String, PartitionScopeThresholds<T>> getPartitionScopeThresholds(BulkProcessingThresholds<T> var1);
        }
    }

    public static final class CosmosAsyncDatabaseHelper {
        private static CosmosAsyncDatabaseAccessor accessor;

        private CosmosAsyncDatabaseHelper() {
        }

        public static <T> void setCosmosAsyncDatabaseAccessor(CosmosAsyncDatabaseAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("CosmosAsyncDatabaseAccessor already initialized!");
            }
            accessor = newAccessor;
        }

        public static <T> CosmosAsyncDatabaseAccessor getCosmosAsyncDatabaseAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("CosmosAsyncDatabaseAccessor is not initialized yet!");
            }
            return accessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(CosmosAsyncDatabase.class);
        }

        public static interface CosmosAsyncDatabaseAccessor {
            public CosmosAsyncClient getCosmosAsyncClient(CosmosAsyncDatabase var1);
        }
    }

    public static final class CosmosPageFluxHelper {
        private static CosmosPageFluxAccessor accessor;

        private CosmosPageFluxHelper() {
        }

        public static <T> void setCosmosPageFluxAccessor(CosmosPageFluxAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("CosmosPageFluxAccessor already initialized!");
            }
            accessor = newAccessor;
        }

        public static <T> CosmosPageFluxAccessor getCosmosPageFluxAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("CosmosPageFluxAccessor is not initialized yet!");
            }
            return accessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(CosmosContainerProperties.class);
        }

        public static interface CosmosPageFluxAccessor {
            public <T> CosmosPagedFlux<T> getCosmosPagedFlux(Function<CosmosPagedFluxOptions, Flux<FeedResponse<T>>> var1);
        }
    }

    public static final class CosmosContainerPropertiesHelper {
        private static CosmosContainerPropertiesAccessor accessor;

        private CosmosContainerPropertiesHelper() {
        }

        public static void setCosmosContainerPropertiesAccessor(CosmosContainerPropertiesAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("CosmosContainerProperties already initialized!");
            }
            accessor = newAccessor;
        }

        public static CosmosContainerPropertiesAccessor getCosmosContainerPropertiesAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("CosmosContainerProperties is not initialized yet!");
            }
            return accessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(CosmosContainerProperties.class);
        }

        public static interface CosmosContainerPropertiesAccessor {
            public String getSelfLink(CosmosContainerProperties var1);
        }
    }

    public static final class CosmosClientHelper {
        private static CosmosClientAccessor accessor;

        private CosmosClientHelper() {
        }

        public static void setCosmosClientAccessor(CosmosClientAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("CosmosClient accessor already initialized!");
            }
            accessor = newAccessor;
        }

        public static CosmosClientAccessor geCosmosClientAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("CosmosClient accessor is not initialized yet!");
            }
            return accessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(CosmosClient.class);
        }

        public static interface CosmosClientAccessor {
            public CosmosAsyncClient getCosmosAsyncClient(CosmosClient var1);
        }
    }

    public static final class CosmosItemResponseHelper {
        private static CosmosItemResponseBuilderAccessor accessor;

        private CosmosItemResponseHelper() {
        }

        public static void setCosmosItemResponseBuilderAccessor(CosmosItemResponseBuilderAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("CosmosItemResponse accessor already initialized!");
            }
            accessor = newAccessor;
        }

        public static CosmosItemResponseBuilderAccessor getCosmosItemResponseBuilderAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("CosmosItemResponse accessor is not initialized yet!");
            }
            return accessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(CosmosItemResponse.class);
        }

        public static interface CosmosItemResponseBuilderAccessor {
            public <T> CosmosItemResponse<T> createCosmosItemResponse(ResourceResponse<Document> var1, byte[] var2, Class<T> var3, ItemDeserializer var4);

            public byte[] getByteArrayContent(CosmosItemResponse<byte[]> var1);

            public void setByteArrayContent(CosmosItemResponse<byte[]> var1, byte[] var2);

            public ResourceResponse<Document> getResourceResponse(CosmosItemResponse<byte[]> var1);
        }
    }

    public static final class CosmosBulkProcessingOptionsHelper {
        private static CosmosBulkProcessingOptionAccessor accessor;

        private CosmosBulkProcessingOptionsHelper() {
        }

        public static void setCosmosBulkProcessingOptionAccessor(CosmosBulkProcessingOptionAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("BulkProcessingOptions accessor already initialized!");
            }
            accessor = newAccessor;
        }

        public static CosmosBulkProcessingOptionAccessor getCosmosBulkProcessingOptionAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("BulkProcessingOptions accessor is not initialized yet!");
            }
            return accessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(BulkProcessingOptions.class);
        }

        public static interface CosmosBulkProcessingOptionAccessor {
            public <T> void setOperationContext(BulkProcessingOptions<T> var1, OperationContextAndListenerTuple var2);

            public <T> OperationContextAndListenerTuple getOperationContext(BulkProcessingOptions<T> var1);
        }
    }

    public static final class CosmosItemRequestOptionsHelper {
        private static CosmosItemRequestOptionsAccessor accessor;

        private CosmosItemRequestOptionsHelper() {
        }

        public static void setCosmosItemRequestOptionsAccessor(CosmosItemRequestOptionsAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("CosmosItemRequestOptions accessor already initialized!");
            }
            accessor = newAccessor;
        }

        public static CosmosItemRequestOptionsAccessor getCosmosItemRequestOptionsAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("CosmosItemRequestOptions accessor is not initialized yet!");
            }
            return accessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(CosmosItemRequestOptions.class);
        }

        public static interface CosmosItemRequestOptionsAccessor {
            public void setOperationContext(CosmosItemRequestOptions var1, OperationContextAndListenerTuple var2);

            public OperationContextAndListenerTuple getOperationContext(CosmosItemRequestOptions var1);

            public CosmosItemRequestOptions clone(CosmosItemRequestOptions var1);

            public CosmosItemRequestOptions setHeader(CosmosItemRequestOptions var1, String var2, String var3);

            public Map<String, String> getHeader(CosmosItemRequestOptions var1);
        }
    }

    public static final class CosmosQueryRequestOptionsHelper {
        private static CosmosQueryRequestOptionsAccessor accessor;

        private CosmosQueryRequestOptionsHelper() {
        }

        public static void setCosmosQueryRequestOptionsAccessor(CosmosQueryRequestOptionsAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("CosmosQueryRequestOptions accessor already initialized!");
            }
            accessor = newAccessor;
        }

        public static CosmosQueryRequestOptionsAccessor getCosmosQueryRequestOptionsAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("CosmosQueryRequestOptions accessor is not initialized yet!");
            }
            return accessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(CosmosQueryRequestOptions.class);
        }

        public static interface CosmosQueryRequestOptionsAccessor {
            public void setOperationContext(CosmosQueryRequestOptions var1, OperationContextAndListenerTuple var2);

            public OperationContextAndListenerTuple getOperationContext(CosmosQueryRequestOptions var1);

            public CosmosQueryRequestOptions setHeader(CosmosQueryRequestOptions var1, String var2, String var3);

            public Map<String, String> getHeader(CosmosQueryRequestOptions var1);
        }
    }

    public static final class PartitionKeyHelper {
        private static PartitionKeyAccessor accessor;

        private PartitionKeyHelper() {
        }

        public static void setPartitionKeyAccessor(PartitionKeyAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("PartitionKey accessor already initialized!");
            }
            accessor = newAccessor;
        }

        public static PartitionKeyAccessor getPartitionKeyAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("PartitionKey accessor is not initialized!");
            }
            return accessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(PartitionKey.class);
        }

        public static interface PartitionKeyAccessor {
            public PartitionKey toPartitionKey(PartitionKeyInternal var1);
        }
    }

    public static final class CosmosClientBuilderHelper {
        private static CosmosClientBuilderAccessor accessor;

        private CosmosClientBuilderHelper() {
        }

        public static void setCosmosClientBuilderAccessor(CosmosClientBuilderAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("CosmosClientBuilder accessor already initialized!");
            }
            accessor = newAccessor;
        }

        static CosmosClientBuilderAccessor getCosmosClientBuilderAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("CosmosClientBuilder accessor is not initialized yet!");
            }
            return accessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(CosmosClientBuilder.class);
        }

        public static interface CosmosClientBuilderAccessor {
            public void setCosmosClientMetadataCachesSnapshot(CosmosClientBuilder var1, CosmosClientMetadataCachesSnapshot var2);

            public CosmosClientMetadataCachesSnapshot getCosmosClientMetadataCachesSnapshot(CosmosClientBuilder var1);
        }
    }
}

