/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.HttpConstants;
import com.azure.cosmos.implementation.Utils;

public class UserAgentContainer {
    private static final int MAX_USER_AGENT_LENGTH = 255;
    private final int maxSuffixLength;
    private final String baseUserAgent;
    private String suffix;
    private String userAgent;
    public static final String AZSDK_USERAGENT_PREFIX = "azsdk-java-";

    private UserAgentContainer(String sdkName, String sdkVersion) {
        this.baseUserAgent = Utils.getUserAgent(sdkName, sdkVersion);
        this.suffix = "";
        this.userAgent = this.baseUserAgent;
        this.maxSuffixLength = 254 - this.baseUserAgent.length();
    }

    public UserAgentContainer() {
        this("cosmos", HttpConstants.Versions.SDK_VERSION);
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        if (suffix.length() > this.maxSuffixLength) {
            suffix = suffix.substring(0, this.maxSuffixLength);
        }
        this.suffix = suffix;
        this.userAgent = this.baseUserAgent.concat(" ").concat(this.suffix);
    }

    public String getUserAgent() {
        return this.userAgent;
    }
}

