/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.batch;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.TransactionalBatchOperationResult;
import com.azure.cosmos.implementation.IRetryPolicy;
import com.azure.cosmos.implementation.ResourceThrottleRetryPolicy;
import com.azure.cosmos.implementation.RetryContext;
import com.azure.cosmos.implementation.ShouldRetryResult;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.batch.BulkExecutorUtil;
import com.azure.cosmos.implementation.caches.RxCollectionCache;
import com.azure.cosmos.implementation.caches.RxPartitionKeyRangeCache;
import com.azure.cosmos.implementation.feedranges.FeedRangeEpkImpl;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import reactor.core.publisher.Mono;

final class BulkOperationRetryPolicy
implements IRetryPolicy {
    private static final int MAX_RETRIES = 1;
    private final RxCollectionCache collectionCache;
    private final RxPartitionKeyRangeCache partitionKeyRangeCache;
    private final String collectionLink;
    private final ResourceThrottleRetryPolicy resourceThrottleRetryPolicy;
    private int attemptedRetries;

    BulkOperationRetryPolicy(RxCollectionCache collectionCache, RxPartitionKeyRangeCache partitionKeyRangeCache, String resourceFullName, ResourceThrottleRetryPolicy resourceThrottleRetryPolicy) {
        this.collectionCache = collectionCache;
        this.partitionKeyRangeCache = partitionKeyRangeCache;
        this.collectionLink = Utils.getCollectionName(resourceFullName);
        this.resourceThrottleRetryPolicy = resourceThrottleRetryPolicy;
    }

    final Mono<ShouldRetryResult> shouldRetry(TransactionalBatchOperationResult result) {
        Preconditions.checkNotNull(result, "expected non-null result");
        CosmosException exception = BridgeInternal.createCosmosException(null, result.getStatusCode(), null, BulkExecutorUtil.getResponseHeadersFromBatchOperationResult(result));
        if (this.resourceThrottleRetryPolicy == null) {
            return Mono.just((Object)ShouldRetryResult.noRetry());
        }
        return this.resourceThrottleRetryPolicy.shouldRetry((Exception)((Object)exception));
    }

    @Override
    public Mono<ShouldRetryResult> shouldRetry(Exception exception) {
        if (this.resourceThrottleRetryPolicy == null) {
            return Mono.just((Object)ShouldRetryResult.noRetry());
        }
        return this.resourceThrottleRetryPolicy.shouldRetry(exception);
    }

    @Override
    public RetryContext getRetryContext() {
        return this.resourceThrottleRetryPolicy.getRetryContext();
    }

    Mono<Boolean> shouldRetryForGone(int statusCode, int subStatusCode) {
        if (statusCode == 410) {
            if (this.attemptedRetries++ > 1) {
                return Mono.just((Object)false);
            }
            if (subStatusCode == 1002 || subStatusCode == 1007 || subStatusCode == 1008) {
                return this.collectionCache.resolveByNameAsync(null, this.collectionLink, null).flatMap(collection -> this.partitionKeyRangeCache.tryGetOverlappingRangesAsync(null, collection.getResourceId(), FeedRangeEpkImpl.forFullRange().getRange(), true, null).then(Mono.just((Object)true)));
            }
            if (subStatusCode == 1000) {
                this.refreshCollectionCache();
            }
            return Mono.just((Object)true);
        }
        return Mono.just((Object)false);
    }

    private void refreshCollectionCache() {
        this.collectionCache.refresh(null, this.collectionLink, null);
    }
}

