/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.ReplicatedResourceClientUtils;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.RxDocumentServiceResponse;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternal;
import com.azure.cosmos.implementation.feedranges.FeedRangePartitionKeyImpl;
import com.azure.cosmos.implementation.query.IDocumentQueryClient;
import com.azure.cosmos.implementation.query.IDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.implementation.routing.PartitionKeyRangeIdentity;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.FeedRange;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.SqlParameter;
import com.azure.cosmos.models.SqlQuerySpec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class DocumentQueryExecutionContextBase<T extends Resource>
implements IDocumentQueryExecutionContext<T> {
    protected final DiagnosticsClientContext diagnosticsClientContext;
    protected ResourceType resourceTypeEnum;
    protected String resourceLink;
    protected IDocumentQueryClient client;
    protected Class<T> resourceType;
    protected CosmosQueryRequestOptions cosmosQueryRequestOptions;
    protected SqlQuerySpec query;
    protected UUID correlatedActivityId;
    protected boolean shouldExecuteQueryRequest;

    protected DocumentQueryExecutionContextBase(DiagnosticsClientContext diagnosticsClientContext, IDocumentQueryClient client, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec query, CosmosQueryRequestOptions cosmosQueryRequestOptions, String resourceLink, boolean getLazyFeedResponse, UUID correlatedActivityId) {
        this.client = client;
        this.resourceTypeEnum = resourceTypeEnum;
        this.resourceType = resourceType;
        this.query = query;
        this.shouldExecuteQueryRequest = query != null;
        this.cosmosQueryRequestOptions = cosmosQueryRequestOptions;
        this.resourceLink = resourceLink;
        this.correlatedActivityId = correlatedActivityId;
        this.diagnosticsClientContext = diagnosticsClientContext;
    }

    @Override
    public abstract Flux<FeedResponse<T>> executeAsync();

    public RxDocumentServiceRequest createDocumentServiceRequest(Map<String, String> requestHeaders, SqlQuerySpec querySpec, PartitionKeyInternal partitionKey) {
        RxDocumentServiceRequest request = querySpec != null ? this.createQueryDocumentServiceRequest(requestHeaders, querySpec) : this.createReadFeedDocumentServiceRequest(requestHeaders);
        this.populatePartitionKeyInfo(request, partitionKey);
        return request;
    }

    protected RxDocumentServiceRequest createDocumentServiceRequest(Map<String, String> requestHeaders, SqlQuerySpec querySpec, PartitionKeyInternal partitionKeyInternal, PartitionKeyRange targetRange, String collectionRid, String throughputControlGroup) {
        RxDocumentServiceRequest request = querySpec != null ? this.createQueryDocumentServiceRequest(requestHeaders, querySpec) : this.createReadFeedDocumentServiceRequest(requestHeaders);
        request.requestContext.resolvedCollectionRid = collectionRid;
        request.throughputControlGroupName = throughputControlGroup;
        if (partitionKeyInternal != null) {
            request.setPartitionKeyInternal(partitionKeyInternal);
        }
        this.populatePartitionKeyRangeInfo(request, targetRange, collectionRid);
        return request;
    }

    protected RxDocumentServiceRequest createDocumentServiceRequestWithFeedRange(Map<String, String> requestHeaders, SqlQuerySpec querySpec, PartitionKeyInternal partitionKeyInternal, FeedRange feedRange, String collectionRid, String throughputControlGroupName) {
        RxDocumentServiceRequest request = querySpec != null ? this.createQueryDocumentServiceRequest(requestHeaders, querySpec) : this.createReadFeedDocumentServiceRequest(requestHeaders);
        request.requestContext.resolvedCollectionRid = collectionRid;
        request.throughputControlGroupName = throughputControlGroupName;
        if (partitionKeyInternal != null) {
            feedRange = new FeedRangePartitionKeyImpl(partitionKeyInternal);
        }
        request.applyFeedRangeFilter(FeedRangeInternal.convert(feedRange));
        return request;
    }

    public Mono<FeedResponse<T>> executeRequestAsync(RxDocumentServiceRequest request) {
        return this.shouldExecuteQueryRequest ? this.executeQueryRequestAsync(request) : this.executeReadFeedRequestAsync(request);
    }

    public Mono<FeedResponse<T>> executeQueryRequestAsync(RxDocumentServiceRequest request) {
        return this.getFeedResponse(this.executeQueryRequestInternalAsync(request));
    }

    public Mono<FeedResponse<T>> executeReadFeedRequestAsync(RxDocumentServiceRequest request) {
        return this.getFeedResponse(this.client.readFeedAsync(request));
    }

    protected Mono<FeedResponse<T>> getFeedResponse(Mono<RxDocumentServiceResponse> response) {
        return response.map(resp -> BridgeInternal.toFeedResponsePage(resp, this.resourceType));
    }

    public CosmosQueryRequestOptions getFeedOptions(String continuationToken, Integer maxPageSize) {
        CosmosQueryRequestOptions options = ModelBridgeInternal.createQueryRequestOptions(this.cosmosQueryRequestOptions);
        ModelBridgeInternal.setQueryRequestOptionsContinuationTokenAndMaxItemCount(options, continuationToken, maxPageSize);
        return options;
    }

    private Mono<RxDocumentServiceResponse> executeQueryRequestInternalAsync(RxDocumentServiceRequest request) {
        return this.client.executeQueryAsync(request);
    }

    public Map<String, String> createCommonHeadersAsync(CosmosQueryRequestOptions cosmosQueryRequestOptions) {
        Map<String, String> customOptions;
        boolean sessionTokenApplicable;
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        ConsistencyLevel defaultConsistencyLevel = this.client.getDefaultConsistencyLevelAsync();
        ConsistencyLevel desiredConsistencyLevel = cosmosQueryRequestOptions.getConsistencyLevel() != null ? cosmosQueryRequestOptions.getConsistencyLevel() : this.client.getDesiredConsistencyLevelAsync();
        boolean bl = sessionTokenApplicable = desiredConsistencyLevel == ConsistencyLevel.SESSION || defaultConsistencyLevel == ConsistencyLevel.SESSION && this.resourceTypeEnum == ResourceType.Document;
        if (!Strings.isNullOrEmpty(cosmosQueryRequestOptions.getSessionToken()) && !ReplicatedResourceClientUtils.isReadingFromMaster(this.resourceTypeEnum, OperationType.ReadFeed) && sessionTokenApplicable) {
            requestHeaders.put("x-ms-session-token", cosmosQueryRequestOptions.getSessionToken());
        }
        if ((customOptions = ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor().getHeader(cosmosQueryRequestOptions)) != null) {
            requestHeaders.putAll(customOptions);
        }
        requestHeaders.put("x-ms-continuation", ModelBridgeInternal.getRequestContinuationFromQueryRequestOptions(cosmosQueryRequestOptions));
        requestHeaders.put("x-ms-documentdb-isquery", Strings.toString(true));
        Integer maxItemCount = ModelBridgeInternal.getMaxItemCountFromQueryRequestOptions(cosmosQueryRequestOptions);
        if (maxItemCount != null && maxItemCount > 0) {
            requestHeaders.put("x-ms-max-item-count", Strings.toString(maxItemCount));
        }
        if (cosmosQueryRequestOptions.getMaxDegreeOfParallelism() != 0) {
            requestHeaders.put("x-ms-documentdb-query-parallelizecrosspartitionquery", Strings.toString(true));
        }
        if (this.cosmosQueryRequestOptions.getResponseContinuationTokenLimitInKb() > 0) {
            requestHeaders.put("x-ms-documentdb-responsecontinuationtokenlimitinkb", Strings.toString(cosmosQueryRequestOptions.getResponseContinuationTokenLimitInKb()));
        }
        if (desiredConsistencyLevel != null) {
            requestHeaders.put("x-ms-consistency-level", desiredConsistencyLevel.toString());
        }
        if (cosmosQueryRequestOptions.isQueryMetricsEnabled()) {
            requestHeaders.put("x-ms-documentdb-populatequerymetrics", String.valueOf(cosmosQueryRequestOptions.isQueryMetricsEnabled()));
        }
        if (cosmosQueryRequestOptions.getDedicatedGatewayRequestOptions() != null && cosmosQueryRequestOptions.getDedicatedGatewayRequestOptions().getMaxIntegratedCacheStaleness() != null) {
            requestHeaders.put("x-ms-dedicatedgateway-max-age", String.valueOf(Utils.getMaxIntegratedCacheStalenessInMillis(cosmosQueryRequestOptions.getDedicatedGatewayRequestOptions())));
        }
        return requestHeaders;
    }

    private void populatePartitionKeyInfo(RxDocumentServiceRequest request, PartitionKeyInternal partitionKey) {
        if (request == null) {
            throw new NullPointerException("request");
        }
        if (this.resourceTypeEnum.isPartitioned() && partitionKey != null) {
            request.setPartitionKeyInternal(partitionKey);
            request.getHeaders().put("x-ms-documentdb-partitionkey", partitionKey.toJson());
        }
    }

    public void populatePartitionKeyRangeInfo(RxDocumentServiceRequest request, PartitionKeyRange range, String collectionRid) {
        if (request == null) {
            throw new NullPointerException("request");
        }
        if (range == null) {
            throw new NullPointerException("range");
        }
        if (this.resourceTypeEnum.isPartitioned()) {
            boolean hasPartitionKey;
            boolean bl = hasPartitionKey = request.getHeaders().get("x-ms-documentdb-partitionkey") != null;
            if (!hasPartitionKey) {
                request.routeTo(new PartitionKeyRangeIdentity(collectionRid, range.getId()));
            }
        }
    }

    private RxDocumentServiceRequest createQueryDocumentServiceRequest(Map<String, String> requestHeaders, SqlQuerySpec querySpec) {
        RxDocumentServiceRequest executeQueryRequest;
        switch (this.client.getQueryCompatibilityMode()) {
            case SqlQuery: {
                List<SqlParameter> params = querySpec.getParameters();
                Utils.checkStateOrThrow(params.size() > 0, "query.parameters", "Unsupported argument in query compatibility mode '%s'", this.client.getQueryCompatibilityMode().toString());
                executeQueryRequest = RxDocumentServiceRequest.create(this.diagnosticsClientContext, OperationType.SqlQuery, this.resourceTypeEnum, this.resourceLink, requestHeaders);
                executeQueryRequest.getHeaders().put("Content-Type", "application/json");
                executeQueryRequest.setContentBytes(Utils.getUTF8Bytes(querySpec.getQueryText()));
                break;
            }
            default: {
                executeQueryRequest = RxDocumentServiceRequest.create(this.diagnosticsClientContext, OperationType.Query, this.resourceTypeEnum, this.resourceLink, requestHeaders);
                executeQueryRequest.getHeaders().put("Content-Type", "application/query+json");
                executeQueryRequest.setByteBuffer(ModelBridgeInternal.serializeJsonToByteBuffer(querySpec));
            }
        }
        return executeQueryRequest;
    }

    private RxDocumentServiceRequest createReadFeedDocumentServiceRequest(Map<String, String> requestHeaders) {
        if (this.resourceTypeEnum == ResourceType.Database || this.resourceTypeEnum == ResourceType.Offer) {
            return RxDocumentServiceRequest.create(this.diagnosticsClientContext, OperationType.ReadFeed, null, this.resourceTypeEnum, requestHeaders);
        }
        return RxDocumentServiceRequest.create(this.diagnosticsClientContext, OperationType.ReadFeed, this.resourceTypeEnum, this.resourceLink, requestHeaders);
    }
}

