/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.BulkItemRequestOptions;
import com.azure.cosmos.BulkPatchItemRequestOptions;
import com.azure.cosmos.CosmosItemOperation;
import com.azure.cosmos.CosmosItemOperationType;
import com.azure.cosmos.CosmosPatchOperations;
import com.azure.cosmos.implementation.batch.ItemBulkOperation;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.util.Beta;

@Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
public final class BulkOperations {
    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static <T> CosmosItemOperation getCreateItemOperation(T item, PartitionKey partitionKey) {
        Preconditions.checkNotNull(item, "expected non-null item");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        return BulkOperations.getCreateItemOperation(item, partitionKey, new BulkItemRequestOptions(), null);
    }

    @Beta(value=Beta.SinceVersion.V4_18_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static <T, TContext> CosmosItemOperation getCreateItemOperation(T item, PartitionKey partitionKey, TContext context) {
        Preconditions.checkNotNull(item, "expected non-null item");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        return BulkOperations.getCreateItemOperation(item, partitionKey, new BulkItemRequestOptions(), context);
    }

    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static <T> CosmosItemOperation getCreateItemOperation(T item, PartitionKey partitionKey, BulkItemRequestOptions requestOptions) {
        Preconditions.checkNotNull(item, "expected non-null item");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        return BulkOperations.getCreateItemOperation(item, partitionKey, requestOptions, null);
    }

    @Beta(value=Beta.SinceVersion.V4_18_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static <T, TContext> CosmosItemOperation getCreateItemOperation(T item, PartitionKey partitionKey, BulkItemRequestOptions requestOptions, TContext context) {
        Preconditions.checkNotNull(item, "expected non-null item");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        if (requestOptions == null) {
            requestOptions = new BulkItemRequestOptions();
        }
        return new ItemBulkOperation<T, TContext>(CosmosItemOperationType.CREATE, null, partitionKey, requestOptions.toRequestOptions(), item, context);
    }

    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static CosmosItemOperation getDeleteItemOperation(String id, PartitionKey partitionKey) {
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        return BulkOperations.getDeleteItemOperation(id, partitionKey, new BulkItemRequestOptions());
    }

    @Beta(value=Beta.SinceVersion.V4_18_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static <TContext> CosmosItemOperation getDeleteItemOperation(String id, PartitionKey partitionKey, TContext context) {
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        return BulkOperations.getDeleteItemOperation(id, partitionKey, new BulkItemRequestOptions(), context);
    }

    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static CosmosItemOperation getDeleteItemOperation(String id, PartitionKey partitionKey, BulkItemRequestOptions requestOptions) {
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        if (requestOptions == null) {
            requestOptions = new BulkItemRequestOptions();
        }
        return BulkOperations.getDeleteItemOperation(id, partitionKey, requestOptions, null);
    }

    @Beta(value=Beta.SinceVersion.V4_18_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static <TContext> CosmosItemOperation getDeleteItemOperation(String id, PartitionKey partitionKey, BulkItemRequestOptions requestOptions, TContext context) {
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        if (requestOptions == null) {
            requestOptions = new BulkItemRequestOptions();
        }
        return new ItemBulkOperation<Object, TContext>(CosmosItemOperationType.DELETE, id, partitionKey, requestOptions.toRequestOptions(), null, context);
    }

    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static CosmosItemOperation getReadItemOperation(String id, PartitionKey partitionKey) {
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        return BulkOperations.getReadItemOperation(id, partitionKey, new BulkItemRequestOptions(), null);
    }

    @Beta(value=Beta.SinceVersion.V4_18_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static <TContext> CosmosItemOperation getReadItemOperation(String id, PartitionKey partitionKey, TContext context) {
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        return BulkOperations.getReadItemOperation(id, partitionKey, new BulkItemRequestOptions(), context);
    }

    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static CosmosItemOperation getReadItemOperation(String id, PartitionKey partitionKey, BulkItemRequestOptions requestOptions) {
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        return BulkOperations.getReadItemOperation(id, partitionKey, requestOptions, null);
    }

    @Beta(value=Beta.SinceVersion.V4_18_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static <TContext> CosmosItemOperation getReadItemOperation(String id, PartitionKey partitionKey, BulkItemRequestOptions requestOptions, TContext context) {
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        if (requestOptions == null) {
            requestOptions = new BulkItemRequestOptions();
        }
        return new ItemBulkOperation<Object, TContext>(CosmosItemOperationType.READ, id, partitionKey, requestOptions.toRequestOptions(), null, context);
    }

    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static <T> CosmosItemOperation getReplaceItemOperation(String id, T item, PartitionKey partitionKey) {
        Preconditions.checkNotNull(item, "expected non-null item");
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        return BulkOperations.getReplaceItemOperation(id, item, partitionKey, new BulkItemRequestOptions(), null);
    }

    @Beta(value=Beta.SinceVersion.V4_18_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static <T, TContext> CosmosItemOperation getReplaceItemOperation(String id, T item, PartitionKey partitionKey, TContext context) {
        Preconditions.checkNotNull(item, "expected non-null item");
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        return BulkOperations.getReplaceItemOperation(id, item, partitionKey, new BulkItemRequestOptions(), context);
    }

    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static <T> CosmosItemOperation getReplaceItemOperation(String id, T item, PartitionKey partitionKey, BulkItemRequestOptions requestOptions) {
        Preconditions.checkNotNull(item, "expected non-null item");
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        return BulkOperations.getReplaceItemOperation(id, item, partitionKey, requestOptions, null);
    }

    @Beta(value=Beta.SinceVersion.V4_18_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static <T, TContext> CosmosItemOperation getReplaceItemOperation(String id, T item, PartitionKey partitionKey, BulkItemRequestOptions requestOptions, TContext context) {
        Preconditions.checkNotNull(item, "expected non-null item");
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        if (requestOptions == null) {
            requestOptions = new BulkItemRequestOptions();
        }
        return new ItemBulkOperation<T, TContext>(CosmosItemOperationType.REPLACE, id, partitionKey, requestOptions.toRequestOptions(), item, context);
    }

    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static <T> CosmosItemOperation getUpsertItemOperation(T item, PartitionKey partitionKey) {
        Preconditions.checkNotNull(item, "expected non-null item");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        return BulkOperations.getUpsertItemOperation(item, partitionKey, new BulkItemRequestOptions(), null);
    }

    @Beta(value=Beta.SinceVersion.V4_18_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static <T, TContext> CosmosItemOperation getUpsertItemOperation(T item, PartitionKey partitionKey, TContext context) {
        Preconditions.checkNotNull(item, "expected non-null item");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        return BulkOperations.getUpsertItemOperation(item, partitionKey, new BulkItemRequestOptions(), context);
    }

    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static <T> CosmosItemOperation getUpsertItemOperation(T item, PartitionKey partitionKey, BulkItemRequestOptions requestOptions) {
        Preconditions.checkNotNull(item, "expected non-null item");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        return BulkOperations.getUpsertItemOperation(item, partitionKey, requestOptions, null);
    }

    @Beta(value=Beta.SinceVersion.V4_18_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static <T, TContext> CosmosItemOperation getUpsertItemOperation(T item, PartitionKey partitionKey, BulkItemRequestOptions requestOptions, TContext context) {
        Preconditions.checkNotNull(item, "expected non-null item");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        if (requestOptions == null) {
            requestOptions = new BulkItemRequestOptions();
        }
        return new ItemBulkOperation<T, TContext>(CosmosItemOperationType.UPSERT, null, partitionKey, requestOptions.toRequestOptions(), item, context);
    }

    @Beta(value=Beta.SinceVersion.V4_11_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static CosmosItemOperation getPatchItemOperation(String id, PartitionKey partitionKey, CosmosPatchOperations cosmosPatchOperations) {
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        Preconditions.checkNotNull(cosmosPatchOperations, "expected non-null cosmosPatchOperations");
        return BulkOperations.getPatchItemOperation(id, partitionKey, cosmosPatchOperations, new BulkPatchItemRequestOptions(), null);
    }

    @Beta(value=Beta.SinceVersion.V4_18_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static <TContext> CosmosItemOperation getPatchItemOperation(String id, PartitionKey partitionKey, CosmosPatchOperations cosmosPatchOperations, TContext context) {
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        Preconditions.checkNotNull(cosmosPatchOperations, "expected non-null cosmosPatchOperations");
        return BulkOperations.getPatchItemOperation(id, partitionKey, cosmosPatchOperations, new BulkPatchItemRequestOptions(), context);
    }

    @Beta(value=Beta.SinceVersion.V4_11_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static CosmosItemOperation getPatchItemOperation(String id, PartitionKey partitionKey, CosmosPatchOperations cosmosPatchOperations, BulkPatchItemRequestOptions requestOptions) {
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        Preconditions.checkNotNull(cosmosPatchOperations, "expected non-null cosmosPatchOperations");
        return BulkOperations.getPatchItemOperation(id, partitionKey, cosmosPatchOperations, requestOptions, null);
    }

    @Beta(value=Beta.SinceVersion.V4_18_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static <TContext> CosmosItemOperation getPatchItemOperation(String id, PartitionKey partitionKey, CosmosPatchOperations cosmosPatchOperations, BulkPatchItemRequestOptions requestOptions, TContext context) {
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        Preconditions.checkNotNull(cosmosPatchOperations, "expected non-null cosmosPatchOperations");
        if (requestOptions == null) {
            requestOptions = new BulkPatchItemRequestOptions();
        }
        return new ItemBulkOperation<CosmosPatchOperations, TContext>(CosmosItemOperationType.PATCH, id, partitionKey, requestOptions.toRequestOptions(), cosmosPatchOperations, context);
    }
}

