/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.directconnectivity.Protocol;
import com.azure.cosmos.implementation.guava25.base.MoreObjects;
import com.azure.cosmos.implementation.guava25.base.Strings;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.time.Duration;
import java.util.Locale;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configs {
    private static final Logger logger = LoggerFactory.getLogger(Configs.class);
    private final SslContext sslContext = this.sslContextInit();
    private static final String PROTOCOL_ENVIRONMENT_VARIABLE = "AZURE_COSMOS_DIRECT_MODE_PROTOCOL";
    private static final String PROTOCOL_PROPERTY = "azure.cosmos.directModeProtocol";
    private static final Protocol DEFAULT_PROTOCOL = Protocol.TCP;
    private static final String UNAVAILABLE_LOCATIONS_EXPIRATION_TIME_IN_SECONDS = "COSMOS.UNAVAILABLE_LOCATIONS_EXPIRATION_TIME_IN_SECONDS";
    private static final String GLOBAL_ENDPOINT_MANAGER_INITIALIZATION_TIME_IN_SECONDS = "COSMOS.GLOBAL_ENDPOINT_MANAGER_MAX_INIT_TIME_IN_SECONDS";
    private static final String MAX_HTTP_BODY_LENGTH_IN_BYTES = "COSMOS.MAX_HTTP_BODY_LENGTH_IN_BYTES";
    private static final String MAX_HTTP_INITIAL_LINE_LENGTH_IN_BYTES = "COSMOS.MAX_HTTP_INITIAL_LINE_LENGTH_IN_BYTES";
    private static final String MAX_HTTP_CHUNK_SIZE_IN_BYTES = "COSMOS.MAX_HTTP_CHUNK_SIZE_IN_BYTES";
    private static final String MAX_HTTP_HEADER_SIZE_IN_BYTES = "COSMOS.MAX_HTTP_HEADER_SIZE_IN_BYTES";
    private static final String MAX_DIRECT_HTTPS_POOL_SIZE = "COSMOS.MAX_DIRECT_HTTP_CONNECTION_LIMIT";
    private static final String HTTP_RESPONSE_TIMEOUT_IN_SECONDS = "COSMOS.HTTP_RESPONSE_TIMEOUT_IN_SECONDS";
    private static final String QUERY_PLAN_RESPONSE_TIMEOUT_IN_SECONDS = "COSMOS.QUERY_PLAN_RESPONSE_TIMEOUT_IN_SECONDS";
    private static final String ADDRESS_REFRESH_RESPONSE_TIMEOUT_IN_SECONDS = "COSMOS.ADDRESS_REFRESH_RESPONSE_TIMEOUT_IN_SECONDS";
    private static final String CLIENT_TELEMETRY_ENABLED = "COSMOS.CLIENT_TELEMETRY_ENABLED";
    private static final String CLIENT_TELEMETRY_SCHEDULING_IN_SECONDS = "COSMOS.CLIENT_TELEMETRY_SCHEDULING_IN_SECONDS";
    private static final String CLIENT_TELEMETRY_ENDPOINT = "COSMOS.CLIENT_TELEMETRY_ENDPOINT";
    private static final String ENVIRONMENT_NAME = "COSMOS.ENVIRONMENT_NAME";
    private static final String QUERYPLAN_CACHING_ENABLED = "COSMOS.QUERYPLAN_CACHING_ENABLED";
    private static final int DEFAULT_CLIENT_TELEMETRY_SCHEDULING_IN_SECONDS = 600;
    private static final int DEFAULT_UNAVAILABLE_LOCATIONS_EXPIRATION_TIME_IN_SECONDS = 300;
    private static final int DEFAULT_MAX_HTTP_BODY_LENGTH_IN_BYTES = 0x600000;
    private static final int DEFAULT_MAX_HTTP_INITIAL_LINE_LENGTH = 4096;
    private static final int DEFAULT_MAX_HTTP_CHUNK_SIZE_IN_BYTES = 8192;
    private static final int DEFAULT_MAX_HTTP_REQUEST_HEADER_SIZE = 32768;
    private static final int MAX_NUMBER_OF_READ_BARRIER_READ_RETRIES = 6;
    private static final int MAX_NUMBER_OF_PRIMARY_READ_RETRIES = 6;
    private static final int MAX_NUMBER_OF_READ_QUORUM_RETRIES = 6;
    private static final int DELAY_BETWEEN_READ_BARRIER_CALLS_IN_MS = 5;
    private static final int MAX_BARRIER_RETRIES_FOR_MULTI_REGION = 30;
    private static final int BARRIER_RETRY_INTERVAL_IN_MS_FOR_MULTI_REGION = 30;
    private static final int MAX_SHORT_BARRIER_RETRIES_FOR_MULTI_REGION = 4;
    private static final int SHORT_BARRIER_RETRY_INTERVAL_IN_MS_FOR_MULTI_REGION = 10;
    private static final int CPU_CNT = Runtime.getRuntime().availableProcessors();
    private static final int DEFAULT_DIRECT_HTTPS_POOL_SIZE = CPU_CNT * 500;
    private static final int DEFAULT_GLOBAL_ENDPOINT_MANAGER_INITIALIZATION_TIME_IN_SECONDS = 120;
    private static final Duration MAX_IDLE_CONNECTION_TIMEOUT = Duration.ofSeconds(60L);
    private static final Duration CONNECTION_ACQUIRE_TIMEOUT = Duration.ofSeconds(45L);
    private static final int REACTOR_NETTY_MAX_CONNECTION_POOL_SIZE = 1000;
    private static final String REACTOR_NETTY_CONNECTION_POOL_NAME = "reactor-netty-connection-pool";
    private static final int DEFAULT_HTTP_RESPONSE_TIMEOUT_IN_SECONDS = 60;
    private static final int DEFAULT_QUERY_PLAN_RESPONSE_TIMEOUT_IN_SECONDS = 5;
    private static final int DEFAULT_ADDRESS_REFRESH_RESPONSE_TIMEOUT_IN_SECONDS = 5;
    private static final String DEFAULT_SESSION_TOKEN_MISMATCH_WAIT_TIME_IN_MILLISECONDS_NAME = "COSMOS.DEFAULT_SESSION_TOKEN_MISMATCH_WAIT_TIME_IN_MILLISECONDS";
    private static final int DEFAULT_SESSION_TOKEN_MISMATCH_WAIT_TIME_IN_MILLISECONDS = 5000;
    private static final String DEFAULT_SESSION_TOKEN_MISMATCH_INITIAL_BACKOFF_TIME_IN_MILLISECONDS_NAME = "COSMOS.DEFAULT_SESSION_TOKEN_MISMATCH_INITIAL_BACKOFF_TIME_IN_MILLISECONDS";
    private static final int DEFAULT_SESSION_TOKEN_MISMATCH_INITIAL_BACKOFF_TIME_IN_MILLISECONDS = 5;
    private static final String DEFAULT_SESSION_TOKEN_MISMATCH_MAXIMUM_BACKOFF_TIME_IN_MILLISECONDS_NAME = "COSMOS.DEFAULT_SESSION_TOKEN_MISMATCH_MAXIMUM_BACKOFF_TIME_IN_MILLISECONDS";
    private static final int DEFAULT_SESSION_TOKEN_MISMATCH_MAXIMUM_BACKOFF_TIME_IN_MILLISECONDS = 50;

    public static int getCPUCnt() {
        return CPU_CNT;
    }

    private SslContext sslContextInit() {
        try {
            SslProvider sslProvider = SslContext.defaultClientProvider();
            return SslContextBuilder.forClient().sslProvider(sslProvider).build();
        }
        catch (SSLException sslException) {
            logger.error("Fatal error cannot instantiate ssl context due to {}", (Object)sslException.getMessage(), (Object)sslException);
            throw new IllegalStateException(sslException);
        }
    }

    public SslContext getSslContext() {
        return this.sslContext;
    }

    public Protocol getProtocol() {
        String protocol = System.getProperty(PROTOCOL_PROPERTY, MoreObjects.firstNonNull(Strings.emptyToNull(System.getenv().get(PROTOCOL_ENVIRONMENT_VARIABLE)), DEFAULT_PROTOCOL.name()));
        try {
            return Protocol.valueOf(protocol.toUpperCase(Locale.ROOT));
        }
        catch (Exception e) {
            logger.error("Parsing protocol {} failed. Using the default {}.", new Object[]{protocol, DEFAULT_PROTOCOL, e});
            return DEFAULT_PROTOCOL;
        }
    }

    public int getMaxNumberOfReadBarrierReadRetries() {
        return 6;
    }

    public int getMaxNumberOfPrimaryReadRetries() {
        return 6;
    }

    public int getMaxNumberOfReadQuorumRetries() {
        return 6;
    }

    public int getDelayBetweenReadBarrierCallsInMs() {
        return 5;
    }

    public int getMaxBarrierRetriesForMultiRegion() {
        return 30;
    }

    public int getBarrierRetryIntervalInMsForMultiRegion() {
        return 30;
    }

    public int getMaxShortBarrierRetriesForMultiRegion() {
        return 4;
    }

    public int getShortBarrierRetryIntervalInMsForMultiRegion() {
        return 10;
    }

    public int getDirectHttpsMaxConnectionLimit() {
        return Configs.getJVMConfigAsInt(MAX_DIRECT_HTTPS_POOL_SIZE, DEFAULT_DIRECT_HTTPS_POOL_SIZE);
    }

    public int getMaxHttpHeaderSize() {
        return Configs.getJVMConfigAsInt(MAX_HTTP_HEADER_SIZE_IN_BYTES, 32768);
    }

    public int getMaxHttpInitialLineLength() {
        return Configs.getJVMConfigAsInt(MAX_HTTP_INITIAL_LINE_LENGTH_IN_BYTES, 4096);
    }

    public int getMaxHttpChunkSize() {
        return Configs.getJVMConfigAsInt(MAX_HTTP_CHUNK_SIZE_IN_BYTES, 8192);
    }

    public int getMaxHttpBodyLength() {
        return Configs.getJVMConfigAsInt(MAX_HTTP_BODY_LENGTH_IN_BYTES, 0x600000);
    }

    public int getUnavailableLocationsExpirationTimeInSeconds() {
        return Configs.getJVMConfigAsInt(UNAVAILABLE_LOCATIONS_EXPIRATION_TIME_IN_SECONDS, 300);
    }

    public static int getClientTelemetrySchedulingInSec() {
        return Configs.getJVMConfigAsInt(CLIENT_TELEMETRY_SCHEDULING_IN_SECONDS, 600);
    }

    public int getGlobalEndpointManagerMaxInitializationTimeInSeconds() {
        return Configs.getJVMConfigAsInt(GLOBAL_ENDPOINT_MANAGER_INITIALIZATION_TIME_IN_SECONDS, 120);
    }

    public String getReactorNettyConnectionPoolName() {
        return REACTOR_NETTY_CONNECTION_POOL_NAME;
    }

    public Duration getMaxIdleConnectionTimeout() {
        return MAX_IDLE_CONNECTION_TIMEOUT;
    }

    public Duration getConnectionAcquireTimeout() {
        return CONNECTION_ACQUIRE_TIMEOUT;
    }

    public int getReactorNettyMaxConnectionPoolSize() {
        return 1000;
    }

    public static int getHttpResponseTimeoutInSeconds() {
        return Configs.getJVMConfigAsInt(HTTP_RESPONSE_TIMEOUT_IN_SECONDS, 60);
    }

    public static int getQueryPlanResponseTimeoutInSeconds() {
        return Configs.getJVMConfigAsInt(QUERY_PLAN_RESPONSE_TIMEOUT_IN_SECONDS, 5);
    }

    public static boolean isClientTelemetryEnabled(boolean defaultValue) {
        return Configs.getJVMConfigAsBoolean(CLIENT_TELEMETRY_ENABLED, defaultValue);
    }

    public static String getClientTelemetryEndpoint() {
        return System.getProperty(CLIENT_TELEMETRY_ENDPOINT);
    }

    public static String getEnvironmentName() {
        return System.getProperty(ENVIRONMENT_NAME);
    }

    public static boolean isQueryPlanCachingEnabled() {
        return Configs.getJVMConfigAsBoolean(QUERYPLAN_CACHING_ENABLED, false);
    }

    public static int getAddressRefreshResponseTimeoutInSeconds() {
        return Configs.getJVMConfigAsInt(ADDRESS_REFRESH_RESPONSE_TIMEOUT_IN_SECONDS, 5);
    }

    public static int getSessionTokenMismatchDefaultWaitTimeInMs() {
        return Configs.getJVMConfigAsInt(DEFAULT_SESSION_TOKEN_MISMATCH_WAIT_TIME_IN_MILLISECONDS_NAME, 5000);
    }

    public static int getSessionTokenMismatchInitialBackoffTimeInMs() {
        return Configs.getJVMConfigAsInt(DEFAULT_SESSION_TOKEN_MISMATCH_INITIAL_BACKOFF_TIME_IN_MILLISECONDS_NAME, 5);
    }

    public static int getSessionTokenMismatchMaximumBackoffTimeInMs() {
        return Configs.getJVMConfigAsInt(DEFAULT_SESSION_TOKEN_MISMATCH_MAXIMUM_BACKOFF_TIME_IN_MILLISECONDS_NAME, 50);
    }

    private static int getJVMConfigAsInt(String propName, int defaultValue) {
        String propValue = System.getProperty(propName);
        return Configs.getIntValue(propValue, defaultValue);
    }

    private static boolean getJVMConfigAsBoolean(String propName, boolean defaultValue) {
        String propValue = System.getProperty(propName);
        return Configs.getBooleanValue(propValue, defaultValue);
    }

    private static int getIntValue(String val, int defaultValue) {
        if (StringUtils.isEmpty(val)) {
            return defaultValue;
        }
        return Integer.valueOf(val);
    }

    private static boolean getBooleanValue(String val, boolean defaultValue) {
        if (StringUtils.isEmpty(val)) {
            return defaultValue;
        }
        return Boolean.valueOf(val);
    }
}

