/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.rntbd;

import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdThreadFactory;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RntbdRequestTimer
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(RntbdRequestTimer.class);
    private static final ThreadFactory threadFactory = new RntbdThreadFactory("request-timer", true, 5);
    private final long requestTimeoutInNanos;
    private final Timer timer;

    public RntbdRequestTimer(long requestTimeoutInNanos, long requestTimerResolutionInNanos) {
        this.timer = new HashedWheelTimer(threadFactory, requestTimerResolutionInNanos, TimeUnit.NANOSECONDS);
        this.requestTimeoutInNanos = requestTimeoutInNanos;
    }

    @Override
    public void close() {
        Set cancelledTimeouts = this.timer.stop();
        logger.debug("request expiration tasks cancelled: {}", (Object)cancelledTimeouts.size());
    }

    public Timeout newTimeout(TimerTask task) {
        return this.timer.newTimeout(task, this.requestTimeoutInNanos, TimeUnit.NANOSECONDS);
    }
}

