/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.BackoffRetryUtility;
import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.DocumentClientRetryPolicy;
import com.azure.cosmos.implementation.InvalidPartitionExceptionRetryPolicy;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.PartitionKeyRangeGoneRetryPolicy;
import com.azure.cosmos.implementation.PathsHelper;
import com.azure.cosmos.implementation.QueryMetrics;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.apachecommons.lang.tuple.ImmutablePair;
import com.azure.cosmos.implementation.caches.IPartitionKeyRangeCache;
import com.azure.cosmos.implementation.caches.RxCollectionCache;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternal;
import com.azure.cosmos.implementation.query.CompositeContinuationToken;
import com.azure.cosmos.implementation.query.DocumentQueryExecutionContextBase;
import com.azure.cosmos.implementation.query.IDocumentQueryClient;
import com.azure.cosmos.implementation.query.OrderByContinuationToken;
import com.azure.cosmos.implementation.query.Paginator;
import com.azure.cosmos.implementation.query.TakeContinuationToken;
import com.azure.cosmos.implementation.query.metrics.ClientSideMetrics;
import com.azure.cosmos.implementation.query.metrics.FetchExecutionRangeAccumulator;
import com.azure.cosmos.implementation.query.metrics.SchedulingStopwatch;
import com.azure.cosmos.implementation.query.metrics.SchedulingTimeSpan;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.implementation.routing.PartitionKeyRangeIdentity;
import com.azure.cosmos.implementation.routing.Range;
import com.azure.cosmos.implementation.routing.RoutingMapProviderHelper;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.SqlQuerySpec;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultDocumentQueryExecutionContext<T extends Resource>
extends DocumentQueryExecutionContextBase<T> {
    private boolean isContinuationExpected;
    private volatile int retries = -1;
    private final SchedulingStopwatch fetchSchedulingMetrics;
    private final FetchExecutionRangeAccumulator fetchExecutionRangeAccumulator;
    private static final String DEFAULT_PARTITION_RANGE = "00-FF";

    public DefaultDocumentQueryExecutionContext(DiagnosticsClientContext diagnosticsClientContext, IDocumentQueryClient client, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec query, CosmosQueryRequestOptions cosmosQueryRequestOptions, String resourceLink, UUID correlatedActivityId, boolean isContinuationExpected) {
        super(diagnosticsClientContext, client, resourceTypeEnum, resourceType, query, cosmosQueryRequestOptions, resourceLink, false, correlatedActivityId);
        this.isContinuationExpected = isContinuationExpected;
        this.fetchSchedulingMetrics = new SchedulingStopwatch();
        this.fetchSchedulingMetrics.ready();
        this.fetchExecutionRangeAccumulator = new FetchExecutionRangeAccumulator(DEFAULT_PARTITION_RANGE);
    }

    protected PartitionKeyInternal getPartitionKeyInternal() {
        return this.cosmosQueryRequestOptions.getPartitionKey() == null ? null : BridgeInternal.getPartitionKeyInternal(this.cosmosQueryRequestOptions.getPartitionKey());
    }

    @Override
    public Flux<FeedResponse<T>> executeAsync() {
        Integer maxItemCount;
        CosmosQueryRequestOptions newCosmosQueryRequestOptions;
        String originalContinuation;
        if (this.cosmosQueryRequestOptions == null) {
            this.cosmosQueryRequestOptions = new CosmosQueryRequestOptions();
        }
        if (DefaultDocumentQueryExecutionContext.isClientSideContinuationToken(originalContinuation = ModelBridgeInternal.getRequestContinuationFromQueryRequestOptions(newCosmosQueryRequestOptions = ModelBridgeInternal.createQueryRequestOptions(this.cosmosQueryRequestOptions)))) {
            ModelBridgeInternal.setQueryRequestOptionsContinuationToken(newCosmosQueryRequestOptions, null);
            newCosmosQueryRequestOptions.setMaxDegreeOfParallelism(Integer.MAX_VALUE);
        }
        int maxPageSize = (maxItemCount = ModelBridgeInternal.getMaxItemCountFromQueryRequestOptions(newCosmosQueryRequestOptions)) != null ? maxItemCount : 100;
        BiFunction<String, Integer, RxDocumentServiceRequest> createRequestFunc = (continuationToken, pageSize) -> this.createRequestAsync((String)continuationToken, (Integer)pageSize);
        Function<RxDocumentServiceRequest, Mono<FeedResponse<T>>> executeFunc = this.executeInternalAsyncFunc();
        return Paginator.getPaginatedQueryResultAsObservable(newCosmosQueryRequestOptions, createRequestFunc, executeFunc, this.resourceType, maxPageSize);
    }

    public Mono<List<PartitionKeyRange>> getTargetPartitionKeyRanges(String resourceId, List<Range<String>> queryRanges) {
        return RoutingMapProviderHelper.getOverlappingRanges(this.client.getPartitionKeyRangeCache(), resourceId, queryRanges);
    }

    public Mono<Range<String>> getTargetRange(String collectionRid, FeedRangeInternal feedRangeInternal) {
        return feedRangeInternal.getNormalizedEffectiveRange(this.client.getPartitionKeyRangeCache(), null, this.client.getCollectionCache().resolveByRidAsync(null, collectionRid, null));
    }

    public Mono<List<PartitionKeyRange>> getTargetPartitionKeyRangesById(String resourceId, String partitionKeyRangeIdInternal) {
        return this.client.getPartitionKeyRangeCache().tryGetPartitionKeyRangeByIdAsync(null, resourceId, partitionKeyRangeIdInternal, false, null).flatMap(partitionKeyRange -> Mono.just(Collections.singletonList(partitionKeyRange.v)));
    }

    protected Function<RxDocumentServiceRequest, Mono<FeedResponse<T>>> executeInternalAsyncFunc() {
        RxCollectionCache collectionCache = this.client.getCollectionCache();
        IPartitionKeyRangeCache partitionKeyRangeCache = this.client.getPartitionKeyRangeCache();
        DocumentClientRetryPolicy retryPolicyInstance = this.client.getResetSessionTokenRetryPolicy().getRequestPolicy();
        retryPolicyInstance = new InvalidPartitionExceptionRetryPolicy(collectionCache, retryPolicyInstance, this.resourceLink, ModelBridgeInternal.getPropertiesFromQueryRequestOptions(this.cosmosQueryRequestOptions));
        if (this.resourceTypeEnum.isPartitioned()) {
            retryPolicyInstance = new PartitionKeyRangeGoneRetryPolicy(this.diagnosticsClientContext, collectionCache, partitionKeyRangeCache, PathsHelper.getCollectionPath(this.resourceLink), retryPolicyInstance, ModelBridgeInternal.getPropertiesFromQueryRequestOptions(this.cosmosQueryRequestOptions));
        }
        DocumentClientRetryPolicy finalRetryPolicyInstance = retryPolicyInstance;
        return req -> {
            finalRetryPolicyInstance.onBeforeSendRequest((RxDocumentServiceRequest)req);
            this.fetchExecutionRangeAccumulator.beginFetchRange();
            this.fetchSchedulingMetrics.start();
            return BackoffRetryUtility.executeRetry(() -> {
                ++this.retries;
                return this.executeRequestAsync((RxDocumentServiceRequest)req);
            }, finalRetryPolicyInstance).map(tFeedResponse -> {
                this.fetchSchedulingMetrics.stop();
                this.fetchExecutionRangeAccumulator.endFetchRange(tFeedResponse.getActivityId(), tFeedResponse.getResults().size(), this.retries);
                ImmutablePair<String, SchedulingTimeSpan> schedulingTimeSpanMap = new ImmutablePair<String, SchedulingTimeSpan>(DEFAULT_PARTITION_RANGE, this.fetchSchedulingMetrics.getElapsedTime());
                if (!StringUtils.isEmpty(tFeedResponse.getResponseHeaders().get("x-ms-documentdb-query-metrics"))) {
                    QueryMetrics qm = BridgeInternal.createQueryMetricsFromDelimitedStringAndClientSideMetrics(tFeedResponse.getResponseHeaders().get("x-ms-documentdb-query-metrics"), new ClientSideMetrics(this.retries, tFeedResponse.getRequestCharge(), this.fetchExecutionRangeAccumulator.getExecutionRanges(), Arrays.asList(schedulingTimeSpanMap)), tFeedResponse.getActivityId());
                    String pkrId = tFeedResponse.getResponseHeaders().get("x-ms-documentdb-partitionkeyrangeid");
                    String queryMetricKey = "00-FF,pkrId:" + pkrId;
                    BridgeInternal.putQueryMetricsIntoMap(tFeedResponse, queryMetricKey, qm);
                }
                return tFeedResponse;
            });
        };
    }

    public RxDocumentServiceRequest createRequestAsync(String continuationToken, Integer maxPageSize) {
        Map<String, String> requestHeaders = this.createCommonHeadersAsync(this.getFeedOptions(continuationToken, maxPageSize));
        RxDocumentServiceRequest request = this.createDocumentServiceRequest(requestHeaders, this.query, this.getPartitionKeyInternal());
        if (!StringUtils.isEmpty(ModelBridgeInternal.getPartitionKeyRangeIdInternal(this.cosmosQueryRequestOptions))) {
            request.routeTo(new PartitionKeyRangeIdentity(ModelBridgeInternal.getPartitionKeyRangeIdInternal(this.cosmosQueryRequestOptions)));
        }
        return request;
    }

    private static boolean isClientSideContinuationToken(String continuationToken) {
        if (continuationToken != null) {
            Utils.ValueHolder<CompositeContinuationToken> outCompositeContinuationToken = new Utils.ValueHolder<CompositeContinuationToken>();
            if (CompositeContinuationToken.tryParse(continuationToken, outCompositeContinuationToken)) {
                return true;
            }
            Utils.ValueHolder<OrderByContinuationToken> outOrderByContinuationToken = new Utils.ValueHolder<OrderByContinuationToken>();
            if (OrderByContinuationToken.tryParse(continuationToken, outOrderByContinuationToken)) {
                return true;
            }
            Utils.ValueHolder<TakeContinuationToken> outTakeContinuationToken = new Utils.ValueHolder<TakeContinuationToken>();
            if (TakeContinuationToken.tryParse(continuationToken, outTakeContinuationToken)) {
                return true;
            }
        }
        return false;
    }
}

