/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.apachecommons.lang.tuple.Pair;
import com.azure.cosmos.implementation.feedranges.FeedRangeEpkImpl;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.query.IPartitionedToken;
import com.azure.cosmos.implementation.routing.Range;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public final class PartitionMapper {
    public static <T extends IPartitionedToken> PartitionMapping<T> getPartitionMapping(List<FeedRangeEpkImpl> feedRangeEpkList, List<T> tokens) {
        Preconditions.checkNotNull(feedRangeEpkList);
        Preconditions.checkNotNull(tokens);
        if (feedRangeEpkList.isEmpty()) {
            throw new IllegalArgumentException("feedRanges should not be empty");
        }
        if (tokens.isEmpty()) {
            throw new IllegalArgumentException("tokens should not be empty");
        }
        List<FeedRangeEpkImpl> mergedFeedRanges = PartitionMapper.mergeRangesWhenPossible(feedRangeEpkList);
        Map<FeedRangeEpkImpl, T> splitRangesAndTokens = PartitionMapper.splitRangesBasedOffContinuationToken(mergedFeedRanges, tokens);
        FeedRangeEpkImpl targetFeedRange = PartitionMapper.getTargetFeedRange(tokens);
        return PartitionMapper.createPartitionMapping(splitRangesAndTokens, tokens, targetFeedRange);
    }

    private static List<FeedRangeEpkImpl> mergeRangesWhenPossible(List<FeedRangeEpkImpl> feedRangeEpkList) {
        ArrayDeque<Pair<String, String>> mergedRanges = new ArrayDeque<Pair<String, String>>(feedRangeEpkList.size());
        for (FeedRangeEpkImpl feedRangeEpk : feedRangeEpkList) {
            if (mergedRanges.isEmpty()) {
                mergedRanges.push(Pair.of(feedRangeEpk.getRange().getMin(), feedRangeEpk.getRange().getMax()));
                continue;
            }
            Pair pop = (Pair)mergedRanges.pop();
            String min = (String)pop.getLeft();
            String max = (String)pop.getRight();
            if (max.equals(feedRangeEpk.getRange().getMin())) {
                mergedRanges.push(Pair.of(min, feedRangeEpk.getRange().getMax()));
                continue;
            }
            mergedRanges.push(pop);
            mergedRanges.push(Pair.of(feedRangeEpk.getRange().getMin(), feedRangeEpk.getRange().getMax()));
        }
        List<FeedRangeEpkImpl> mergedFeedRanges = mergedRanges.stream().map(pair -> {
            Range<Comparable> range = new Range<Comparable>((Comparable)pair.getLeft(), (Comparable)pair.getRight(), true, false);
            return new FeedRangeEpkImpl(range);
        }).collect(Collectors.toList());
        return mergedFeedRanges;
    }

    private static <T extends IPartitionedToken> Map<FeedRangeEpkImpl, T> splitRangesBasedOffContinuationToken(List<FeedRangeEpkImpl> feedRangeEpks, List<T> tokens) {
        HashSet<FeedRangeEpkImpl> remainingRanges = new HashSet<FeedRangeEpkImpl>(feedRangeEpks);
        HashMap<FeedRangeEpkImpl, IPartitionedToken> splitRangesAndTokens = new HashMap<FeedRangeEpkImpl, IPartitionedToken>();
        for (IPartitionedToken token : tokens) {
            List rangesThatOverlapToken = remainingRanges.stream().filter(feedRangeEpk -> {
                boolean tokenRightOfStart = Strings.isNullOrEmpty(feedRangeEpk.getRange().getMin()) || !Strings.isNullOrEmpty(token.getRange().getMin()) && token.getRange().getMin().compareTo(feedRangeEpk.getRange().getMin()) >= 0;
                boolean tokenLeftOfEnd = Strings.isNullOrEmpty(feedRangeEpk.getRange().getMax()) || !Strings.isNullOrEmpty(token.getRange().getMax()) && token.getRange().getMax().compareTo(feedRangeEpk.getRange().getMax()) <= 0;
                boolean rangeCompletelyOverlapsToken = tokenRightOfStart && tokenLeftOfEnd;
                return rangeCompletelyOverlapsToken;
            }).collect(Collectors.toList());
            if (rangesThatOverlapToken.size() == 0) continue;
            if (rangesThatOverlapToken.size() == 1) {
                FeedRangeEpkImpl feedRangeEpk2 = (FeedRangeEpkImpl)rangesThatOverlapToken.get(0);
                remainingRanges.remove(feedRangeEpk2);
                if (!feedRangeEpk2.getRange().getMin().equals(token.getRange().getMin())) {
                    FeedRangeEpkImpl leftOfOverlap = new FeedRangeEpkImpl(new Range<String>(feedRangeEpk2.getRange().getMin(), token.getRange().getMin(), true, false));
                    remainingRanges.add(leftOfOverlap);
                }
                FeedRangeEpkImpl overlappingSection = new FeedRangeEpkImpl(new Range<String>(token.getRange().getMin(), token.getRange().getMax(), true, false));
                splitRangesAndTokens.put(overlappingSection, token);
                if (token.getRange().getMax().equals(feedRangeEpk2.getRange().getMax())) continue;
                FeedRangeEpkImpl rightOfOverlap = new FeedRangeEpkImpl(new Range<String>(token.getRange().getMax(), feedRangeEpk2.getRange().getMax(), true, false));
                remainingRanges.add(rightOfOverlap);
                continue;
            }
            throw new IllegalStateException("Token was overlapped by multiple ranges");
        }
        for (FeedRangeEpkImpl remainingRange : remainingRanges) {
            splitRangesAndTokens.put(remainingRange, null);
        }
        return splitRangesAndTokens;
    }

    private static <T extends IPartitionedToken> FeedRangeEpkImpl getTargetFeedRange(List<T> tokens) {
        IPartitionedToken firstContinuationToken = (IPartitionedToken)tokens.stream().sorted(Comparator.comparing(t -> t.getRange().getMin())).collect(Collectors.toList()).get(0);
        return new FeedRangeEpkImpl(new Range<String>(firstContinuationToken.getRange().getMin(), firstContinuationToken.getRange().getMax(), true, false));
    }

    private static <T extends IPartitionedToken> PartitionMapping<T> createPartitionMapping(Map<FeedRangeEpkImpl, T> splitRangesAndTokensMap, List<T> tokens, FeedRangeEpkImpl targetRange) {
        List pairs;
        List splitRangesAndTokens = splitRangesAndTokensMap.entrySet().stream().map(e -> Pair.of(e.getKey(), e.getValue())).collect(Collectors.toList());
        List<Object> sortedRanges = splitRangesAndTokens.stream().sorted(Comparator.comparing(p -> ((FeedRangeEpkImpl)p.getLeft()).getRange().getMin())).collect(Collectors.toList());
        Optional<Object> matchedIndex = Optional.empty();
        for (int i = 0; i < sortedRanges.size() && !matchedIndex.isPresent(); ++i) {
            Pair feedRangeEpkTPair = (Pair)sortedRanges.get(i);
            if (!((FeedRangeEpkImpl)feedRangeEpkTPair.getLeft()).equals(targetRange)) continue;
            matchedIndex = Optional.of(i);
        }
        if (!matchedIndex.isPresent()) {
            if (splitRangesAndTokens.size() != 1) {
                throw new IllegalStateException("Could not find continuation token for range " + targetRange);
            }
            sortedRanges = Collections.singletonList(Pair.of(((Pair)sortedRanges.get(0)).getLeft(), tokens.get(0)));
            matchedIndex = Optional.of(0);
        }
        HashMap partitionsLeftOfTarget = new HashMap();
        if ((Integer)matchedIndex.get() != 0) {
            pairs = sortedRanges.subList(0, (Integer)matchedIndex.get());
            for (Object p2 : pairs) {
                partitionsLeftOfTarget.put(((Pair)p2).getLeft(), ((Pair)p2).getRight());
            }
        }
        pairs = sortedRanges.subList((Integer)matchedIndex.get(), (Integer)matchedIndex.get() + 1);
        HashMap targetPartition = new HashMap();
        for (Pair p3 : pairs) {
            targetPartition.put(p3.getLeft(), p3.getRight());
        }
        HashMap partitionsRightOfTarget = new HashMap();
        if ((Integer)matchedIndex.get() != sortedRanges.size() - 1) {
            List<Object> rPairs = sortedRanges.subList((Integer)matchedIndex.get() + 1, sortedRanges.size());
            for (Pair pair : rPairs) {
                partitionsRightOfTarget.put(pair.getLeft(), pair.getRight());
            }
        }
        return new PartitionMapping(partitionsLeftOfTarget, targetPartition, partitionsRightOfTarget);
    }

    public static class PartitionMapping<T extends IPartitionedToken> {
        private final Map<FeedRangeEpkImpl, T> mappingLeftOfTarget;
        private final Map<FeedRangeEpkImpl, T> targetMapping;
        private final Map<FeedRangeEpkImpl, T> mappingRightOfTarget;

        public PartitionMapping(Map<FeedRangeEpkImpl, T> mappingLeftOfTarget, Map<FeedRangeEpkImpl, T> targetMapping, Map<FeedRangeEpkImpl, T> mappingRightOfTarget) {
            Preconditions.checkNotNull(mappingLeftOfTarget);
            Preconditions.checkNotNull(targetMapping);
            Preconditions.checkNotNull(mappingLeftOfTarget);
            this.mappingLeftOfTarget = mappingLeftOfTarget;
            this.targetMapping = targetMapping;
            this.mappingRightOfTarget = mappingRightOfTarget;
        }

        public Map<FeedRangeEpkImpl, T> getMappingLeftOfTarget() {
            return this.mappingLeftOfTarget;
        }

        public Map<FeedRangeEpkImpl, T> getTargetMapping() {
            return this.targetMapping;
        }

        public Map<FeedRangeEpkImpl, T> getMappingRightOfTarget() {
            return this.mappingRightOfTarget;
        }
    }
}

