/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.rntbd;

import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdChannelAcquisitionEvent;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdChannelAcquisitionEventType;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdPollChannelEvent;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RntbdChannelAcquisitionTimeline {
    private static final Logger logger = LoggerFactory.getLogger(RntbdChannelAcquisitionTimeline.class);
    private final List<RntbdChannelAcquisitionEvent> events = new ArrayList<RntbdChannelAcquisitionEvent>();
    private volatile RntbdChannelAcquisitionEvent currentEvent;

    public List<RntbdChannelAcquisitionEvent> getEvents() {
        return this.events;
    }

    public static RntbdChannelAcquisitionEvent startNewEvent(RntbdChannelAcquisitionTimeline timeline, RntbdChannelAcquisitionEventType eventType) {
        if (timeline != null) {
            RntbdChannelAcquisitionEvent newEvent = new RntbdChannelAcquisitionEvent(eventType, Instant.now());
            timeline.addNewEvent(newEvent);
            return newEvent;
        }
        return null;
    }

    public static RntbdPollChannelEvent startNewPollEvent(RntbdChannelAcquisitionTimeline timeline, int availableChannels, int acquiredChannels) {
        if (timeline != null) {
            RntbdPollChannelEvent newEvent = new RntbdPollChannelEvent(availableChannels, acquiredChannels, Instant.now());
            timeline.addNewEvent(newEvent);
            return newEvent;
        }
        return null;
    }

    private void addNewEvent(RntbdChannelAcquisitionEvent event) {
        if (this.currentEvent != null) {
            this.currentEvent.complete(event.getCreatedTime());
        }
        this.events.add(event);
        this.currentEvent = event;
    }

    public static void addDetailsToLastEvent(RntbdChannelAcquisitionTimeline timeline, Object detail) {
        if (timeline != null && timeline.currentEvent != null) {
            RntbdChannelAcquisitionEvent.addDetail(timeline.currentEvent, detail);
        }
    }
}

