/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.query.AggregateDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.DCountDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.DistinctDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.GroupByDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.IDocumentQueryClient;
import com.azure.cosmos.implementation.query.IDocumentQueryExecutionComponent;
import com.azure.cosmos.implementation.query.IDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.OrderByDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.ParallelDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.PipelinedDocumentQueryParams;
import com.azure.cosmos.implementation.query.QueryInfo;
import com.azure.cosmos.implementation.query.SkipDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.TopDocumentQueryExecutionContext;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.SqlQuerySpec;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import reactor.core.publisher.Flux;

public class PipelinedDocumentQueryExecutionContext<T extends Resource>
implements IDocumentQueryExecutionContext<T> {
    private IDocumentQueryExecutionComponent<T> component;
    private int actualPageSize;
    private UUID correlatedActivityId;
    private QueryInfo queryInfo;

    private PipelinedDocumentQueryExecutionContext(IDocumentQueryExecutionComponent<T> component, int actualPageSize, UUID correlatedActivityId, QueryInfo queryInfo) {
        this.component = component;
        this.actualPageSize = actualPageSize;
        this.correlatedActivityId = correlatedActivityId;
        this.queryInfo = queryInfo;
    }

    public static <T extends Resource> Flux<PipelinedDocumentQueryExecutionContext<T>> createAsync(DiagnosticsClientContext diagnosticsClientContext, IDocumentQueryClient client, PipelinedDocumentQueryParams<T> initParams) {
        QueryInfo queryInfo = initParams.getQueryInfo();
        UUID correlatedActivityId = initParams.getCorrelatedActivityId();
        CosmosQueryRequestOptions cosmosQueryRequestOptions = initParams.getCosmosQueryRequestOptions();
        BiFunction<String, PipelinedDocumentQueryParams, Flux> createBaseComponentFunction = queryInfo.hasOrderBy() ? (continuationToken, documentQueryParams) -> {
            CosmosQueryRequestOptions orderByCosmosQueryRequestOptions = ModelBridgeInternal.createQueryRequestOptions(cosmosQueryRequestOptions);
            ModelBridgeInternal.setQueryRequestOptionsContinuationToken(orderByCosmosQueryRequestOptions, continuationToken);
            initParams.setCosmosQueryRequestOptions(orderByCosmosQueryRequestOptions);
            return OrderByDocumentQueryExecutionContext.createAsync(diagnosticsClientContext, client, documentQueryParams);
        } : (continuationToken, documentQueryParams) -> {
            CosmosQueryRequestOptions parallelCosmosQueryRequestOptions = ModelBridgeInternal.createQueryRequestOptions(cosmosQueryRequestOptions);
            ModelBridgeInternal.setQueryRequestOptionsContinuationToken(parallelCosmosQueryRequestOptions, continuationToken);
            initParams.setCosmosQueryRequestOptions(parallelCosmosQueryRequestOptions);
            return ParallelDocumentQueryExecutionContext.createAsync(diagnosticsClientContext, client, documentQueryParams);
        };
        BiFunction<String, PipelinedDocumentQueryParams, Flux> createAggregateComponentFunction = queryInfo.hasAggregates() && !queryInfo.hasGroupBy() ? (continuationToken, documentQueryParams) -> AggregateDocumentQueryExecutionContext.createAsync(createBaseComponentFunction, queryInfo.getAggregates(), queryInfo.getGroupByAliasToAggregateType(), queryInfo.getGroupByAliases(), queryInfo.hasSelectValue(), continuationToken, documentQueryParams) : createBaseComponentFunction;
        BiFunction<String, PipelinedDocumentQueryParams, Flux> createDistinctComponentFunction = queryInfo.hasDistinct() ? (continuationToken, documentQueryParams) -> DistinctDocumentQueryExecutionContext.createAsync(createAggregateComponentFunction, queryInfo.getDistinctQueryType(), continuationToken, documentQueryParams) : createAggregateComponentFunction;
        BiFunction<String, PipelinedDocumentQueryParams, Flux> createGroupByComponentFunction = queryInfo.hasGroupBy() ? (continuationToken, documentQueryParams) -> GroupByDocumentQueryExecutionContext.createAsync(createDistinctComponentFunction, continuationToken, queryInfo.getGroupByAliasToAggregateType(), queryInfo.getGroupByAliases(), queryInfo.hasSelectValue(), documentQueryParams) : createDistinctComponentFunction;
        BiFunction<String, PipelinedDocumentQueryParams, Flux> createSkipComponentFunction = queryInfo.hasOffset() ? (continuationToken, documentQueryParams) -> SkipDocumentQueryExecutionContext.createAsync(createGroupByComponentFunction, queryInfo.getOffset(), continuationToken, documentQueryParams) : createGroupByComponentFunction;
        BiFunction<String, PipelinedDocumentQueryParams, Flux> createTopComponentFunction = queryInfo.hasTop() ? (continuationToken, documentQueryParams) -> TopDocumentQueryExecutionContext.createAsync(createSkipComponentFunction, queryInfo.getTop(), queryInfo.getTop(), continuationToken, documentQueryParams) : createSkipComponentFunction;
        BiFunction<String, PipelinedDocumentQueryParams, Flux> createTakeComponentFunction = queryInfo.hasLimit() ? (continuationToken, documentQueryParams) -> {
            int totalLimit = queryInfo.getLimit();
            if (queryInfo.hasOffset()) {
                totalLimit = queryInfo.getOffset() + queryInfo.getLimit();
            }
            return TopDocumentQueryExecutionContext.createAsync(createTopComponentFunction, queryInfo.getLimit(), totalLimit, continuationToken, documentQueryParams);
        } : createTopComponentFunction;
        BiFunction<String, PipelinedDocumentQueryParams, Flux> createDCountComponentFunction = queryInfo.hasDCount() ? (continuationToken, documentQueryParams) -> DCountDocumentQueryExecutionContext.createAsync(createTakeComponentFunction, queryInfo, continuationToken, documentQueryParams) : createTakeComponentFunction;
        int actualPageSize = Utils.getValueOrDefault(ModelBridgeInternal.getMaxItemCountFromQueryRequestOptions(cosmosQueryRequestOptions), 100);
        if (actualPageSize == -1) {
            actualPageSize = Integer.MAX_VALUE;
        }
        int pageSize = Math.min(actualPageSize, Utils.getValueOrDefault(queryInfo.getTop(), actualPageSize));
        return createDCountComponentFunction.apply(ModelBridgeInternal.getRequestContinuationFromQueryRequestOptions(cosmosQueryRequestOptions), initParams).map(c -> new PipelinedDocumentQueryExecutionContext(c, pageSize, correlatedActivityId, queryInfo));
    }

    public static <T extends Resource> Flux<PipelinedDocumentQueryExecutionContext<T>> createReadManyAsync(DiagnosticsClientContext diagnosticsClientContext, IDocumentQueryClient queryClient, String collectionResourceId, SqlQuerySpec sqlQuery, Map<PartitionKeyRange, SqlQuerySpec> rangeQueryMap, CosmosQueryRequestOptions cosmosQueryRequestOptions, String resourceId, String collectionLink, UUID activityId, Class<T> klass, ResourceType resourceTypeEnum) {
        Flux<IDocumentQueryExecutionComponent<T>> documentQueryExecutionComponentFlux = ParallelDocumentQueryExecutionContext.createReadManyQueryAsync(diagnosticsClientContext, queryClient, collectionResourceId, sqlQuery, rangeQueryMap, cosmosQueryRequestOptions, resourceId, collectionLink, activityId, klass, resourceTypeEnum);
        return documentQueryExecutionComponentFlux.map(c -> new PipelinedDocumentQueryExecutionContext(c, -1, activityId, null));
    }

    @Override
    public Flux<FeedResponse<T>> executeAsync() {
        return this.component.drainAsync(this.actualPageSize);
    }

    public QueryInfo getQueryInfo() {
        return this.queryInfo;
    }
}

