/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.RequestOptions;
import com.azure.cosmos.util.Beta;

@Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
public final class CosmosBatchRequestOptions {
    private ConsistencyLevel consistencyLevel;
    private String sessionToken;

    ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    CosmosBatchRequestOptions setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public String getSessionToken() {
        return this.sessionToken;
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public CosmosBatchRequestOptions setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
        return this;
    }

    RequestOptions toRequestOptions() {
        RequestOptions requestOptions = new RequestOptions();
        requestOptions.setConsistencyLevel(this.getConsistencyLevel());
        requestOptions.setSessionToken(this.sessionToken);
        return requestOptions;
    }

    static {
        ImplementationBridgeHelpers.CosmosBatchRequestOptionsHelper.setCosmosBatchRequestOptionsAccessor(new ImplementationBridgeHelpers.CosmosBatchRequestOptionsHelper.CosmosBatchRequestOptionsAccessor(){

            @Override
            public ConsistencyLevel getConsistencyLevel(CosmosBatchRequestOptions cosmosBatchRequestOptions) {
                return cosmosBatchRequestOptions.getConsistencyLevel();
            }

            @Override
            public CosmosBatchRequestOptions setConsistencyLevel(CosmosBatchRequestOptions cosmosBatchRequestOptions, ConsistencyLevel consistencyLevel) {
                return cosmosBatchRequestOptions.setConsistencyLevel(consistencyLevel);
            }
        });
    }
}

