/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.implementation.batch.BatchExecUtils;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.CosmosBatchOperationResult;
import com.azure.cosmos.util.Beta;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
public class CosmosBatchResponse {
    private final Map<String, String> responseHeaders;
    private final int statusCode;
    private final String errorMessage;
    private final List<CosmosBatchOperationResult> results;
    private final int subStatusCode;
    private final CosmosDiagnostics cosmosDiagnostics;

    CosmosBatchResponse(int statusCode, int subStatusCode, String errorMessage, Map<String, String> responseHeaders, CosmosDiagnostics cosmosDiagnostics) {
        Preconditions.checkNotNull(statusCode, "expected non-null statusCode");
        Preconditions.checkNotNull(responseHeaders, "expected non-null responseHeaders");
        this.statusCode = statusCode;
        this.subStatusCode = subStatusCode;
        this.errorMessage = errorMessage;
        this.responseHeaders = responseHeaders;
        this.cosmosDiagnostics = cosmosDiagnostics;
        this.results = new ArrayList<CosmosBatchOperationResult>();
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public CosmosDiagnostics getDiagnostics() {
        return this.cosmosDiagnostics;
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public int size() {
        return this.results == null ? 0 : this.results.size();
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public boolean isSuccessStatusCode() {
        return this.statusCode >= 200 && this.statusCode <= 299;
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public String getActivityId() {
        return BatchExecUtils.getActivityId(this.responseHeaders);
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public double getRequestCharge() {
        return BatchExecUtils.getRequestCharge(this.responseHeaders);
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public int getStatusCode() {
        return this.statusCode;
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public String getSessionToken() {
        return BatchExecUtils.getSessionToken(this.responseHeaders);
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public Duration getRetryAfterDuration() {
        return BatchExecUtils.getRetryAfterDuration(this.responseHeaders);
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public int getSubStatusCode() {
        return this.subStatusCode;
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public List<CosmosBatchOperationResult> getResults() {
        return Collections.unmodifiableList(this.results);
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public int getResponseLength() {
        return BatchExecUtils.getResponseLength(this.responseHeaders);
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public Duration getDuration() {
        if (this.cosmosDiagnostics == null) {
            return Duration.ZERO;
        }
        return this.cosmosDiagnostics.getDuration();
    }

    void addAll(List<? extends CosmosBatchOperationResult> collection) {
        this.results.addAll(collection);
    }
}

