/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.spark.OperationContextAndListenerTuple;
import com.azure.cosmos.models.CosmosBulkExecutionThresholdsState;
import com.azure.cosmos.util.Beta;
import java.time.Duration;

@Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
public final class CosmosBulkExecutionOptions {
    private int maxMicroBatchSize = 100;
    private int maxMicroBatchConcurrency = 1;
    private double maxMicroBatchRetryRate = 0.2;
    private double minMicroBatchRetryRate = 0.1;
    private Duration maxMicroBatchInterval = Duration.ofMillis(1000L);
    private final Object legacyBatchScopedContext;
    private final CosmosBulkExecutionThresholdsState thresholds;
    private OperationContextAndListenerTuple operationContextAndListenerTuple;

    CosmosBulkExecutionOptions(Object legacyBatchScopedContext, CosmosBulkExecutionThresholdsState thresholds) {
        this.legacyBatchScopedContext = legacyBatchScopedContext;
        this.thresholds = thresholds == null ? new CosmosBulkExecutionThresholdsState() : thresholds;
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public CosmosBulkExecutionOptions(CosmosBulkExecutionThresholdsState thresholds) {
        this(null, thresholds);
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public CosmosBulkExecutionOptions() {
        this(null);
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public int getMaxMicroBatchSize() {
        return this.maxMicroBatchSize;
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public CosmosBulkExecutionOptions setMaxMicroBatchSize(int maxMicroBatchSize) {
        this.maxMicroBatchSize = maxMicroBatchSize;
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public int getMaxMicroBatchConcurrency() {
        return this.maxMicroBatchConcurrency;
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public CosmosBulkExecutionOptions setMaxMicroBatchConcurrency(int maxMicroBatchConcurrency) {
        this.maxMicroBatchConcurrency = maxMicroBatchConcurrency;
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public Duration getMaxMicroBatchInterval() {
        return this.maxMicroBatchInterval;
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public CosmosBulkExecutionOptions setMaxMicroBatchInterval(Duration maxMicroBatchInterval) {
        this.maxMicroBatchInterval = maxMicroBatchInterval;
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public double getMaxTargetedMicroBatchRetryRate() {
        return this.maxMicroBatchRetryRate;
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public CosmosBulkExecutionOptions setTargetedMicroBatchRetryRate(double minRetryRate, double maxRetryRate) {
        if (minRetryRate < 0.0) {
            throw new IllegalArgumentException("The maxRetryRate must not be a negative value");
        }
        if (minRetryRate > maxRetryRate) {
            throw new IllegalArgumentException("The minRetryRate must not exceed the maxRetryRate");
        }
        this.maxMicroBatchRetryRate = maxRetryRate;
        this.minMicroBatchRetryRate = minRetryRate;
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public double getMinTargetedMicroBatchRetryRate() {
        return this.minMicroBatchRetryRate;
    }

    Object getLegacyBatchScopedContext() {
        return this.legacyBatchScopedContext;
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public CosmosBulkExecutionThresholdsState getThresholds() {
        return this.thresholds;
    }

    OperationContextAndListenerTuple getOperationContextAndListenerTuple() {
        return this.operationContextAndListenerTuple;
    }

    void setOperationContextAndListenerTuple(OperationContextAndListenerTuple operationContextAndListenerTuple) {
        this.operationContextAndListenerTuple = operationContextAndListenerTuple;
    }

    static {
        ImplementationBridgeHelpers.CosmosBulkExecutionOptionsHelper.setCosmosBulkExecutionOptionsAccessor(new ImplementationBridgeHelpers.CosmosBulkExecutionOptionsHelper.CosmosBulkExecutionOptionsAccessor(){

            @Override
            public void setOperationContext(CosmosBulkExecutionOptions options, OperationContextAndListenerTuple operationContextAndListenerTuple) {
                options.setOperationContextAndListenerTuple(operationContextAndListenerTuple);
            }

            @Override
            public OperationContextAndListenerTuple getOperationContext(CosmosBulkExecutionOptions options) {
                return options.getOperationContextAndListenerTuple();
            }

            @Override
            public <T> T getLegacyBatchScopedContext(CosmosBulkExecutionOptions options) {
                return (T)options.getLegacyBatchScopedContext();
            }
        });
    }
}

