/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.BulkExecutionOptions;
import com.azure.cosmos.BulkExecutionThresholds;
import com.azure.cosmos.BulkProcessingOptions;
import com.azure.cosmos.CosmosAsyncConflict;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.CosmosAsyncScripts;
import com.azure.cosmos.CosmosBridgeInternal;
import com.azure.cosmos.CosmosBulkOperationResponse;
import com.azure.cosmos.CosmosItemOperation;
import com.azure.cosmos.GlobalThroughputControlConfig;
import com.azure.cosmos.ThroughputControlGroupConfig;
import com.azure.cosmos.TransactionalBatch;
import com.azure.cosmos.TransactionalBatchRequestOptions;
import com.azure.cosmos.TransactionalBatchResponse;
import com.azure.cosmos.implementation.AsyncDocumentClient;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.CosmosPagedFluxOptions;
import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.InternalObjectNode;
import com.azure.cosmos.implementation.ItemDeserializer;
import com.azure.cosmos.implementation.Offer;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.RequestOptions;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.batch.BatchExecutor;
import com.azure.cosmos.implementation.batch.BulkExecutor;
import com.azure.cosmos.implementation.feedranges.FeedRangeEpkImpl;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternal;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.query.QueryInfo;
import com.azure.cosmos.implementation.routing.Range;
import com.azure.cosmos.implementation.throughputControl.config.GlobalThroughputControlGroup;
import com.azure.cosmos.implementation.throughputControl.config.LocalThroughputControlGroup;
import com.azure.cosmos.implementation.throughputControl.config.ThroughputControlGroupFactory;
import com.azure.cosmos.models.CosmosBatch;
import com.azure.cosmos.models.CosmosBatchOperationResult;
import com.azure.cosmos.models.CosmosBatchRequestOptions;
import com.azure.cosmos.models.CosmosBatchResponse;
import com.azure.cosmos.models.CosmosBulkExecutionOptions;
import com.azure.cosmos.models.CosmosChangeFeedRequestOptions;
import com.azure.cosmos.models.CosmosConflictProperties;
import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.CosmosContainerRequestOptions;
import com.azure.cosmos.models.CosmosContainerResponse;
import com.azure.cosmos.models.CosmosItemIdentity;
import com.azure.cosmos.models.CosmosItemRequestOptions;
import com.azure.cosmos.models.CosmosItemResponse;
import com.azure.cosmos.models.CosmosPatchItemRequestOptions;
import com.azure.cosmos.models.CosmosPatchOperations;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.FeedRange;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.SqlParameter;
import com.azure.cosmos.models.SqlQuerySpec;
import com.azure.cosmos.models.ThroughputProperties;
import com.azure.cosmos.models.ThroughputResponse;
import com.azure.cosmos.util.Beta;
import com.azure.cosmos.util.CosmosPagedFlux;
import com.azure.cosmos.util.UtilBridgeInternal;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CosmosAsyncContainer {
    private static final Logger logger = LoggerFactory.getLogger(CosmosAsyncContainer.class);
    private final CosmosAsyncDatabase database;
    private final String id;
    private final String link;
    private final String replaceContainerSpanName;
    private final String deleteContainerSpanName;
    private final String replaceThroughputSpanName;
    private final String readThroughputSpanName;
    private final String readContainerSpanName;
    private final String readItemSpanName;
    private final String upsertItemSpanName;
    private final String deleteItemSpanName;
    private final String deleteAllItemsByPartitionKeySpanName;
    private final String replaceItemSpanName;
    private final String patchItemSpanName;
    private final String createItemSpanName;
    private final String readAllItemsSpanName;
    private final String queryItemsSpanName;
    private final String queryChangeFeedSpanName;
    private final String readAllConflictsSpanName;
    private final String queryConflictsSpanName;
    private final String batchSpanName;
    private final AtomicBoolean isInitialized;
    private CosmosAsyncScripts scripts;

    CosmosAsyncContainer(String id, CosmosAsyncDatabase database) {
        this.id = id;
        this.database = database;
        this.link = this.getParentLink() + "/" + this.getURIPathSegment() + "/" + this.getId();
        this.replaceContainerSpanName = "replaceContainer." + this.id;
        this.deleteContainerSpanName = "deleteContainer." + this.id;
        this.replaceThroughputSpanName = "replaceThroughput." + this.id;
        this.readThroughputSpanName = "readThroughput." + this.id;
        this.readContainerSpanName = "readContainer." + this.id;
        this.readItemSpanName = "readItem." + this.id;
        this.upsertItemSpanName = "upsertItem." + this.id;
        this.deleteItemSpanName = "deleteItem." + this.id;
        this.deleteAllItemsByPartitionKeySpanName = "deleteAllItemsByPartitionKey." + this.id;
        this.replaceItemSpanName = "replaceItem." + this.id;
        this.patchItemSpanName = "patchItem." + this.id;
        this.createItemSpanName = "createItem." + this.id;
        this.readAllItemsSpanName = "readAllItems." + this.id;
        this.queryItemsSpanName = "queryItems." + this.id;
        this.queryChangeFeedSpanName = "queryChangeFeed." + this.id;
        this.readAllConflictsSpanName = "readAllConflicts." + this.id;
        this.queryConflictsSpanName = "queryConflicts." + this.id;
        this.batchSpanName = "transactionalBatch." + this.id;
        this.isInitialized = new AtomicBoolean(false);
    }

    public String getId() {
        return this.id;
    }

    public Mono<CosmosContainerResponse> read() {
        return this.read(new CosmosContainerRequestOptions());
    }

    public Mono<CosmosContainerResponse> read(CosmosContainerRequestOptions options) {
        CosmosContainerRequestOptions requestOptions = options == null ? new CosmosContainerRequestOptions() : options;
        return FluxUtil.withContext(context -> this.read(requestOptions, (Context)context));
    }

    public Mono<CosmosContainerResponse> delete(CosmosContainerRequestOptions options) {
        CosmosContainerRequestOptions requestOptions = options == null ? new CosmosContainerRequestOptions() : options;
        return FluxUtil.withContext(context -> this.deleteInternal(requestOptions, (Context)context));
    }

    public Mono<CosmosContainerResponse> delete() {
        return this.delete(new CosmosContainerRequestOptions());
    }

    public Mono<CosmosContainerResponse> replace(CosmosContainerProperties containerProperties) {
        return this.replace(containerProperties, null);
    }

    public Mono<CosmosContainerResponse> replace(CosmosContainerProperties containerProperties, CosmosContainerRequestOptions options) {
        CosmosContainerRequestOptions requestOptions = options == null ? new CosmosContainerRequestOptions() : options;
        return FluxUtil.withContext(context -> this.replaceInternal(containerProperties, requestOptions, (Context)context));
    }

    public <T> Mono<CosmosItemResponse<T>> createItem(T item) {
        return this.createItem(item, new CosmosItemRequestOptions());
    }

    public <T> Mono<CosmosItemResponse<T>> createItem(T item, PartitionKey partitionKey, CosmosItemRequestOptions options) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        ModelBridgeInternal.setPartitionKey(options, partitionKey);
        return this.createItem(item, options);
    }

    public <T> Mono<CosmosItemResponse<T>> createItem(T item, CosmosItemRequestOptions options) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        CosmosItemRequestOptions requestOptions = options;
        return FluxUtil.withContext(context -> this.createItemInternal(item, requestOptions, (Context)context));
    }

    private <T> Mono<CosmosItemResponse<T>> createItemInternal(T item, CosmosItemRequestOptions options, Context context) {
        Mono<CosmosItemResponse<T>> responseMono = this.createItemInternal(item, options);
        return this.database.getClient().getTracerProvider().traceEnabledCosmosItemResponsePublisher(responseMono, context, this.createItemSpanName, this.getId(), this.database.getId(), this.database.getClient(), ModelBridgeInternal.getConsistencyLevel(options), OperationType.Create, ResourceType.Document, options.getThresholdForDiagnosticsOnTracer());
    }

    private <T> Mono<CosmosItemResponse<T>> createItemInternal(T item, CosmosItemRequestOptions options) {
        Class<?> itemType = item.getClass();
        RequestOptions requestOptions = ModelBridgeInternal.toRequestOptions(options);
        return this.database.getDocClientWrapper().createDocument(this.getLink(), item, requestOptions, true).map(response -> ModelBridgeInternal.createCosmosAsyncItemResponse(response, itemType, this.getItemDeserializer())).single();
    }

    public <T> Mono<CosmosItemResponse<T>> upsertItem(T item) {
        return this.upsertItem(item, new CosmosItemRequestOptions());
    }

    public <T> Mono<CosmosItemResponse<T>> upsertItem(T item, CosmosItemRequestOptions options) {
        CosmosItemRequestOptions requestOptions = options == null ? new CosmosItemRequestOptions() : options;
        return FluxUtil.withContext(context -> this.upsertItemInternal(item, requestOptions, (Context)context));
    }

    public <T> Mono<CosmosItemResponse<T>> upsertItem(T item, PartitionKey partitionKey, CosmosItemRequestOptions options) {
        CosmosItemRequestOptions requestOptions = options == null ? new CosmosItemRequestOptions() : options;
        ModelBridgeInternal.setPartitionKey(requestOptions, partitionKey);
        return FluxUtil.withContext(context -> this.upsertItemInternal(item, requestOptions, (Context)context));
    }

    <T> CosmosPagedFlux<T> readAllItems(Class<T> classType) {
        return this.readAllItems(new CosmosQueryRequestOptions(), classType);
    }

    <T> CosmosPagedFlux<T> readAllItems(CosmosQueryRequestOptions options, Class<T> classType) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            pagedFluxOptions.setTracerAndTelemetryInformation(this.readAllItemsSpanName, this.database.getId(), this.getId(), OperationType.ReadFeed, ResourceType.Document, this.getDatabase().getClient());
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, options);
            pagedFluxOptions.setThresholdForDiagnosticsOnTracer(options.getThresholdForDiagnosticsOnTracer());
            return this.getDatabase().getDocClientWrapper().readDocuments(this.getLink(), options).map(response -> this.prepareFeedResponse((FeedResponse<Document>)response, false, classType));
        });
    }

    public <T> CosmosPagedFlux<T> queryItems(String query, Class<T> classType) {
        return this.queryItemsInternal(new SqlQuerySpec(query), new CosmosQueryRequestOptions(), classType);
    }

    @Beta(value=Beta.SinceVersion.V4_14_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public Mono<Void> openConnectionsAndInitCaches() {
        int retryCount = Configs.getOpenConnectionsRetriesCount();
        if (this.isInitialized.compareAndSet(false, true)) {
            return this.getFeedRanges().flatMap(feedRanges -> {
                ArrayList<Flux<FeedResponse<ObjectNode>>> fluxList = new ArrayList<Flux<FeedResponse<ObjectNode>>>();
                SqlQuerySpec querySpec = new SqlQuerySpec();
                querySpec.setQueryText("select * from c where c.id = @id");
                querySpec.setParameters(Collections.singletonList(new SqlParameter("@id", UUID.randomUUID().toString())));
                for (int i = 0; i < retryCount; ++i) {
                    for (FeedRange feedRange : feedRanges) {
                        CosmosQueryRequestOptions options = new CosmosQueryRequestOptions();
                        options.setFeedRange(feedRange);
                        CosmosPagedFlux<ObjectNode> cosmosPagedFlux = this.queryItems(querySpec, options, ObjectNode.class);
                        fluxList.add(cosmosPagedFlux.byPage());
                    }
                }
                Mono listMono = Flux.merge(fluxList).collectList();
                return listMono.flatMap(objects -> Mono.empty());
            });
        }
        logger.warn("openConnectionsAndInitCaches is already called once on Container {}, no operation will take place in this call", (Object)this.getId());
        return Mono.empty();
    }

    public <T> CosmosPagedFlux<T> queryItems(String query, CosmosQueryRequestOptions options, Class<T> classType) {
        if (options == null) {
            options = new CosmosQueryRequestOptions();
        }
        return this.queryItemsInternal(new SqlQuerySpec(query), options, classType);
    }

    public <T> CosmosPagedFlux<T> queryItems(SqlQuerySpec querySpec, Class<T> classType) {
        return this.queryItemsInternal(querySpec, new CosmosQueryRequestOptions(), classType);
    }

    public <T> CosmosPagedFlux<T> queryItems(SqlQuerySpec querySpec, CosmosQueryRequestOptions options, Class<T> classType) {
        if (options == null) {
            options = new CosmosQueryRequestOptions();
        }
        return this.queryItemsInternal(querySpec, options, classType);
    }

    <T> CosmosPagedFlux<T> queryItemsInternal(SqlQuerySpec sqlQuerySpec, CosmosQueryRequestOptions cosmosQueryRequestOptions, Class<T> classType) {
        if (cosmosQueryRequestOptions != null && cosmosQueryRequestOptions.getPartitionKey() != null && cosmosQueryRequestOptions.getFeedRange() != null) {
            throw new IllegalArgumentException("Setting partitionKey and feedRange at the same time is not allowed");
        }
        return UtilBridgeInternal.createCosmosPagedFlux(this.queryItemsInternalFunc(sqlQuerySpec, cosmosQueryRequestOptions, classType));
    }

    <T> Function<CosmosPagedFluxOptions, Flux<FeedResponse<T>>> queryItemsInternalFunc(SqlQuerySpec sqlQuerySpec, CosmosQueryRequestOptions cosmosQueryRequestOptions, Class<T> classType) {
        Function<CosmosPagedFluxOptions, Flux<FeedResponse<T>>> pagedFluxOptionsFluxFunction = pagedFluxOptions -> {
            String spanName = this.queryItemsSpanName;
            pagedFluxOptions.setTracerAndTelemetryInformation(spanName, this.database.getId(), this.getId(), OperationType.Query, ResourceType.Document, this.getDatabase().getClient());
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, cosmosQueryRequestOptions);
            pagedFluxOptions.setThresholdForDiagnosticsOnTracer(cosmosQueryRequestOptions.getThresholdForDiagnosticsOnTracer());
            return this.getDatabase().getDocClientWrapper().queryDocuments(this.getLink(), sqlQuerySpec, cosmosQueryRequestOptions).map(response -> this.prepareFeedResponse((FeedResponse<Document>)response, false, classType));
        };
        return pagedFluxOptionsFluxFunction;
    }

    <T> Function<CosmosPagedFluxOptions, Flux<FeedResponse<T>>> queryItemsInternalFunc(Mono<SqlQuerySpec> sqlQuerySpecMono, CosmosQueryRequestOptions cosmosQueryRequestOptions, Class<T> classType) {
        Function<CosmosPagedFluxOptions, Flux<FeedResponse<T>>> pagedFluxOptionsFluxFunction = pagedFluxOptions -> {
            String spanName = this.queryItemsSpanName;
            pagedFluxOptions.setTracerAndTelemetryInformation(spanName, this.database.getId(), this.getId(), OperationType.Query, ResourceType.Document, this.getDatabase().getClient());
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, cosmosQueryRequestOptions);
            pagedFluxOptions.setThresholdForDiagnosticsOnTracer(cosmosQueryRequestOptions.getThresholdForDiagnosticsOnTracer());
            return sqlQuerySpecMono.flux().flatMap(sqlQuerySpec -> this.getDatabase().getDocClientWrapper().queryDocuments(this.getLink(), (SqlQuerySpec)sqlQuerySpec, cosmosQueryRequestOptions)).map(response -> this.prepareFeedResponse((FeedResponse<Document>)response, false, classType));
        };
        return pagedFluxOptionsFluxFunction;
    }

    @Beta(value=Beta.SinceVersion.V4_12_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public <T> CosmosPagedFlux<T> queryChangeFeed(CosmosChangeFeedRequestOptions options, Class<T> classType) {
        Preconditions.checkNotNull(options, "Argument 'options' must not be null.");
        Preconditions.checkNotNull(classType, "Argument 'classType' must not be null.");
        return this.queryChangeFeedInternal(options, classType);
    }

    <T> CosmosPagedFlux<T> queryChangeFeedInternal(CosmosChangeFeedRequestOptions cosmosChangeFeedRequestOptions, Class<T> classType) {
        return UtilBridgeInternal.createCosmosPagedFlux(this.queryChangeFeedInternalFunc(cosmosChangeFeedRequestOptions, classType));
    }

    <T> Function<CosmosPagedFluxOptions, Flux<FeedResponse<T>>> queryChangeFeedInternalFunc(CosmosChangeFeedRequestOptions cosmosChangeFeedRequestOptions, Class<T> classType) {
        Preconditions.checkNotNull(cosmosChangeFeedRequestOptions, "Argument 'cosmosChangeFeedRequestOptions' must not be null.");
        Function<CosmosPagedFluxOptions, Flux<FeedResponse<T>>> pagedFluxOptionsFluxFunction = pagedFluxOptions -> {
            Preconditions.checkNotNull(pagedFluxOptions, "Argument 'pagedFluxOptions' must not be null.");
            String spanName = this.queryChangeFeedSpanName;
            pagedFluxOptions.setTracerAndTelemetryInformation(spanName, this.database.getId(), this.getId(), OperationType.ReadFeed, ResourceType.Document, this.getDatabase().getClient());
            Utils.getEffectiveCosmosChangeFeedRequestOptions(pagedFluxOptions, cosmosChangeFeedRequestOptions);
            AsyncDocumentClient clientWrapper = this.database.getDocClientWrapper();
            return clientWrapper.getCollectionCache().resolveByNameAsync(null, this.link, null).flatMapMany(collection -> {
                if (collection == null) {
                    throw new IllegalStateException("Collection cannot be null");
                }
                return clientWrapper.queryDocumentChangeFeed((DocumentCollection)collection, cosmosChangeFeedRequestOptions).map(response -> this.prepareFeedResponse((FeedResponse<Document>)response, true, classType));
            });
        };
        return pagedFluxOptionsFluxFunction;
    }

    private <T> FeedResponse<T> prepareFeedResponse(FeedResponse<Document> response, boolean isChangeFeed, Class<T> classType) {
        boolean isNoChangesResponse;
        QueryInfo queryInfo = ModelBridgeInternal.getQueryInfoFromFeedResponse(response);
        boolean useEtagAsContinuation = isChangeFeed;
        boolean bl = isNoChangesResponse = isChangeFeed ? ModelBridgeInternal.getNoCHangesFromFeedResponse(response) : false;
        if (queryInfo != null && queryInfo.hasSelectValue()) {
            List transformedResults = response.getResults().stream().map(d -> d.has("_value") ? this.transform(d.get("_value"), classType) : ModelBridgeInternal.toObjectFromJsonSerializable(d, classType)).collect(Collectors.toList());
            return BridgeInternal.createFeedResponseWithQueryMetrics(transformedResults, response.getResponseHeaders(), ModelBridgeInternal.queryMetrics(response), ModelBridgeInternal.getQueryPlanDiagnosticsContext(response), useEtagAsContinuation, isNoChangesResponse, response.getCosmosDiagnostics());
        }
        return BridgeInternal.createFeedResponseWithQueryMetrics(response.getResults().stream().map(document -> ModelBridgeInternal.toObjectFromJsonSerializable(document, classType)).collect(Collectors.toList()), response.getResponseHeaders(), ModelBridgeInternal.queryMetrics(response), ModelBridgeInternal.getQueryPlanDiagnosticsContext(response), useEtagAsContinuation, isNoChangesResponse, response.getCosmosDiagnostics());
    }

    private <T> T transform(Object object, Class<T> classType) {
        return (T)Utils.getSimpleObjectMapper().convertValue(object, classType);
    }

    @Deprecated
    @Beta(value=Beta.SinceVersion.V4_7_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public Mono<TransactionalBatchResponse> executeTransactionalBatch(TransactionalBatch transactionalBatch) {
        return this.executeTransactionalBatch(transactionalBatch, new TransactionalBatchRequestOptions());
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public Mono<CosmosBatchResponse> executeCosmosBatch(CosmosBatch cosmosBatch) {
        return this.executeCosmosBatch(cosmosBatch, new CosmosBatchRequestOptions());
    }

    @Deprecated
    @Beta(value=Beta.SinceVersion.V4_7_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public Mono<TransactionalBatchResponse> executeTransactionalBatch(TransactionalBatch transactionalBatch, TransactionalBatchRequestOptions requestOptions) {
        if (requestOptions == null) {
            requestOptions = new TransactionalBatchRequestOptions();
        }
        CosmosBatchRequestOptions cosmosBatchRequestOptions = new CosmosBatchRequestOptions();
        cosmosBatchRequestOptions.setSessionToken(requestOptions.getSessionToken());
        ImplementationBridgeHelpers.CosmosBatchRequestOptionsHelper.getCosmosBatchRequestOptionsAccessor().setConsistencyLevel(cosmosBatchRequestOptions, requestOptions.getConsistencyLevel());
        CosmosBatch cosmosBatch = CosmosBatch.createCosmosBatch(transactionalBatch.getPartitionKeyValue());
        ImplementationBridgeHelpers.CosmosBatchHelper.getCosmosBatchAccessor().getOperationsInternal(cosmosBatch).addAll(transactionalBatch.getOperationsInternal());
        Mono<CosmosBatchResponse> cosmosBatchResponseMono = this.executeCosmosBatch(cosmosBatch, cosmosBatchRequestOptions);
        return this.convertToTransactionBatchResponse(cosmosBatchResponseMono);
    }

    private Mono<TransactionalBatchResponse> convertToTransactionBatchResponse(Mono<CosmosBatchResponse> cosmosBatchResponseMono) {
        return cosmosBatchResponseMono.flatMap(cosmosBatchResponse -> {
            TransactionalBatchResponse transactionBatchResponse = BridgeInternal.createTransactionBatchResponse(cosmosBatchResponse.getStatusCode(), cosmosBatchResponse.getSubStatusCode(), cosmosBatchResponse.getErrorMessage(), cosmosBatchResponse.getResponseHeaders(), cosmosBatchResponse.getDiagnostics());
            List transactionalBatchOperationResults = cosmosBatchResponse.getResults().stream().map(cosmosBatchOperationResult -> {
                CosmosItemOperation cosmosItemOperation = BridgeInternal.toDeprecatedCosmosItemOperation(cosmosBatchOperationResult.getOperation());
                return BridgeInternal.createTransactionBatchResult(cosmosBatchOperationResult.getETag(), cosmosBatchOperationResult.getRequestCharge(), ImplementationBridgeHelpers.CosmosBatchOperationResultHelper.getCosmosBatchOperationResultAccessor().getResourceObject((CosmosBatchOperationResult)cosmosBatchOperationResult), cosmosBatchOperationResult.getStatusCode(), cosmosBatchOperationResult.getRetryAfterDuration(), cosmosBatchOperationResult.getSubStatusCode(), cosmosItemOperation);
            }).collect(Collectors.toList());
            transactionBatchResponse.addAll(Collections.unmodifiableList(transactionalBatchOperationResults));
            return Mono.just((Object)transactionBatchResponse);
        });
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public Mono<CosmosBatchResponse> executeCosmosBatch(CosmosBatch cosmosBatch, CosmosBatchRequestOptions requestOptions) {
        if (requestOptions == null) {
            requestOptions = new CosmosBatchRequestOptions();
        }
        CosmosBatchRequestOptions cosmosBatchRequestOptions = requestOptions;
        return FluxUtil.withContext(context -> {
            BatchExecutor executor = new BatchExecutor(this, cosmosBatch, cosmosBatchRequestOptions);
            Mono<CosmosBatchResponse> responseMono = executor.executeAsync();
            return this.database.getClient().getTracerProvider().traceEnabledBatchResponsePublisher(responseMono, (Context)context, this.batchSpanName, this.getId(), this.database.getId(), this.database.getClient(), ImplementationBridgeHelpers.CosmosBatchRequestOptionsHelper.getCosmosBatchRequestOptionsAccessor().getConsistencyLevel(cosmosBatchRequestOptions), OperationType.Batch, ResourceType.Document);
        });
    }

    @Deprecated
    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public <TContext> Flux<CosmosBulkOperationResponse<TContext>> processBulkOperations(Flux<CosmosItemOperation> operations) {
        return this.processBulkOperations(operations, new BulkExecutionOptions());
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public <TContext> Flux<com.azure.cosmos.models.CosmosBulkOperationResponse<TContext>> executeBulkOperations(Flux<com.azure.cosmos.models.CosmosItemOperation> operations) {
        return this.executeBulkOperations(operations, new CosmosBulkExecutionOptions());
    }

    @Deprecated
    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public <TContext> Flux<CosmosBulkOperationResponse<TContext>> processBulkOperations(Flux<CosmosItemOperation> operations, BulkProcessingOptions<TContext> bulkOptions) {
        if (bulkOptions == null) {
            bulkOptions = new BulkProcessingOptions();
        }
        BulkExecutionOptions options = new BulkExecutionOptions(bulkOptions.getBatchContext(), new BulkExecutionThresholds(bulkOptions.getThresholds().getPartitionScopeThresholds()));
        options.setTargetedMicroBatchRetryRate(bulkOptions.getMinTargetedMicroBatchRetryRate(), bulkOptions.getMaxTargetedMicroBatchRetryRate());
        return this.processBulkOperations(operations, options);
    }

    @Deprecated
    @Beta(value=Beta.SinceVersion.V4_18_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public <TContext> Flux<CosmosBulkOperationResponse<TContext>> processBulkOperations(Flux<CosmosItemOperation> operations, BulkExecutionOptions bulkOptions) {
        Flux cosmosItemOperationFlux = operations.flatMap(operation -> Flux.just((Object)ModelBridgeInternal.toCosmosItemOperation(operation)));
        Flux<com.azure.cosmos.models.CosmosBulkOperationResponse<TContext>> cosmosBulkOperationResponseFlux = this.executeBulkOperations((Flux<com.azure.cosmos.models.CosmosItemOperation>)cosmosItemOperationFlux, bulkOptions.toCosmosBulkExecutionOptions());
        return cosmosBulkOperationResponseFlux.flatMap(response -> Flux.just(BridgeInternal.toDeprecatedCosmosBulkOperationResponse(response)));
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public <TContext> Flux<com.azure.cosmos.models.CosmosBulkOperationResponse<TContext>> executeBulkOperations(Flux<com.azure.cosmos.models.CosmosItemOperation> operations, CosmosBulkExecutionOptions bulkOptions) {
        if (bulkOptions == null) {
            bulkOptions = new CosmosBulkExecutionOptions();
        }
        CosmosBulkExecutionOptions cosmosBulkExecutionOptions = bulkOptions;
        return Flux.deferContextual(context -> {
            BulkExecutor executor = new BulkExecutor(this, operations, cosmosBulkExecutionOptions);
            return executor.execute();
        });
    }

    public <T> Mono<CosmosItemResponse<T>> readItem(String itemId, PartitionKey partitionKey, Class<T> itemType) {
        return this.readItem(itemId, partitionKey, ModelBridgeInternal.createCosmosItemRequestOptions(partitionKey), itemType);
    }

    public <T> Mono<CosmosItemResponse<T>> readItem(String itemId, PartitionKey partitionKey, CosmosItemRequestOptions options, Class<T> itemType) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        ModelBridgeInternal.setPartitionKey(options, partitionKey);
        RequestOptions requestOptions = ModelBridgeInternal.toRequestOptions(options);
        return FluxUtil.withContext(context -> this.readItemInternal(itemId, requestOptions, itemType, (Context)context));
    }

    public <T> Mono<FeedResponse<T>> readMany(List<CosmosItemIdentity> itemIdentityList, Class<T> classType) {
        return this.readMany(itemIdentityList, null, classType);
    }

    public <T> Mono<FeedResponse<T>> readMany(List<CosmosItemIdentity> itemIdentityList, String sessionToken, Class<T> classType) {
        CosmosQueryRequestOptions options = new CosmosQueryRequestOptions();
        if (!StringUtils.isNotEmpty(sessionToken)) {
            options = options.setSessionToken(sessionToken);
        }
        options.setMaxDegreeOfParallelism(-1);
        return CosmosBridgeInternal.getAsyncDocumentClient(this.getDatabase()).readMany(itemIdentityList, BridgeInternal.getLink(this), options, classType);
    }

    public <T> CosmosPagedFlux<T> readAllItems(PartitionKey partitionKey, Class<T> classType) {
        CosmosQueryRequestOptions queryRequestOptions = new CosmosQueryRequestOptions();
        queryRequestOptions.setPartitionKey(partitionKey);
        return this.readAllItems(partitionKey, queryRequestOptions, classType);
    }

    public <T> CosmosPagedFlux<T> readAllItems(PartitionKey partitionKey, CosmosQueryRequestOptions options, Class<T> classType) {
        CosmosQueryRequestOptions requestOptions = options == null ? new CosmosQueryRequestOptions() : options;
        requestOptions.setPartitionKey(partitionKey);
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            pagedFluxOptions.setTracerAndTelemetryInformation(this.readAllItemsSpanName, this.database.getId(), this.getId(), OperationType.ReadFeed, ResourceType.Document, this.getDatabase().getClient());
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, requestOptions);
            return this.getDatabase().getDocClientWrapper().readAllDocuments(this.getLink(), partitionKey, requestOptions).map(response -> this.prepareFeedResponse((FeedResponse<Document>)response, false, classType));
        });
    }

    public <T> Mono<CosmosItemResponse<T>> replaceItem(T item, String itemId, PartitionKey partitionKey) {
        return this.replaceItem(item, itemId, partitionKey, new CosmosItemRequestOptions());
    }

    public <T> Mono<CosmosItemResponse<T>> replaceItem(T item, String itemId, PartitionKey partitionKey, CosmosItemRequestOptions options) {
        Document doc = InternalObjectNode.fromObject(item);
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        ModelBridgeInternal.setPartitionKey(options, partitionKey);
        Class<?> itemType = item.getClass();
        CosmosItemRequestOptions requestOptions = options;
        return FluxUtil.withContext(context -> this.replaceItemInternal(itemType, itemId, doc, requestOptions, (Context)context));
    }

    @Deprecated
    @Beta(value=Beta.SinceVersion.V4_11_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public <T> Mono<CosmosItemResponse<T>> patchItem(String itemId, PartitionKey partitionKey, com.azure.cosmos.CosmosPatchOperations cosmosPatchOperations, Class<T> itemType) {
        return this.patchItem(itemId, partitionKey, cosmosPatchOperations, new CosmosPatchItemRequestOptions(), itemType);
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public <T> Mono<CosmosItemResponse<T>> patchItem(String itemId, PartitionKey partitionKey, CosmosPatchOperations cosmosPatchOperations, Class<T> itemType) {
        return this.patchItem(itemId, partitionKey, cosmosPatchOperations, new CosmosPatchItemRequestOptions(), itemType);
    }

    @Deprecated
    @Beta(value=Beta.SinceVersion.V4_11_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public <T> Mono<CosmosItemResponse<T>> patchItem(String itemId, PartitionKey partitionKey, com.azure.cosmos.CosmosPatchOperations cosmosPatchOperations, CosmosPatchItemRequestOptions options, Class<T> itemType) {
        Preconditions.checkNotNull(itemId, "expected non-null itemId");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey for patchItem");
        Preconditions.checkNotNull(cosmosPatchOperations, "expected non-null cosmosPatchOperations");
        if (options == null) {
            options = new CosmosPatchItemRequestOptions();
        }
        ModelBridgeInternal.setPartitionKey(options, partitionKey);
        CosmosPatchItemRequestOptions requestOptions = options;
        CosmosPatchOperations modelsCosmosPatchOperations = CosmosPatchOperations.create();
        ImplementationBridgeHelpers.CosmosPatchOperationsHelper.getCosmosPatchOperationsAccessor().getPatchOperations(modelsCosmosPatchOperations).addAll(cosmosPatchOperations.getPatchOperations());
        return FluxUtil.withContext(context -> this.patchItemInternal(itemId, modelsCosmosPatchOperations, requestOptions, (Context)context, itemType));
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public <T> Mono<CosmosItemResponse<T>> patchItem(String itemId, PartitionKey partitionKey, CosmosPatchOperations cosmosPatchOperations, CosmosPatchItemRequestOptions options, Class<T> itemType) {
        Preconditions.checkNotNull(itemId, "expected non-null itemId");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey for patchItem");
        Preconditions.checkNotNull(cosmosPatchOperations, "expected non-null cosmosPatchOperations");
        if (options == null) {
            options = new CosmosPatchItemRequestOptions();
        }
        ModelBridgeInternal.setPartitionKey(options, partitionKey);
        CosmosPatchItemRequestOptions requestOptions = options;
        return FluxUtil.withContext(context -> this.patchItemInternal(itemId, cosmosPatchOperations, requestOptions, (Context)context, itemType));
    }

    public Mono<CosmosItemResponse<Object>> deleteItem(String itemId, PartitionKey partitionKey) {
        return this.deleteItem(itemId, partitionKey, new CosmosItemRequestOptions());
    }

    public Mono<CosmosItemResponse<Object>> deleteItem(String itemId, PartitionKey partitionKey, CosmosItemRequestOptions options) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        ModelBridgeInternal.setPartitionKey(options, partitionKey);
        RequestOptions requestOptions = ModelBridgeInternal.toRequestOptions(options);
        return FluxUtil.withContext(context -> this.deleteItemInternal(itemId, null, requestOptions, (Context)context));
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public Mono<CosmosItemResponse<Object>> deleteAllItemsByPartitionKey(PartitionKey partitionKey, CosmosItemRequestOptions options) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        ModelBridgeInternal.setPartitionKey(options, partitionKey);
        RequestOptions requestOptions = ModelBridgeInternal.toRequestOptions(options);
        return FluxUtil.withContext(context -> this.deleteAllItemsByPartitionKeyInternal(partitionKey, requestOptions, (Context)context));
    }

    public <T> Mono<CosmosItemResponse<Object>> deleteItem(T item, CosmosItemRequestOptions options) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        RequestOptions requestOptions = ModelBridgeInternal.toRequestOptions(options);
        InternalObjectNode internalObjectNode = InternalObjectNode.fromObjectToInternalObjectNode(item);
        return FluxUtil.withContext(context -> this.deleteItemInternal(internalObjectNode.getId(), internalObjectNode, requestOptions, (Context)context));
    }

    private String getItemLink(String itemId) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getLink());
        builder.append("/");
        builder.append("docs");
        builder.append("/");
        builder.append(itemId);
        return builder.toString();
    }

    public CosmosAsyncScripts getScripts() {
        if (this.scripts == null) {
            this.scripts = new CosmosAsyncScripts(this);
        }
        return this.scripts;
    }

    public CosmosPagedFlux<CosmosConflictProperties> readAllConflicts(CosmosQueryRequestOptions options) {
        CosmosQueryRequestOptions requestOptions = options == null ? new CosmosQueryRequestOptions() : options;
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            pagedFluxOptions.setTracerInformation(this.getDatabase().getClient().getTracerProvider(), this.readAllConflictsSpanName, this.getDatabase().getClient().getServiceEndpoint(), this.database.getId());
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, requestOptions);
            return this.database.getDocClientWrapper().readConflicts(this.getLink(), requestOptions).map(response -> BridgeInternal.createFeedResponse(ModelBridgeInternal.getCosmosConflictPropertiesFromV2Results(response.getResults()), response.getResponseHeaders()));
        });
    }

    public CosmosPagedFlux<CosmosConflictProperties> queryConflicts(String query) {
        return this.queryConflicts(query, new CosmosQueryRequestOptions());
    }

    public CosmosPagedFlux<CosmosConflictProperties> queryConflicts(String query, CosmosQueryRequestOptions options) {
        CosmosQueryRequestOptions requestOptions = options == null ? new CosmosQueryRequestOptions() : options;
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            pagedFluxOptions.setTracerInformation(this.getDatabase().getClient().getTracerProvider(), this.queryConflictsSpanName, this.getDatabase().getClient().getServiceEndpoint(), this.database.getId());
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, requestOptions);
            return this.database.getDocClientWrapper().queryConflicts(this.getLink(), query, requestOptions).map(response -> BridgeInternal.createFeedResponse(ModelBridgeInternal.getCosmosConflictPropertiesFromV2Results(response.getResults()), response.getResponseHeaders()));
        });
    }

    public CosmosAsyncConflict getConflict(String id) {
        return new CosmosAsyncConflict(id, this);
    }

    public Mono<ThroughputResponse> replaceThroughput(ThroughputProperties throughputProperties) {
        return FluxUtil.withContext(context -> this.replaceThroughputInternal(throughputProperties, (Context)context));
    }

    public Mono<ThroughputResponse> readThroughput() {
        return FluxUtil.withContext(context -> this.readThroughputInternal((Context)context));
    }

    public CosmosAsyncDatabase getDatabase() {
        return this.database;
    }

    String getURIPathSegment() {
        return "colls";
    }

    String getParentLink() {
        return this.database.getLink();
    }

    String getLink() {
        return this.link;
    }

    private Mono<CosmosItemResponse<Object>> deleteItemInternal(String itemId, InternalObjectNode internalObjectNode, RequestOptions requestOptions, Context context) {
        Mono responseMono = this.getDatabase().getDocClientWrapper().deleteDocument(this.getItemLink(itemId), internalObjectNode, requestOptions).map(response -> ModelBridgeInternal.createCosmosAsyncItemResponseWithObjectType(response)).single();
        return this.database.getClient().getTracerProvider().traceEnabledCosmosItemResponsePublisher(responseMono, context, this.deleteItemSpanName, this.getId(), this.database.getId(), this.database.getClient(), requestOptions.getConsistencyLevel(), OperationType.Delete, ResourceType.Document, requestOptions.getThresholdForDiagnosticsOnTracer());
    }

    private Mono<CosmosItemResponse<Object>> deleteAllItemsByPartitionKeyInternal(PartitionKey partitionKey, RequestOptions requestOptions, Context context) {
        Mono responseMono = this.getDatabase().getDocClientWrapper().deleteAllDocumentsByPartitionKey(this.getLink(), partitionKey, requestOptions).map(response -> ModelBridgeInternal.createCosmosAsyncItemResponseWithObjectType(response)).single();
        return this.database.getClient().getTracerProvider().traceEnabledCosmosItemResponsePublisher(responseMono, context, this.deleteAllItemsByPartitionKeySpanName, this.getId(), this.database.getId(), this.database.getClient(), requestOptions.getConsistencyLevel(), OperationType.Delete, ResourceType.PartitionKey, requestOptions.getThresholdForDiagnosticsOnTracer());
    }

    private <T> Mono<CosmosItemResponse<T>> replaceItemInternal(Class<T> itemType, String itemId, Document doc, CosmosItemRequestOptions options, Context context) {
        Mono responseMono = this.getDatabase().getDocClientWrapper().replaceDocument(this.getItemLink(itemId), doc, ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosAsyncItemResponse(response, itemType, this.getItemDeserializer())).single();
        return this.database.getClient().getTracerProvider().traceEnabledCosmosItemResponsePublisher(responseMono, context, this.replaceItemSpanName, this.getId(), this.database.getId(), this.database.getClient(), ModelBridgeInternal.getConsistencyLevel(options), OperationType.Replace, ResourceType.Document, options.getThresholdForDiagnosticsOnTracer());
    }

    private <T> Mono<CosmosItemResponse<T>> patchItemInternal(String itemId, CosmosPatchOperations cosmosPatchOperations, CosmosPatchItemRequestOptions options, Context context, Class<T> itemType) {
        Mono responseMono = this.getDatabase().getDocClientWrapper().patchDocument(this.getItemLink(itemId), cosmosPatchOperations, ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosAsyncItemResponse(response, itemType, this.getItemDeserializer()));
        return this.database.getClient().getTracerProvider().traceEnabledCosmosItemResponsePublisher(responseMono, context, this.patchItemSpanName, this.getId(), this.database.getId(), this.database.getClient(), ModelBridgeInternal.getConsistencyLevel(options), OperationType.Patch, ResourceType.Document, options.getThresholdForDiagnosticsOnTracer());
    }

    private <T> Mono<CosmosItemResponse<T>> upsertItemInternal(T item, CosmosItemRequestOptions options, Context context) {
        Class<?> itemType = item.getClass();
        Mono responseMono = this.getDatabase().getDocClientWrapper().upsertDocument(this.getLink(), item, ModelBridgeInternal.toRequestOptions(options), true).map(response -> ModelBridgeInternal.createCosmosAsyncItemResponse(response, itemType, this.getItemDeserializer())).single();
        return this.database.getClient().getTracerProvider().traceEnabledCosmosItemResponsePublisher(responseMono, context, this.upsertItemSpanName, this.getId(), this.database.getId(), this.database.getClient(), ModelBridgeInternal.getConsistencyLevel(options), OperationType.Upsert, ResourceType.Document, options.getThresholdForDiagnosticsOnTracer());
    }

    private <T> Mono<CosmosItemResponse<T>> readItemInternal(String itemId, RequestOptions requestOptions, Class<T> itemType, Context context) {
        Mono responseMono = this.getDatabase().getDocClientWrapper().readDocument(this.getItemLink(itemId), requestOptions).map(response -> ModelBridgeInternal.createCosmosAsyncItemResponse(response, itemType, this.getItemDeserializer())).single();
        return this.database.getClient().getTracerProvider().traceEnabledCosmosItemResponsePublisher(responseMono, context, this.readItemSpanName, this.getId(), this.database.getId(), this.database.getClient(), requestOptions.getConsistencyLevel(), OperationType.Read, ResourceType.Document, requestOptions.getThresholdForDiagnosticsOnTracer());
    }

    Mono<CosmosContainerResponse> read(CosmosContainerRequestOptions options, Context context) {
        Mono responseMono = this.database.getDocClientWrapper().readCollection(this.getLink(), ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosContainerResponse(response)).single();
        return this.database.getClient().getTracerProvider().traceEnabledCosmosResponsePublisher(responseMono, context, this.readContainerSpanName, this.database.getId(), this.database.getClient().getServiceEndpoint());
    }

    private Mono<CosmosContainerResponse> deleteInternal(CosmosContainerRequestOptions options, Context context) {
        Mono responseMono = this.database.getDocClientWrapper().deleteCollection(this.getLink(), ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosContainerResponse(response)).single();
        return this.database.getClient().getTracerProvider().traceEnabledCosmosResponsePublisher(responseMono, context, this.deleteContainerSpanName, this.database.getId(), this.database.getClient().getServiceEndpoint());
    }

    private Mono<CosmosContainerResponse> replaceInternal(CosmosContainerProperties containerProperties, CosmosContainerRequestOptions options, Context context) {
        Mono responseMono = this.database.getDocClientWrapper().replaceCollection(ModelBridgeInternal.getV2Collection(containerProperties), ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosContainerResponse(response)).single();
        return this.database.getClient().getTracerProvider().traceEnabledCosmosResponsePublisher(responseMono, context, this.replaceContainerSpanName, this.database.getId(), this.database.getClient().getServiceEndpoint());
    }

    private Mono<ThroughputResponse> readThroughputInternal(Context context) {
        Context nestedContext = context.addData((Object)"cosmosCallDepth", (Object)"nested");
        Mono<ThroughputResponse> responseMono = this.readThroughputInternal(this.read(new CosmosContainerRequestOptions(), nestedContext));
        return this.getDatabase().getClient().getTracerProvider().traceEnabledCosmosResponsePublisher(responseMono, context, this.readThroughputSpanName, this.database.getId(), this.database.getClient().getServiceEndpoint());
    }

    private Mono<ThroughputResponse> readThroughputInternal(Mono<CosmosContainerResponse> responseMono) {
        return responseMono.flatMap(response -> this.database.getDocClientWrapper().queryOffers(this.database.getOfferQuerySpecFromResourceId(response.getProperties().getResourceId()), new CosmosQueryRequestOptions()).single().flatMap(offerFeedResponse -> {
            if (offerFeedResponse.getResults().isEmpty()) {
                return Mono.error((Throwable)((Object)BridgeInternal.createCosmosException(400, "No offers found for the resource " + this.getId())));
            }
            return this.database.getDocClientWrapper().readOffer(((Offer)offerFeedResponse.getResults().get(0)).getSelfLink()).single();
        }).map(ModelBridgeInternal::createThroughputRespose));
    }

    private Mono<ThroughputResponse> replaceThroughputInternal(ThroughputProperties throughputProperties, Context context) {
        Context nestedContext = context.addData((Object)"cosmosCallDepth", (Object)"nested");
        Mono<ThroughputResponse> responseMono = this.replaceThroughputInternal(this.read(new CosmosContainerRequestOptions(), nestedContext), throughputProperties);
        return this.getDatabase().getClient().getTracerProvider().traceEnabledCosmosResponsePublisher(responseMono, context, this.replaceThroughputSpanName, this.database.getId(), this.database.getClient().getServiceEndpoint());
    }

    private Mono<ThroughputResponse> replaceThroughputInternal(Mono<CosmosContainerResponse> responseMono, ThroughputProperties throughputProperties) {
        return responseMono.flatMap(response -> this.database.getDocClientWrapper().queryOffers(this.database.getOfferQuerySpecFromResourceId(response.getProperties().getResourceId()), new CosmosQueryRequestOptions()).single().flatMap(offerFeedResponse -> {
            if (offerFeedResponse.getResults().isEmpty()) {
                return Mono.error((Throwable)((Object)BridgeInternal.createCosmosException(400, "No offers found for the resource " + this.getId())));
            }
            Offer existingOffer = (Offer)offerFeedResponse.getResults().get(0);
            Offer updatedOffer = ModelBridgeInternal.updateOfferFromProperties(existingOffer, throughputProperties);
            return this.database.getDocClientWrapper().replaceOffer(updatedOffer).single();
        }).map(ModelBridgeInternal::createThroughputRespose));
    }

    ItemDeserializer getItemDeserializer() {
        return this.getDatabase().getDocClientWrapper().getItemDeserializer();
    }

    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public Mono<List<FeedRange>> getFeedRanges() {
        return this.getDatabase().getDocClientWrapper().getFeedRanges(this.getLink());
    }

    Mono<List<FeedRangeEpkImpl>> trySplitFeedRange(FeedRange feedRange, int targetedCountAfterSplit) {
        Preconditions.checkNotNull(feedRange, "Argument 'feedRange' must not be null.");
        AsyncDocumentClient clientWrapper = this.database.getDocClientWrapper();
        Mono getCollectionObservable = clientWrapper.getCollectionCache().resolveByNameAsync(null, this.link, null).map(collection -> Utils.ValueHolder.initialize(collection));
        return FeedRangeInternal.convert(feedRange).trySplit(clientWrapper.getPartitionKeyRangeCache(), null, (Mono<Utils.ValueHolder<DocumentCollection>>)getCollectionObservable, targetedCountAfterSplit);
    }

    Mono<Range<String>> getNormalizedEffectiveRange(FeedRange feedRange) {
        Preconditions.checkNotNull(feedRange, "Argument 'feedRange' must not be null.");
        AsyncDocumentClient clientWrapper = this.database.getDocClientWrapper();
        Mono getCollectionObservable = clientWrapper.getCollectionCache().resolveByNameAsync(null, this.link, null).map(collection -> Utils.ValueHolder.initialize(collection));
        return FeedRangeInternal.convert(feedRange).getNormalizedEffectiveRange(clientWrapper.getPartitionKeyRangeCache(), null, (Mono<Utils.ValueHolder<DocumentCollection>>)getCollectionObservable);
    }

    @Beta(value=Beta.SinceVersion.V4_13_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public void enableLocalThroughputControlGroup(ThroughputControlGroupConfig groupConfig) {
        LocalThroughputControlGroup localControlGroup = ThroughputControlGroupFactory.createThroughputLocalControlGroup(groupConfig, this);
        this.database.getClient().enableThroughputControlGroup(localControlGroup);
    }

    @Beta(value=Beta.SinceVersion.V4_13_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public void enableGlobalThroughputControlGroup(ThroughputControlGroupConfig groupConfig, GlobalThroughputControlConfig globalControlConfig) {
        GlobalThroughputControlGroup globalControlGroup = ThroughputControlGroupFactory.createThroughputGlobalControlGroup(groupConfig, globalControlConfig, this);
        this.database.getClient().enableThroughputControlGroup(globalControlGroup);
    }

    static {
        ImplementationBridgeHelpers.CosmosAsyncContainerHelper.setCosmosAsyncContainerAccessor(new ImplementationBridgeHelpers.CosmosAsyncContainerHelper.CosmosAsyncContainerAccessor(){

            @Override
            public <T> Function<CosmosPagedFluxOptions, Flux<FeedResponse<T>>> queryChangeFeedInternalFunc(CosmosAsyncContainer cosmosAsyncContainer, CosmosChangeFeedRequestOptions cosmosChangeFeedRequestOptions, Class<T> classType) {
                return cosmosAsyncContainer.queryChangeFeedInternalFunc(cosmosChangeFeedRequestOptions, classType);
            }
        });
    }
}

