/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.batch.BatchExecUtils;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.util.Beta;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Duration;
import java.util.Map;

@Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
public final class CosmosBulkItemResponse {
    private final String eTag;
    private final double requestCharge;
    private final ObjectNode resourceObject;
    private final int statusCode;
    private final Duration retryAfter;
    private final int subStatusCode;
    private final Map<String, String> responseHeaders;
    private final CosmosDiagnostics cosmosDiagnostics;

    CosmosBulkItemResponse(String eTag, double requestCharge, ObjectNode resourceObject, int statusCode, Duration retryAfter, int subStatusCode, Map<String, String> responseHeaders, CosmosDiagnostics cosmosDiagnostics) {
        Preconditions.checkNotNull(responseHeaders, "expected non-null responseHeaders");
        this.eTag = eTag;
        this.requestCharge = requestCharge;
        this.resourceObject = resourceObject;
        this.statusCode = statusCode;
        this.retryAfter = retryAfter;
        this.subStatusCode = subStatusCode;
        this.responseHeaders = responseHeaders;
        this.cosmosDiagnostics = cosmosDiagnostics;
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public String getActivityId() {
        return BatchExecUtils.getActivityId(this.responseHeaders);
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public String getETag() {
        return this.eTag;
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public double getRequestCharge() {
        return this.requestCharge;
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public <T> T getItem(Class<T> type) {
        T item = null;
        if (this.getResourceObject() != null) {
            item = new JsonSerializable(this.getResourceObject()).toObject(type);
        }
        return item;
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public Duration getRetryAfterDuration() {
        return this.retryAfter;
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public int getSubStatusCode() {
        return this.subStatusCode;
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public boolean isSuccessStatusCode() {
        return this.statusCode >= 200 && this.statusCode <= 299;
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public int getStatusCode() {
        return this.statusCode;
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public CosmosDiagnostics getCosmosDiagnostics() {
        return this.cosmosDiagnostics;
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public String getSessionToken() {
        return BatchExecUtils.getSessionToken(this.responseHeaders);
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    @Beta(value=Beta.SinceVersion.V4_19_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public Duration getDuration() {
        if (this.cosmosDiagnostics == null) {
            return Duration.ZERO;
        }
        return this.cosmosDiagnostics.getDuration();
    }

    private ObjectNode getResourceObject() {
        return this.resourceObject;
    }

    static {
        ImplementationBridgeHelpers.CosmosBulkItemResponseHelper.setCosmosBulkItemResponseAccessor(new ImplementationBridgeHelpers.CosmosBulkItemResponseHelper.CosmosBulkItemResponseAccessor(){

            @Override
            public ObjectNode getResourceObject(CosmosBulkItemResponse cosmosBulkItemResponse) {
                return cosmosBulkItemResponse.getResourceObject();
            }
        });
    }
}

