/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.implementation.RequestOptions;
import com.azure.cosmos.models.CosmosConflictRequestOptions;
import com.azure.cosmos.models.CosmosConflictResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import reactor.core.publisher.Mono;

public final class CosmosAsyncConflict {
    private final CosmosAsyncContainer container;
    private String id;

    CosmosAsyncConflict(String id, CosmosAsyncContainer container) {
        this.id = id;
        this.container = container;
    }

    public String getId() {
        return this.id;
    }

    CosmosAsyncConflict setId(String id) {
        this.id = id;
        return this;
    }

    public Mono<CosmosConflictResponse> read(CosmosConflictRequestOptions options) {
        if (options == null) {
            options = new CosmosConflictRequestOptions();
        }
        RequestOptions requestOptions = ModelBridgeInternal.toRequestOptions(options);
        return this.container.getDatabase().getDocClientWrapper().readConflict(this.getLink(), requestOptions).map(response -> ModelBridgeInternal.createCosmosConflictResponse(response)).single();
    }

    public Mono<CosmosConflictResponse> delete(CosmosConflictRequestOptions options) {
        if (options == null) {
            options = new CosmosConflictRequestOptions();
        }
        RequestOptions requestOptions = ModelBridgeInternal.toRequestOptions(options);
        return this.container.getDatabase().getDocClientWrapper().deleteConflict(this.getLink(), requestOptions).map(response -> ModelBridgeInternal.createCosmosConflictResponse(response)).single();
    }

    String getURIPathSegment() {
        return "conflicts";
    }

    String getParentLink() {
        return this.container.getLink();
    }

    String getLink() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getParentLink());
        builder.append("/");
        builder.append(this.getURIPathSegment());
        builder.append("/");
        builder.append(this.getId());
        return builder.toString();
    }
}

