/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.CosmosAsyncPermission;
import com.azure.cosmos.implementation.Permission;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.models.CosmosPermissionProperties;
import com.azure.cosmos.models.CosmosPermissionRequestOptions;
import com.azure.cosmos.models.CosmosPermissionResponse;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.CosmosUserProperties;
import com.azure.cosmos.models.CosmosUserResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.util.CosmosPagedFlux;
import com.azure.cosmos.util.UtilBridgeInternal;
import reactor.core.publisher.Mono;

public class CosmosAsyncUser {
    private final CosmosAsyncDatabase database;
    private String id;

    CosmosAsyncUser(String id, CosmosAsyncDatabase database) {
        this.id = id;
        this.database = database;
    }

    public String getId() {
        return this.id;
    }

    CosmosAsyncUser setId(String id) {
        this.id = id;
        return this;
    }

    public Mono<CosmosUserResponse> read() {
        return this.database.getDocClientWrapper().readUser(this.getLink(), null).map(response -> ModelBridgeInternal.createCosmosUserResponse(response)).single();
    }

    public Mono<CosmosUserResponse> replace(CosmosUserProperties userProperties) {
        return this.database.getDocClientWrapper().replaceUser(ModelBridgeInternal.getV2User(userProperties), null).map(response -> ModelBridgeInternal.createCosmosUserResponse(response)).single();
    }

    public Mono<CosmosUserResponse> delete() {
        return this.database.getDocClientWrapper().deleteUser(this.getLink(), null).map(response -> ModelBridgeInternal.createCosmosUserResponse(response)).single();
    }

    public Mono<CosmosPermissionResponse> createPermission(CosmosPermissionProperties permissionProperties, CosmosPermissionRequestOptions options) {
        if (options == null) {
            options = new CosmosPermissionRequestOptions();
        }
        Permission permission = ModelBridgeInternal.getPermission(permissionProperties, this.database.getId());
        return this.database.getDocClientWrapper().createPermission(this.getLink(), permission, ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosPermissionResponse(response)).single();
    }

    public Mono<CosmosPermissionResponse> upsertPermission(CosmosPermissionProperties permissionProperties, CosmosPermissionRequestOptions options) {
        Permission permission = ModelBridgeInternal.getPermission(permissionProperties, this.database.getId());
        if (options == null) {
            options = new CosmosPermissionRequestOptions();
        }
        return this.database.getDocClientWrapper().upsertPermission(this.getLink(), permission, ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosPermissionResponse(response)).single();
    }

    public CosmosPagedFlux<CosmosPermissionProperties> readAllPermissions() {
        return this.readAllPermissions(new CosmosQueryRequestOptions());
    }

    CosmosPagedFlux<CosmosPermissionProperties> readAllPermissions(CosmosQueryRequestOptions options) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, options);
            return this.getDatabase().getDocClientWrapper().readPermissions(this.getLink(), options).map(response -> BridgeInternal.createFeedResponse(ModelBridgeInternal.getCosmosPermissionPropertiesFromResults(response.getResults()), response.getResponseHeaders()));
        });
    }

    public CosmosPagedFlux<CosmosPermissionProperties> queryPermissions(String query) {
        return this.queryPermissions(query, new CosmosQueryRequestOptions());
    }

    public CosmosPagedFlux<CosmosPermissionProperties> queryPermissions(String query, CosmosQueryRequestOptions options) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, options);
            return this.getDatabase().getDocClientWrapper().queryPermissions(this.getLink(), query, options).map(response -> BridgeInternal.createFeedResponse(ModelBridgeInternal.getCosmosPermissionPropertiesFromResults(response.getResults()), response.getResponseHeaders()));
        });
    }

    public CosmosAsyncPermission getPermission(String id) {
        return new CosmosAsyncPermission(id, this);
    }

    String getURIPathSegment() {
        return "users";
    }

    String getParentLink() {
        return this.database.getLink();
    }

    String getLink() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getParentLink());
        builder.append("/");
        builder.append(this.getURIPathSegment());
        builder.append("/");
        builder.append(this.getId());
        return builder.toString();
    }

    CosmosAsyncDatabase getDatabase() {
        return this.database;
    }
}

