/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.credential.AzureKeyCredential;
import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosClient;
import com.azure.cosmos.DirectConnectionConfig;
import com.azure.cosmos.GatewayConnectionConfig;
import com.azure.cosmos.ThrottlingRetryOptions;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.ConnectionPolicy;
import com.azure.cosmos.implementation.CosmosAuthorizationTokenResolver;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.models.CosmosPermissionProperties;
import java.util.Collections;
import java.util.List;

@ServiceClientBuilder(serviceClients={CosmosClient.class, CosmosAsyncClient.class})
public class CosmosClientBuilder {
    private Configs configs = new Configs();
    private String serviceEndpoint;
    private String keyOrResourceToken;
    private ConnectionPolicy connectionPolicy = new ConnectionPolicy(DirectConnectionConfig.getDefaultConfig());
    private GatewayConnectionConfig gatewayConnectionConfig;
    private DirectConnectionConfig directConnectionConfig;
    private ConsistencyLevel desiredConsistencyLevel;
    private List<CosmosPermissionProperties> permissions;
    private CosmosAuthorizationTokenResolver cosmosAuthorizationTokenResolver;
    private AzureKeyCredential credential;
    private boolean sessionCapturingOverrideEnabled;
    private boolean connectionSharingAcrossClientsEnabled;
    private boolean contentResponseOnWriteEnabled;
    private String userAgentSuffix = "";
    private ThrottlingRetryOptions throttlingRetryOptions = new ThrottlingRetryOptions();
    private List<String> preferredRegions;
    private boolean endpointDiscoveryEnabled = true;
    private boolean multipleWriteRegionsEnabled = true;
    private boolean readRequestsFallbackEnabled = true;

    CosmosClientBuilder sessionCapturingOverrideEnabled(boolean sessionCapturingOverrideEnabled) {
        this.sessionCapturingOverrideEnabled = sessionCapturingOverrideEnabled;
        return this;
    }

    boolean isSessionCapturingOverrideEnabled() {
        return this.sessionCapturingOverrideEnabled;
    }

    public CosmosClientBuilder connectionSharingAcrossClientsEnabled(boolean connectionSharingAcrossClientsEnabled) {
        this.connectionSharingAcrossClientsEnabled = connectionSharingAcrossClientsEnabled;
        return this;
    }

    boolean isConnectionSharingAcrossClientsEnabled() {
        return this.connectionSharingAcrossClientsEnabled;
    }

    CosmosAuthorizationTokenResolver getAuthorizationTokenResolver() {
        return this.cosmosAuthorizationTokenResolver;
    }

    CosmosClientBuilder authorizationTokenResolver(CosmosAuthorizationTokenResolver cosmosAuthorizationTokenResolver) {
        this.cosmosAuthorizationTokenResolver = cosmosAuthorizationTokenResolver;
        return this;
    }

    String getEndpoint() {
        return this.serviceEndpoint;
    }

    public CosmosClientBuilder endpoint(String endpoint) {
        this.serviceEndpoint = endpoint;
        return this;
    }

    String getKey() {
        return this.keyOrResourceToken;
    }

    public CosmosClientBuilder key(String key) {
        this.keyOrResourceToken = key;
        return this;
    }

    String getResourceToken() {
        return this.keyOrResourceToken;
    }

    public CosmosClientBuilder resourceToken(String resourceToken) {
        this.keyOrResourceToken = resourceToken;
        return this;
    }

    List<CosmosPermissionProperties> getPermissions() {
        return this.permissions;
    }

    public CosmosClientBuilder permissions(List<CosmosPermissionProperties> permissions) {
        this.permissions = permissions;
        return this;
    }

    ConsistencyLevel getConsistencyLevel() {
        return this.desiredConsistencyLevel;
    }

    public CosmosClientBuilder consistencyLevel(ConsistencyLevel desiredConsistencyLevel) {
        this.desiredConsistencyLevel = desiredConsistencyLevel;
        return this;
    }

    ConnectionPolicy getConnectionPolicy() {
        return this.connectionPolicy;
    }

    AzureKeyCredential getCredential() {
        return this.credential;
    }

    public CosmosClientBuilder credential(AzureKeyCredential credential) {
        this.credential = credential;
        return this;
    }

    boolean isContentResponseOnWriteEnabled() {
        return this.contentResponseOnWriteEnabled;
    }

    public CosmosClientBuilder contentResponseOnWriteEnabled(boolean contentResponseOnWriteEnabled) {
        this.contentResponseOnWriteEnabled = contentResponseOnWriteEnabled;
        return this;
    }

    public CosmosClientBuilder gatewayMode() {
        this.gatewayConnectionConfig = GatewayConnectionConfig.getDefaultConfig();
        return this;
    }

    public CosmosClientBuilder gatewayMode(GatewayConnectionConfig gatewayConnectionConfig) {
        this.gatewayConnectionConfig = gatewayConnectionConfig;
        return this;
    }

    public CosmosClientBuilder directMode() {
        this.directConnectionConfig = DirectConnectionConfig.getDefaultConfig();
        return this;
    }

    public CosmosClientBuilder directMode(DirectConnectionConfig directConnectionConfig) {
        this.directConnectionConfig = directConnectionConfig;
        return this;
    }

    public CosmosClientBuilder directMode(DirectConnectionConfig directConnectionConfig, GatewayConnectionConfig gatewayConnectionConfig) {
        this.directConnectionConfig = directConnectionConfig;
        this.gatewayConnectionConfig = gatewayConnectionConfig;
        return this;
    }

    public CosmosClientBuilder userAgentSuffix(String userAgentSuffix) {
        this.userAgentSuffix = userAgentSuffix;
        return this;
    }

    public CosmosClientBuilder throttlingRetryOptions(ThrottlingRetryOptions throttlingRetryOptions) {
        this.throttlingRetryOptions = throttlingRetryOptions;
        return this;
    }

    public CosmosClientBuilder preferredRegions(List<String> preferredRegions) {
        this.preferredRegions = preferredRegions;
        return this;
    }

    public CosmosClientBuilder endpointDiscoveryEnabled(boolean endpointDiscoveryEnabled) {
        this.endpointDiscoveryEnabled = endpointDiscoveryEnabled;
        return this;
    }

    public CosmosClientBuilder multipleWriteRegionsEnabled(boolean multipleWriteRegionsEnabled) {
        this.multipleWriteRegionsEnabled = multipleWriteRegionsEnabled;
        return this;
    }

    public CosmosClientBuilder readRequestsFallbackEnabled(boolean readRequestsFallbackEnabled) {
        this.readRequestsFallbackEnabled = readRequestsFallbackEnabled;
        return this;
    }

    GatewayConnectionConfig getGatewayConnectionConfig() {
        return this.gatewayConnectionConfig;
    }

    DirectConnectionConfig getDirectConnectionConfig() {
        return this.directConnectionConfig;
    }

    String getUserAgentSuffix() {
        return this.userAgentSuffix;
    }

    ThrottlingRetryOptions getThrottlingRetryOptions() {
        return this.throttlingRetryOptions;
    }

    List<String> getPreferredRegions() {
        return this.preferredRegions != null ? this.preferredRegions : Collections.emptyList();
    }

    boolean isEndpointDiscoveryEnabled() {
        return this.endpointDiscoveryEnabled;
    }

    boolean isMultipleWriteRegionsEnabled() {
        return this.multipleWriteRegionsEnabled;
    }

    boolean isReadRequestsFallbackEnabled() {
        return this.readRequestsFallbackEnabled;
    }

    public CosmosAsyncClient buildAsyncClient() {
        this.validateConfig();
        this.buildConnectionPolicy();
        return new CosmosAsyncClient(this);
    }

    public CosmosClient buildClient() {
        this.validateConfig();
        this.buildConnectionPolicy();
        return new CosmosClient(this);
    }

    private void buildConnectionPolicy() {
        if (this.directConnectionConfig != null) {
            this.connectionPolicy = new ConnectionPolicy(this.directConnectionConfig);
            if (this.gatewayConnectionConfig != null) {
                this.connectionPolicy.setMaxConnectionPoolSize(this.gatewayConnectionConfig.getMaxConnectionPoolSize());
                this.connectionPolicy.setRequestTimeout(this.gatewayConnectionConfig.getRequestTimeout());
                this.connectionPolicy.setIdleHttpConnectionTimeout(this.gatewayConnectionConfig.getIdleConnectionTimeout());
            }
        } else if (this.gatewayConnectionConfig != null) {
            this.connectionPolicy = new ConnectionPolicy(this.gatewayConnectionConfig);
        }
        this.connectionPolicy.setPreferredRegions(this.preferredRegions);
        this.connectionPolicy.setUserAgentSuffix(this.userAgentSuffix);
        this.connectionPolicy.setThrottlingRetryOptions(this.throttlingRetryOptions);
        this.connectionPolicy.setEndpointDiscoveryEnabled(this.endpointDiscoveryEnabled);
        this.connectionPolicy.setMultipleWriteRegionsEnabled(this.multipleWriteRegionsEnabled);
        this.connectionPolicy.setReadRequestsFallbackEnabled(this.readRequestsFallbackEnabled);
    }

    private void validateConfig() {
        this.ifThrowIllegalArgException(this.serviceEndpoint == null, "cannot buildAsyncClient client without service endpoint");
        this.ifThrowIllegalArgException(this.keyOrResourceToken == null && (this.permissions == null || this.permissions.isEmpty()) && this.credential == null, "cannot buildAsyncClient client without any one of key, resource token, permissions, and azure key credential");
        this.ifThrowIllegalArgException(this.credential != null && StringUtils.isEmpty(this.credential.getKey()), "cannot buildAsyncClient client without key credential");
    }

    Configs configs() {
        return this.configs;
    }

    CosmosClientBuilder configs(Configs configs) {
        this.configs = configs;
        return this;
    }

    private void ifThrowIllegalArgException(boolean value, String error) {
        if (value) {
            throw new IllegalArgumentException(error);
        }
    }
}

