/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.Database;
import com.azure.cosmos.implementation.ResourceResponse;
import com.azure.cosmos.implementation.apachecommons.lang.RandomStringUtils;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.SqlParameter;
import com.azure.cosmos.models.SqlQuerySpec;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DatabaseForTest {
    private static Logger logger = LoggerFactory.getLogger(DatabaseForTest.class);
    public static final String SHARED_DB_ID_PREFIX = "RxJava.SDKTest.SharedDatabase";
    private static final Duration CLEANUP_THRESHOLD_DURATION = Duration.ofHours(2L);
    private static final String DELIMITER = "_";
    private static DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss");
    public LocalDateTime createdTime;
    public Database createdDatabase;

    private DatabaseForTest(Database db, LocalDateTime createdTime) {
        this.createdDatabase = db;
        this.createdTime = createdTime;
    }

    private boolean isStale() {
        return this.isOlderThan(CLEANUP_THRESHOLD_DURATION);
    }

    private boolean isOlderThan(Duration dur) {
        return this.createdTime.isBefore(LocalDateTime.now().minus(dur));
    }

    public static String generateId() {
        return "RxJava.SDKTest.SharedDatabase_" + TIME_FORMATTER.format(LocalDateTime.now()) + DELIMITER + RandomStringUtils.randomAlphabetic(3);
    }

    private static DatabaseForTest from(Database db) {
        if (db == null || db.getId() == null || db.getSelfLink() == null) {
            return null;
        }
        String id = db.getId();
        if (id == null) {
            return null;
        }
        String[] parts = StringUtils.split(id, DELIMITER);
        if (parts.length != 3) {
            return null;
        }
        if (!StringUtils.equals(parts[0], SHARED_DB_ID_PREFIX)) {
            return null;
        }
        try {
            LocalDateTime parsedTime = LocalDateTime.parse(parts[1], TIME_FORMATTER);
            return new DatabaseForTest(db, parsedTime);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static DatabaseForTest create(DatabaseManager client) {
        Database dbDef = new Database();
        dbDef.setId(DatabaseForTest.generateId());
        Database db = (Database)((ResourceResponse)client.createDatabase(dbDef).single().block()).getResource();
        DatabaseForTest dbForTest = DatabaseForTest.from(db);
        assert (dbForTest != null);
        return dbForTest;
    }

    public static void cleanupStaleTestDatabases(DatabaseManager client) {
        logger.info("Cleaning stale test databases ...");
        List dbs = (List)client.queryDatabases(new SqlQuerySpec("SELECT * FROM c WHERE STARTSWITH(c.id, @PREFIX)", Collections.singletonList(new SqlParameter("@PREFIX", SHARED_DB_ID_PREFIX)))).flatMap(page -> Flux.fromIterable(page.getResults())).collectList().block();
        if (dbs == null) {
            return;
        }
        for (Database db : dbs) {
            assert (db.getId().startsWith(SHARED_DB_ID_PREFIX));
            DatabaseForTest dbForTest = DatabaseForTest.from(db);
            if (!dbForTest.isStale()) continue;
            logger.info("Deleting database {}", (Object)db.getId());
            client.deleteDatabase(db.getId()).block();
        }
    }

    public static interface DatabaseManager {
        public Flux<FeedResponse<Database>> queryDatabases(SqlQuerySpec var1);

        public Mono<ResourceResponse<Database>> createDatabase(Database var1);

        public Mono<ResourceResponse<Database>> deleteDatabase(String var1);
    }
}

