/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.Offer;
import com.azure.cosmos.implementation.ResourceResponse;
import com.azure.cosmos.models.CosmosResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.ThroughputProperties;

public class ThroughputResponse
extends CosmosResponse<ThroughputProperties> {
    private ResourceResponse<Offer> offerResourceResponse;
    private ThroughputProperties throughputProperties;

    ThroughputResponse(ResourceResponse<Offer> offerResourceResponse) {
        super(offerResourceResponse);
        this.offerResourceResponse = offerResourceResponse;
    }

    @Override
    public ThroughputProperties getProperties() {
        if (this.throughputProperties == null) {
            Offer offer = new Offer(ModelBridgeInternal.getPropertyBagFromJsonSerializable(this.offerResourceResponse.getResource()));
            this.throughputProperties = new ThroughputProperties(offer);
        }
        return this.throughputProperties;
    }

    public int getMinThroughput() {
        return Integer.parseInt(this.offerResourceResponse.getResponseHeaders().get("x-ms-cosmos-min-throughput"));
    }

    public boolean isReplacePending() {
        return Boolean.parseBoolean(this.offerResourceResponse.getResponseHeaders().get("x-ms-offer-replace-pending"));
    }
}

