/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.core.util.Context;
import com.azure.core.util.tracing.Tracer;
import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.ClientSideRequestStatistics;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.RequestTimeline;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.SerializationDiagnosticsContext;
import com.azure.cosmos.implementation.clienttelemetry.ClientTelemetry;
import com.azure.cosmos.implementation.clienttelemetry.ReportPayload;
import com.azure.cosmos.implementation.directconnectivity.DirectBridgeInternal;
import com.azure.cosmos.models.CosmosBatchResponse;
import com.azure.cosmos.models.CosmosItemResponse;
import com.azure.cosmos.models.CosmosResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.HdrHistogram.ConcurrentDoubleHistogram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Signal;

public class TracerProvider {
    private Tracer tracer;
    private static final Logger LOGGER = LoggerFactory.getLogger(TracerProvider.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final String JSON_STRING = "JSON";
    public static final String DB_TYPE_VALUE = "Cosmos";
    public static final String DB_TYPE = "db.type";
    public static final String DB_INSTANCE = "db.instance";
    public static final String DB_URL = "db.url";
    public static final String DB_STATEMENT = "db.statement";
    public static final String COSMOS_CALL_DEPTH = "cosmosCallDepth";
    public static final String COSMOS_CALL_DEPTH_VAL = "nested";
    public static final int ERROR_CODE = 0;
    public static final String RESOURCE_PROVIDER_NAME = "Microsoft.DocumentDB";
    public final Duration CRUD_THRESHOLD_FOR_DIAGNOSTICS = Duration.ofMillis(100L);
    public final Duration QUERY_THRESHOLD_FOR_DIAGNOSTICS = Duration.ofMillis(500L);

    public TracerProvider(Tracer tracer) {
        this.tracer = tracer;
    }

    public boolean isEnabled() {
        return this.tracer != null;
    }

    public Context startSpan(String methodName, String databaseId, String endpoint, Context context) {
        Context local = Objects.requireNonNull(context, "'context' cannot be null.");
        local = local.addData((Object)"az.namespace", (Object)RESOURCE_PROVIDER_NAME);
        local = this.tracer.start(methodName, local);
        if (databaseId != null) {
            this.tracer.setAttribute(DB_INSTANCE, databaseId, local);
        }
        this.tracer.setAttribute(DB_TYPE, DB_TYPE_VALUE, local);
        this.tracer.setAttribute(DB_URL, endpoint, local);
        this.tracer.setAttribute(DB_STATEMENT, methodName, local);
        return local;
    }

    public void addEvent(String name, Map<String, Object> attributes, OffsetDateTime timestamp, Context context) {
        this.tracer.addEvent(name, attributes, timestamp, context);
    }

    public <T extends CosmosResponse<? extends Resource>> void endSpan(Context context, Signal<T> signal, int statusCode) {
        Objects.requireNonNull(context, "'context' cannot be null.");
        Objects.requireNonNull(signal, "'signal' cannot be null.");
        switch (signal.getType()) {
            case ON_COMPLETE: {
                this.end(statusCode, null, context);
                break;
            }
            case ON_ERROR: {
                Throwable throwable = null;
                if (signal.hasError() && (throwable = signal.getThrowable()) instanceof CosmosException) {
                    CosmosException exception = (CosmosException)((Object)throwable);
                    statusCode = exception.getStatusCode();
                }
                this.end(statusCode, throwable, context);
                break;
            }
        }
    }

    public <T extends CosmosResponse<?>> Mono<T> traceEnabledCosmosResponsePublisher(Mono<T> resultPublisher, Context context, String spanName, String databaseId, String endpoint) {
        return this.traceEnabledPublisher(resultPublisher, context, spanName, databaseId, endpoint, response -> response.getStatusCode(), response -> response.getDiagnostics(), null);
    }

    public Mono<CosmosBatchResponse> traceEnabledBatchResponsePublisher(Mono<CosmosBatchResponse> resultPublisher, Context context, String spanName, String containerId, String databaseId, CosmosAsyncClient client, ConsistencyLevel consistencyLevel, OperationType operationType, ResourceType resourceType) {
        return this.publisherWithClientTelemetry(resultPublisher, context, spanName, containerId, databaseId, BridgeInternal.getServiceEndpoint(client), client, consistencyLevel, operationType, resourceType, CosmosBatchResponse::getStatusCode, CosmosBatchResponse::getDiagnostics, null);
    }

    public <T> Mono<CosmosItemResponse<T>> traceEnabledCosmosItemResponsePublisher(Mono<CosmosItemResponse<T>> resultPublisher, Context context, String spanName, String containerId, String databaseId, CosmosAsyncClient client, ConsistencyLevel consistencyLevel, OperationType operationType, ResourceType resourceType, Duration thresholdForDiagnosticsOnTracer) {
        return this.publisherWithClientTelemetry(resultPublisher, context, spanName, containerId, databaseId, BridgeInternal.getServiceEndpoint(client), client, consistencyLevel, operationType, resourceType, CosmosItemResponse::getStatusCode, CosmosItemResponse::getDiagnostics, thresholdForDiagnosticsOnTracer);
    }

    private <T> Mono<T> traceEnabledPublisher(Mono<T> resultPublisher, Context context, String spanName, String databaseId, String endpoint, Function<T, Integer> statusCodeFunc, Function<T, CosmosDiagnostics> diagnosticFunc, Duration thresholdForDiagnosticsOnTracer) {
        AtomicReference<Context> parentContext = new AtomicReference<Context>(Context.NONE);
        Optional callDepth = context.getData((Object)COSMOS_CALL_DEPTH);
        boolean isNestedCall = callDepth.isPresent();
        return resultPublisher.doOnSubscribe(ignoredValue -> {
            if (this.isEnabled() && !isNestedCall) {
                parentContext.set(this.startSpan(spanName, databaseId, endpoint, context));
            }
        }).doOnSuccess(response -> {
            if (this.isEnabled() && !isNestedCall) {
                CosmosDiagnostics cosmosDiagnostics = (CosmosDiagnostics)diagnosticFunc.apply(response);
                try {
                    Duration threshold = thresholdForDiagnosticsOnTracer;
                    if (threshold == null) {
                        threshold = this.CRUD_THRESHOLD_FOR_DIAGNOSTICS;
                    }
                    if (cosmosDiagnostics != null && cosmosDiagnostics.getDuration() != null && cosmosDiagnostics.getDuration().compareTo(threshold) > 0) {
                        this.addDiagnosticsOnTracerEvent(cosmosDiagnostics, (Context)parentContext.get());
                    }
                }
                catch (JsonProcessingException ex) {
                    LOGGER.warn("Error while serializing diagnostics for tracer", (Object)ex.getMessage());
                }
                this.endSpan((Context)parentContext.get(), Signal.complete(), (Integer)statusCodeFunc.apply(response));
            }
        }).doOnError(throwable -> {
            if (this.isEnabled() && !isNestedCall) {
                this.endSpan((Context)parentContext.get(), Signal.error((Throwable)throwable), 0);
            }
        });
    }

    private <T> Mono<T> publisherWithClientTelemetry(Mono<T> resultPublisher, Context context, String spanName, String containerId, String databaseId, String endpoint, CosmosAsyncClient client, ConsistencyLevel consistencyLevel, OperationType operationType, ResourceType resourceType, Function<T, Integer> statusCodeFunc, Function<T, CosmosDiagnostics> diagnosticFunc, Duration thresholdForDiagnosticsOnTracer) {
        Mono<T> tracerMono = this.traceEnabledPublisher(resultPublisher, context, spanName, databaseId, endpoint, statusCodeFunc, diagnosticFunc, thresholdForDiagnosticsOnTracer);
        return tracerMono.doOnSuccess(response -> {
            if (Configs.isClientTelemetryEnabled(BridgeInternal.isClientTelemetryEnabled(client)) && response instanceof CosmosItemResponse) {
                CosmosItemResponse itemResponse = (CosmosItemResponse)response;
                this.fillClientTelemetry(client, itemResponse.getDiagnostics(), itemResponse.getStatusCode(), ModelBridgeInternal.getPayloadLength(itemResponse), containerId, databaseId, operationType, resourceType, consistencyLevel, (float)itemResponse.getRequestCharge());
            } else if (Configs.isClientTelemetryEnabled(BridgeInternal.isClientTelemetryEnabled(client)) && response instanceof CosmosBatchResponse) {
                CosmosBatchResponse cosmosBatchResponse = (CosmosBatchResponse)response;
                this.fillClientTelemetry(client, cosmosBatchResponse.getDiagnostics(), cosmosBatchResponse.getStatusCode(), ModelBridgeInternal.getPayloadLength(cosmosBatchResponse), containerId, databaseId, operationType, resourceType, consistencyLevel, (float)cosmosBatchResponse.getRequestCharge());
            }
        }).doOnError(throwable -> {
            if (Configs.isClientTelemetryEnabled(BridgeInternal.isClientTelemetryEnabled(client)) && throwable instanceof CosmosException) {
                CosmosException cosmosException = (CosmosException)((Object)((Object)throwable));
                this.fillClientTelemetry(client, cosmosException.getDiagnostics(), cosmosException.getStatusCode(), null, containerId, databaseId, operationType, resourceType, consistencyLevel, (float)cosmosException.getRequestCharge());
            }
        });
    }

    private void end(int statusCode, Throwable throwable, Context context) {
        if (throwable != null && throwable instanceof CosmosException) {
            CosmosException cosmosException = (CosmosException)((Object)throwable);
            if (statusCode == 404 && cosmosException.getSubStatusCode() == 0) {
                this.tracer.end(statusCode, null, context);
                return;
            }
        }
        this.tracer.end(statusCode, throwable, context);
    }

    private void fillClientTelemetry(CosmosAsyncClient cosmosAsyncClient, CosmosDiagnostics cosmosDiagnostics, int statusCode, Integer objectSize, String containerId, String databaseId, OperationType operationType, ResourceType resourceType, ConsistencyLevel consistencyLevel, float requestCharge) {
        ClientTelemetry telemetry = BridgeInternal.getContextClient(cosmosAsyncClient).getClientTelemetry();
        ReportPayload reportPayloadLatency = this.createReportPayload(cosmosAsyncClient, cosmosDiagnostics, statusCode, objectSize, containerId, databaseId, operationType, resourceType, consistencyLevel, "RequestLatency", "MicroSec");
        ConcurrentDoubleHistogram latencyHistogram = telemetry.getClientTelemetryInfo().getOperationInfoMap().get(reportPayloadLatency);
        if (latencyHistogram != null) {
            ClientTelemetry.recordValue(latencyHistogram, cosmosDiagnostics.getDuration().toNanos() / 1000L);
        } else {
            latencyHistogram = statusCode >= 200 && statusCode <= 299 ? new ConcurrentDoubleHistogram(300000000L, 4) : new ConcurrentDoubleHistogram(300000000L, 2);
            latencyHistogram.setAutoResize(true);
            ClientTelemetry.recordValue(latencyHistogram, cosmosDiagnostics.getDuration().toNanos() / 1000L);
            telemetry.getClientTelemetryInfo().getOperationInfoMap().put(reportPayloadLatency, latencyHistogram);
        }
        ReportPayload reportPayloadRequestCharge = this.createReportPayload(cosmosAsyncClient, cosmosDiagnostics, statusCode, objectSize, containerId, databaseId, operationType, resourceType, consistencyLevel, "RequestCharge", "RU");
        ConcurrentDoubleHistogram requestChargeHistogram = telemetry.getClientTelemetryInfo().getOperationInfoMap().get(reportPayloadRequestCharge);
        if (requestChargeHistogram != null) {
            ClientTelemetry.recordValue(requestChargeHistogram, requestCharge);
        } else {
            requestChargeHistogram = new ConcurrentDoubleHistogram(10000L, 2);
            requestChargeHistogram.setAutoResize(true);
            ClientTelemetry.recordValue(requestChargeHistogram, requestCharge);
            telemetry.getClientTelemetryInfo().getOperationInfoMap().put(reportPayloadRequestCharge, requestChargeHistogram);
        }
    }

    private ReportPayload createReportPayload(CosmosAsyncClient cosmosAsyncClient, CosmosDiagnostics cosmosDiagnostics, int statusCode, Integer objectSize, String containerId, String databaseId, OperationType operationType, ResourceType resourceType, ConsistencyLevel consistencyLevel, String metricsName, String unitName) {
        ReportPayload reportPayload = new ReportPayload(metricsName, unitName);
        reportPayload.setRegionsContacted(BridgeInternal.getRegionsContacted(cosmosDiagnostics).toString());
        reportPayload.setConsistency(consistencyLevel == null ? BridgeInternal.getContextClient(cosmosAsyncClient).getConsistencyLevel() : consistencyLevel);
        if (objectSize != null) {
            reportPayload.setGreaterThan1Kb(objectSize > 1024);
        }
        reportPayload.setDatabaseName(databaseId);
        reportPayload.setContainerName(containerId);
        reportPayload.setOperation(operationType);
        reportPayload.setResource(resourceType);
        reportPayload.setStatusCode(statusCode);
        return reportPayload;
    }

    private void addDiagnosticsOnTracerEvent(CosmosDiagnostics cosmosDiagnostics, Context context) throws JsonProcessingException {
        if (cosmosDiagnostics == null) {
            return;
        }
        ClientSideRequestStatistics clientSideRequestStatistics = BridgeInternal.getClientSideRequestStatics(cosmosDiagnostics);
        HashMap<String, Object> attributes = null;
        int diagnosticsCounter = 1;
        for (ClientSideRequestStatistics.StoreResponseStatistics storeResponseStatistics : clientSideRequestStatistics.getResponseStatisticsList()) {
            attributes = new HashMap<String, Object>();
            attributes.put(JSON_STRING, mapper.writeValueAsString((Object)storeResponseStatistics));
            Iterator<RequestTimeline.Event> eventIterator = null;
            try {
                if (storeResponseStatistics.getStoreResult() != null) {
                    eventIterator = DirectBridgeInternal.getRequestTimeline(storeResponseStatistics.getStoreResult().toResponse()).iterator();
                }
            }
            catch (CosmosException ex) {
                eventIterator = BridgeInternal.getRequestTimeline(ex).iterator();
            }
            OffsetDateTime requestStartTime = OffsetDateTime.ofInstant(storeResponseStatistics.getRequestResponseTimeUTC(), ZoneOffset.UTC);
            if (eventIterator != null) {
                while (eventIterator.hasNext()) {
                    RequestTimeline.Event event = eventIterator.next();
                    if (!event.getName().equals("created")) continue;
                    requestStartTime = OffsetDateTime.ofInstant(event.getStartTime(), ZoneOffset.UTC);
                    break;
                }
            }
            this.addEvent("StoreResponse" + diagnosticsCounter++, attributes, requestStartTime, context);
        }
        diagnosticsCounter = 1;
        for (ClientSideRequestStatistics.StoreResponseStatistics statistics : ClientSideRequestStatistics.getCappedSupplementalResponseStatisticsList(clientSideRequestStatistics.getSupplementalResponseStatisticsList())) {
            attributes = new HashMap();
            attributes.put(JSON_STRING, mapper.writeValueAsString((Object)statistics));
            OffsetDateTime requestStartTime = OffsetDateTime.ofInstant(statistics.getRequestResponseTimeUTC(), ZoneOffset.UTC);
            if (statistics.getStoreResult() != null) {
                for (RequestTimeline.Event event : DirectBridgeInternal.getRequestTimeline(statistics.getStoreResult().toResponse())) {
                    if (!event.getName().equals("created")) continue;
                    requestStartTime = OffsetDateTime.ofInstant(event.getStartTime(), ZoneOffset.UTC);
                    break;
                }
            }
            this.addEvent("Supplemental StoreResponse" + diagnosticsCounter++, attributes, requestStartTime, context);
        }
        if (clientSideRequestStatistics.getGatewayStatistics() != null) {
            attributes = new HashMap();
            attributes.put(JSON_STRING, mapper.writeValueAsString((Object)clientSideRequestStatistics.getGatewayStatistics()));
            OffsetDateTime requestStartTime = OffsetDateTime.ofInstant(clientSideRequestStatistics.getRequestStartTimeUTC(), ZoneOffset.UTC);
            if (clientSideRequestStatistics.getGatewayStatistics().getRequestTimeline() != null) {
                for (RequestTimeline.Event event : clientSideRequestStatistics.getGatewayStatistics().getRequestTimeline()) {
                    if (!event.getName().equals("created")) continue;
                    requestStartTime = OffsetDateTime.ofInstant(event.getStartTime(), ZoneOffset.UTC);
                    break;
                }
            }
            this.addEvent("GatewayStatistics", attributes, requestStartTime, context);
        }
        if (clientSideRequestStatistics.getRetryContext().getRetryStartTime() != null) {
            attributes = new HashMap();
            attributes.put(JSON_STRING, mapper.writeValueAsString((Object)clientSideRequestStatistics.getRetryContext()));
            this.addEvent("Retry Context", attributes, OffsetDateTime.ofInstant(clientSideRequestStatistics.getRetryContext().getRetryStartTime(), ZoneOffset.UTC), context);
        }
        diagnosticsCounter = 1;
        for (ClientSideRequestStatistics.AddressResolutionStatistics addressResolutionStatistics : clientSideRequestStatistics.getAddressResolutionStatistics().values()) {
            attributes = new HashMap();
            attributes.put(JSON_STRING, mapper.writeValueAsString((Object)addressResolutionStatistics));
            this.addEvent("AddressResolutionStatistics" + diagnosticsCounter++, attributes, OffsetDateTime.ofInstant(addressResolutionStatistics.getStartTimeUTC(), ZoneOffset.UTC), context);
        }
        if (clientSideRequestStatistics.getSerializationDiagnosticsContext().serializationDiagnosticsList != null) {
            for (SerializationDiagnosticsContext.SerializationDiagnostics serializationDiagnostics : clientSideRequestStatistics.getSerializationDiagnosticsContext().serializationDiagnosticsList) {
                attributes = new HashMap();
                attributes.put(JSON_STRING, mapper.writeValueAsString((Object)serializationDiagnostics));
                this.addEvent("SerializationDiagnostics " + (Object)((Object)serializationDiagnostics.serializationType), attributes, OffsetDateTime.ofInstant(serializationDiagnostics.startTimeUTC, ZoneOffset.UTC), context);
            }
        }
        attributes = new HashMap();
        attributes.put(JSON_STRING, mapper.writeValueAsString(clientSideRequestStatistics.getRegionsContacted()));
        this.addEvent("RegionContacted", attributes, OffsetDateTime.ofInstant(clientSideRequestStatistics.getRequestStartTimeUTC(), ZoneOffset.UTC), context);
        attributes = new HashMap();
        attributes.put(JSON_STRING, mapper.writeValueAsString((Object)ClientSideRequestStatistics.fetchSystemInformation()));
        this.addEvent("SystemInformation", attributes, OffsetDateTime.ofInstant(clientSideRequestStatistics.getRequestStartTimeUTC(), ZoneOffset.UTC), context);
        attributes = new HashMap();
        attributes.put(JSON_STRING, mapper.writeValueAsString((Object)clientSideRequestStatistics.getDiagnosticsClientContext()));
        this.addEvent("ClientCfgs", attributes, OffsetDateTime.ofInstant(clientSideRequestStatistics.getRequestStartTimeUTC(), ZoneOffset.UTC), context);
    }
}

