/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.spark.OperationContextAndListenerTuple;
import com.azure.cosmos.models.CosmosBulkExecutionThresholdsState;
import java.time.Duration;

public final class CosmosBulkExecutionOptions {
    private int maxMicroBatchSize = 100;
    private int maxMicroBatchConcurrency = 1;
    private double maxMicroBatchRetryRate = 0.2;
    private double minMicroBatchRetryRate = 0.1;
    private Duration maxMicroBatchInterval = Duration.ofMillis(1000L);
    private final Object legacyBatchScopedContext;
    private final CosmosBulkExecutionThresholdsState thresholds;
    private OperationContextAndListenerTuple operationContextAndListenerTuple;

    CosmosBulkExecutionOptions(Object legacyBatchScopedContext, CosmosBulkExecutionThresholdsState thresholdsState) {
        this.legacyBatchScopedContext = legacyBatchScopedContext;
        this.thresholds = thresholdsState == null ? new CosmosBulkExecutionThresholdsState() : thresholdsState;
    }

    public CosmosBulkExecutionOptions(CosmosBulkExecutionThresholdsState thresholdsState) {
        this(null, thresholdsState);
    }

    public CosmosBulkExecutionOptions() {
        this(null);
    }

    int getMaxMicroBatchSize() {
        return this.maxMicroBatchSize;
    }

    CosmosBulkExecutionOptions setMaxMicroBatchSize(int maxMicroBatchSize) {
        this.maxMicroBatchSize = maxMicroBatchSize;
        return this;
    }

    int getMaxMicroBatchConcurrency() {
        return this.maxMicroBatchConcurrency;
    }

    Duration getMaxMicroBatchInterval() {
        return this.maxMicroBatchInterval;
    }

    double getMaxTargetedMicroBatchRetryRate() {
        return this.maxMicroBatchRetryRate;
    }

    CosmosBulkExecutionOptions setTargetedMicroBatchRetryRate(double minRetryRate, double maxRetryRate) {
        if (minRetryRate < 0.0) {
            throw new IllegalArgumentException("The maxRetryRate must not be a negative value");
        }
        if (minRetryRate > maxRetryRate) {
            throw new IllegalArgumentException("The minRetryRate must not exceed the maxRetryRate");
        }
        this.maxMicroBatchRetryRate = maxRetryRate;
        this.minMicroBatchRetryRate = minRetryRate;
        return this;
    }

    double getMinTargetedMicroBatchRetryRate() {
        return this.minMicroBatchRetryRate;
    }

    Object getLegacyBatchScopedContext() {
        return this.legacyBatchScopedContext;
    }

    public CosmosBulkExecutionThresholdsState getThresholdsState() {
        return this.thresholds;
    }

    OperationContextAndListenerTuple getOperationContextAndListenerTuple() {
        return this.operationContextAndListenerTuple;
    }

    void setOperationContextAndListenerTuple(OperationContextAndListenerTuple operationContextAndListenerTuple) {
        this.operationContextAndListenerTuple = operationContextAndListenerTuple;
    }

    static {
        ImplementationBridgeHelpers.CosmosBulkExecutionOptionsHelper.setCosmosBulkExecutionOptionsAccessor(new ImplementationBridgeHelpers.CosmosBulkExecutionOptionsHelper.CosmosBulkExecutionOptionsAccessor(){

            @Override
            public void setOperationContext(CosmosBulkExecutionOptions options, OperationContextAndListenerTuple operationContextAndListenerTuple) {
                options.setOperationContextAndListenerTuple(operationContextAndListenerTuple);
            }

            @Override
            public OperationContextAndListenerTuple getOperationContext(CosmosBulkExecutionOptions options) {
                return options.getOperationContextAndListenerTuple();
            }

            @Override
            public <T> T getLegacyBatchScopedContext(CosmosBulkExecutionOptions options) {
                return (T)options.getLegacyBatchScopedContext();
            }

            @Override
            public double getMinTargetedMicroBatchRetryRate(CosmosBulkExecutionOptions options) {
                return options.getMinTargetedMicroBatchRetryRate();
            }

            @Override
            public double getMaxTargetedMicroBatchRetryRate(CosmosBulkExecutionOptions options) {
                return options.getMaxTargetedMicroBatchRetryRate();
            }

            @Override
            public int getMaxMicroBatchSize(CosmosBulkExecutionOptions options) {
                return options.getMaxMicroBatchSize();
            }

            @Override
            public CosmosBulkExecutionOptions setMaxMicroBatchSize(CosmosBulkExecutionOptions options, int maxMicroBatchSize) {
                return options.setMaxMicroBatchSize(maxMicroBatchSize);
            }

            @Override
            public int getMaxMicroBatchConcurrency(CosmosBulkExecutionOptions options) {
                return options.getMaxMicroBatchConcurrency();
            }

            @Override
            public Duration getMaxMicroBatchInterval(CosmosBulkExecutionOptions options) {
                return options.getMaxMicroBatchInterval();
            }

            @Override
            public CosmosBulkExecutionOptions setTargetedMicroBatchRetryRate(CosmosBulkExecutionOptions options, double minRetryRate, double maxRetryRate) {
                return options.setTargetedMicroBatchRetryRate(minRetryRate, maxRetryRate);
            }
        });
    }
}

