/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.BadRequestException;
import com.azure.cosmos.implementation.Exceptions;
import com.azure.cosmos.implementation.GoneException;
import com.azure.cosmos.implementation.ISessionContainer;
import com.azure.cosmos.implementation.ISessionToken;
import com.azure.cosmos.implementation.Integers;
import com.azure.cosmos.implementation.InternalServerErrorException;
import com.azure.cosmos.implementation.MutableVolatile;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.PartitionIsMigratingException;
import com.azure.cosmos.implementation.PartitionKeyRangeGoneException;
import com.azure.cosmos.implementation.PartitionKeyRangeIsSplittingException;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.SessionTokenHelper;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.apachecommons.lang.tuple.Pair;
import com.azure.cosmos.implementation.directconnectivity.AddressSelector;
import com.azure.cosmos.implementation.directconnectivity.ReadMode;
import com.azure.cosmos.implementation.directconnectivity.StoreResponse;
import com.azure.cosmos.implementation.directconnectivity.StoreResult;
import com.azure.cosmos.implementation.directconnectivity.TransportClient;
import com.azure.cosmos.implementation.directconnectivity.TransportException;
import com.azure.cosmos.implementation.directconnectivity.Uri;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class StoreReader {
    private final Logger logger = LoggerFactory.getLogger(StoreReader.class);
    private final TransportClient transportClient;
    private final AddressSelector addressSelector;
    private final ISessionContainer sessionContainer;
    private String lastReadAddress;

    public StoreReader(TransportClient transportClient, AddressSelector addressSelector, ISessionContainer sessionContainer) {
        this.transportClient = transportClient;
        this.addressSelector = addressSelector;
        this.sessionContainer = sessionContainer;
    }

    public Mono<List<StoreResult>> readMultipleReplicaAsync(RxDocumentServiceRequest entity, boolean includePrimary, int replicaCountToRead, boolean requiresValidLsn, boolean useSessionToken, ReadMode readMode) {
        return this.readMultipleReplicaAsync(entity, includePrimary, replicaCountToRead, requiresValidLsn, useSessionToken, readMode, false, false);
    }

    public Mono<List<StoreResult>> readMultipleReplicaAsync(RxDocumentServiceRequest entity, boolean includePrimary, int replicaCountToRead, boolean requiresValidLsn, boolean useSessionToken, ReadMode readMode, boolean checkMinLSN, boolean forceReadAll) {
        if (entity.requestContext.timeoutHelper.isElapsed()) {
            return Mono.error((Throwable)((Object)new GoneException()));
        }
        String originalSessionToken = entity.getHeaders().get("x-ms-session-token");
        if (entity.requestContext.cosmosDiagnostics == null) {
            entity.requestContext.cosmosDiagnostics = entity.createCosmosDiagnostics();
        }
        Mono<ReadReplicaResult> readQuorumResultObs = this.readMultipleReplicasInternalAsync(entity, includePrimary, replicaCountToRead, requiresValidLsn, useSessionToken, readMode, checkMinLSN, forceReadAll);
        return readQuorumResultObs.flatMap(readQuorumResult -> {
            if (entity.requestContext.performLocalRefreshOnGoneException && readQuorumResult.retryWithForceRefresh && !entity.requestContext.forceRefreshAddressCache) {
                if (entity.requestContext.timeoutHelper.isElapsed()) {
                    return Mono.error((Throwable)((Object)new GoneException()));
                }
                entity.requestContext.forceRefreshAddressCache = true;
                return this.readMultipleReplicasInternalAsync(entity, includePrimary, replicaCountToRead, requiresValidLsn, useSessionToken, readMode, false, forceReadAll).map(r -> r.responses);
            }
            return Mono.just(readQuorumResult.responses);
        }).flux().doAfterTerminate(() -> SessionTokenHelper.setOriginalSessionToken(entity, originalSessionToken)).single();
    }

    private Flux<ReadReplicaResult> earlyResultIfNotEnoughReplicas(List<Uri> replicaAddresses, RxDocumentServiceRequest request, int replicaCountToRead) {
        if (replicaAddresses.size() < replicaCountToRead) {
            if (!request.requestContext.forceRefreshAddressCache) {
                return Flux.just((Object)new ReadReplicaResult(true, Collections.emptyList()));
            }
            return Flux.just((Object)new ReadReplicaResult(false, Collections.emptyList()));
        }
        return Flux.empty();
    }

    private Flux<StoreResult> toStoreResult(RxDocumentServiceRequest request, Pair<Flux<StoreResponse>, Uri> storeRespAndURI, ReadMode readMode, boolean requiresValidLsn) {
        return storeRespAndURI.getLeft().flatMap(storeResponse -> {
            try {
                StoreResult storeResult = this.createAndRecordStoreResult(request, (StoreResponse)storeResponse, null, requiresValidLsn, readMode != ReadMode.Strong, (Uri)storeRespAndURI.getRight());
                BridgeInternal.getContactedReplicas(request.requestContext.cosmosDiagnostics).add(((Uri)storeRespAndURI.getRight()).getURI());
                return Flux.just((Object)storeResult);
            }
            catch (Exception e) {
                return Flux.error((Throwable)e);
            }
        }).onErrorResume(t -> {
            Throwable unwrappedException = reactor.core.Exceptions.unwrap((Throwable)t);
            try {
                this.logger.debug("Exception is thrown while doing readMany: ", unwrappedException);
                Exception storeException = Utils.as(unwrappedException, Exception.class);
                if (storeException == null) {
                    return Flux.error((Throwable)unwrappedException);
                }
                StoreResult storeResult = this.createAndRecordStoreResult(request, null, storeException, requiresValidLsn, readMode != ReadMode.Strong, (Uri)storeRespAndURI.getRight());
                if (storeException instanceof TransportException) {
                    BridgeInternal.getFailedReplicas(request.requestContext.cosmosDiagnostics).add(((Uri)storeRespAndURI.getRight()).getURI());
                }
                return Flux.just((Object)storeResult);
            }
            catch (Exception e) {
                return Flux.error((Throwable)e);
            }
        });
    }

    private Flux<List<StoreResult>> readFromReplicas(List<StoreResult> resultCollector, List<Uri> resolveApiResults, AtomicInteger replicasToRead, RxDocumentServiceRequest entity, boolean includePrimary, int replicaCountToRead, boolean requiresValidLsn, boolean useSessionToken, ReadMode readMode, boolean checkMinLSN, boolean forceReadAll, MutableVolatile<ISessionToken> requestSessionToken, MutableVolatile<Boolean> hasGoneException, boolean enforceSessionCheck, MutableVolatile<ReadReplicaResult> shortCircut) {
        if (entity.requestContext.timeoutHelper.isElapsed()) {
            return Flux.error((Throwable)((Object)new GoneException()));
        }
        ArrayList<Pair<Flux, Uri>> readStoreTasks = new ArrayList<Pair<Flux, Uri>>();
        int uriIndex = StoreReader.generateNextRandom(resolveApiResults.size());
        while (resolveApiResults.size() > 0) {
            Pair<Mono, Uri> res;
            Uri uri = resolveApiResults.get(uriIndex %= resolveApiResults.size());
            try {
                res = this.readFromStoreAsync(resolveApiResults.get(uriIndex), entity);
            }
            catch (Exception e2) {
                res = Pair.of(Mono.error((Throwable)e2), uri);
            }
            readStoreTasks.add(Pair.of(res.getLeft().flux(), res.getRight()));
            resolveApiResults.remove(uriIndex);
            if (forceReadAll || readStoreTasks.size() != replicasToRead.get()) continue;
            break;
        }
        replicasToRead.set(readStoreTasks.size() >= replicasToRead.get() ? 0 : replicasToRead.get() - readStoreTasks.size());
        List storeResult = readStoreTasks.stream().map(item -> this.toStoreResult(entity, (Pair<Flux<StoreResponse>, Uri>)item, readMode, requiresValidLsn)).collect(Collectors.toList());
        Flux allStoreResults = Flux.merge(storeResult);
        return allStoreResults.collectList().onErrorResume(e -> {
            if (reactor.core.Exceptions.isMultiple((Throwable)e)) {
                this.logger.info("Captured composite exception");
                List exceptions = reactor.core.Exceptions.unwrapMultiple((Throwable)e);
                assert (!exceptions.isEmpty());
                return Mono.error((Throwable)((Throwable)exceptions.get(0)));
            }
            return Mono.error((Throwable)e);
        }).map(newStoreResults -> {
            for (StoreResult srr : newStoreResults) {
                if (srr.isValid) {
                    try {
                        if (requestSessionToken.v == null || srr.sessionToken != null && ((ISessionToken)requestSessionToken.v).isValid(srr.sessionToken) || !enforceSessionCheck && !srr.isNotFoundException) {
                            resultCollector.add(srr);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (srr.isThroughputControlRequestRateTooLargeException) {
                    resultCollector.add(srr);
                }
                hasGoneException.v = (Boolean)hasGoneException.v != false || srr.isGoneException && !srr.isInvalidPartitionException;
                if (resultCollector.size() >= replicaCountToRead) {
                    if (((Boolean)hasGoneException.v).booleanValue() && !entity.requestContext.performedBackgroundAddressRefresh) {
                        this.startBackgroundAddressRefresh(entity);
                        entity.requestContext.performedBackgroundAddressRefresh = true;
                    }
                    shortCircut.v = new ReadReplicaResult(false, resultCollector);
                    replicasToRead.set(0);
                    return resultCollector;
                }
                replicasToRead.set(replicaCountToRead - resultCollector.size());
            }
            return resultCollector;
        }).flux();
    }

    private ReadReplicaResult createReadReplicaResult(List<StoreResult> responseResult, int replicaCountToRead, int resolvedAddressCount, boolean hasGoneException, RxDocumentServiceRequest entity) {
        if (responseResult.size() < replicaCountToRead) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Could not get quorum number of responses. ValidResponsesReceived: {} ResponsesExpected: {}, ResolvedAddressCount: {}, ResponsesString: {}", new Object[]{responseResult.size(), replicaCountToRead, resolvedAddressCount, String.join((CharSequence)";", responseResult.stream().map(r -> r.toString()).collect(Collectors.toList()))});
            }
            if (hasGoneException) {
                if (!entity.requestContext.performLocalRefreshOnGoneException) {
                    throw new GoneException();
                }
                if (!entity.requestContext.forceRefreshAddressCache) {
                    return new ReadReplicaResult(true, responseResult);
                }
            }
        }
        return new ReadReplicaResult(false, responseResult);
    }

    private Mono<ReadReplicaResult> readMultipleReplicasInternalAsync(RxDocumentServiceRequest entity, boolean includePrimary, int replicaCountToRead, boolean requiresValidLsn, boolean useSessionToken, ReadMode readMode, boolean checkMinLSN, boolean forceReadAll) {
        if (entity.requestContext.timeoutHelper.isElapsed()) {
            return Mono.error((Throwable)((Object)new GoneException()));
        }
        String requestedCollectionId = null;
        if (entity.forceNameCacheRefresh) {
            requestedCollectionId = entity.requestContext.resolvedCollectionRid;
        }
        Mono<List<Uri>> resolveApiResultsObs = this.addressSelector.resolveAllUriAsync(entity, includePrimary, entity.requestContext.forceRefreshAddressCache);
        if (!(StringUtils.isEmpty(requestedCollectionId) || StringUtils.isEmpty(entity.requestContext.resolvedCollectionRid) || requestedCollectionId.equals(entity.requestContext.resolvedCollectionRid))) {
            this.sessionContainer.clearTokenByResourceId(requestedCollectionId);
        }
        return resolveApiResultsObs.flux().map(list -> Collections.synchronizedList(new ArrayList(list))).flatMap(resolveApiResults -> {
            try {
                MutableVolatile requestSessionToken = new MutableVolatile();
                if (useSessionToken) {
                    SessionTokenHelper.setPartitionLocalSessionToken(entity, this.sessionContainer);
                    if (checkMinLSN) {
                        requestSessionToken.v = entity.requestContext.sessionToken;
                    }
                } else {
                    entity.getHeaders().remove("x-ms-session-token");
                }
                Flux<ReadReplicaResult> y = this.earlyResultIfNotEnoughReplicas((List<Uri>)resolveApiResults, entity, replicaCountToRead);
                return y.switchIfEmpty((Publisher)Flux.defer(() -> {
                    List storeResultList = Collections.synchronizedList(new ArrayList());
                    AtomicInteger replicasToRead = new AtomicInteger(replicaCountToRead);
                    boolean enforceSessionCheck = true;
                    MutableVolatile<Boolean> hasGoneException = new MutableVolatile<Boolean>(false);
                    MutableVolatile shortCircuitResult = new MutableVolatile();
                    return Flux.defer(() -> this.readFromReplicas(storeResultList, (List<Uri>)resolveApiResults, replicasToRead, entity, includePrimary, replicaCountToRead, requiresValidLsn, useSessionToken, readMode, checkMinLSN, forceReadAll, requestSessionToken, hasGoneException, enforceSessionCheck, shortCircuitResult)).repeat().takeUntil(x -> replicasToRead.get() <= 0 || resolveApiResults.size() <= 0).thenMany((Publisher)Flux.defer(() -> {
                        try {
                            return Flux.just((Object)this.createReadReplicaResult(storeResultList, replicaCountToRead, resolveApiResults.size(), (Boolean)hasGoneException.v, entity));
                        }
                        catch (Exception e) {
                            return Flux.error((Throwable)e);
                        }
                    }));
                }));
            }
            catch (Exception e) {
                return Flux.error((Throwable)e);
            }
        }).single();
    }

    public Mono<StoreResult> readPrimaryAsync(RxDocumentServiceRequest entity, boolean requiresValidLsn, boolean useSessionToken) {
        if (entity.requestContext.timeoutHelper.isElapsed()) {
            return Mono.error((Throwable)((Object)new GoneException()));
        }
        String originalSessionToken = entity.getHeaders().get("x-ms-session-token");
        if (entity.requestContext.cosmosDiagnostics == null) {
            entity.requestContext.cosmosDiagnostics = entity.createCosmosDiagnostics();
        }
        return this.readPrimaryInternalAsync(entity, requiresValidLsn, useSessionToken).flatMap(readQuorumResult -> {
            if (entity.requestContext.performLocalRefreshOnGoneException && readQuorumResult.retryWithForceRefresh && !entity.requestContext.forceRefreshAddressCache) {
                if (entity.requestContext.timeoutHelper.isElapsed()) {
                    return Mono.error((Throwable)((Object)new GoneException()));
                }
                entity.requestContext.forceRefreshAddressCache = true;
                return this.readPrimaryInternalAsync(entity, requiresValidLsn, useSessionToken);
            }
            return Mono.just((Object)readQuorumResult);
        }).flatMap(readQuorumResult -> {
            if (readQuorumResult.responses.size() == 0) {
                return Mono.error((Throwable)((Object)new GoneException("The requested resource is no longer available at the server.")));
            }
            return Mono.just((Object)readQuorumResult.responses.get(0));
        }).doOnEach(arg -> {
            try {
                SessionTokenHelper.setOriginalSessionToken(entity, originalSessionToken);
            }
            catch (Throwable throwable) {
                this.logger.error("Unexpected failure in handling orig [{}]: new [{}]", new Object[]{arg, throwable.getMessage(), throwable});
            }
        });
    }

    private Mono<ReadReplicaResult> readPrimaryInternalAsync(RxDocumentServiceRequest entity, boolean requiresValidLsn, boolean useSessionToken) {
        if (entity.requestContext.timeoutHelper.isElapsed()) {
            return Mono.error((Throwable)((Object)new GoneException()));
        }
        Mono<Uri> primaryUriObs = this.addressSelector.resolvePrimaryUriAsync(entity, entity.requestContext.forceRefreshAddressCache);
        Mono storeResultObs = primaryUriObs.flatMap(primaryUri -> {
            try {
                if (useSessionToken) {
                    SessionTokenHelper.setPartitionLocalSessionToken(entity, this.sessionContainer);
                } else {
                    entity.getHeaders().remove("x-ms-session-token");
                }
                Pair<Mono<StoreResponse>, Uri> storeResponseObsAndUri = this.readFromStoreAsync((Uri)primaryUri, entity);
                return storeResponseObsAndUri.getLeft().flatMap(storeResponse -> {
                    try {
                        StoreResult storeResult = this.createAndRecordStoreResult(entity, storeResponse != null ? storeResponse : null, null, requiresValidLsn, true, storeResponse != null ? (Uri)storeResponseObsAndUri.getRight() : null);
                        return Mono.just((Object)storeResult);
                    }
                    catch (CosmosException e) {
                        return Mono.error((Throwable)((Object)e));
                    }
                });
            }
            catch (CosmosException e) {
                return Mono.error((Throwable)((Object)e));
            }
        }).onErrorResume(t -> {
            Throwable unwrappedException = reactor.core.Exceptions.unwrap((Throwable)t);
            this.logger.debug("Exception is thrown while doing READ Primary", unwrappedException);
            Exception storeTaskException = Utils.as(unwrappedException, Exception.class);
            if (storeTaskException == null) {
                return Mono.error((Throwable)unwrappedException);
            }
            try {
                StoreResult storeResult = this.createAndRecordStoreResult(entity, null, storeTaskException, requiresValidLsn, true, null);
                return Mono.just((Object)storeResult);
            }
            catch (CosmosException e) {
                return Mono.error((Throwable)((Object)e));
            }
        });
        return storeResultObs.map(storeResult -> {
            if (storeResult.isGoneException && !storeResult.isInvalidPartitionException) {
                return new ReadReplicaResult(true, Collections.emptyList());
            }
            return new ReadReplicaResult(false, Collections.singletonList(storeResult));
        });
    }

    private Pair<Mono<StoreResponse>, Uri> readFromStoreAsync(Uri physicalAddress, RxDocumentServiceRequest request) {
        if (request.requestContext.timeoutHelper.isElapsed()) {
            throw new GoneException();
        }
        String ifNoneMatch = request.getHeaders().get("If-None-Match");
        String continuation = null;
        String maxPageSize = null;
        this.lastReadAddress = physicalAddress.toString();
        if (request.getOperationType() == OperationType.ReadFeed || request.getOperationType() == OperationType.Query) {
            continuation = request.getHeaders().get("x-ms-continuation");
            maxPageSize = request.getHeaders().get("x-ms-max-item-count");
            if (continuation != null && continuation.contains(";")) {
                String[] parts = StringUtils.split(continuation, ';');
                if (parts.length < 3) {
                    throw new BadRequestException(String.format("Value '%s' specified for the header '%s' is invalid.", continuation, "x-ms-continuation"));
                }
                continuation = parts[0];
            }
            request.setContinuation(continuation);
        }
        switch (request.getOperationType()) {
            case Read: 
            case Head: {
                Mono<StoreResponse> storeResponseObs = this.transportClient.invokeResourceOperationAsync(physicalAddress, request);
                return Pair.of(storeResponseObs, physicalAddress);
            }
            case ReadFeed: 
            case HeadFeed: 
            case Query: 
            case SqlQuery: 
            case ExecuteJavaScript: {
                Mono<StoreResponse> storeResponseObs = StoreReader.completeActivity(this.transportClient.invokeResourceOperationAsync(physicalAddress, request), null);
                return Pair.of(storeResponseObs, physicalAddress);
            }
        }
        throw new IllegalStateException(String.format("Unexpected operation setType {%s}", new Object[]{request.getOperationType()}));
    }

    private static Mono<StoreResponse> completeActivity(Mono<StoreResponse> task, Object activity) {
        return task;
    }

    StoreResult createAndRecordStoreResult(RxDocumentServiceRequest request, StoreResponse storeResponse, Exception responseException, boolean requiresValidLsn, boolean useLocalLSNBasedHeaders, Uri storePhysicalAddress) {
        StoreResult storeResult = this.createStoreResult(storeResponse, responseException, requiresValidLsn, useLocalLSNBasedHeaders, storePhysicalAddress);
        try {
            BridgeInternal.recordResponse(request.requestContext.cosmosDiagnostics, request, storeResult);
            if (request.requestContext.requestChargeTracker != null) {
                request.requestContext.requestChargeTracker.addCharge(storeResult.requestCharge);
            }
        }
        catch (Exception e) {
            this.logger.error("Unexpected failure while recording response", (Throwable)e);
        }
        if (responseException != null) {
            StoreReader.verifyCanContinueOnException(storeResult.getException());
        }
        return storeResult;
    }

    StoreResult createStoreResult(StoreResponse storeResponse, Exception responseException, boolean requiresValidLsn, boolean useLocalLSNBasedHeaders, Uri storePhysicalAddress) {
        if (responseException == null) {
            String headerValue = null;
            long quorumAckedLSN = -1L;
            int currentReplicaSetSize = -1;
            int currentWriteQuorum = -1;
            long globalCommittedLSN = -1L;
            int numberOfReadRegions = -1;
            Double backendLatencyInMs = null;
            long itemLSN = -1L;
            headerValue = storeResponse.getHeaderValue(useLocalLSNBasedHeaders ? "x-ms-cosmos-quorum-acked-llsn" : "x-ms-quorum-acked-lsn");
            if (headerValue != null) {
                quorumAckedLSN = Long.parseLong(headerValue);
            }
            if ((headerValue = storeResponse.getHeaderValue("x-ms-current-replica-set-size")) != null) {
                currentReplicaSetSize = Integer.parseInt(headerValue);
            }
            if ((headerValue = storeResponse.getHeaderValue("x-ms-current-write-quorum")) != null) {
                currentWriteQuorum = Integer.parseInt(headerValue);
            }
            double requestCharge = 0.0;
            headerValue = storeResponse.getHeaderValue("x-ms-request-charge");
            if (headerValue != null) {
                requestCharge = Double.parseDouble(headerValue);
            }
            String activityId = "";
            headerValue = storeResponse.getHeaderValue("x-ms-activity-id");
            if (headerValue != null) {
                activityId = headerValue;
            }
            String correlatedActivityId = "";
            headerValue = storeResponse.getHeaderValue("x-ms-cosmos-correlated-activityid");
            if (headerValue != null) {
                correlatedActivityId = headerValue;
            }
            if ((headerValue = storeResponse.getHeaderValue("x-ms-number-of-read-regions")) != null) {
                numberOfReadRegions = Integer.parseInt(headerValue);
            }
            if ((headerValue = storeResponse.getHeaderValue("x-ms-global-Committed-lsn")) != null) {
                globalCommittedLSN = Long.parseLong(headerValue);
            }
            if ((headerValue = storeResponse.getHeaderValue(useLocalLSNBasedHeaders ? "x-ms-cosmos-item-llsn" : "x-ms-item-lsn")) != null) {
                itemLSN = Long.parseLong(headerValue);
            }
            if (!Strings.isNullOrEmpty(headerValue = storeResponse.getHeaderValue("x-ms-request-duration-ms"))) {
                backendLatencyInMs = Double.parseDouble(headerValue);
            }
            long lsn = -1L;
            if (useLocalLSNBasedHeaders) {
                headerValue = storeResponse.getHeaderValue("x-ms-cosmos-llsn");
                if (headerValue != null) {
                    lsn = Long.parseLong(headerValue);
                }
            } else {
                lsn = storeResponse.getLSN();
            }
            ISessionToken sessionToken = null;
            headerValue = storeResponse.getHeaderValue("x-ms-session-token");
            if (headerValue != null) {
                sessionToken = SessionTokenHelper.parse(headerValue);
            }
            return new StoreResult(storeResponse, null, storeResponse.getPartitionKeyRangeId(), lsn, quorumAckedLSN, requestCharge, activityId, correlatedActivityId, currentReplicaSetSize, currentWriteQuorum, true, storePhysicalAddress, globalCommittedLSN, numberOfReadRegions, itemLSN, sessionToken, backendLatencyInMs);
        }
        Throwable unwrappedResponseExceptions = reactor.core.Exceptions.unwrap((Throwable)responseException);
        CosmosException cosmosException = Utils.as(unwrappedResponseExceptions, CosmosException.class);
        String activityId = "";
        String correlatedActivityId = "";
        if (cosmosException != null) {
            long quorumAckedLSN = -1L;
            int currentReplicaSetSize = -1;
            int currentWriteQuorum = -1;
            long globalCommittedLSN = -1L;
            int numberOfReadRegions = -1;
            Double backendLatencyInMs = null;
            String headerValue = cosmosException.getResponseHeaders().get(useLocalLSNBasedHeaders ? "x-ms-cosmos-quorum-acked-llsn" : "x-ms-quorum-acked-lsn");
            if (!Strings.isNullOrEmpty(headerValue)) {
                quorumAckedLSN = Long.parseLong(headerValue);
            }
            if (!Strings.isNullOrEmpty(headerValue = cosmosException.getResponseHeaders().get("x-ms-current-replica-set-size"))) {
                currentReplicaSetSize = Integer.parseInt(headerValue);
            }
            if (!Strings.isNullOrEmpty(headerValue = cosmosException.getResponseHeaders().get("x-ms-current-write-quorum"))) {
                currentReplicaSetSize = Integer.parseInt(headerValue);
            }
            double requestCharge = 0.0;
            headerValue = cosmosException.getResponseHeaders().get("x-ms-request-charge");
            if (!Strings.isNullOrEmpty(headerValue)) {
                requestCharge = Double.parseDouble(headerValue);
            }
            if (!Strings.isNullOrEmpty(headerValue = cosmosException.getResponseHeaders().get("x-ms-activity-id"))) {
                activityId = headerValue;
            }
            if (!Strings.isNullOrEmpty(headerValue = cosmosException.getResponseHeaders().get("x-ms-cosmos-correlated-activityid"))) {
                correlatedActivityId = headerValue;
            }
            if (!Strings.isNullOrEmpty(headerValue = cosmosException.getResponseHeaders().get("x-ms-number-of-read-regions"))) {
                numberOfReadRegions = Integer.parseInt(headerValue);
            }
            if (!Strings.isNullOrEmpty(headerValue = cosmosException.getResponseHeaders().get("x-ms-global-Committed-lsn"))) {
                globalCommittedLSN = Long.parseLong(headerValue);
            }
            if (!Strings.isNullOrEmpty(headerValue = cosmosException.getResponseHeaders().get("x-ms-request-duration-ms"))) {
                backendLatencyInMs = Double.parseDouble(headerValue);
            }
            long lsn = -1L;
            if (useLocalLSNBasedHeaders) {
                headerValue = cosmosException.getResponseHeaders().get("x-ms-cosmos-llsn");
                if (!Strings.isNullOrEmpty(headerValue)) {
                    lsn = Long.parseLong(headerValue);
                }
            } else {
                lsn = BridgeInternal.getLSN(cosmosException);
            }
            ISessionToken sessionToken = null;
            headerValue = cosmosException.getResponseHeaders().get("x-ms-session-token");
            if (!Strings.isNullOrEmpty(headerValue)) {
                sessionToken = SessionTokenHelper.parse(headerValue);
            }
            return new StoreResult(null, cosmosException, BridgeInternal.getPartitionKeyRangeId(cosmosException), lsn, quorumAckedLSN, requestCharge, activityId, correlatedActivityId, currentReplicaSetSize, currentWriteQuorum, !requiresValidLsn || (cosmosException.getStatusCode() != 410 || Exceptions.isSubStatusCode(cosmosException, 1000)) && lsn >= 0L, storePhysicalAddress == null ? BridgeInternal.getRequestUri(cosmosException) : storePhysicalAddress, globalCommittedLSN, numberOfReadRegions, -1L, sessionToken, backendLatencyInMs);
        }
        this.logger.error("Unexpected exception {} received while reading from store.", (Object)responseException.getMessage(), (Object)responseException);
        return new StoreResult(null, new InternalServerErrorException("Unknown server error occurred when processing this request. If the issue persists, please contact Azure Support: http://aka.ms/azure-support", responseException), null, -1L, -1L, 0.0, activityId, correlatedActivityId, 0, 0, false, storePhysicalAddress, -1L, 0, -1L, null, null);
    }

    void startBackgroundAddressRefresh(RxDocumentServiceRequest request) {
        this.addressSelector.resolveAllUriAsync(request, true, true).publishOn(Schedulers.boundedElastic()).subscribe(r -> {}, e -> this.logger.warn("Background refresh of the addresses failed with {}", (Object)e.getMessage(), e));
    }

    private static int generateNextRandom(int maxValue) {
        return ThreadLocalRandom.current().nextInt(maxValue);
    }

    static void verifyCanContinueOnException(CosmosException ex) {
        if (ex instanceof PartitionKeyRangeGoneException) {
            throw ex;
        }
        if (ex instanceof PartitionKeyRangeIsSplittingException) {
            throw ex;
        }
        if (ex instanceof PartitionIsMigratingException) {
            throw ex;
        }
        String value = ex.getResponseHeaders().get("x-ms-request-validation-failure");
        if (Strings.isNullOrWhiteSpace(value)) {
            return;
        }
        Integer result = Integers.tryParse(value);
        if (result != null && result == 1) {
            throw ex;
        }
    }

    private static class ReadReplicaResult {
        public final boolean retryWithForceRefresh;
        public final List<StoreResult> responses;

        public ReadReplicaResult(boolean retryWithForceRefresh, List<StoreResult> responses) {
            this.retryWithForceRefresh = retryWithForceRefresh;
            this.responses = responses;
        }
    }
}

