/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.core.http.ProxyOptions;
import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.ConnectionMode;
import com.azure.cosmos.DirectConnectionConfig;
import com.azure.cosmos.GatewayConnectionConfig;
import com.azure.cosmos.ThrottlingRetryOptions;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import java.time.Duration;
import java.util.Collections;
import java.util.List;

public final class ConnectionPolicy {
    private static final int defaultGatewayMaxConnectionPoolSize = GatewayConnectionConfig.getDefaultConfig().getMaxConnectionPoolSize();
    private ConnectionMode connectionMode;
    private boolean endpointDiscoveryEnabled;
    private boolean multipleWriteRegionsEnabled;
    private List<String> preferredRegions;
    private boolean readRequestsFallbackEnabled;
    private ThrottlingRetryOptions throttlingRetryOptions;
    private String userAgentSuffix;
    private int maxConnectionPoolSize;
    private Duration httpNetworkRequestTimeout;
    private ProxyOptions proxy;
    private Duration idleHttpConnectionTimeout;
    private Duration connectTimeout;
    private Duration idleTcpConnectionTimeout;
    private Duration idleTcpEndpointTimeout;
    private int maxConnectionsPerEndpoint;
    private int maxRequestsPerConnection;
    private Duration tcpNetworkRequestTimeout;
    private boolean tcpConnectionEndpointRediscoveryEnabled;
    private int ioThreadCountPerCoreFactor;
    private int ioThreadPriority;
    private boolean clientTelemetryEnabled;

    public ConnectionPolicy(GatewayConnectionConfig gatewayConnectionConfig) {
        this(ConnectionMode.GATEWAY);
        this.idleHttpConnectionTimeout = gatewayConnectionConfig.getIdleConnectionTimeout();
        this.maxConnectionPoolSize = gatewayConnectionConfig.getMaxConnectionPoolSize();
        this.httpNetworkRequestTimeout = BridgeInternal.getNetworkRequestTimeoutFromGatewayConnectionConfig(gatewayConnectionConfig);
        this.proxy = gatewayConnectionConfig.getProxy();
        this.tcpConnectionEndpointRediscoveryEnabled = false;
    }

    public ConnectionPolicy(DirectConnectionConfig directConnectionConfig) {
        this(ConnectionMode.DIRECT);
        this.connectTimeout = directConnectionConfig.getConnectTimeout();
        this.idleTcpConnectionTimeout = directConnectionConfig.getIdleConnectionTimeout();
        this.idleTcpEndpointTimeout = directConnectionConfig.getIdleEndpointTimeout();
        this.maxConnectionsPerEndpoint = directConnectionConfig.getMaxConnectionsPerEndpoint();
        this.maxRequestsPerConnection = directConnectionConfig.getMaxRequestsPerConnection();
        this.tcpNetworkRequestTimeout = directConnectionConfig.getNetworkRequestTimeout();
        this.tcpConnectionEndpointRediscoveryEnabled = directConnectionConfig.isConnectionEndpointRediscoveryEnabled();
        this.ioThreadCountPerCoreFactor = ImplementationBridgeHelpers.DirectConnectionConfigHelper.getDirectConnectionConfigAccessor().getIoThreadCountPerCoreFactor(directConnectionConfig);
        this.ioThreadPriority = ImplementationBridgeHelpers.DirectConnectionConfigHelper.getDirectConnectionConfigAccessor().getIoThreadPriority(directConnectionConfig);
    }

    private ConnectionPolicy(ConnectionMode connectionMode) {
        this.connectionMode = connectionMode;
        this.endpointDiscoveryEnabled = true;
        this.maxConnectionPoolSize = defaultGatewayMaxConnectionPoolSize;
        this.multipleWriteRegionsEnabled = true;
        this.readRequestsFallbackEnabled = true;
        this.throttlingRetryOptions = new ThrottlingRetryOptions();
        this.userAgentSuffix = "";
        this.ioThreadPriority = 5;
    }

    public boolean isTcpConnectionEndpointRediscoveryEnabled() {
        return this.tcpConnectionEndpointRediscoveryEnabled;
    }

    public ConnectionPolicy setTcpConnectionEndpointRediscoveryEnabled(boolean tcpConnectionEndpointRediscoveryEnabled) {
        this.tcpConnectionEndpointRediscoveryEnabled = tcpConnectionEndpointRediscoveryEnabled;
        return this;
    }

    public static ConnectionPolicy getDefaultPolicy() {
        return new ConnectionPolicy(DirectConnectionConfig.getDefaultConfig());
    }

    public Duration getHttpNetworkRequestTimeout() {
        return this.httpNetworkRequestTimeout;
    }

    public ConnectionPolicy setHttpNetworkRequestTimeout(Duration httpNetworkRequestTimeout) {
        this.httpNetworkRequestTimeout = httpNetworkRequestTimeout;
        return this;
    }

    public Duration getTcpNetworkRequestTimeout() {
        return this.tcpNetworkRequestTimeout;
    }

    public ConnectionPolicy setTcpNetworkRequestTimeout(Duration tcpNetworkRequestTimeout) {
        this.tcpNetworkRequestTimeout = tcpNetworkRequestTimeout;
        return this;
    }

    public ConnectionMode getConnectionMode() {
        return this.connectionMode;
    }

    public ConnectionPolicy setConnectionMode(ConnectionMode connectionMode) {
        this.connectionMode = connectionMode;
        return this;
    }

    public int getMaxConnectionPoolSize() {
        return this.maxConnectionPoolSize;
    }

    public ConnectionPolicy setMaxConnectionPoolSize(int maxConnectionPoolSize) {
        this.maxConnectionPoolSize = maxConnectionPoolSize;
        return this;
    }

    public Duration getIdleHttpConnectionTimeout() {
        return this.idleHttpConnectionTimeout;
    }

    public ConnectionPolicy setIdleHttpConnectionTimeout(Duration idleHttpConnectionTimeout) {
        this.idleHttpConnectionTimeout = idleHttpConnectionTimeout;
        return this;
    }

    public Duration getIdleTcpConnectionTimeout() {
        return this.idleTcpConnectionTimeout;
    }

    public ConnectionPolicy setIdleTcpConnectionTimeout(Duration idleTcpConnectionTimeout) {
        this.idleTcpConnectionTimeout = idleTcpConnectionTimeout;
        return this;
    }

    public String getUserAgentSuffix() {
        return this.userAgentSuffix;
    }

    public ConnectionPolicy setUserAgentSuffix(String userAgentSuffix) {
        this.userAgentSuffix = userAgentSuffix;
        return this;
    }

    public ThrottlingRetryOptions getThrottlingRetryOptions() {
        return this.throttlingRetryOptions;
    }

    public ConnectionPolicy setThrottlingRetryOptions(ThrottlingRetryOptions throttlingRetryOptions) {
        if (throttlingRetryOptions == null) {
            throw new IllegalArgumentException("retryOptions value must not be null.");
        }
        this.throttlingRetryOptions = throttlingRetryOptions;
        return this;
    }

    public boolean isEndpointDiscoveryEnabled() {
        return this.endpointDiscoveryEnabled;
    }

    public ConnectionPolicy setEndpointDiscoveryEnabled(boolean endpointDiscoveryEnabled) {
        this.endpointDiscoveryEnabled = endpointDiscoveryEnabled;
        return this;
    }

    public boolean isMultipleWriteRegionsEnabled() {
        return this.multipleWriteRegionsEnabled;
    }

    public boolean isReadRequestsFallbackEnabled() {
        return this.readRequestsFallbackEnabled;
    }

    public ConnectionPolicy setMultipleWriteRegionsEnabled(boolean multipleWriteRegionsEnabled) {
        this.multipleWriteRegionsEnabled = multipleWriteRegionsEnabled;
        return this;
    }

    public ConnectionPolicy setReadRequestsFallbackEnabled(boolean readRequestsFallbackEnabled) {
        this.readRequestsFallbackEnabled = readRequestsFallbackEnabled;
        return this;
    }

    public List<String> getPreferredRegions() {
        return this.preferredRegions != null ? this.preferredRegions : Collections.emptyList();
    }

    public ConnectionPolicy setPreferredRegions(List<String> preferredRegions) {
        this.preferredRegions = preferredRegions;
        return this;
    }

    public ProxyOptions getProxy() {
        return this.proxy;
    }

    public ConnectionPolicy setProxy(ProxyOptions proxy) {
        this.proxy = proxy;
        return this;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public ConnectionPolicy setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public Duration getIdleTcpEndpointTimeout() {
        return this.idleTcpEndpointTimeout;
    }

    public ConnectionPolicy setIdleTcpEndpointTimeout(Duration idleTcpEndpointTimeout) {
        this.idleTcpEndpointTimeout = idleTcpEndpointTimeout;
        return this;
    }

    public int getMaxConnectionsPerEndpoint() {
        return this.maxConnectionsPerEndpoint;
    }

    public ConnectionPolicy setMaxConnectionsPerEndpoint(int maxConnectionsPerEndpoint) {
        this.maxConnectionsPerEndpoint = maxConnectionsPerEndpoint;
        return this;
    }

    public int getMaxRequestsPerConnection() {
        return this.maxRequestsPerConnection;
    }

    public ConnectionPolicy setMaxRequestsPerConnection(int maxRequestsPerConnection) {
        this.maxRequestsPerConnection = maxRequestsPerConnection;
        return this;
    }

    public boolean isClientTelemetryEnabled() {
        return this.clientTelemetryEnabled;
    }

    public void setClientTelemetryEnabled(boolean clientTelemetryEnabled) {
        this.clientTelemetryEnabled = clientTelemetryEnabled;
    }

    public int getIoThreadCountPerCoreFactor() {
        return this.ioThreadCountPerCoreFactor;
    }

    public int getIoThreadPriority() {
        return this.ioThreadPriority;
    }

    public ConnectionPolicy setIoThreadCountPerCoreFactor(int ioThreadCountPerCoreFactor) {
        this.ioThreadCountPerCoreFactor = ioThreadCountPerCoreFactor;
        return this;
    }

    public ConnectionPolicy setIoThreadPriority(int ioThreadPriority) {
        this.ioThreadPriority = ioThreadPriority;
        return this;
    }

    public String toString() {
        return "ConnectionPolicy{httpNetworkRequestTimeout=" + this.httpNetworkRequestTimeout + ", tcpNetworkRequestTimeout=" + this.tcpNetworkRequestTimeout + ", connectionMode=" + (Object)((Object)this.connectionMode) + ", maxConnectionPoolSize=" + this.maxConnectionPoolSize + ", idleHttpConnectionTimeout=" + this.idleHttpConnectionTimeout + ", idleTcpConnectionTimeout=" + this.idleTcpConnectionTimeout + ", userAgentSuffix='" + this.userAgentSuffix + '\'' + ", throttlingRetryOptions=" + this.throttlingRetryOptions + ", endpointDiscoveryEnabled=" + this.endpointDiscoveryEnabled + ", preferredRegions=" + this.preferredRegions + ", multipleWriteRegionsEnabled=" + this.multipleWriteRegionsEnabled + ", proxyType=" + (this.proxy != null ? this.proxy.getType() : null) + ", inetSocketProxyAddress=" + (this.proxy != null ? this.proxy.getAddress() : null) + ", readRequestsFallbackEnabled=" + this.readRequestsFallbackEnabled + ", connectTimeout=" + this.connectTimeout + ", idleTcpEndpointTimeout=" + this.idleTcpEndpointTimeout + ", maxConnectionsPerEndpoint=" + this.maxConnectionsPerEndpoint + ", maxRequestsPerConnection=" + this.maxRequestsPerConnection + ", tcpConnectionEndpointRediscoveryEnabled=" + this.tcpConnectionEndpointRediscoveryEnabled + ", clientTelemetryEnabled=" + this.clientTelemetryEnabled + '}';
    }
}

