/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.spark.OperationContextAndListenerTuple;
import com.azure.cosmos.models.DedicatedGatewayRequestOptions;
import com.azure.cosmos.models.FeedRange;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.util.Beta;
import com.fasterxml.jackson.databind.JsonNode;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;

public class CosmosQueryRequestOptions {
    private ConsistencyLevel consistencyLevel;
    private String sessionToken;
    private String partitionKeyRangeId;
    private Boolean scanInQueryEnabled;
    private Boolean emitVerboseTracesInQuery;
    private int maxDegreeOfParallelism;
    private int maxBufferedItemCount;
    private int responseContinuationTokenLimitInKb;
    private Integer maxItemCount;
    private String requestContinuation;
    private PartitionKey partitionkey;
    private boolean queryMetricsEnabled;
    private Map<String, Object> properties;
    private boolean emptyPagesAllowed;
    private FeedRange feedRange;
    private OperationContextAndListenerTuple operationContextAndListenerTuple;
    private String throughputControlGroupName;
    private DedicatedGatewayRequestOptions dedicatedGatewayRequestOptions;
    private Duration thresholdForDiagnosticsOnTracer;
    private Map<String, String> customOptions;
    private boolean indexMetricsEnabled;
    private boolean queryPlanRetrievalDisallowed;
    private UUID correlationActivityId;
    private boolean emptyPageDiagnosticsEnabled;
    private Function<JsonNode, ?> itemFactoryMethod;

    public CosmosQueryRequestOptions() {
        this.queryMetricsEnabled = true;
        this.emptyPageDiagnosticsEnabled = Configs.isEmptyPageDiagnosticsEnabled();
    }

    CosmosQueryRequestOptions(CosmosQueryRequestOptions options) {
        this.consistencyLevel = options.consistencyLevel;
        this.sessionToken = options.sessionToken;
        this.partitionKeyRangeId = options.partitionKeyRangeId;
        this.scanInQueryEnabled = options.scanInQueryEnabled;
        this.emitVerboseTracesInQuery = options.emitVerboseTracesInQuery;
        this.maxDegreeOfParallelism = options.maxDegreeOfParallelism;
        this.maxBufferedItemCount = options.maxBufferedItemCount;
        this.responseContinuationTokenLimitInKb = options.responseContinuationTokenLimitInKb;
        this.maxItemCount = options.maxItemCount;
        this.requestContinuation = options.requestContinuation;
        this.partitionkey = options.partitionkey;
        this.queryMetricsEnabled = options.queryMetricsEnabled;
        this.emptyPagesAllowed = options.emptyPagesAllowed;
        this.throughputControlGroupName = options.throughputControlGroupName;
        this.operationContextAndListenerTuple = options.operationContextAndListenerTuple;
        this.dedicatedGatewayRequestOptions = options.dedicatedGatewayRequestOptions;
        this.customOptions = options.customOptions;
        this.indexMetricsEnabled = options.indexMetricsEnabled;
        this.queryPlanRetrievalDisallowed = options.queryPlanRetrievalDisallowed;
        this.correlationActivityId = options.correlationActivityId;
        this.emptyPageDiagnosticsEnabled = options.emptyPageDiagnosticsEnabled;
        this.itemFactoryMethod = options.itemFactoryMethod;
    }

    void setOperationContextAndListenerTuple(OperationContextAndListenerTuple operationContextAndListenerTuple) {
        this.operationContextAndListenerTuple = operationContextAndListenerTuple;
    }

    OperationContextAndListenerTuple getOperationContextAndListenerTuple() {
        return this.operationContextAndListenerTuple;
    }

    String getPartitionKeyRangeIdInternal() {
        return this.partitionKeyRangeId;
    }

    CosmosQueryRequestOptions setPartitionKeyRangeIdInternal(String partitionKeyRangeId) {
        this.partitionKeyRangeId = partitionKeyRangeId;
        return this;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public CosmosQueryRequestOptions setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public CosmosQueryRequestOptions setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
        return this;
    }

    public Boolean isScanInQueryEnabled() {
        return this.scanInQueryEnabled;
    }

    public CosmosQueryRequestOptions setScanInQueryEnabled(Boolean scanInQueryEnabled) {
        this.scanInQueryEnabled = scanInQueryEnabled;
        return this;
    }

    UUID getCorrelationActivityId() {
        return this.correlationActivityId;
    }

    CosmosQueryRequestOptions setCorrelationActivityId(UUID correlationActivityId) {
        this.correlationActivityId = correlationActivityId;
        return this;
    }

    Boolean isEmitVerboseTracesInQuery() {
        return this.emitVerboseTracesInQuery;
    }

    CosmosQueryRequestOptions setEmitVerboseTracesInQuery(Boolean emitVerboseTracesInQuery) {
        this.emitVerboseTracesInQuery = emitVerboseTracesInQuery;
        return this;
    }

    public int getMaxDegreeOfParallelism() {
        return this.maxDegreeOfParallelism;
    }

    public CosmosQueryRequestOptions setMaxDegreeOfParallelism(int maxDegreeOfParallelism) {
        this.maxDegreeOfParallelism = maxDegreeOfParallelism;
        return this;
    }

    public int getMaxBufferedItemCount() {
        return this.maxBufferedItemCount;
    }

    public CosmosQueryRequestOptions setMaxBufferedItemCount(int maxBufferedItemCount) {
        this.maxBufferedItemCount = maxBufferedItemCount;
        return this;
    }

    public CosmosQueryRequestOptions setResponseContinuationTokenLimitInKb(int limitInKb) {
        this.responseContinuationTokenLimitInKb = limitInKb;
        return this;
    }

    public int getResponseContinuationTokenLimitInKb() {
        return this.responseContinuationTokenLimitInKb;
    }

    Integer getMaxItemCount() {
        return this.maxItemCount;
    }

    CosmosQueryRequestOptions setMaxItemCount(Integer maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    String getRequestContinuation() {
        return this.requestContinuation;
    }

    CosmosQueryRequestOptions setRequestContinuation(String requestContinuation) {
        this.requestContinuation = requestContinuation;
        return this;
    }

    public PartitionKey getPartitionKey() {
        return this.partitionkey;
    }

    public CosmosQueryRequestOptions setPartitionKey(PartitionKey partitionkey) {
        this.partitionkey = partitionkey;
        return this;
    }

    public boolean isQueryMetricsEnabled() {
        return this.queryMetricsEnabled;
    }

    public CosmosQueryRequestOptions setQueryMetricsEnabled(boolean queryMetricsEnabled) {
        this.queryMetricsEnabled = queryMetricsEnabled;
        return this;
    }

    Map<String, Object> getProperties() {
        return this.properties;
    }

    CosmosQueryRequestOptions setProperties(Map<String, Object> properties) {
        this.properties = properties;
        return this;
    }

    boolean isEmptyPagesAllowed() {
        return this.emptyPagesAllowed;
    }

    CosmosQueryRequestOptions setEmptyPagesAllowed(boolean emptyPagesAllowed) {
        this.emptyPagesAllowed = emptyPagesAllowed;
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_13_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public FeedRange getFeedRange() {
        return this.feedRange;
    }

    @Beta(value=Beta.SinceVersion.V4_13_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public CosmosQueryRequestOptions setFeedRange(FeedRange feedRange) {
        this.feedRange = feedRange;
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_13_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public String getThroughputControlGroupName() {
        return this.throughputControlGroupName;
    }

    @Beta(value=Beta.SinceVersion.V4_13_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public CosmosQueryRequestOptions setThroughputControlGroupName(String throughputControlGroupName) {
        this.throughputControlGroupName = throughputControlGroupName;
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_15_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public DedicatedGatewayRequestOptions getDedicatedGatewayRequestOptions() {
        return this.dedicatedGatewayRequestOptions;
    }

    @Beta(value=Beta.SinceVersion.V4_15_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public CosmosQueryRequestOptions setDedicatedGatewayRequestOptions(DedicatedGatewayRequestOptions dedicatedGatewayRequestOptions) {
        this.dedicatedGatewayRequestOptions = dedicatedGatewayRequestOptions;
        return this;
    }

    public Duration getThresholdForDiagnosticsOnTracer() {
        return this.thresholdForDiagnosticsOnTracer;
    }

    public CosmosQueryRequestOptions setThresholdForDiagnosticsOnTracer(Duration thresholdForDiagnosticsOnTracer) {
        this.thresholdForDiagnosticsOnTracer = thresholdForDiagnosticsOnTracer;
        return this;
    }

    public boolean isIndexMetricsEnabled() {
        return this.indexMetricsEnabled;
    }

    public CosmosQueryRequestOptions setIndexMetricsEnabled(boolean indexMetricsEnabled) {
        this.indexMetricsEnabled = indexMetricsEnabled;
        return this;
    }

    CosmosQueryRequestOptions setHeader(String name, String value) {
        if (this.customOptions == null) {
            this.customOptions = new HashMap<String, String>();
        }
        this.customOptions.put(name, value);
        return this;
    }

    Map<String, String> getHeaders() {
        return this.customOptions;
    }

    CosmosQueryRequestOptions disallowQueryPlanRetrieval() {
        this.queryPlanRetrievalDisallowed = true;
        return this;
    }

    boolean isQueryPlanRetrievalDisallowed() {
        return this.queryPlanRetrievalDisallowed;
    }

    boolean isEmptyPageDiagnosticsEnabled() {
        return this.emptyPageDiagnosticsEnabled;
    }

    CosmosQueryRequestOptions setEmptyPageDiagnosticsEnabled(boolean emptyPageDiagnosticsEnabled) {
        this.emptyPageDiagnosticsEnabled = emptyPageDiagnosticsEnabled;
        return this;
    }

    Function<JsonNode, ?> getItemFactoryMethod() {
        return this.itemFactoryMethod;
    }

    CosmosQueryRequestOptions setItemFactoryMethod(Function<JsonNode, ?> factoryMethod) {
        this.itemFactoryMethod = factoryMethod;
        return this;
    }

    static {
        ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.setCosmosQueryRequestOptionsAccessor(new ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.CosmosQueryRequestOptionsAccessor(){

            @Override
            public void setOperationContext(CosmosQueryRequestOptions queryRequestOptions, OperationContextAndListenerTuple operationContextAndListenerTuple) {
                queryRequestOptions.setOperationContextAndListenerTuple(operationContextAndListenerTuple);
            }

            @Override
            public OperationContextAndListenerTuple getOperationContext(CosmosQueryRequestOptions queryRequestOptions) {
                return queryRequestOptions.getOperationContextAndListenerTuple();
            }

            @Override
            public CosmosQueryRequestOptions setHeader(CosmosQueryRequestOptions queryRequestOptions, String name, String value) {
                return queryRequestOptions.setHeader(name, value);
            }

            @Override
            public Map<String, String> getHeader(CosmosQueryRequestOptions queryRequestOptions) {
                return queryRequestOptions.getHeaders();
            }

            @Override
            public CosmosQueryRequestOptions disallowQueryPlanRetrieval(CosmosQueryRequestOptions queryRequestOptions) {
                return queryRequestOptions.disallowQueryPlanRetrieval();
            }

            @Override
            public UUID getCorrelationActivityId(CosmosQueryRequestOptions queryRequestOptions) {
                if (queryRequestOptions == null) {
                    return null;
                }
                return queryRequestOptions.getCorrelationActivityId();
            }

            @Override
            public CosmosQueryRequestOptions setCorrelationActivityId(CosmosQueryRequestOptions queryRequestOptions, UUID correlationActivityId) {
                return queryRequestOptions.setCorrelationActivityId(correlationActivityId);
            }

            @Override
            public boolean isQueryPlanRetrievalDisallowed(CosmosQueryRequestOptions queryRequestOptions) {
                return queryRequestOptions.isQueryPlanRetrievalDisallowed();
            }

            @Override
            public boolean isEmptyPageDiagnosticsEnabled(CosmosQueryRequestOptions queryRequestOptions) {
                return queryRequestOptions.isEmptyPageDiagnosticsEnabled();
            }

            @Override
            public CosmosQueryRequestOptions setEmptyPageDiagnosticsEnabled(CosmosQueryRequestOptions queryRequestOptions, boolean emptyPageDiagnosticsEnabled) {
                return queryRequestOptions.setEmptyPageDiagnosticsEnabled(emptyPageDiagnosticsEnabled);
            }

            @Override
            public <T> Function<JsonNode, T> getItemFactoryMethod(CosmosQueryRequestOptions queryRequestOptions, Class<T> classOfT) {
                return queryRequestOptions.getItemFactoryMethod();
            }

            @Override
            public CosmosQueryRequestOptions setItemFactoryMethod(CosmosQueryRequestOptions queryRequestOptions, Function<JsonNode, ?> factoryMethod) {
                return queryRequestOptions.setItemFactoryMethod(factoryMethod);
            }
        });
    }
}

