/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.DiagnosticsInstantSerializer;
import com.azure.cosmos.implementation.GlobalEndpointManager;
import com.azure.cosmos.implementation.MetadataDiagnosticsContext;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.RequestTimeline;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RetryContext;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.SerializationDiagnosticsContext;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.cpu.CpuMemoryMonitor;
import com.azure.cosmos.implementation.directconnectivity.DirectBridgeInternal;
import com.azure.cosmos.implementation.directconnectivity.StoreResponse;
import com.azure.cosmos.implementation.directconnectivity.StoreResult;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonSerialize(using=ClientSideRequestStatisticsSerializer.class)
public class ClientSideRequestStatistics {
    private static final int MAX_SUPPLEMENTAL_REQUESTS_FOR_TO_STRING = 10;
    private final DiagnosticsClientContext diagnosticsClientContext;
    private String activityId;
    private List<StoreResponseStatistics> responseStatisticsList;
    private List<StoreResponseStatistics> supplementalResponseStatisticsList;
    private Map<String, AddressResolutionStatistics> addressResolutionStatistics;
    private List<URI> contactedReplicas;
    private Set<URI> failedReplicas;
    private Instant requestStartTimeUTC;
    private Instant requestEndTimeUTC;
    private Set<String> regionsContacted;
    private Set<URI> locationEndpointsContacted;
    private RetryContext retryContext;
    private GatewayStatistics gatewayStatistics;
    private RequestTimeline gatewayRequestTimeline;
    private MetadataDiagnosticsContext metadataDiagnosticsContext;
    private SerializationDiagnosticsContext serializationDiagnosticsContext;
    private GlobalEndpointManager globalEndpointManager;

    public ClientSideRequestStatistics(DiagnosticsClientContext diagnosticsClientContext, GlobalEndpointManager globalEndpointManager) {
        this.diagnosticsClientContext = diagnosticsClientContext;
        this.requestStartTimeUTC = Instant.now();
        this.requestEndTimeUTC = Instant.now();
        this.responseStatisticsList = new ArrayList<StoreResponseStatistics>();
        this.supplementalResponseStatisticsList = new ArrayList<StoreResponseStatistics>();
        this.addressResolutionStatistics = new HashMap<String, AddressResolutionStatistics>();
        this.contactedReplicas = Collections.synchronizedList(new ArrayList());
        this.failedReplicas = Collections.synchronizedSet(new HashSet());
        this.regionsContacted = Collections.synchronizedSet(new HashSet());
        this.locationEndpointsContacted = Collections.synchronizedSet(new HashSet());
        this.metadataDiagnosticsContext = new MetadataDiagnosticsContext();
        this.serializationDiagnosticsContext = new SerializationDiagnosticsContext();
        this.retryContext = new RetryContext();
        this.globalEndpointManager = globalEndpointManager;
    }

    public ClientSideRequestStatistics(ClientSideRequestStatistics toBeCloned) {
        this.diagnosticsClientContext = toBeCloned.diagnosticsClientContext;
        this.requestStartTimeUTC = toBeCloned.requestStartTimeUTC;
        this.requestEndTimeUTC = toBeCloned.requestEndTimeUTC;
        this.responseStatisticsList = new ArrayList<StoreResponseStatistics>(toBeCloned.responseStatisticsList);
        this.supplementalResponseStatisticsList = new ArrayList<StoreResponseStatistics>(toBeCloned.supplementalResponseStatisticsList);
        this.addressResolutionStatistics = new HashMap<String, AddressResolutionStatistics>(toBeCloned.addressResolutionStatistics);
        this.contactedReplicas = Collections.synchronizedList(new ArrayList<URI>(toBeCloned.contactedReplicas));
        this.failedReplicas = Collections.synchronizedSet(new HashSet<URI>(toBeCloned.failedReplicas));
        this.regionsContacted = Collections.synchronizedSet(new HashSet<String>(toBeCloned.regionsContacted));
        this.locationEndpointsContacted = Collections.synchronizedSet(new HashSet<URI>(toBeCloned.locationEndpointsContacted));
        this.metadataDiagnosticsContext = new MetadataDiagnosticsContext(toBeCloned.metadataDiagnosticsContext);
        this.serializationDiagnosticsContext = new SerializationDiagnosticsContext(toBeCloned.serializationDiagnosticsContext);
        this.retryContext = new RetryContext(toBeCloned.retryContext);
        this.globalEndpointManager = toBeCloned.globalEndpointManager;
    }

    public Duration getDuration() {
        return Duration.between(this.requestStartTimeUTC, this.requestEndTimeUTC);
    }

    public Instant getRequestStartTimeUTC() {
        return this.requestStartTimeUTC;
    }

    public DiagnosticsClientContext getDiagnosticsClientContext() {
        return this.diagnosticsClientContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordResponse(RxDocumentServiceRequest request, StoreResult storeResult) {
        Objects.requireNonNull(request, "request is required and cannot be null.");
        Instant responseTime = Instant.now();
        StoreResponseStatistics storeResponseStatistics = new StoreResponseStatistics();
        storeResponseStatistics.requestResponseTimeUTC = responseTime;
        storeResponseStatistics.storeResult = storeResult;
        storeResponseStatistics.requestOperationType = request.getOperationType();
        storeResponseStatistics.requestResourceType = request.getResourceType();
        this.activityId = request.getActivityId().toString();
        URI locationEndPoint = null;
        if (request.requestContext != null && request.requestContext.locationEndpointToRoute != null) {
            locationEndPoint = request.requestContext.locationEndpointToRoute;
        }
        ClientSideRequestStatistics clientSideRequestStatistics = this;
        synchronized (clientSideRequestStatistics) {
            if (responseTime.isAfter(this.requestEndTimeUTC)) {
                this.requestEndTimeUTC = responseTime;
            }
            if (locationEndPoint != null) {
                this.regionsContacted.add(this.globalEndpointManager.getRegionName(locationEndPoint, request.getOperationType()));
                this.locationEndpointsContacted.add(locationEndPoint);
            }
            if (storeResponseStatistics.requestOperationType == OperationType.Head || storeResponseStatistics.requestOperationType == OperationType.HeadFeed) {
                this.supplementalResponseStatisticsList.add(storeResponseStatistics);
            } else {
                this.responseStatisticsList.add(storeResponseStatistics);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordGatewayResponse(RxDocumentServiceRequest rxDocumentServiceRequest, StoreResponse storeResponse, CosmosException exception) {
        Instant responseTime = Instant.now();
        ClientSideRequestStatistics clientSideRequestStatistics = this;
        synchronized (clientSideRequestStatistics) {
            if (responseTime.isAfter(this.requestEndTimeUTC)) {
                this.requestEndTimeUTC = responseTime;
            }
            URI locationEndPoint = null;
            if (rxDocumentServiceRequest != null && rxDocumentServiceRequest.requestContext != null) {
                locationEndPoint = rxDocumentServiceRequest.requestContext.locationEndpointToRoute;
            }
            this.recordRetryContextEndTime();
            if (locationEndPoint != null) {
                this.regionsContacted.add(this.globalEndpointManager.getRegionName(locationEndPoint, rxDocumentServiceRequest.getOperationType()));
                this.locationEndpointsContacted.add(locationEndPoint);
            }
            this.gatewayStatistics = new GatewayStatistics();
            if (rxDocumentServiceRequest != null) {
                this.gatewayStatistics.operationType = rxDocumentServiceRequest.getOperationType();
                this.gatewayStatistics.resourceType = rxDocumentServiceRequest.getResourceType();
            }
            if (storeResponse != null) {
                this.gatewayStatistics.statusCode = storeResponse.getStatus();
                this.gatewayStatistics.subStatusCode = DirectBridgeInternal.getSubStatusCode(storeResponse);
                this.gatewayStatistics.sessionToken = storeResponse.getHeaderValue("x-ms-session-token");
                this.gatewayStatistics.requestCharge = storeResponse.getHeaderValue("x-ms-request-charge");
                this.gatewayStatistics.requestTimeline = DirectBridgeInternal.getRequestTimeline(storeResponse);
                this.gatewayStatistics.partitionKeyRangeId = storeResponse.getPartitionKeyRangeId();
                this.activityId = storeResponse.getHeaderValue("x-ms-activity-id");
            } else if (exception != null) {
                this.gatewayStatistics.statusCode = exception.getStatusCode();
                this.gatewayStatistics.subStatusCode = exception.getSubStatusCode();
                this.gatewayStatistics.requestTimeline = this.gatewayRequestTimeline;
                this.gatewayStatistics.requestCharge = String.valueOf(exception.getRequestCharge());
                this.activityId = exception.getActivityId();
            }
        }
    }

    public void setGatewayRequestTimeline(RequestTimeline transportRequestTimeline) {
        this.gatewayRequestTimeline = transportRequestTimeline;
    }

    public RequestTimeline getGatewayRequestTimeline() {
        return this.gatewayRequestTimeline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String recordAddressResolutionStart(URI targetEndpoint, boolean forceRefresh, boolean forceCollectionRoutingMapRefresh) {
        String identifier = Utils.randomUUID().toString();
        AddressResolutionStatistics resolutionStatistics = new AddressResolutionStatistics();
        resolutionStatistics.startTimeUTC = Instant.now();
        resolutionStatistics.endTimeUTC = null;
        resolutionStatistics.targetEndpoint = targetEndpoint == null ? "<NULL>" : targetEndpoint.toString();
        resolutionStatistics.forceRefresh = forceRefresh;
        resolutionStatistics.forceCollectionRoutingMapRefresh = forceCollectionRoutingMapRefresh;
        ClientSideRequestStatistics clientSideRequestStatistics = this;
        synchronized (clientSideRequestStatistics) {
            this.addressResolutionStatistics.put(identifier, resolutionStatistics);
        }
        return identifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordAddressResolutionEnd(String identifier, String errorMessage) {
        if (StringUtils.isEmpty(identifier)) {
            return;
        }
        Instant responseTime = Instant.now();
        ClientSideRequestStatistics clientSideRequestStatistics = this;
        synchronized (clientSideRequestStatistics) {
            if (!this.addressResolutionStatistics.containsKey(identifier)) {
                throw new IllegalArgumentException("Identifier " + identifier + " does not exist. Please call start before calling end");
            }
            if (responseTime.isAfter(this.requestEndTimeUTC)) {
                this.requestEndTimeUTC = responseTime;
            }
            AddressResolutionStatistics resolutionStatistics = this.addressResolutionStatistics.get(identifier);
            resolutionStatistics.endTimeUTC = responseTime;
            resolutionStatistics.errorMessage = errorMessage;
            resolutionStatistics.inflightRequest = false;
        }
    }

    public List<URI> getContactedReplicas() {
        return this.contactedReplicas;
    }

    public void setContactedReplicas(List<URI> contactedReplicas) {
        this.contactedReplicas = Collections.synchronizedList(contactedReplicas);
    }

    public Set<URI> getFailedReplicas() {
        return this.failedReplicas;
    }

    public void setFailedReplicas(Set<URI> failedReplicas) {
        this.failedReplicas = Collections.synchronizedSet(failedReplicas);
    }

    public Set<String> getContactedRegionNames() {
        return this.regionsContacted;
    }

    public void setRegionsContacted(Set<String> regionsContacted) {
        this.regionsContacted = Collections.synchronizedSet(regionsContacted);
    }

    public Set<URI> getLocationEndpointsContacted() {
        return this.locationEndpointsContacted;
    }

    public void setLocationEndpointsContacted(Set<URI> locationEndpointsContacted) {
        this.locationEndpointsContacted = locationEndpointsContacted;
    }

    public MetadataDiagnosticsContext getMetadataDiagnosticsContext() {
        return this.metadataDiagnosticsContext;
    }

    public SerializationDiagnosticsContext getSerializationDiagnosticsContext() {
        return this.serializationDiagnosticsContext;
    }

    public void recordRetryContextEndTime() {
        this.retryContext.updateEndTime();
    }

    public RetryContext getRetryContext() {
        return this.retryContext;
    }

    public List<StoreResponseStatistics> getResponseStatisticsList() {
        return this.responseStatisticsList;
    }

    public List<StoreResponseStatistics> getSupplementalResponseStatisticsList() {
        return this.supplementalResponseStatisticsList;
    }

    public Map<String, AddressResolutionStatistics> getAddressResolutionStatistics() {
        return this.addressResolutionStatistics;
    }

    public GatewayStatistics getGatewayStatistics() {
        return this.gatewayStatistics;
    }

    public static List<StoreResponseStatistics> getCappedSupplementalResponseStatisticsList(List<StoreResponseStatistics> supplementalResponseStatisticsList) {
        int supplementalResponseStatisticsListCount = supplementalResponseStatisticsList.size();
        int initialIndex = Math.max(supplementalResponseStatisticsListCount - 10, 0);
        if (initialIndex != 0) {
            List<StoreResponseStatistics> subList = supplementalResponseStatisticsList.subList(initialIndex, supplementalResponseStatisticsListCount);
            return subList;
        }
        return supplementalResponseStatisticsList;
    }

    public static SystemInformation fetchSystemInformation() {
        SystemInformation systemInformation = new SystemInformation();
        Runtime runtime = Runtime.getRuntime();
        long totalMemory = runtime.totalMemory() / 1024L;
        long freeMemory = runtime.freeMemory() / 1024L;
        long maxMemory = runtime.maxMemory() / 1024L;
        systemInformation.usedMemory = totalMemory - freeMemory + " KB";
        systemInformation.availableMemory = maxMemory - (totalMemory - freeMemory) + " KB";
        systemInformation.availableProcessors = runtime.availableProcessors();
        systemInformation.systemCpuLoad = CpuMemoryMonitor.getCpuLoad().toString();
        return systemInformation;
    }

    public static class GatewayStatistics {
        private String sessionToken;
        private OperationType operationType;
        private ResourceType resourceType;
        private int statusCode;
        private int subStatusCode;
        private String requestCharge;
        private RequestTimeline requestTimeline;
        private String partitionKeyRangeId;

        public String getSessionToken() {
            return this.sessionToken;
        }

        public OperationType getOperationType() {
            return this.operationType;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public int getSubStatusCode() {
            return this.subStatusCode;
        }

        public String getRequestCharge() {
            return this.requestCharge;
        }

        public RequestTimeline getRequestTimeline() {
            return this.requestTimeline;
        }

        public ResourceType getResourceType() {
            return this.resourceType;
        }

        public String getPartitionKeyRangeId() {
            return this.partitionKeyRangeId;
        }
    }

    public static class AddressResolutionStatistics {
        @JsonSerialize(using=DiagnosticsInstantSerializer.class)
        private Instant startTimeUTC;
        @JsonSerialize(using=DiagnosticsInstantSerializer.class)
        private Instant endTimeUTC;
        @JsonSerialize
        private String targetEndpoint;
        @JsonSerialize
        private String errorMessage;
        @JsonSerialize
        private boolean forceRefresh;
        @JsonSerialize
        private boolean forceCollectionRoutingMapRefresh;
        @JsonSerialize
        private boolean inflightRequest = true;

        public Instant getStartTimeUTC() {
            return this.startTimeUTC;
        }

        public Instant getEndTimeUTC() {
            return this.endTimeUTC;
        }

        public String getTargetEndpoint() {
            return this.targetEndpoint;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public boolean isInflightRequest() {
            return this.inflightRequest;
        }

        public boolean isForceRefresh() {
            return this.forceRefresh;
        }

        public boolean isForceCollectionRoutingMapRefresh() {
            return this.forceCollectionRoutingMapRefresh;
        }
    }

    public static class ClientSideRequestStatisticsSerializer
    extends StdSerializer<ClientSideRequestStatistics> {
        private static final long serialVersionUID = -2746532297176812860L;

        ClientSideRequestStatisticsSerializer() {
            super(ClientSideRequestStatistics.class);
        }

        public void serialize(ClientSideRequestStatistics statistics, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeStartObject();
            long requestLatency = statistics.getDuration().toMillis();
            generator.writeStringField("userAgent", Utils.getUserAgent());
            generator.writeStringField("activityId", statistics.activityId);
            generator.writeNumberField("requestLatencyInMs", requestLatency);
            generator.writeStringField("requestStartTimeUTC", DiagnosticsInstantSerializer.fromInstant(statistics.requestStartTimeUTC));
            generator.writeStringField("requestEndTimeUTC", DiagnosticsInstantSerializer.fromInstant(statistics.requestEndTimeUTC));
            generator.writeObjectField("responseStatisticsList", (Object)statistics.responseStatisticsList);
            generator.writeObjectField("supplementalResponseStatisticsList", ClientSideRequestStatistics.getCappedSupplementalResponseStatisticsList(statistics.supplementalResponseStatisticsList));
            generator.writeObjectField("addressResolutionStatistics", (Object)statistics.addressResolutionStatistics);
            generator.writeObjectField("regionsContacted", (Object)statistics.regionsContacted);
            generator.writeObjectField("retryContext", (Object)statistics.retryContext);
            generator.writeObjectField("metadataDiagnosticsContext", (Object)statistics.getMetadataDiagnosticsContext());
            generator.writeObjectField("serializationDiagnosticsContext", (Object)statistics.getSerializationDiagnosticsContext());
            generator.writeObjectField("gatewayStatistics", (Object)statistics.gatewayStatistics);
            try {
                SystemInformation systemInformation = ClientSideRequestStatistics.fetchSystemInformation();
                generator.writeObjectField("systemInformation", (Object)systemInformation);
            }
            catch (Exception exception) {
                // empty catch block
            }
            generator.writeObjectField("clientCfgs", (Object)statistics.diagnosticsClientContext);
            generator.writeEndObject();
        }
    }

    public static class SystemInformation {
        private String usedMemory;
        private String availableMemory;
        private String systemCpuLoad;
        private int availableProcessors;

        public String getUsedMemory() {
            return this.usedMemory;
        }

        public String getAvailableMemory() {
            return this.availableMemory;
        }

        public String getSystemCpuLoad() {
            return this.systemCpuLoad;
        }

        public int getAvailableProcessors() {
            return this.availableProcessors;
        }
    }

    public static class StoreResponseStatistics {
        @JsonSerialize(using=StoreResult.StoreResultSerializer.class)
        private StoreResult storeResult;
        @JsonSerialize(using=DiagnosticsInstantSerializer.class)
        private Instant requestResponseTimeUTC;
        @JsonSerialize
        private ResourceType requestResourceType;
        @JsonSerialize
        private OperationType requestOperationType;

        public StoreResult getStoreResult() {
            return this.storeResult;
        }

        public Instant getRequestResponseTimeUTC() {
            return this.requestResponseTimeUTC;
        }

        public ResourceType getRequestResourceType() {
            return this.requestResourceType;
        }

        public OperationType getRequestOperationType() {
            return this.requestOperationType;
        }
    }
}

