/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.http;

import com.azure.core.http.ProxyOptions;
import com.azure.cosmos.implementation.Configs;
import java.time.Duration;

public class HttpClientConfig {
    public static final String REACTOR_NETWORK_LOG_CATEGORY = "com.azure.cosmos.netty-network";
    private final Configs configs;
    private Integer maxPoolSize;
    private Duration maxIdleConnectionTimeout;
    private Duration networkRequestTimeout;
    private ProxyOptions proxy;
    private boolean connectionKeepAlive = true;

    public HttpClientConfig(Configs configs) {
        this.configs = configs;
    }

    public HttpClientConfig withPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
        return this;
    }

    public HttpClientConfig withProxy(ProxyOptions proxy) {
        this.proxy = proxy;
        return this;
    }

    public HttpClientConfig withMaxIdleConnectionTimeout(Duration maxIdleConnectionTimeout) {
        this.maxIdleConnectionTimeout = maxIdleConnectionTimeout;
        return this;
    }

    public HttpClientConfig withNetworkRequestTimeout(Duration requestTimeout) {
        this.networkRequestTimeout = requestTimeout;
        return this;
    }

    public HttpClientConfig withConnectionKeepAlive(boolean connectionKeepAlive) {
        this.connectionKeepAlive = connectionKeepAlive;
        return this;
    }

    public Configs getConfigs() {
        return this.configs;
    }

    public Integer getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public Duration getMaxIdleConnectionTimeout() {
        return this.maxIdleConnectionTimeout;
    }

    public Duration getNetworkRequestTimeout() {
        return this.networkRequestTimeout;
    }

    public ProxyOptions getProxy() {
        return this.proxy;
    }

    public boolean isConnectionKeepAlive() {
        return this.connectionKeepAlive;
    }
}

