/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.BadRequestException;
import com.azure.cosmos.implementation.ClientSideRequestStatistics;
import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.implementation.DocumentClientRetryPolicy;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.QueryMetrics;
import com.azure.cosmos.implementation.RequestChargeTracker;
import com.azure.cosmos.implementation.ResourceId;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Undefined;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.tuple.ImmutablePair;
import com.azure.cosmos.implementation.apachecommons.lang.tuple.Pair;
import com.azure.cosmos.implementation.feedranges.FeedRangeEpkImpl;
import com.azure.cosmos.implementation.query.CompositeContinuationToken;
import com.azure.cosmos.implementation.query.IDocumentQueryClient;
import com.azure.cosmos.implementation.query.IDocumentQueryExecutionComponent;
import com.azure.cosmos.implementation.query.ItemType;
import com.azure.cosmos.implementation.query.ItemTypeHelper;
import com.azure.cosmos.implementation.query.OrderByContinuationToken;
import com.azure.cosmos.implementation.query.OrderByDocumentProducer;
import com.azure.cosmos.implementation.query.OrderByUtils;
import com.azure.cosmos.implementation.query.ParallelDocumentQueryExecutionContextBase;
import com.azure.cosmos.implementation.query.PartitionMapper;
import com.azure.cosmos.implementation.query.PipelinedDocumentQueryParams;
import com.azure.cosmos.implementation.query.QueryInfo;
import com.azure.cosmos.implementation.query.QueryItem;
import com.azure.cosmos.implementation.query.SortOrder;
import com.azure.cosmos.implementation.query.TriFunction;
import com.azure.cosmos.implementation.query.orderbyquery.ComparisonFilters;
import com.azure.cosmos.implementation.query.orderbyquery.ComparisonWithDefinedFilters;
import com.azure.cosmos.implementation.query.orderbyquery.ComparisonWithUndefinedFilters;
import com.azure.cosmos.implementation.query.orderbyquery.OrderByRowResult;
import com.azure.cosmos.implementation.query.orderbyquery.OrderbyRowComparer;
import com.azure.cosmos.implementation.routing.Range;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.SqlQuerySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class OrderByDocumentQueryExecutionContext
extends ParallelDocumentQueryExecutionContextBase<Document> {
    private static final String FormatPlaceHolder = "{documentdb-formattableorderbyquery-filter}";
    private static final String True = "true";
    private static final Pattern QUOTE_PATTERN = Pattern.compile("\"");
    private final String collectionRid;
    private final OrderbyRowComparer<Document> consumeComparer;
    private final RequestChargeTracker tracker;
    private final ConcurrentMap<String, QueryMetrics> queryMetricMap;
    private final List<ClientSideRequestStatistics> clientSideRequestStatisticsList;
    private Flux<OrderByRowResult<Document>> orderByObservable;
    private final Map<FeedRangeEpkImpl, OrderByContinuationToken> targetRangeToOrderByContinuationTokenMap;

    private OrderByDocumentQueryExecutionContext(DiagnosticsClientContext diagnosticsClientContext, IDocumentQueryClient client, ResourceType resourceTypeEnum, SqlQuerySpec query, CosmosQueryRequestOptions cosmosQueryRequestOptions, String resourceLink, String rewrittenQuery, OrderbyRowComparer<Document> consumeComparer, String collectionRid, UUID correlatedActivityId, boolean hasSelectValue) {
        super(diagnosticsClientContext, client, resourceTypeEnum, Document.class, query, cosmosQueryRequestOptions, resourceLink, rewrittenQuery, correlatedActivityId, hasSelectValue);
        this.collectionRid = collectionRid;
        this.consumeComparer = consumeComparer;
        this.tracker = new RequestChargeTracker();
        this.queryMetricMap = new ConcurrentHashMap<String, QueryMetrics>();
        this.clientSideRequestStatisticsList = Collections.synchronizedList(new ArrayList());
        this.targetRangeToOrderByContinuationTokenMap = new ConcurrentHashMap<FeedRangeEpkImpl, OrderByContinuationToken>();
    }

    public static Flux<IDocumentQueryExecutionComponent<Document>> createAsync(DiagnosticsClientContext diagnosticsClientContext, IDocumentQueryClient client, PipelinedDocumentQueryParams<Document> initParams) {
        QueryInfo queryInfo = initParams.getQueryInfo();
        OrderByDocumentQueryExecutionContext context = new OrderByDocumentQueryExecutionContext(diagnosticsClientContext, client, initParams.getResourceTypeEnum(), initParams.getQuery(), initParams.getCosmosQueryRequestOptions(), initParams.getResourceLink(), initParams.getQueryInfo().getRewrittenQuery(), new OrderbyRowComparer<Document>(queryInfo.getOrderBy()), initParams.getCollectionRid(), initParams.getCorrelatedActivityId(), queryInfo.hasSelectValue());
        context.setTop(initParams.getTop());
        try {
            context.initialize(initParams.getFeedRanges(), initParams.getQueryInfo().getOrderBy(), initParams.getQueryInfo().getOrderByExpressions(), initParams.getInitialPageSize(), ModelBridgeInternal.getRequestContinuationFromQueryRequestOptions(initParams.getCosmosQueryRequestOptions()));
            return Flux.just((Object)context);
        }
        catch (CosmosException dce) {
            return Flux.error((Throwable)((Object)dce));
        }
    }

    private void initialize(List<FeedRangeEpkImpl> feedRanges, List<SortOrder> sortOrders, Collection<String> orderByExpressions, int initialPageSize, String continuationToken) throws CosmosException {
        if (continuationToken == null) {
            HashMap<FeedRangeEpkImpl, String> partitionKeyRangeToContinuationToken = new HashMap<FeedRangeEpkImpl, String>();
            for (FeedRangeEpkImpl feedRangeEpk : feedRanges) {
                partitionKeyRangeToContinuationToken.put(feedRangeEpk, null);
            }
            super.initialize(this.collectionRid, partitionKeyRangeToContinuationToken, initialPageSize, new SqlQuerySpec(this.querySpec.getQueryText().replace(FormatPlaceHolder, True), this.querySpec.getParameters()));
        } else {
            Utils.ValueHolder<OrderByContinuationToken> outOrderByContinuationToken = new Utils.ValueHolder<OrderByContinuationToken>();
            if (!OrderByContinuationToken.tryParse(continuationToken, outOrderByContinuationToken)) {
                String message = String.format("INVALID JSON in continuation token %s for OrderBy~Context", continuationToken);
                throw BridgeInternal.createCosmosException(400, message);
            }
            OrderByContinuationToken orderByContinuationToken = (OrderByContinuationToken)outOrderByContinuationToken.v;
            CompositeContinuationToken compositeContinuationToken = orderByContinuationToken.getCompositeContinuationToken();
            if (compositeContinuationToken.getRange().isEmpty()) {
                String message = String.format("INVALID RANGE in the continuation token %s for OrderBy~Context.", continuationToken);
                throw BridgeInternal.createCosmosException(400, message);
            }
            Pair<Boolean, ResourceId> booleanResourceIdPair = ResourceId.tryParse(orderByContinuationToken.getRid());
            if (!booleanResourceIdPair.getLeft().booleanValue()) {
                throw new BadRequestException(String.format("INVALID Rid in the continuation token %s for OrderBy~Context.", orderByContinuationToken.getCompositeContinuationToken().getToken()));
            }
            FormattedFilterInfo formattedFilterInfo = this.getFormattedFilters(orderByExpressions, orderByContinuationToken.getOrderByItems(), sortOrders, orderByContinuationToken.getInclusive());
            PartitionMapper.PartitionMapping<OrderByContinuationToken> partitionMapping = PartitionMapper.getPartitionMapping(feedRanges, Collections.singletonList(orderByContinuationToken));
            this.initializeWithTokenAndFilter(partitionMapping.getMappingLeftOfTarget(), initialPageSize, formattedFilterInfo.filterForRangesLeftOfTheTargetRange);
            this.initializeWithTokenAndFilter(partitionMapping.getTargetMapping(), initialPageSize, formattedFilterInfo.filterForTargetRange);
            this.initializeWithTokenAndFilter(partitionMapping.getMappingRightOfTarget(), initialPageSize, formattedFilterInfo.filterForRangesRightOfTheTargetRange);
        }
        this.orderByObservable = OrderByUtils.orderedMerge(this.consumeComparer, this.tracker, this.documentProducers, this.queryMetricMap, this.targetRangeToOrderByContinuationTokenMap, this.clientSideRequestStatisticsList);
    }

    private void initializeWithTokenAndFilter(Map<FeedRangeEpkImpl, OrderByContinuationToken> rangeToTokenMapping, int initialPageSize, String filter) {
        for (Map.Entry<FeedRangeEpkImpl, OrderByContinuationToken> entry : rangeToTokenMapping.entrySet()) {
            if (entry.getValue() != null) {
                this.targetRangeToOrderByContinuationTokenMap.put(entry.getKey(), entry.getValue());
            }
            HashMap<FeedRangeEpkImpl, String> partitionKeyRangeToContinuationToken = new HashMap<FeedRangeEpkImpl, String>();
            partitionKeyRangeToContinuationToken.put(entry.getKey(), null);
            super.initialize(this.collectionRid, partitionKeyRangeToContinuationToken, initialPageSize, new SqlQuerySpec(this.querySpec.getQueryText().replace(FormatPlaceHolder, filter), this.querySpec.getParameters()));
        }
    }

    private FormattedFilterInfo getFormattedFilters(Collection<String> orderByExpressionCollection, QueryItem[] orderByItems, Collection<SortOrder> sortOrderCollection, boolean inclusive) {
        SortOrder[] sortOrders = new SortOrder[sortOrderCollection.size()];
        sortOrderCollection.toArray(sortOrders);
        String[] expressions = new String[orderByExpressionCollection.size()];
        orderByExpressionCollection.toArray(expressions);
        if (expressions.length != sortOrders.length) {
            throw new IllegalArgumentException("expressions.size() != sortOrders.size()");
        }
        if (expressions.length != orderByItems.length) {
            throw new IllegalArgumentException("expressions.size() != orderByItems.length");
        }
        int numOrderByItems = expressions.length;
        boolean isSingleOrderBy = numOrderByItems == 1;
        StringBuilder left = new StringBuilder();
        StringBuilder target = new StringBuilder();
        StringBuilder right = new StringBuilder();
        if (isSingleOrderBy) {
            String expression = expressions[0];
            SortOrder sortOrder = sortOrders[0];
            QueryItem orderByItem = orderByItems[0];
            Object rawItem = orderByItem.getItem();
            this.appendToBuilders(left, target, right, "(");
            String orderByItemToString = this.getOrderByItemString(rawItem);
            ComparisonFilters filters = rawItem == Undefined.value() ? new ComparisonWithUndefinedFilters(expression) : new ComparisonWithDefinedFilters(expression, orderByItemToString);
            left.append(sortOrder == SortOrder.Descending ? filters.lessThan() : filters.greaterThan());
            if (inclusive) {
                target.append(sortOrder == SortOrder.Descending ? filters.lessThanOrEqualTo() : filters.greaterThanOrEqualTo());
            } else {
                target.append(sortOrder == SortOrder.Descending ? filters.lessThan() : filters.greaterThan());
            }
            right.append(sortOrder == SortOrder.Descending ? filters.lessThanOrEqualTo() : filters.greaterThanOrEqualTo());
            List<String> definedFunctions = IsSystemFunctions.getIsDefinedFunctions(ItemTypeHelper.getOrderByItemType(rawItem), sortOrder == SortOrder.Ascending);
            StringBuilder isDefinedFuncBuilder = new StringBuilder();
            for (String idf : definedFunctions) {
                isDefinedFuncBuilder.append(" OR ");
                isDefinedFuncBuilder.append(String.format("%s(%s)", idf, expression));
            }
            String isDefinedFunctions = isDefinedFuncBuilder.toString();
            left.append(isDefinedFunctions);
            target.append(isDefinedFunctions);
            right.append(isDefinedFunctions);
            this.appendToBuilders(left, target, right, ")");
        } else {
            for (int prefixLength = 1; prefixLength <= numOrderByItems; ++prefixLength) {
                boolean lastPrefix = prefixLength == numOrderByItems;
                this.appendToBuilders(left, target, right, "(");
                for (int index = 0; index < prefixLength; ++index) {
                    ComparisonFilters filters;
                    String expression = expressions[index];
                    SortOrder sortOrder = sortOrders[index];
                    QueryItem orderbyItem = orderByItems[index];
                    Object orderbyRawItem = orderbyItem.getItem();
                    boolean lastItem = index == prefixLength - 1;
                    this.appendToBuilders(left, target, right, "(");
                    String orderByItemToString = this.getOrderByItemString(orderbyRawItem);
                    ComparisonFilters comparisonFilters = filters = orderbyRawItem == Undefined.value() ? new ComparisonWithUndefinedFilters(expression) : new ComparisonWithDefinedFilters(expression, orderByItemToString);
                    if (lastItem) {
                        if (lastPrefix) {
                            left.append(sortOrder == SortOrder.Descending ? filters.lessThan() : filters.greaterThan());
                            if (inclusive) {
                                target.append(sortOrder == SortOrder.Descending ? filters.lessThanOrEqualTo() : filters.greaterThanOrEqualTo());
                            } else {
                                target.append(sortOrder == SortOrder.Descending ? filters.lessThan() : filters.greaterThan());
                            }
                            right.append(sortOrder == SortOrder.Descending ? filters.lessThanOrEqualTo() : filters.greaterThanOrEqualTo());
                        } else {
                            left.append(sortOrder == SortOrder.Descending ? filters.lessThan() : filters.greaterThan());
                            target.append(sortOrder == SortOrder.Descending ? filters.lessThan() : filters.greaterThan());
                            right.append(sortOrder == SortOrder.Descending ? filters.lessThan() : filters.greaterThan());
                        }
                    } else {
                        left.append(filters.equalTo());
                        target.append(filters.equalTo());
                        right.append(filters.equalTo());
                    }
                    if (lastItem) {
                        List<String> definedFunctions = IsSystemFunctions.getIsDefinedFunctions(ItemTypeHelper.getOrderByItemType(orderbyRawItem), sortOrder == SortOrder.Ascending);
                        StringBuilder isDefinedFuncBuilder = new StringBuilder();
                        for (String idf : definedFunctions) {
                            isDefinedFuncBuilder.append(" OR ");
                            isDefinedFuncBuilder.append(String.format("%s(%s)", idf, expression));
                        }
                        String isDefinedFunctions = isDefinedFuncBuilder.toString();
                        left.append(isDefinedFunctions);
                        target.append(isDefinedFunctions);
                        right.append(isDefinedFunctions);
                    }
                    this.appendToBuilders(left, target, right, ")");
                    if (lastItem) continue;
                    this.appendToBuilders(left, target, right, " AND ");
                }
                this.appendToBuilders(left, target, right, ")");
                if (lastPrefix) continue;
                this.appendToBuilders(left, target, right, " OR ");
            }
        }
        return new FormattedFilterInfo(left.toString(), target.toString(), right.toString());
    }

    private String getOrderByItemString(Object orderbyRawItem) {
        String orderByItemToString = orderbyRawItem instanceof String ? "\"" + QUOTE_PATTERN.matcher(orderbyRawItem.toString()).replaceAll("\\\"") + "\"" : (orderbyRawItem != null ? orderbyRawItem.toString() : "null");
        return orderByItemToString;
    }

    private void appendToBuilders(StringBuilder leftBuilder, StringBuilder targetBuilder, StringBuilder rightBuilder, String appendText) {
        this.appendToBuilders(leftBuilder, targetBuilder, rightBuilder, appendText, appendText, appendText);
    }

    private void appendToBuilders(StringBuilder leftBuilder, StringBuilder targetBuilder, StringBuilder rightBuilder, String leftAppendText, String targetAppendText, String rightAppendText) {
        leftBuilder.append(leftAppendText);
        targetBuilder.append(targetAppendText);
        rightBuilder.append(rightAppendText);
    }

    protected OrderByDocumentProducer createDocumentProducer(String collectionRid, PartitionKeyRange targetRange, String continuationToken, int initialPageSize, CosmosQueryRequestOptions cosmosQueryRequestOptions, SqlQuerySpec querySpecForInit, Map<String, String> commonRequestHeaders, TriFunction<FeedRangeEpkImpl, String, Integer, RxDocumentServiceRequest> createRequestFunc, Function<RxDocumentServiceRequest, Mono<FeedResponse<Document>>> executeFunc, Callable<DocumentClientRetryPolicy> createRetryPolicyFunc, FeedRangeEpkImpl feedRange) {
        return new OrderByDocumentProducer(this.consumeComparer, this.client, collectionRid, cosmosQueryRequestOptions, createRequestFunc, executeFunc, targetRange, feedRange, collectionRid, createRetryPolicyFunc, this.resourceType, this.correlatedActivityId, initialPageSize, continuationToken, this.top, this.targetRangeToOrderByContinuationTokenMap);
    }

    @Override
    public Flux<FeedResponse<Document>> drainAsync(int maxPageSize) {
        return this.orderByObservable.transformDeferred((Function)new ItemToPageTransformer(this.tracker, maxPageSize, this.queryMetricMap, this::getContinuationToken, this.clientSideRequestStatisticsList));
    }

    @Override
    public Flux<FeedResponse<Document>> executeAsync() {
        return this.drainAsync(ModelBridgeInternal.getMaxItemCountFromQueryRequestOptions(this.cosmosQueryRequestOptions));
    }

    private String getContinuationToken(OrderByRowResult<Document> orderByRowResult) {
        String rid = orderByRowResult.getResourceId();
        String backendContinuationToken = orderByRowResult.getSourceBackendContinuationToken();
        Range<String> range = orderByRowResult.getSourceRange().getRange();
        boolean inclusive = true;
        CompositeContinuationToken compositeContinuationToken = new CompositeContinuationToken(backendContinuationToken, range);
        QueryItem[] orderByItems = new QueryItem[orderByRowResult.getOrderByItems().size()];
        orderByRowResult.getOrderByItems().toArray(orderByItems);
        return new OrderByContinuationToken(compositeContinuationToken, orderByItems, rid, inclusive).toJson();
    }

    private static final class FormattedFilterInfo {
        private final String filterForRangesLeftOfTheTargetRange;
        private final String filterForTargetRange;
        private final String filterForRangesRightOfTheTargetRange;

        public FormattedFilterInfo(String filterForRangesLeftOfTheTargetRange, String filterForTargetRange, String filterForRangesRightOfTheTargetRange) {
            if (filterForRangesLeftOfTheTargetRange == null) {
                throw new IllegalArgumentException("filterForRangesLeftOfTheTargetRange must not be null.");
            }
            if (filterForTargetRange == null) {
                throw new IllegalArgumentException("filterForTargetRange must not be null.");
            }
            if (filterForRangesRightOfTheTargetRange == null) {
                throw new IllegalArgumentException("filterForRangesRightOfTheTargetRange must not be null.");
            }
            this.filterForRangesLeftOfTheTargetRange = filterForRangesLeftOfTheTargetRange;
            this.filterForTargetRange = filterForTargetRange;
            this.filterForRangesRightOfTheTargetRange = filterForRangesRightOfTheTargetRange;
        }

        public String getFilterForRangesLeftOfTheTargetRange() {
            return this.filterForRangesLeftOfTheTargetRange;
        }

        public String getFilterForTargetRange() {
            return this.filterForTargetRange;
        }

        public String getFilterForRangesRightOfTheTargetRange() {
            return this.filterForRangesRightOfTheTargetRange;
        }
    }

    private static class ItemToPageTransformer
    implements Function<Flux<OrderByRowResult<Document>>, Flux<FeedResponse<Document>>> {
        private static final int DEFAULT_PAGE_SIZE = 100;
        private final RequestChargeTracker tracker;
        private final int maxPageSize;
        private final ConcurrentMap<String, QueryMetrics> queryMetricMap;
        private final Function<OrderByRowResult<Document>, String> orderByContinuationTokenCallback;
        private final List<ClientSideRequestStatistics> clientSideRequestStatisticsList;
        private volatile FeedResponse<OrderByRowResult<Document>> previousPage;

        public ItemToPageTransformer(RequestChargeTracker tracker, int maxPageSize, ConcurrentMap<String, QueryMetrics> queryMetricsMap, Function<OrderByRowResult<Document>, String> orderByContinuationTokenCallback, List<ClientSideRequestStatistics> clientSideRequestStatisticsList) {
            this.tracker = tracker;
            this.maxPageSize = maxPageSize > 0 ? maxPageSize : 100;
            this.queryMetricMap = queryMetricsMap;
            this.orderByContinuationTokenCallback = orderByContinuationTokenCallback;
            this.previousPage = null;
            this.clientSideRequestStatisticsList = clientSideRequestStatisticsList;
        }

        private static Map<String, String> headerResponse(double requestCharge) {
            return Utils.immutableMapOf("x-ms-request-charge", String.valueOf(requestCharge));
        }

        private FeedResponse<OrderByRowResult<Document>> addOrderByContinuationToken(FeedResponse<OrderByRowResult<Document>> page, String orderByContinuationToken) {
            HashMap<String, String> headers = new HashMap<String, String>(page.getResponseHeaders());
            headers.put("x-ms-continuation", orderByContinuationToken);
            return BridgeInternal.createFeedResponseWithQueryMetrics(page.getResults(), headers, BridgeInternal.queryMetricsFromFeedResponse(page), ModelBridgeInternal.getQueryPlanDiagnosticsContext(page), false, false, page.getCosmosDiagnostics());
        }

        @Override
        public Flux<FeedResponse<Document>> apply(Flux<OrderByRowResult<Document>> source) {
            return source.window(this.maxPageSize).map(Flux::collectList).flatMap(resultListObs -> resultListObs, 1).map(orderByRowResults -> {
                FeedResponse feedResponse = BridgeInternal.createFeedResponse(orderByRowResults, ItemToPageTransformer.headerResponse(this.tracker.getAndResetCharge()));
                if (!this.queryMetricMap.isEmpty()) {
                    for (Map.Entry entry : this.queryMetricMap.entrySet()) {
                        BridgeInternal.putQueryMetricsIntoMap(feedResponse, (String)entry.getKey(), (QueryMetrics)entry.getValue());
                    }
                }
                return feedResponse;
            }).concatWith((Publisher)Flux.defer(() -> Flux.just(BridgeInternal.createFeedResponse(Utils.immutableListOf(), null)))).map(orderByRowResults -> {
                ImmutablePair<FeedResponse<OrderByRowResult<Document>>, FeedResponse> previousCurrent = new ImmutablePair<FeedResponse<OrderByRowResult<Document>>, FeedResponse>(this.previousPage, (FeedResponse)orderByRowResults);
                this.previousPage = orderByRowResults;
                return previousCurrent;
            }).skip(1L).map(currentNext -> {
                FeedResponse<OrderByRowResult<Document>> page;
                FeedResponse<OrderByRowResult<Document>> current = (FeedResponse<OrderByRowResult<Document>>)currentNext.left;
                FeedResponse next = (FeedResponse)currentNext.right;
                if (next.getResults().size() == 0) {
                    page = current;
                    page = this.addOrderByContinuationToken(page, null);
                } else {
                    page = current;
                    List results = next.getResults();
                    OrderByRowResult firstElementInNextPage = (OrderByRowResult)results.get(0);
                    String orderByContinuationToken = this.orderByContinuationTokenCallback.apply(firstElementInNextPage);
                    page = this.addOrderByContinuationToken(page, orderByContinuationToken);
                }
                return page;
            }).map(feedOfOrderByRowResults -> {
                ArrayList<Document> unwrappedResults = new ArrayList<Document>();
                for (OrderByRowResult orderByRowResult : feedOfOrderByRowResults.getResults()) {
                    unwrappedResults.add(orderByRowResult.getPayload());
                }
                FeedResponse feedResponse = BridgeInternal.createFeedResponseWithQueryMetrics(unwrappedResults, feedOfOrderByRowResults.getResponseHeaders(), BridgeInternal.queryMetricsFromFeedResponse(feedOfOrderByRowResults), ModelBridgeInternal.getQueryPlanDiagnosticsContext(feedOfOrderByRowResults), false, false, feedOfOrderByRowResults.getCosmosDiagnostics());
                BridgeInternal.addClientSideDiagnosticsToFeed(feedResponse.getCosmosDiagnostics(), this.clientSideRequestStatisticsList);
                return feedResponse;
            }).switchIfEmpty((Publisher)Flux.defer(() -> {
                FeedResponse frp = BridgeInternal.createFeedResponseWithQueryMetrics(Utils.immutableListOf(), ItemToPageTransformer.headerResponse(this.tracker.getAndResetCharge()), this.queryMetricMap, null, false, false, null);
                BridgeInternal.addClientSideDiagnosticsToFeed(frp.getCosmosDiagnostics(), this.clientSideRequestStatisticsList);
                return Flux.just(frp);
            }));
        }
    }

    static class IsSystemFunctions {
        static final String Defined = "IS_DEFINED";
        static final String NotDefined = "NOT IS_DEFINED";
        static final String Null = "IS_NULL";
        static final String Boolean = "IS_BOOLEAN";
        static final String Number = "IS_NUMBER";
        static final String IsString = "IS_STRING";
        static final String Array = "IS_ARRAY";
        static final String Object = "IS_OBJECT";
        static final List<String> systemFunctionSortOrder = Arrays.asList("NOT IS_DEFINED", "IS_NULL", "IS_BOOLEAN", "IS_NUMBER", "IS_STRING", "IS_ARRAY", "IS_OBJECT");
        final List<String> extendedTypesSystemFunctionSortOrder = Arrays.asList("NOT IS_DEFINED", "IS_DEFINED");

        IsSystemFunctions() {
        }

        public static List<String> getIsDefinedFunctions(ItemType itemtype, boolean isAscending) {
            switch (itemtype) {
                case NoValue: {
                    return IsSystemFunctions.getIsDefinedFunctionsInternal(0, isAscending);
                }
                case Null: {
                    return IsSystemFunctions.getIsDefinedFunctionsInternal(1, isAscending);
                }
                case Boolean: {
                    return IsSystemFunctions.getIsDefinedFunctionsInternal(2, isAscending);
                }
                case Number: {
                    return IsSystemFunctions.getIsDefinedFunctionsInternal(3, isAscending);
                }
                case String: {
                    return IsSystemFunctions.getIsDefinedFunctionsInternal(4, isAscending);
                }
                case ArrayNode: {
                    return IsSystemFunctions.getIsDefinedFunctionsInternal(5, isAscending);
                }
                case ObjectNode: {
                    return IsSystemFunctions.getIsDefinedFunctionsInternal(6, isAscending);
                }
            }
            return null;
        }

        private static List<String> getIsDefinedFunctionsInternal(int index, boolean isAscending) {
            return isAscending ? systemFunctionSortOrder.subList(index + 1, systemFunctionSortOrder.size()) : systemFunctionSortOrder.subList(0, index);
        }

        List<String> getExtendedTypesIsDefinedFunctions(int index, boolean isAscending) {
            return isAscending ? this.extendedTypesSystemFunctionSortOrder.subList(index + 1, this.extendedTypesSystemFunctionSortOrder.size()) : this.extendedTypesSystemFunctionSortOrder.subList(0, index);
        }

        private static class ExtendedTypesSortOrder {
            public static final int Undefined = 0;
            public static final int Defined = 1;

            private ExtendedTypesSortOrder() {
            }
        }

        private static class SortOrder {
            public static final int Undefined = 0;
            public static final int Null = 1;
            public static final int Boolean = 2;
            public static final int Number = 3;
            public static final int String = 4;
            public static final int Array = 5;
            public static final int Object = 6;

            private SortOrder() {
            }
        }
    }
}

