/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.util.Beta;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Duration;

@Beta(value=Beta.SinceVersion.V4_12_0, warningText="Preview API - subject to change in non-backwards compatible way")
public final class ChangeFeedPolicy {
    private final JsonSerializable jsonSerializable;

    @Beta(value=Beta.SinceVersion.V4_12_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static ChangeFeedPolicy createFullFidelityPolicy(Duration retentionDuration) {
        if (retentionDuration.isNegative() || retentionDuration.isZero() || retentionDuration.getNano() != 0 || retentionDuration.getSeconds() % 60L != 0L) {
            throw new IllegalArgumentException("Argument retentionDuration must be a duration of a positive number of minutes.");
        }
        ChangeFeedPolicy policy = new ChangeFeedPolicy();
        policy.setFullFidelityRetentionDurationInMinutes((int)(retentionDuration.getSeconds() / 60L));
        return policy;
    }

    @Beta(value=Beta.SinceVersion.V4_12_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static ChangeFeedPolicy createIncrementalPolicy() {
        ChangeFeedPolicy policy = new ChangeFeedPolicy();
        policy.setFullFidelityRetentionDurationInMinutes(null);
        return policy;
    }

    ChangeFeedPolicy() {
        this.jsonSerializable = new JsonSerializable();
    }

    ChangeFeedPolicy(String jsonString) {
        this.jsonSerializable = new JsonSerializable(jsonString);
    }

    ChangeFeedPolicy(ObjectNode objectNode) {
        this.jsonSerializable = new JsonSerializable(objectNode);
    }

    @Beta(value=Beta.SinceVersion.V4_12_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public Duration getFullFidelityRetentionDuration() {
        return Duration.ofMinutes(this.getFullFidelityRetentionDurationInMinutes());
    }

    int getFullFidelityRetentionDurationInMinutes() {
        Integer intValue = this.jsonSerializable.getInt("retentionDuration");
        if (intValue == null || intValue < 0) {
            return 0;
        }
        return intValue;
    }

    ChangeFeedPolicy setFullFidelityRetentionDurationInMinutes(Integer retentionDurationInMinutes) {
        if (retentionDurationInMinutes == null || retentionDurationInMinutes <= 0) {
            this.jsonSerializable.set("retentionDuration", 0);
        } else {
            this.jsonSerializable.set("retentionDuration", retentionDurationInMinutes);
        }
        return this;
    }

    void populatePropertyBag() {
        this.jsonSerializable.populatePropertyBag();
    }

    JsonSerializable getJsonSerializable() {
        return this.jsonSerializable;
    }
}

