/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosAsyncClientEncryptionKey;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.CosmosClient;
import com.azure.cosmos.CosmosClientBuilder;
import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.DirectConnectionConfig;
import com.azure.cosmos.implementation.ApiType;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.ConnectionPolicy;
import com.azure.cosmos.implementation.CosmosClientMetadataCachesSnapshot;
import com.azure.cosmos.implementation.CosmosPagedFluxOptions;
import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.implementation.FeedResponseDiagnostics;
import com.azure.cosmos.implementation.ItemDeserializer;
import com.azure.cosmos.implementation.RequestOptions;
import com.azure.cosmos.implementation.ResourceResponse;
import com.azure.cosmos.implementation.batch.ItemBatchOperation;
import com.azure.cosmos.implementation.batch.PartitionScopeThresholds;
import com.azure.cosmos.implementation.patch.PatchOperation;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.implementation.spark.OperationContextAndListenerTuple;
import com.azure.cosmos.models.CosmosBatch;
import com.azure.cosmos.models.CosmosBatchOperationResult;
import com.azure.cosmos.models.CosmosBatchRequestOptions;
import com.azure.cosmos.models.CosmosBatchResponse;
import com.azure.cosmos.models.CosmosBulkExecutionOptions;
import com.azure.cosmos.models.CosmosBulkExecutionThresholdsState;
import com.azure.cosmos.models.CosmosBulkItemResponse;
import com.azure.cosmos.models.CosmosChangeFeedRequestOptions;
import com.azure.cosmos.models.CosmosClientEncryptionKeyResponse;
import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.CosmosItemRequestOptions;
import com.azure.cosmos.models.CosmosItemResponse;
import com.azure.cosmos.models.CosmosPatchOperations;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.util.CosmosPagedFlux;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ImplementationBridgeHelpers {
    private static final Logger logger = LoggerFactory.getLogger(ImplementationBridgeHelpers.class);

    private static <T> void ensureClassLoaded(Class<T> classType) {
        try {
            Class.forName(classType.getName());
        }
        catch (ClassNotFoundException e) {
            logger.error("cannot load class {}", (Object)classType.getName());
            throw new RuntimeException(e);
        }
    }

    public static final class CosmosExceptionHelper {
        private static CosmosExceptionAccessor accessor;

        private CosmosExceptionHelper() {
        }

        public static CosmosExceptionAccessor getCosmosExceptionAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("CosmosExceptionAccessor is not initialized yet!");
            }
            return accessor;
        }

        public static void setCosmosExceptionAccessor(CosmosExceptionAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("CosmosExceptionAccessor already initialized!");
            }
            accessor = newAccessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(CosmosException.class);
        }

        public static interface CosmosExceptionAccessor {
            public CosmosException createCosmosException(int var1, Exception var2);

            public CosmosException createSerializableCosmosException(CosmosException var1);
        }
    }

    public static final class CosmosAsyncClientEncryptionKeyHelper {
        private static CosmosAsyncClientEncryptionKeyAccessor accessor;

        private CosmosAsyncClientEncryptionKeyHelper() {
        }

        public static CosmosAsyncClientEncryptionKeyAccessor getCosmosAsyncClientEncryptionKeyAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("CosmosAsyncClientEncryptionKeyAccessor is not initialized yet!");
            }
            return accessor;
        }

        public static void setCosmosAsyncClientEncryptionKeyAccessor(CosmosAsyncClientEncryptionKeyAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("CosmosAsyncClientEncryptionKeyAccessor already initialized!");
            }
            accessor = newAccessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(CosmosAsyncClientEncryptionKey.class);
        }

        public static interface CosmosAsyncClientEncryptionKeyAccessor {
            public Mono<CosmosClientEncryptionKeyResponse> readClientEncryptionKey(CosmosAsyncClientEncryptionKey var1, RequestOptions var2);
        }
    }

    public static final class CosmosBatchResponseHelper {
        private static CosmosBatchResponseAccessor accessor;

        private CosmosBatchResponseHelper() {
        }

        public static CosmosBatchResponseAccessor getCosmosBatchResponseAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("CosmosBatchResponseAccessor is not initialized yet!");
            }
            return accessor;
        }

        public static void setCosmosBatchResponseAccessor(CosmosBatchResponseAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("CosmosBatchResponseAccessor already initialized!");
            }
            accessor = newAccessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(CosmosBatchResponse.class);
        }

        public static interface CosmosBatchResponseAccessor {
            public List<CosmosBatchOperationResult> getResults(CosmosBatchResponse var1);
        }
    }

    public static final class CosmosBulkItemResponseHelper {
        private static CosmosBulkItemResponseAccessor accessor;

        private CosmosBulkItemResponseHelper() {
        }

        public static CosmosBulkItemResponseAccessor getCosmosBulkItemResponseAccessor() {
            return accessor;
        }

        public static void setCosmosBulkItemResponseAccessor(CosmosBulkItemResponseAccessor accessor) {
            CosmosBulkItemResponseHelper.accessor = accessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(CosmosBulkItemResponse.class);
        }

        public static interface CosmosBulkItemResponseAccessor {
            public ObjectNode getResourceObject(CosmosBulkItemResponse var1);

            public void setResourceObject(CosmosBulkItemResponse var1, ObjectNode var2);
        }
    }

    public static final class CosmosBatchHelper {
        private static CosmosBatchAccessor accessor;

        private CosmosBatchHelper() {
        }

        public static CosmosBatchAccessor getCosmosBatchAccessor() {
            return accessor;
        }

        public static void setCosmosBatchAccessor(CosmosBatchAccessor accessor) {
            CosmosBatchHelper.accessor = accessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(CosmosBatch.class);
        }

        public static interface CosmosBatchAccessor {
            public List<ItemBatchOperation<?>> getOperationsInternal(CosmosBatch var1);
        }
    }

    public static final class CosmosPatchOperationsHelper {
        private static CosmosPatchOperationsAccessor accessor;

        private CosmosPatchOperationsHelper() {
        }

        public static CosmosPatchOperationsAccessor getCosmosPatchOperationsAccessor() {
            return accessor;
        }

        public static void setCosmosPatchOperationsAccessor(CosmosPatchOperationsAccessor accessor) {
            CosmosPatchOperationsHelper.accessor = accessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(CosmosPatchOperations.class);
        }

        public static interface CosmosPatchOperationsAccessor {
            public List<PatchOperation> getPatchOperations(CosmosPatchOperations var1);
        }
    }

    public static final class CosmosBatchOperationResultHelper {
        private static CosmosBatchOperationResultAccessor accessor;

        private CosmosBatchOperationResultHelper() {
        }

        public static CosmosBatchOperationResultAccessor getCosmosBatchOperationResultAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("CosmosBatchOperationResultAccessor is not initialized yet!");
            }
            return accessor;
        }

        public static void setCosmosBatchOperationResultAccessor(CosmosBatchOperationResultAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("CosmosBatchOperationResultAccessor already initialized!");
            }
            accessor = newAccessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(CosmosBatchOperationResult.class);
        }

        public static interface CosmosBatchOperationResultAccessor {
            public ObjectNode getResourceObject(CosmosBatchOperationResult var1);

            public void setResourceObject(CosmosBatchOperationResult var1, ObjectNode var2);
        }
    }

    public static final class CosmosBatchRequestOptionsHelper {
        private static CosmosBatchRequestOptionsAccessor accessor;

        private CosmosBatchRequestOptionsHelper() {
        }

        public static CosmosBatchRequestOptionsAccessor getCosmosBatchRequestOptionsAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("CosmosBatchRequestOptionsAccessor is not initialized yet!");
            }
            return accessor;
        }

        public static void setCosmosBatchRequestOptionsAccessor(CosmosBatchRequestOptionsAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("CosmosBatchRequestOptionsAccessor already initialized!");
            }
            accessor = newAccessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(CosmosBatchRequestOptions.class);
        }

        public static interface CosmosBatchRequestOptionsAccessor {
            public ConsistencyLevel getConsistencyLevel(CosmosBatchRequestOptions var1);

            public CosmosBatchRequestOptions setConsistencyLevel(CosmosBatchRequestOptions var1, ConsistencyLevel var2);

            public CosmosBatchRequestOptions setHeader(CosmosBatchRequestOptions var1, String var2, String var3);

            public Map<String, String> getHeader(CosmosBatchRequestOptions var1);
        }
    }

    public static final class FeedResponseHelper {
        private static FeedResponseAccessor accessor;

        private FeedResponseHelper() {
        }

        public static void setFeedResponseAccessor(FeedResponseAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("FeedResponseAccessor already initialized!");
            }
            accessor = newAccessor;
        }

        public static FeedResponseAccessor getFeedResponseAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("FeedResponseAccessor is not initialized yet!");
            }
            return accessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(FeedResponse.class);
        }

        public static interface FeedResponseAccessor {
            public <T> boolean getNoChanges(FeedResponse<T> var1);

            public <TNew, T> FeedResponse<TNew> convertGenericType(FeedResponse<T> var1, Function<T, TNew> var2);
        }
    }

    public static final class CosmosAsyncContainerHelper {
        private static CosmosAsyncContainerAccessor accessor;

        private CosmosAsyncContainerHelper() {
        }

        public static void setCosmosAsyncContainerAccessor(CosmosAsyncContainerAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("CosmosAsyncContainerAccessor already initialized!");
            }
            accessor = newAccessor;
        }

        public static CosmosAsyncContainerAccessor getCosmosAsyncContainerAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("CosmosAsyncContainerAccessor is not initialized yet!");
            }
            return accessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(CosmosAsyncContainer.class);
        }

        public static interface CosmosAsyncContainerAccessor {
            public <T> Function<CosmosPagedFluxOptions, Flux<FeedResponse<T>>> queryChangeFeedInternalFunc(CosmosAsyncContainer var1, CosmosChangeFeedRequestOptions var2, Class<T> var3);
        }
    }

    public static final class CosmosDiagnosticsHelper {
        private static CosmosDiagnosticsAccessor accessor;

        private CosmosDiagnosticsHelper() {
        }

        public static void setCosmosDiagnosticsAccessor(CosmosDiagnosticsAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("CosmosDiagnosticsAccessor already initialized!");
            }
            accessor = newAccessor;
        }

        public static CosmosDiagnosticsAccessor getCosmosDiagnosticsAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("CosmosDiagnosticsAccessor is not initialized yet!");
            }
            return accessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(CosmosDiagnostics.class);
        }

        public static interface CosmosDiagnosticsAccessor {
            public FeedResponseDiagnostics getFeedResponseDiagnostics(CosmosDiagnostics var1);

            public AtomicBoolean isDiagnosticsCapturedInPagedFlux(CosmosDiagnostics var1);
        }
    }

    public static final class CosmosBulkExecutionThresholdsStateHelper {
        private static CosmosBulkExecutionThresholdsStateAccessor accessor;

        private CosmosBulkExecutionThresholdsStateHelper() {
        }

        public static void setBulkExecutionThresholdsAccessor(CosmosBulkExecutionThresholdsStateAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("BulkExecutionThresholds accessor already initialized!");
            }
            accessor = newAccessor;
        }

        public static CosmosBulkExecutionThresholdsStateAccessor getBulkExecutionThresholdsAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("BulkExecutionThresholds accessor is not initialized yet!");
            }
            return accessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(CosmosBulkExecutionThresholdsState.class);
        }

        public static interface CosmosBulkExecutionThresholdsStateAccessor {
            public ConcurrentMap<String, PartitionScopeThresholds> getPartitionScopeThresholds(CosmosBulkExecutionThresholdsState var1);

            public CosmosBulkExecutionThresholdsState createWithPartitionScopeThresholds(ConcurrentMap<String, PartitionScopeThresholds> var1);
        }
    }

    public static final class CosmosAsyncDatabaseHelper {
        private static CosmosAsyncDatabaseAccessor accessor;

        private CosmosAsyncDatabaseHelper() {
        }

        public static <T> void setCosmosAsyncDatabaseAccessor(CosmosAsyncDatabaseAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("CosmosAsyncDatabaseAccessor already initialized!");
            }
            accessor = newAccessor;
        }

        public static <T> CosmosAsyncDatabaseAccessor getCosmosAsyncDatabaseAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("CosmosAsyncDatabaseAccessor is not initialized yet!");
            }
            return accessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(CosmosAsyncDatabase.class);
        }

        public static interface CosmosAsyncDatabaseAccessor {
            public CosmosAsyncClient getCosmosAsyncClient(CosmosAsyncDatabase var1);

            public String getLink(CosmosAsyncDatabase var1);
        }
    }

    public static final class CosmosPageFluxHelper {
        private static CosmosPageFluxAccessor accessor;

        private CosmosPageFluxHelper() {
        }

        public static <T> void setCosmosPageFluxAccessor(CosmosPageFluxAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("CosmosPageFluxAccessor already initialized!");
            }
            accessor = newAccessor;
        }

        public static <T> CosmosPageFluxAccessor getCosmosPageFluxAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("CosmosPageFluxAccessor is not initialized yet!");
            }
            return accessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(CosmosContainerProperties.class);
        }

        public static interface CosmosPageFluxAccessor {
            public <T> CosmosPagedFlux<T> getCosmosPagedFlux(Function<CosmosPagedFluxOptions, Flux<FeedResponse<T>>> var1);
        }
    }

    public static final class CosmosContainerPropertiesHelper {
        private static CosmosContainerPropertiesAccessor accessor;

        private CosmosContainerPropertiesHelper() {
        }

        public static void setCosmosContainerPropertiesAccessor(CosmosContainerPropertiesAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("CosmosContainerProperties already initialized!");
            }
            accessor = newAccessor;
        }

        public static CosmosContainerPropertiesAccessor getCosmosContainerPropertiesAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("CosmosContainerProperties is not initialized yet!");
            }
            return accessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(CosmosContainerProperties.class);
        }

        public static interface CosmosContainerPropertiesAccessor {
            public String getSelfLink(CosmosContainerProperties var1);

            public void setSelfLink(CosmosContainerProperties var1, String var2);
        }
    }

    public static final class CosmosClientHelper {
        private static CosmosClientAccessor accessor;

        private CosmosClientHelper() {
        }

        public static void setCosmosClientAccessor(CosmosClientAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("CosmosClient accessor already initialized!");
            }
            accessor = newAccessor;
        }

        public static CosmosClientAccessor geCosmosClientAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("CosmosClient accessor is not initialized yet!");
            }
            return accessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(CosmosClient.class);
        }

        public static interface CosmosClientAccessor {
            public CosmosAsyncClient getCosmosAsyncClient(CosmosClient var1);
        }
    }

    public static final class CosmosItemResponseHelper {
        private static CosmosItemResponseBuilderAccessor accessor;

        private CosmosItemResponseHelper() {
        }

        public static void setCosmosItemResponseBuilderAccessor(CosmosItemResponseBuilderAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("CosmosItemResponse accessor already initialized!");
            }
            accessor = newAccessor;
        }

        public static CosmosItemResponseBuilderAccessor getCosmosItemResponseBuilderAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("CosmosItemResponse accessor is not initialized yet!");
            }
            return accessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(CosmosItemResponse.class);
        }

        public static interface CosmosItemResponseBuilderAccessor {
            public <T> CosmosItemResponse<T> createCosmosItemResponse(ResourceResponse<Document> var1, byte[] var2, Class<T> var3, ItemDeserializer var4);

            public byte[] getByteArrayContent(CosmosItemResponse<byte[]> var1);

            public void setByteArrayContent(CosmosItemResponse<byte[]> var1, byte[] var2);

            public ResourceResponse<Document> getResourceResponse(CosmosItemResponse<byte[]> var1);
        }
    }

    public static final class CosmosBulkExecutionOptionsHelper {
        private static CosmosBulkExecutionOptionsAccessor accessor;

        private CosmosBulkExecutionOptionsHelper() {
        }

        public static void setCosmosBulkExecutionOptionsAccessor(CosmosBulkExecutionOptionsAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("CosmosBulkExecutionOptions accessor already initialized!");
            }
            accessor = newAccessor;
        }

        public static CosmosBulkExecutionOptionsAccessor getCosmosBulkExecutionOptionsAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("CosmosBulkExecutionOptions accessor is not initialized yet!");
            }
            return accessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(CosmosBulkExecutionOptions.class);
        }

        public static interface CosmosBulkExecutionOptionsAccessor {
            public void setOperationContext(CosmosBulkExecutionOptions var1, OperationContextAndListenerTuple var2);

            public OperationContextAndListenerTuple getOperationContext(CosmosBulkExecutionOptions var1);

            public <T> T getLegacyBatchScopedContext(CosmosBulkExecutionOptions var1);

            public double getMinTargetedMicroBatchRetryRate(CosmosBulkExecutionOptions var1);

            public double getMaxTargetedMicroBatchRetryRate(CosmosBulkExecutionOptions var1);

            public CosmosBulkExecutionOptions setTargetedMicroBatchRetryRate(CosmosBulkExecutionOptions var1, double var2, double var4);

            public int getMaxMicroBatchSize(CosmosBulkExecutionOptions var1);

            public CosmosBulkExecutionOptions setMaxMicroBatchSize(CosmosBulkExecutionOptions var1, int var2);

            public int getMaxMicroBatchConcurrency(CosmosBulkExecutionOptions var1);

            public Integer getMaxConcurrentCosmosPartitions(CosmosBulkExecutionOptions var1);

            public CosmosBulkExecutionOptions setMaxConcurrentCosmosPartitions(CosmosBulkExecutionOptions var1, int var2);

            public Duration getMaxMicroBatchInterval(CosmosBulkExecutionOptions var1);

            public CosmosBulkExecutionOptions setHeader(CosmosBulkExecutionOptions var1, String var2, String var3);

            public Map<String, String> getHeader(CosmosBulkExecutionOptions var1);

            public Map<String, String> getCustomOptions(CosmosBulkExecutionOptions var1);
        }
    }

    public static final class CosmosItemRequestOptionsHelper {
        private static CosmosItemRequestOptionsAccessor accessor;

        private CosmosItemRequestOptionsHelper() {
        }

        public static void setCosmosItemRequestOptionsAccessor(CosmosItemRequestOptionsAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("CosmosItemRequestOptions accessor already initialized!");
            }
            accessor = newAccessor;
        }

        public static CosmosItemRequestOptionsAccessor getCosmosItemRequestOptionsAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("CosmosItemRequestOptions accessor is not initialized yet!");
            }
            return accessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(CosmosItemRequestOptions.class);
        }

        public static interface CosmosItemRequestOptionsAccessor {
            public void setOperationContext(CosmosItemRequestOptions var1, OperationContextAndListenerTuple var2);

            public OperationContextAndListenerTuple getOperationContext(CosmosItemRequestOptions var1);

            public CosmosItemRequestOptions clone(CosmosItemRequestOptions var1);

            public CosmosItemRequestOptions setHeader(CosmosItemRequestOptions var1, String var2, String var3);

            public Map<String, String> getHeader(CosmosItemRequestOptions var1);
        }
    }

    public static final class CosmosChangeFeedRequestOptionsHelper {
        private static CosmosChangeFeedRequestOptionsAccessor accessor;

        private CosmosChangeFeedRequestOptionsHelper() {
        }

        public static void setCosmosChangeFeedRequestOptionsAccessor(CosmosChangeFeedRequestOptionsAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("CosmosChangeFeedRequestOptions accessor already initialized!");
            }
            accessor = newAccessor;
        }

        public static CosmosChangeFeedRequestOptionsAccessor getCosmosChangeFeedRequestOptionsAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("CosmosChangeFeedRequestOptions accessor is not initialized yet!");
            }
            return accessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(CosmosChangeFeedRequestOptions.class);
        }

        public static interface CosmosChangeFeedRequestOptionsAccessor {
            public CosmosChangeFeedRequestOptions setHeader(CosmosChangeFeedRequestOptions var1, String var2, String var3);

            public Map<String, String> getHeader(CosmosChangeFeedRequestOptions var1);

            public void setOperationContext(CosmosChangeFeedRequestOptions var1, OperationContextAndListenerTuple var2);

            public OperationContextAndListenerTuple getOperationContext(CosmosChangeFeedRequestOptions var1);

            public <T> Function<JsonNode, T> getItemFactoryMethod(CosmosChangeFeedRequestOptions var1, Class<T> var2);

            public CosmosChangeFeedRequestOptions setItemFactoryMethod(CosmosChangeFeedRequestOptions var1, Function<JsonNode, ?> var2);
        }
    }

    public static final class CosmosQueryRequestOptionsHelper {
        private static CosmosQueryRequestOptionsAccessor accessor;

        private CosmosQueryRequestOptionsHelper() {
        }

        public static void setCosmosQueryRequestOptionsAccessor(CosmosQueryRequestOptionsAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("CosmosQueryRequestOptions accessor already initialized!");
            }
            accessor = newAccessor;
        }

        public static CosmosQueryRequestOptionsAccessor getCosmosQueryRequestOptionsAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("CosmosQueryRequestOptions accessor is not initialized yet!");
            }
            return accessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(CosmosQueryRequestOptions.class);
        }

        public static interface CosmosQueryRequestOptionsAccessor {
            public void setOperationContext(CosmosQueryRequestOptions var1, OperationContextAndListenerTuple var2);

            public OperationContextAndListenerTuple getOperationContext(CosmosQueryRequestOptions var1);

            public CosmosQueryRequestOptions setHeader(CosmosQueryRequestOptions var1, String var2, String var3);

            public Map<String, String> getHeader(CosmosQueryRequestOptions var1);

            public boolean isQueryPlanRetrievalDisallowed(CosmosQueryRequestOptions var1);

            public CosmosQueryRequestOptions disallowQueryPlanRetrieval(CosmosQueryRequestOptions var1);

            public UUID getCorrelationActivityId(CosmosQueryRequestOptions var1);

            public CosmosQueryRequestOptions setCorrelationActivityId(CosmosQueryRequestOptions var1, UUID var2);

            public boolean isEmptyPageDiagnosticsEnabled(CosmosQueryRequestOptions var1);

            public CosmosQueryRequestOptions setEmptyPageDiagnosticsEnabled(CosmosQueryRequestOptions var1, boolean var2);

            public <T> Function<JsonNode, T> getItemFactoryMethod(CosmosQueryRequestOptions var1, Class<T> var2);

            public CosmosQueryRequestOptions setItemFactoryMethod(CosmosQueryRequestOptions var1, Function<JsonNode, ?> var2);
        }
    }

    public static final class DirectConnectionConfigHelper {
        private static DirectConnectionConfigAccessor accessor;

        private DirectConnectionConfigHelper() {
        }

        public static void setDirectConnectionConfigAccessor(DirectConnectionConfigAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("DirectConnectionConfig accessor already initialized!");
            }
            accessor = newAccessor;
        }

        public static DirectConnectionConfigAccessor getDirectConnectionConfigAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("DirectConnectionConfig accessor is not initialized!");
            }
            return accessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(DirectConnectionConfig.class);
        }

        public static interface DirectConnectionConfigAccessor {
            public int getIoThreadCountPerCoreFactor(DirectConnectionConfig var1);

            public DirectConnectionConfig setIoThreadCountPerCoreFactor(DirectConnectionConfig var1, int var2);

            public int getIoThreadPriority(DirectConnectionConfig var1);

            public DirectConnectionConfig setIoThreadPriority(DirectConnectionConfig var1, int var2);
        }
    }

    public static final class PartitionKeyHelper {
        private static PartitionKeyAccessor accessor;

        private PartitionKeyHelper() {
        }

        public static void setPartitionKeyAccessor(PartitionKeyAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("PartitionKey accessor already initialized!");
            }
            accessor = newAccessor;
        }

        public static PartitionKeyAccessor getPartitionKeyAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("PartitionKey accessor is not initialized!");
            }
            return accessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(PartitionKey.class);
        }

        public static interface PartitionKeyAccessor {
            public PartitionKey toPartitionKey(PartitionKeyInternal var1);
        }
    }

    public static final class CosmosClientBuilderHelper {
        private static CosmosClientBuilderAccessor accessor;

        private CosmosClientBuilderHelper() {
        }

        public static void setCosmosClientBuilderAccessor(CosmosClientBuilderAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("CosmosClientBuilder accessor already initialized!");
            }
            accessor = newAccessor;
        }

        public static CosmosClientBuilderAccessor getCosmosClientBuilderAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("CosmosClientBuilder accessor is not initialized yet!");
            }
            return accessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(CosmosClientBuilder.class);
        }

        public static interface CosmosClientBuilderAccessor {
            public void setCosmosClientMetadataCachesSnapshot(CosmosClientBuilder var1, CosmosClientMetadataCachesSnapshot var2);

            public CosmosClientMetadataCachesSnapshot getCosmosClientMetadataCachesSnapshot(CosmosClientBuilder var1);

            public void setCosmosClientApiType(CosmosClientBuilder var1, ApiType var2);

            public ApiType getCosmosClientApiType(CosmosClientBuilder var1);

            public ConnectionPolicy getConnectionPolicy(CosmosClientBuilder var1);

            public Configs getConfigs(CosmosClientBuilder var1);

            public ConsistencyLevel getConsistencyLevel(CosmosClientBuilder var1);
        }
    }
}

