/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.BadRequestException;
import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.ICollectionRoutingMapCache;
import com.azure.cosmos.implementation.InternalServerErrorException;
import com.azure.cosmos.implementation.InvalidPartitionException;
import com.azure.cosmos.implementation.NotFoundException;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.PartitionKeyRangeGoneException;
import com.azure.cosmos.implementation.ResourceId;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.NotImplementedException;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.caches.RxCollectionCache;
import com.azure.cosmos.implementation.directconnectivity.AddressInformation;
import com.azure.cosmos.implementation.directconnectivity.IAddressCache;
import com.azure.cosmos.implementation.directconnectivity.IAddressResolver;
import com.azure.cosmos.implementation.directconnectivity.ReplicatedResourceClient;
import com.azure.cosmos.implementation.routing.CollectionRoutingMap;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.implementation.routing.PartitionKeyInternalHelper;
import com.azure.cosmos.implementation.routing.PartitionKeyRangeIdentity;
import java.net.URI;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class AddressResolver
implements IAddressResolver {
    private static Logger logger = LoggerFactory.getLogger(AddressResolver.class);
    private static final PartitionKeyRangeIdentity masterPartitionKeyRangeIdentity = new PartitionKeyRangeIdentity("M");
    private RxCollectionCache collectionCache;
    private ICollectionRoutingMapCache collectionRoutingMapCache;
    private IAddressCache addressCache;

    public void initializeCaches(RxCollectionCache collectionCache, ICollectionRoutingMapCache collectionRoutingMapCache, IAddressCache addressCache) {
        this.collectionCache = collectionCache;
        this.addressCache = addressCache;
        this.collectionRoutingMapCache = collectionRoutingMapCache;
    }

    @Override
    public Mono<AddressInformation[]> resolveAsync(RxDocumentServiceRequest request, boolean forceRefreshPartitionAddresses) {
        Mono<ResolutionResult> resultObs = this.resolveAddressesAndIdentityAsync(request, forceRefreshPartitionAddresses);
        return resultObs.flatMap(result -> {
            try {
                this.throwIfTargetChanged(request, result.TargetPartitionKeyRange);
            }
            catch (Exception e) {
                return Mono.error((Throwable)e);
            }
            request.requestContext.resolvedPartitionKeyRange = result.TargetPartitionKeyRange;
            return Mono.just((Object)result.Addresses);
        });
    }

    @Override
    public int updateAddresses(URI serverKey) {
        throw new NotImplementedException("updateAddresses() is not supported in AddressResolver");
    }

    private static boolean isSameCollection(PartitionKeyRange initiallyResolved, PartitionKeyRange newlyResolved) {
        if (initiallyResolved == null) {
            throw new IllegalArgumentException("parent");
        }
        if (newlyResolved == null) {
            return false;
        }
        if (Strings.areEqual(initiallyResolved.getId(), "M") && Strings.areEqual(newlyResolved.getId(), "M")) {
            return true;
        }
        if (Strings.areEqual(initiallyResolved.getId(), "M") || Strings.areEqual(newlyResolved.getId(), "M")) {
            String message = "Request was resolved to master partition and then to server partition.";
            assert (false) : message;
            logger.warn(message);
            return false;
        }
        if (ResourceId.parse(initiallyResolved.getResourceId()).getDocumentCollection() != ResourceId.parse(newlyResolved.getResourceId()).getDocumentCollection()) {
            return false;
        }
        if (!(Strings.areEqual(initiallyResolved.getId(), newlyResolved.getId()) || newlyResolved.getParents() != null && newlyResolved.getParents().contains(initiallyResolved.getId()))) {
            String message = "Request is targeted at a partition key range which is not child of previously targeted range.";
            assert (false) : message;
            logger.warn(message);
            return false;
        }
        return true;
    }

    private void throwIfTargetChanged(RxDocumentServiceRequest request, PartitionKeyRange targetRange) {
        if (request.requestContext.resolvedPartitionKeyRange != null && !AddressResolver.isSameCollection(request.requestContext.resolvedPartitionKeyRange, targetRange)) {
            if (!request.getIsNameBased()) {
                String message = String.format("Target should not change for non name based requests. Previous target %s, Current %s", request.requestContext.resolvedPartitionKeyRange, targetRange);
                assert (false) : message;
                logger.warn(message);
            }
            request.requestContext.resolvedPartitionKeyRange = null;
            throw new InvalidPartitionException("Target for the request is invalid", request.requestContext.resourcePhysicalAddress);
        }
    }

    private static void ensureRoutingMapPresent(RxDocumentServiceRequest request, CollectionRoutingMap routingMap, DocumentCollection collection) {
        if (routingMap == null && request.getIsNameBased() && request.getPartitionKeyRangeIdentity() != null && request.getPartitionKeyRangeIdentity().getCollectionRid() != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Routing map for request with partitionkeyrageid {} was not found", (Object)request.getPartitionKeyRangeIdentity().toHeader());
            }
            InvalidPartitionException invalidPartitionException = new InvalidPartitionException();
            BridgeInternal.setResourceAddress(invalidPartitionException, request.requestContext.resourcePhysicalAddress);
            throw invalidPartitionException;
        }
        if (routingMap == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Routing map was not found although collection cache is upto date for collection {}", (Object)collection.getResourceId());
            }
            NotFoundException e = new NotFoundException();
            BridgeInternal.setResourceAddress(e, request.requestContext.resourcePhysicalAddress);
            throw e;
        }
    }

    private Mono<Utils.ValueHolder<ResolutionResult>> tryResolveServerPartitionAsync(RxDocumentServiceRequest request, DocumentCollection collection, CollectionRoutingMap routingMap, boolean collectionCacheIsUptodate, boolean collectionRoutingMapCacheIsUptodate, boolean forceRefreshPartitionAddresses) {
        try {
            if (request.getPartitionKeyRangeIdentity() != null) {
                return this.tryResolveServerPartitionByPartitionKeyRangeIdAsync(request, collection, routingMap, collectionCacheIsUptodate, collectionRoutingMapCacheIsUptodate, forceRefreshPartitionAddresses);
            }
            if (!(request.getResourceType().isPartitioned() || request.getResourceType() == ResourceType.StoredProcedure && request.getOperationType() == OperationType.ExecuteJavaScript || request.getResourceType() == ResourceType.DocumentCollection && request.getOperationType() == OperationType.Head)) {
                logger.error("Shouldn't come here for non partitioned resources. resourceType : {}, operationtype:{}, resourceaddress:{}", new Object[]{request.getResourceType(), request.getOperationType(), request.getResourceAddress()});
                return Mono.error((Throwable)((Object)BridgeInternal.setResourceAddress(new InternalServerErrorException("Unknown server error occurred when processing this request. If the issue persists, please contact Azure Support: http://aka.ms/azure-support"), request.requestContext.resourcePhysicalAddress)));
            }
            PartitionKeyInternal partitionKeyInternal = request.getPartitionKeyInternal();
            PartitionKeyRange range = partitionKeyInternal != null || request.getHeaders().containsKey("x-ms-documentdb-partitionkey") ? this.tryResolveServerPartitionByPartitionKey(request, partitionKeyInternal, collectionCacheIsUptodate, collection, routingMap) : this.tryResolveSinglePartitionCollection(request, routingMap, collectionCacheIsUptodate);
            if (range == null) {
                logger.debug("Collection cache or routing map cache is potentially outdated. Returning null. Upper logic will refresh cache and retry.");
                return Mono.just(new Utils.ValueHolder<Object>(null));
            }
            Mono<Utils.ValueHolder<AddressInformation[]>> addressesObs = this.addressCache.tryGetAddresses(request, new PartitionKeyRangeIdentity(collection.getResourceId(), range.getId()), forceRefreshPartitionAddresses);
            return addressesObs.flatMap(addressesValueHolder -> {
                if (addressesValueHolder.v == null) {
                    logger.info("Could not resolve addresses for identity {}/{}. Potentially collection cache or routing map cache is outdated. Return empty - upper logic will refresh and retry. ", (Object)new PartitionKeyRangeIdentity(collection.getResourceId(), range.getId()));
                    return Mono.just(new Utils.ValueHolder<Object>(null));
                }
                return Mono.just(new Utils.ValueHolder<ResolutionResult>(new ResolutionResult(range, (AddressInformation[])addressesValueHolder.v)));
            });
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }

    private PartitionKeyRange tryResolveSinglePartitionCollection(RxDocumentServiceRequest request, CollectionRoutingMap routingMap, boolean collectionCacheIsUptoDate) {
        if (routingMap.getOrderedPartitionKeyRanges().size() == 1) {
            return routingMap.getOrderedPartitionKeyRanges().get(0);
        }
        logger.debug("tryResolveSinglePartitionCollection: collectionCacheIsUptoDate = {}", (Object)collectionCacheIsUptoDate);
        if (collectionCacheIsUptoDate) {
            throw BridgeInternal.setResourceAddress(new BadRequestException("PartitionKey value must be supplied for this operation."), request.requestContext.resourcePhysicalAddress);
        }
        return null;
    }

    private Mono<ResolutionResult> resolveMasterResourceAddress(RxDocumentServiceRequest request, boolean forceRefreshPartitionAddresses) {
        assert (ReplicatedResourceClient.isReadingFromMaster(request.getResourceType(), request.getOperationType()) && request.getPartitionKeyRangeIdentity() == null);
        Mono<Utils.ValueHolder<AddressInformation[]>> addressesObs = this.addressCache.tryGetAddresses(request, masterPartitionKeyRangeIdentity, forceRefreshPartitionAddresses);
        return addressesObs.flatMap(addressesValueHolder -> {
            if (addressesValueHolder.v == null) {
                logger.warn("Could not get addresses for master partition");
                NotFoundException e = new NotFoundException();
                BridgeInternal.setResourceAddress(e, request.requestContext.resourcePhysicalAddress);
                return Mono.error((Throwable)((Object)e));
            }
            PartitionKeyRange partitionKeyRange = new PartitionKeyRange();
            partitionKeyRange.setId("M");
            return Mono.just((Object)new ResolutionResult(partitionKeyRange, (AddressInformation[])addressesValueHolder.v));
        });
    }

    private Mono<RefreshState> getOrRefreshRoutingMap(RxDocumentServiceRequest request, boolean forceRefreshPartitionAddresses) {
        RefreshState state = new RefreshState();
        state.collectionCacheIsUptoDate = !request.getIsNameBased() || request.getPartitionKeyRangeIdentity() != null && request.getPartitionKeyRangeIdentity().getCollectionRid() != null;
        state.collectionRoutingMapCacheIsUptoDate = false;
        Mono<Utils.ValueHolder<DocumentCollection>> collectionObs = this.collectionCache.resolveCollectionAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), request);
        Mono stateObs = collectionObs.flatMap(collectionValueHolder -> {
            state.collection = (DocumentCollection)collectionValueHolder.v;
            Mono<Utils.ValueHolder<CollectionRoutingMap>> routingMapObs = this.collectionRoutingMapCache.tryLookupAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), ((DocumentCollection)collectionValueHolder.v).getResourceId(), null, request.forceCollectionRoutingMapRefresh, request.properties);
            Utils.ValueHolder underlyingCollection = collectionValueHolder;
            return routingMapObs.flatMap(routingMapValueHolder -> {
                state.routingMap = (CollectionRoutingMap)routingMapValueHolder.v;
                if (request.forcePartitionKeyRangeRefresh) {
                    state.collectionRoutingMapCacheIsUptoDate = true;
                    request.forcePartitionKeyRangeRefresh = false;
                    if (routingMapValueHolder.v != null) {
                        return this.collectionRoutingMapCache.tryLookupAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), ((DocumentCollection)underlyingCollection.v).getResourceId(), (CollectionRoutingMap)routingMapValueHolder.v, request.properties).map(newRoutingMapValueHolder -> {
                            state.routingMap = (CollectionRoutingMap)newRoutingMapValueHolder.v;
                            return state;
                        });
                    }
                }
                return Mono.just((Object)state);
            });
        });
        return stateObs.flatMap(newState -> {
            if (newState.routingMap == null && !newState.collectionCacheIsUptoDate) {
                request.forceNameCacheRefresh = true;
                newState.collectionCacheIsUptoDate = true;
                newState.collectionRoutingMapCacheIsUptoDate = false;
                Mono<Utils.ValueHolder<DocumentCollection>> newCollectionObs = this.collectionCache.resolveCollectionAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), request);
                return newCollectionObs.flatMap(collectionValueHolder -> {
                    newState.collection = (DocumentCollection)collectionValueHolder.v;
                    Mono<Utils.ValueHolder<CollectionRoutingMap>> newRoutingMapObs = this.collectionRoutingMapCache.tryLookupAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), ((DocumentCollection)collectionValueHolder.v).getResourceId(), null, request.properties);
                    return newRoutingMapObs.map(routingMapValueHolder -> {
                        newState.routingMap = (CollectionRoutingMap)routingMapValueHolder.v;
                        return newState;
                    });
                });
            }
            return Mono.just((Object)newState);
        });
    }

    private Mono<RefreshState> getStateWithNewRoutingMap(RefreshState state, Mono<Utils.ValueHolder<CollectionRoutingMap>> routingMapSingle) {
        return routingMapSingle.map(routingMapValueHolder -> {
            state.routingMap = (CollectionRoutingMap)routingMapValueHolder.v;
            return state;
        });
    }

    private Mono<ResolutionResult> resolveAddressesAndIdentityAsync(RxDocumentServiceRequest request, boolean forceRefreshPartitionAddresses) {
        if (ReplicatedResourceClient.isReadingFromMaster(request.getResourceType(), request.getOperationType()) && request.getPartitionKeyRangeIdentity() == null) {
            return this.resolveMasterResourceAddress(request, forceRefreshPartitionAddresses);
        }
        Mono<RefreshState> refreshStateObs = this.getOrRefreshRoutingMap(request, forceRefreshPartitionAddresses);
        return refreshStateObs.flatMap(state -> {
            try {
                AddressResolver.ensureRoutingMapPresent(request, state.routingMap, state.collection);
            }
            catch (Exception e) {
                return Mono.error((Throwable)e);
            }
            Mono<Utils.ValueHolder<ResolutionResult>> resultObs = this.tryResolveServerPartitionAsync(request, state.collection, state.routingMap, state.collectionCacheIsUptoDate, state.collectionRoutingMapCacheIsUptoDate, forceRefreshPartitionAddresses);
            Function<ResolutionResult, Mono> addCollectionRidIfNameBased = funcResolutionResult -> {
                assert (funcResolutionResult != null);
                if (request.getIsNameBased()) {
                    request.getHeaders().put("x-ms-documentdb-collection-rid", state.collection.getResourceId());
                }
                return Mono.just((Object)funcResolutionResult);
            };
            return resultObs.flatMap(resolutionResultValueHolder -> {
                if (resolutionResultValueHolder.v != null) {
                    return (Mono)addCollectionRidIfNameBased.apply((ResolutionResult)resolutionResultValueHolder.v);
                }
                assert (resolutionResultValueHolder.v == null);
                Function<RefreshState, Mono> ensureCollectionRoutingMapCacheIsUptoDateFunc = funcState -> {
                    if (!funcState.collectionRoutingMapCacheIsUptoDate) {
                        funcState.collectionRoutingMapCacheIsUptoDate = true;
                        Mono<Utils.ValueHolder<CollectionRoutingMap>> newRoutingMapObs = this.collectionRoutingMapCache.tryLookupAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), funcState.collection.getResourceId(), funcState.routingMap, request.properties);
                        return this.getStateWithNewRoutingMap((RefreshState)funcState, newRoutingMapObs);
                    }
                    return Mono.just((Object)state);
                };
                Function<RefreshState, Mono> resolveServerPartition = funcState -> {
                    try {
                        AddressResolver.ensureRoutingMapPresent(request, funcState.routingMap, funcState.collection);
                    }
                    catch (Exception e) {
                        return Mono.error((Throwable)e);
                    }
                    return this.tryResolveServerPartitionAsync(request, funcState.collection, funcState.routingMap, true, true, forceRefreshPartitionAddresses);
                };
                Function<Utils.ValueHolder, Mono> onNullThrowNotFound = funcResolutionResult -> {
                    if (funcResolutionResult.v == null) {
                        logger.debug("Couldn't route partitionkeyrange-oblivious request after retry/cache refresh. Collection doesn't exist.");
                        return Mono.error((Throwable)((Object)BridgeInternal.setResourceAddress(new NotFoundException(), request.requestContext.resourcePhysicalAddress)));
                    }
                    return Mono.just((Object)((ResolutionResult)funcResolutionResult.v));
                };
                if (!state.collectionCacheIsUptoDate) {
                    request.forceNameCacheRefresh = true;
                    state.collectionCacheIsUptoDate = true;
                    Mono<Utils.ValueHolder<DocumentCollection>> newCollectionObs = this.collectionCache.resolveCollectionAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), request);
                    Mono newRefreshStateObs = newCollectionObs.flatMap(collectionValueHolder -> {
                        state.collection = (DocumentCollection)collectionValueHolder.v;
                        if (!StringUtils.equals(((DocumentCollection)collectionValueHolder.v).getResourceId(), state.routingMap.getCollectionUniqueId())) {
                            state.collectionRoutingMapCacheIsUptoDate = false;
                            Mono<Utils.ValueHolder<CollectionRoutingMap>> newRoutingMap = this.collectionRoutingMapCache.tryLookupAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), ((DocumentCollection)collectionValueHolder.v).getResourceId(), null, request.properties);
                            return this.getStateWithNewRoutingMap((RefreshState)state, newRoutingMap);
                        }
                        return Mono.just((Object)state);
                    });
                    Mono newResultObs = newRefreshStateObs.flatMap(ensureCollectionRoutingMapCacheIsUptoDateFunc).flatMap(resolveServerPartition);
                    return newResultObs.flatMap(onNullThrowNotFound).flatMap(addCollectionRidIfNameBased);
                }
                return ensureCollectionRoutingMapCacheIsUptoDateFunc.apply((RefreshState)state).flatMap(resolveServerPartition).flatMap(onNullThrowNotFound).flatMap(addCollectionRidIfNameBased);
            });
        });
    }

    private ResolutionResult handleRangeAddressResolutionFailure(RxDocumentServiceRequest request, boolean collectionCacheIsUpToDate, boolean routingMapCacheIsUpToDate, CollectionRoutingMap routingMap) {
        if (collectionCacheIsUpToDate && routingMapCacheIsUpToDate || collectionCacheIsUpToDate && routingMap.isGone(request.getPartitionKeyRangeIdentity().getPartitionKeyRangeId())) {
            String errorMessage = String.format("PartitionKeyRange with id %s in collection %s doesn't exist", request.getPartitionKeyRangeIdentity().getPartitionKeyRangeId(), request.getPartitionKeyRangeIdentity().getCollectionRid());
            throw BridgeInternal.setResourceAddress(new PartitionKeyRangeGoneException(errorMessage), request.requestContext.resourcePhysicalAddress);
        }
        logger.debug("handleRangeAddressResolutionFailure returns null");
        return null;
    }

    private <T> Mono<T> returnOrError(Callable<T> function) {
        try {
            return Mono.just(function.call());
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }

    private Mono<Utils.ValueHolder<ResolutionResult>> tryResolveServerPartitionByPartitionKeyRangeIdAsync(RxDocumentServiceRequest request, DocumentCollection collection, CollectionRoutingMap routingMap, boolean collectionCacheIsUpToDate, boolean routingMapCacheIsUpToDate, boolean forceRefreshPartitionAddresses) {
        PartitionKeyRange partitionKeyRange = routingMap.getRangeByPartitionKeyRangeId(request.getPartitionKeyRangeIdentity().getPartitionKeyRangeId());
        if (partitionKeyRange == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Cannot resolve range '{}'", (Object)request.getPartitionKeyRangeIdentity().toHeader());
            }
            return this.returnOrError(() -> new Utils.ValueHolder<ResolutionResult>(this.handleRangeAddressResolutionFailure(request, collectionCacheIsUpToDate, routingMapCacheIsUpToDate, routingMap)));
        }
        Mono<Utils.ValueHolder<AddressInformation[]>> addressesObs = this.addressCache.tryGetAddresses(request, new PartitionKeyRangeIdentity(collection.getResourceId(), request.getPartitionKeyRangeIdentity().getPartitionKeyRangeId()), forceRefreshPartitionAddresses);
        return addressesObs.flatMap(addressesValueHolder -> {
            if (addressesValueHolder.v == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Cannot resolve addresses for range '{}'", (Object)request.getPartitionKeyRangeIdentity().toHeader());
                }
                try {
                    return Mono.just(new Utils.ValueHolder<ResolutionResult>(this.handleRangeAddressResolutionFailure(request, collectionCacheIsUpToDate, routingMapCacheIsUpToDate, routingMap)));
                }
                catch (CosmosException e) {
                    return Mono.error((Throwable)((Object)e));
                }
            }
            return Mono.just(new Utils.ValueHolder<ResolutionResult>(new ResolutionResult(partitionKeyRange, (AddressInformation[])addressesValueHolder.v)));
        });
    }

    private PartitionKeyRange tryResolveServerPartitionByPartitionKey(RxDocumentServiceRequest request, PartitionKeyInternal partitionKey, boolean collectionCacheUptoDate, DocumentCollection collection, CollectionRoutingMap routingMap) {
        String partitionKeyString;
        if (request == null) {
            throw new NullPointerException("request");
        }
        if (collection == null) {
            throw new NullPointerException("collection");
        }
        if (routingMap == null) {
            throw new NullPointerException("routingMap");
        }
        if (partitionKey == null && (partitionKeyString = request.getHeaders().get("x-ms-documentdb-partitionkey")) != null) {
            try {
                logger.warn("PartitionKeyInternal is not set in DocumentServiceRequest, attempting to deserialize header {}. Note, any code setting PARTITION_KEY header value must also set PartitionKeyInternal to avoid deserialization cost.", (Object)partitionKeyString);
                partitionKey = PartitionKeyInternal.fromJsonString(partitionKeyString);
            }
            catch (Exception ex) {
                throw BridgeInternal.setResourceAddress(new BadRequestException(String.format("Partition key %s is invalid.", partitionKeyString), ex), request.requestContext.resourcePhysicalAddress);
            }
        }
        if (partitionKey == null) {
            throw new InternalServerErrorException(String.format("partition key is null", new Object[0]));
        }
        if (partitionKey.equals(PartitionKeyInternal.Empty) || Utils.getCollectionSize(partitionKey.getComponents()) == collection.getPartitionKey().getPaths().size()) {
            String effectivePartitionKey = PartitionKeyInternalHelper.getEffectivePartitionKeyString(partitionKey, collection.getPartitionKey());
            return routingMap.getRangeByEffectivePartitionKey(effectivePartitionKey);
        }
        if (collectionCacheUptoDate) {
            BadRequestException badRequestException = BridgeInternal.setResourceAddress(new BadRequestException("Partition key provided either doesn't correspond to definition in the collection or doesn't match partition key field values specified in the document."), request.requestContext.resourcePhysicalAddress);
            badRequestException.getResponseHeaders().put("x-ms-substatus", Integer.toString(1001));
            throw badRequestException;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Cannot compute effective partition getKey. Definition has '{}' getPaths, values supplied has '{}' getPaths. Will refresh cache and retry.", (Object)collection.getPartitionKey().getPaths().size(), (Object)Utils.getCollectionSize(partitionKey.getComponents()));
        }
        return null;
    }

    private static class ResolutionResult {
        final PartitionKeyRange TargetPartitionKeyRange;
        final AddressInformation[] Addresses;

        ResolutionResult(PartitionKeyRange targetPartitionKeyRange, AddressInformation[] addresses) {
            if (targetPartitionKeyRange == null) {
                throw new NullPointerException("targetPartitionKeyRange");
            }
            if (addresses == null) {
                throw new NullPointerException("addresses");
            }
            this.TargetPartitionKeyRange = targetPartitionKeyRange;
            this.Addresses = addresses;
        }
    }

    private static class RefreshState {
        volatile boolean collectionCacheIsUptoDate;
        volatile boolean collectionRoutingMapCacheIsUptoDate;
        volatile DocumentCollection collection;
        volatile CollectionRoutingMap routingMap;
        volatile ResolutionResult resolutionResult;

        private RefreshState() {
        }
    }
}

