/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.BackoffRetryUtility;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.Exceptions;
import com.azure.cosmos.implementation.IAuthorizationTokenProvider;
import com.azure.cosmos.implementation.IRetryPolicy;
import com.azure.cosmos.implementation.ISessionToken;
import com.azure.cosmos.implementation.InternalServerErrorException;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.RxDocumentServiceResponse;
import com.azure.cosmos.implementation.SessionContainer;
import com.azure.cosmos.implementation.SessionTokenHelper;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.math.NumberUtils;
import com.azure.cosmos.implementation.directconnectivity.AddressSelector;
import com.azure.cosmos.implementation.directconnectivity.GatewayServiceConfigurationReader;
import com.azure.cosmos.implementation.directconnectivity.IAddressResolver;
import com.azure.cosmos.implementation.directconnectivity.IStoreClient;
import com.azure.cosmos.implementation.directconnectivity.ReplicatedResourceClient;
import com.azure.cosmos.implementation.directconnectivity.StoreResponse;
import com.azure.cosmos.implementation.directconnectivity.TransportClient;
import com.azure.cosmos.implementation.throughputControl.ThroughputControlStore;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class StoreClient
implements IStoreClient {
    private final DiagnosticsClientContext diagnosticsClientContext;
    private final Logger logger = LoggerFactory.getLogger(StoreClient.class);
    private final GatewayServiceConfigurationReader serviceConfigurationReader;
    private final SessionContainer sessionContainer;
    private final ReplicatedResourceClient replicatedResourceClient;
    private final TransportClient transportClient;
    private final String ZERO_PARTITION_KEY_RANGE = "0";

    public StoreClient(DiagnosticsClientContext diagnosticsClientContext, Configs configs, IAddressResolver addressResolver, SessionContainer sessionContainer, GatewayServiceConfigurationReader serviceConfigurationReader, IAuthorizationTokenProvider userTokenProvider, TransportClient transportClient, boolean useMultipleWriteLocations) {
        this.diagnosticsClientContext = diagnosticsClientContext;
        this.transportClient = transportClient;
        this.sessionContainer = sessionContainer;
        this.serviceConfigurationReader = serviceConfigurationReader;
        this.replicatedResourceClient = new ReplicatedResourceClient(diagnosticsClientContext, configs, new AddressSelector(addressResolver, configs.getProtocol()), sessionContainer, this.transportClient, serviceConfigurationReader, userTokenProvider, false, useMultipleWriteLocations);
    }

    public void enableThroughputControl(ThroughputControlStore throughputControlStore) {
        this.replicatedResourceClient.enableThroughputControl(throughputControlStore);
    }

    @Override
    public Mono<RxDocumentServiceResponse> processMessageAsync(RxDocumentServiceRequest request, IRetryPolicy retryPolicy, Function<RxDocumentServiceRequest, Mono<RxDocumentServiceRequest>> prepareRequestAsyncDelegate) {
        Mono storeResponse;
        if (request == null) {
            throw new NullPointerException("request");
        }
        Callable storeResponseDelegate = () -> this.replicatedResourceClient.invokeAsync(request, prepareRequestAsyncDelegate);
        try {
            storeResponse = retryPolicy != null ? BackoffRetryUtility.executeRetry(storeResponseDelegate, retryPolicy) : storeResponseDelegate.call();
        }
        catch (Exception e2) {
            return Mono.error((Throwable)e2);
        }
        storeResponse = storeResponse.doOnError(e -> {
            try {
                Throwable unwrappedException = reactor.core.Exceptions.unwrap((Throwable)e);
                CosmosException exception = Utils.as(unwrappedException, CosmosException.class);
                if (exception == null) {
                    return;
                }
                BridgeInternal.recordRetryContextEndTime(request.requestContext.cosmosDiagnostics);
                exception = BridgeInternal.setCosmosDiagnostics(exception, request.requestContext.cosmosDiagnostics);
                this.handleUnsuccessfulStoreResponse(request, exception);
            }
            catch (Throwable throwable) {
                this.logger.error("Unexpected failure in handling orig [{}]", (Object)e.getMessage(), e);
                this.logger.error("Unexpected failure in handling orig [{}] : new [{}]", new Object[]{e.getMessage(), throwable.getMessage(), throwable});
            }
        });
        return storeResponse.flatMap(sr -> {
            try {
                return Mono.just((Object)this.completeResponse((StoreResponse)sr, request));
            }
            catch (Exception e) {
                return Mono.error((Throwable)e);
            }
        });
    }

    private void handleUnsuccessfulStoreResponse(RxDocumentServiceRequest request, CosmosException exception) {
        this.updateResponseHeader(request, exception.getResponseHeaders());
        if (!ReplicatedResourceClient.isMasterResource(request.getResourceType()) && (Exceptions.isStatusCode(exception, 412) || Exceptions.isStatusCode(exception, 409) || Exceptions.isStatusCode(exception, 404) && !Exceptions.isSubStatusCode(exception, 1002))) {
            this.captureSessionToken(request, exception.getResponseHeaders());
        }
    }

    private RxDocumentServiceResponse completeResponse(StoreResponse storeResponse, RxDocumentServiceRequest request) throws InternalServerErrorException {
        if (storeResponse.getResponseHeaderNames().length != storeResponse.getResponseHeaderValues().length) {
            throw new InternalServerErrorException("The backend response was not in the correct format.");
        }
        HashMap<String, String> headers = new HashMap<String, String>(storeResponse.getResponseHeaderNames().length);
        for (int idx = 0; idx < storeResponse.getResponseHeaderNames().length; ++idx) {
            String name = storeResponse.getResponseHeaderNames()[idx];
            String value = storeResponse.getResponseHeaderValues()[idx];
            headers.put(name, value);
        }
        this.updateResponseHeader(request, headers);
        this.captureSessionToken(request, headers);
        BridgeInternal.recordRetryContextEndTime(request.requestContext.cosmosDiagnostics);
        RxDocumentServiceResponse rxDocumentServiceResponse = new RxDocumentServiceResponse(this.diagnosticsClientContext, storeResponse);
        rxDocumentServiceResponse.setCosmosDiagnostics(request.requestContext.cosmosDiagnostics);
        return rxDocumentServiceResponse;
    }

    private long getLSN(Map<String, String> headers) {
        long defaultValue = -1L;
        String value = headers.get("lsn");
        if (!Strings.isNullOrEmpty(value)) {
            return NumberUtils.toLong(value, defaultValue);
        }
        return defaultValue;
    }

    private void updateResponseHeader(RxDocumentServiceRequest request, Map<String, String> headers) {
        String requestConsistencyLevel = request.getHeaders().get("x-ms-consistency-level");
        boolean sessionConsistency = this.serviceConfigurationReader.getDefaultConsistencyLevel() == ConsistencyLevel.SESSION || !Strings.isNullOrEmpty(requestConsistencyLevel) && Strings.areEqualIgnoreCase(requestConsistencyLevel, ConsistencyLevel.SESSION.toString());
        long storeLSN = this.getLSN(headers);
        if (storeLSN == -1L) {
            return;
        }
        String partitionKeyRangeId = headers.get("x-ms-documentdb-partitionkeyrangeid");
        if (Strings.isNullOrEmpty(partitionKeyRangeId)) {
            String inputSession = request.getHeaders().get("x-ms-session-token");
            partitionKeyRangeId = !Strings.isNullOrEmpty(inputSession) && inputSession.indexOf(":") >= 1 ? inputSession.substring(0, inputSession.indexOf(":")) : "0";
        }
        ISessionToken sessionToken = null;
        String sessionTokenResponseHeader = headers.get("x-ms-session-token");
        if (!Strings.isNullOrEmpty(sessionTokenResponseHeader)) {
            sessionToken = SessionTokenHelper.parse(sessionTokenResponseHeader);
        }
        if (sessionToken != null) {
            headers.put("x-ms-session-token", SessionTokenHelper.concatPartitionKeyRangeIdWithSessionToken(partitionKeyRangeId, sessionToken.convertToString()));
        }
        headers.remove("x-ms-documentdb-partitionkeyrangeid");
    }

    private void captureSessionToken(RxDocumentServiceRequest request, Map<String, String> headers) {
        if (request.getResourceType() == ResourceType.DocumentCollection && request.getOperationType() == OperationType.Delete) {
            String resourceId = request.getIsNameBased() ? headers.get("x-ms-content-path") : request.getResourceId();
            this.sessionContainer.clearTokenByResourceId(resourceId);
        } else {
            this.sessionContainer.setSessionToken(request, headers);
        }
    }
}

