/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.patch.PatchOperation;
import com.azure.cosmos.implementation.patch.PatchOperationCore;
import com.azure.cosmos.implementation.patch.PatchOperationType;
import java.util.ArrayList;
import java.util.List;

public final class CosmosPatchOperations {
    private final List<PatchOperation> patchOperations = new ArrayList<PatchOperation>();

    private CosmosPatchOperations() {
    }

    public static CosmosPatchOperations create() {
        return new CosmosPatchOperations();
    }

    public <T> CosmosPatchOperations add(String path, T value) {
        Preconditions.checkArgument(StringUtils.isNotEmpty(path), "path empty %s", (Object)path);
        this.patchOperations.add(new PatchOperationCore<T>(PatchOperationType.ADD, path, value));
        return this;
    }

    public CosmosPatchOperations remove(String path) {
        Preconditions.checkArgument(StringUtils.isNotEmpty(path), "path empty %s", (Object)path);
        this.patchOperations.add(new PatchOperationCore<Object>(PatchOperationType.REMOVE, path, null));
        return this;
    }

    public <T> CosmosPatchOperations replace(String path, T value) {
        Preconditions.checkArgument(StringUtils.isNotEmpty(path), "path empty %s", (Object)path);
        this.patchOperations.add(new PatchOperationCore<T>(PatchOperationType.REPLACE, path, value));
        return this;
    }

    public <T> CosmosPatchOperations set(String path, T value) {
        Preconditions.checkArgument(StringUtils.isNotEmpty(path), "path empty %s", (Object)path);
        this.patchOperations.add(new PatchOperationCore<T>(PatchOperationType.SET, path, value));
        return this;
    }

    public CosmosPatchOperations increment(String path, long value) {
        Preconditions.checkArgument(StringUtils.isNotEmpty(path), "path empty %s", (Object)path);
        this.patchOperations.add(new PatchOperationCore<Long>(PatchOperationType.INCREMENT, path, value));
        return this;
    }

    public CosmosPatchOperations increment(String path, double value) {
        Preconditions.checkArgument(StringUtils.isNotEmpty(path), "path empty %s", (Object)path);
        this.patchOperations.add(new PatchOperationCore<Double>(PatchOperationType.INCREMENT, path, value));
        return this;
    }

    List<PatchOperation> getPatchOperations() {
        return this.patchOperations;
    }

    static {
        ImplementationBridgeHelpers.CosmosPatchOperationsHelper.setCosmosPatchOperationsAccessor(new ImplementationBridgeHelpers.CosmosPatchOperationsHelper.CosmosPatchOperationsAccessor(){

            @Override
            public List<PatchOperation> getPatchOperations(CosmosPatchOperations cosmosPatchOperations) {
                return cosmosPatchOperations.getPatchOperations();
            }
        });
    }
}

