/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity;

import com.azure.cosmos.implementation.RequestTimeline;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdChannelAcquisitionTimeline;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdEndpointStatistics;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreResponse {
    static final Logger LOGGER = LoggerFactory.getLogger(StoreResponse.class);
    private final int status;
    private final String[] responseHeaderNames;
    private final String[] responseHeaderValues;
    private final byte[] content;
    private int pendingRequestQueueSize;
    private int requestPayloadLength;
    private int responsePayloadLength;
    private RequestTimeline requestTimeline;
    private RntbdChannelAcquisitionTimeline channelAcquisitionTimeline;
    private int rntbdChannelTaskQueueSize;
    private RntbdEndpointStatistics rntbdEndpointStatistics;
    private int rntbdRequestLength;
    private int rntbdResponseLength;

    public StoreResponse(int status, List<Map.Entry<String, String>> headerEntries, byte[] content) {
        this.requestTimeline = RequestTimeline.empty();
        this.responseHeaderNames = new String[headerEntries.size()];
        this.responseHeaderValues = new String[headerEntries.size()];
        int i = 0;
        for (Map.Entry<String, String> headerEntry : headerEntries) {
            this.responseHeaderNames[i] = headerEntry.getKey();
            this.responseHeaderValues[i] = headerEntry.getValue();
            ++i;
        }
        this.status = status;
        this.content = content;
        if (this.content != null) {
            this.responsePayloadLength = this.content.length;
        }
    }

    public int getStatus() {
        return this.status;
    }

    public String[] getResponseHeaderNames() {
        return this.responseHeaderNames;
    }

    public String[] getResponseHeaderValues() {
        return this.responseHeaderValues;
    }

    public int getRntbdChannelTaskQueueSize() {
        return this.rntbdChannelTaskQueueSize;
    }

    public void setRntbdChannelTaskQueueSize(int rntbdChannelTaskQueueSize) {
        this.rntbdChannelTaskQueueSize = rntbdChannelTaskQueueSize;
    }

    public int getPendingRequestQueueSize() {
        return this.pendingRequestQueueSize;
    }

    public void setRntbdPendingRequestSize(int pendingRequestQueueSize) {
        this.pendingRequestQueueSize = pendingRequestQueueSize;
    }

    public void setRntbdRequestLength(int rntbdRequestLength) {
        this.rntbdRequestLength = rntbdRequestLength;
    }

    public void setRntbdResponseLength(int rntbdResponseLength) {
        this.rntbdResponseLength = rntbdResponseLength;
    }

    public int getRntbdRequestLength() {
        return this.rntbdRequestLength;
    }

    public int getRntbdResponseLength() {
        return this.rntbdResponseLength;
    }

    public int getRequestPayloadLength() {
        return this.requestPayloadLength;
    }

    public void setRequestPayloadLength(int requestPayloadLength) {
        this.requestPayloadLength = requestPayloadLength;
    }

    public byte[] getResponseBody() {
        return this.content;
    }

    public int getResponseBodyLength() {
        return this.responsePayloadLength;
    }

    public long getLSN() {
        String lsnString = this.getHeaderValue("lsn");
        if (StringUtils.isNotEmpty(lsnString)) {
            return Long.parseLong(lsnString);
        }
        return -1L;
    }

    public String getPartitionKeyRangeId() {
        return this.getHeaderValue("x-ms-documentdb-partitionkeyrangeid");
    }

    public String getContinuation() {
        return this.getHeaderValue("x-ms-continuation");
    }

    public String getHeaderValue(String attribute) {
        if (this.responseHeaderValues == null || this.responseHeaderNames.length != this.responseHeaderValues.length) {
            return null;
        }
        for (int i = 0; i < this.responseHeaderNames.length; ++i) {
            if (!this.responseHeaderNames[i].equalsIgnoreCase(attribute)) continue;
            return this.responseHeaderValues[i];
        }
        return null;
    }

    public double getRequestCharge() {
        String value = this.getHeaderValue("x-ms-request-charge");
        if (StringUtils.isEmpty(value)) {
            return 0.0;
        }
        return Double.parseDouble(value);
    }

    public static StoreResponse createSerializableStoreResponse(StoreResponse storeResponse) {
        if (storeResponse == null) {
            return null;
        }
        return new StoreResponse(storeResponse);
    }

    void setRequestTimeline(RequestTimeline requestTimeline) {
        this.requestTimeline = requestTimeline;
    }

    RequestTimeline getRequestTimeline() {
        return this.requestTimeline;
    }

    void setChannelAcquisitionTimeline(RntbdChannelAcquisitionTimeline channelAcquisitionTimeline) {
        this.channelAcquisitionTimeline = channelAcquisitionTimeline;
    }

    RntbdChannelAcquisitionTimeline getChannelAcquisitionTimeline() {
        return this.channelAcquisitionTimeline;
    }

    void setEndpointStatistics(RntbdEndpointStatistics rntbdEndpointStatistics) {
        this.rntbdEndpointStatistics = rntbdEndpointStatistics;
    }

    RntbdEndpointStatistics getEndpointStsts() {
        return this.rntbdEndpointStatistics;
    }

    int getSubStatusCode() {
        int subStatusCode = 0;
        String subStatusCodeString = this.getHeaderValue("x-ms-substatus");
        if (StringUtils.isNotEmpty(subStatusCodeString)) {
            try {
                subStatusCode = Integer.parseInt(subStatusCodeString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return subStatusCode;
    }

    private StoreResponse(StoreResponse storeResponse) {
        this.responseHeaderValues = null;
        this.responseHeaderNames = null;
        this.content = null;
        this.status = storeResponse.status;
        this.pendingRequestQueueSize = storeResponse.pendingRequestQueueSize;
        this.requestPayloadLength = storeResponse.requestPayloadLength;
        this.responsePayloadLength = storeResponse.responsePayloadLength;
        this.requestTimeline = storeResponse.requestTimeline;
        this.channelAcquisitionTimeline = storeResponse.channelAcquisitionTimeline;
        this.rntbdChannelTaskQueueSize = storeResponse.rntbdChannelTaskQueueSize;
        this.rntbdEndpointStatistics = storeResponse.rntbdEndpointStatistics;
        this.rntbdRequestLength = storeResponse.rntbdRequestLength;
        this.rntbdResponseLength = storeResponse.rntbdResponseLength;
    }
}

