/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.spark.OperationContextAndListenerTuple;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

abstract class Fetcher<T> {
    private static final Logger logger = LoggerFactory.getLogger(Fetcher.class);
    private final Function<RxDocumentServiceRequest, Mono<FeedResponse<T>>> executeFunc;
    private final boolean isChangeFeed;
    private final OperationContextAndListenerTuple operationContext;
    private Supplier<String> operationContextTextProvider;
    private volatile boolean shouldFetchMore;
    private volatile int maxItemCount;
    private volatile int top;

    public Fetcher(Function<RxDocumentServiceRequest, Mono<FeedResponse<T>>> executeFunc, boolean isChangeFeed, int top, int maxItemCount, OperationContextAndListenerTuple operationContext) {
        Preconditions.checkNotNull(executeFunc, "Argument 'executeFunc' must not be null.");
        this.executeFunc = executeFunc;
        this.isChangeFeed = isChangeFeed;
        this.operationContext = operationContext;
        this.operationContextTextProvider = () -> {
            String operationContextText = operationContext != null && operationContext.getOperationContext() != null ? operationContext.getOperationContext().toString() : "n/a";
            this.operationContextTextProvider = () -> operationContextText;
            return operationContextText;
        };
        this.top = top;
        this.maxItemCount = top == -1 ? maxItemCount : Math.min(maxItemCount, top);
        this.shouldFetchMore = true;
    }

    public final boolean shouldFetchMore() {
        return this.shouldFetchMore;
    }

    public Mono<FeedResponse<T>> nextPage() {
        return this.nextPageCore();
    }

    protected final Mono<FeedResponse<T>> nextPageCore() {
        RxDocumentServiceRequest request = this.createRequest();
        return this.nextPage(request);
    }

    protected abstract String applyServerResponseContinuation(String var1, RxDocumentServiceRequest var2);

    protected abstract boolean isFullyDrained(boolean var1, FeedResponse<T> var2);

    protected abstract String getContinuationForLogging();

    public String getOperationContextText() {
        return this.operationContextTextProvider.get();
    }

    private void updateState(FeedResponse<T> response, RxDocumentServiceRequest request) {
        String transformedContinuation = this.applyServerResponseContinuation(response.getContinuationToken(), request);
        ModelBridgeInternal.setFeedResponseContinuationToken(transformedContinuation, response);
        if (this.top != -1) {
            this.top -= response.getResults().size();
            if (this.top < 0) {
                logger.warn("Azure Cosmos DB BackEnd Service returned more than requested {} items, Context: {}", (Object)this.maxItemCount, (Object)this.operationContextTextProvider.get());
                this.top = 0;
            }
            this.maxItemCount = Math.min(this.maxItemCount, this.top);
        }
        boolean bl = this.shouldFetchMore = this.shouldFetchMore && this.top != 0 && !this.isFullyDrained(this.isChangeFeed, response);
        if (logger.isDebugEnabled()) {
            logger.debug("Fetcher state updated: isChangeFeed = {}, continuation token = {}, max item count = {}, should fetch more = {}, Context: {}", new Object[]{this.isChangeFeed, this.getContinuationForLogging(), this.maxItemCount, this.shouldFetchMore, this.operationContextTextProvider.get()});
        }
    }

    protected void reenableShouldFetchMoreForRetry() {
        this.shouldFetchMore = true;
    }

    private RxDocumentServiceRequest createRequest() {
        if (!this.shouldFetchMore) {
            logger.error("invalid state, trying to fetch more after completion, Context: {}", (Object)this.operationContextTextProvider.get());
            throw new IllegalStateException("INVALID state, trying to fetch more after completion");
        }
        return this.createRequest(this.maxItemCount);
    }

    protected abstract RxDocumentServiceRequest createRequest(int var1);

    private Mono<FeedResponse<T>> nextPage(RxDocumentServiceRequest request) {
        return this.executeFunc.apply(request).map(rsp -> {
            this.updateState((FeedResponse<T>)rsp, request);
            return rsp;
        });
    }
}

