/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.CosmosAsyncUser;
import com.azure.cosmos.models.CosmosPermissionProperties;
import com.azure.cosmos.models.CosmosPermissionRequestOptions;
import com.azure.cosmos.models.CosmosPermissionResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import reactor.core.publisher.Mono;

public class CosmosAsyncPermission {
    private final CosmosAsyncUser cosmosUser;
    private String id;

    CosmosAsyncPermission(String id, CosmosAsyncUser user) {
        this.id = id;
        this.cosmosUser = user;
    }

    public String getId() {
        return this.id;
    }

    CosmosAsyncPermission setId(String id) {
        this.id = id;
        return this;
    }

    public Mono<CosmosPermissionResponse> read(CosmosPermissionRequestOptions options) {
        if (options == null) {
            options = new CosmosPermissionRequestOptions();
        }
        CosmosPermissionRequestOptions requestOptions = options;
        return FluxUtil.withContext(context -> this.readInternal(requestOptions, (Context)context));
    }

    public Mono<CosmosPermissionResponse> replace(CosmosPermissionProperties permissionProperties, CosmosPermissionRequestOptions options) {
        if (options == null) {
            options = new CosmosPermissionRequestOptions();
        }
        CosmosPermissionRequestOptions requestOptions = options;
        return FluxUtil.withContext(context -> this.replaceInternal(permissionProperties, requestOptions, (Context)context));
    }

    public Mono<CosmosPermissionResponse> delete(CosmosPermissionRequestOptions options) {
        if (options == null) {
            options = new CosmosPermissionRequestOptions();
        }
        CosmosPermissionRequestOptions requestOptions = options;
        return FluxUtil.withContext(context -> this.deleteInternal(requestOptions, (Context)context));
    }

    String getURIPathSegment() {
        return "permissions";
    }

    String getParentLink() {
        return this.cosmosUser.getLink();
    }

    String getLink() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getParentLink());
        builder.append("/");
        builder.append(this.getURIPathSegment());
        builder.append("/");
        builder.append(this.getId());
        return builder.toString();
    }

    private Mono<CosmosPermissionResponse> readInternal(CosmosPermissionRequestOptions options, Context context) {
        String spanName = "readPermission." + this.cosmosUser.getId();
        Mono responseMono = this.cosmosUser.getDatabase().getDocClientWrapper().readPermission(this.getLink(), ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosPermissionResponse(response));
        return this.cosmosUser.getDatabase().getClient().getTracerProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.cosmosUser.getDatabase().getId(), this.cosmosUser.getDatabase().getClient().getServiceEndpoint());
    }

    private Mono<CosmosPermissionResponse> replaceInternal(CosmosPermissionProperties permissionProperties, CosmosPermissionRequestOptions options, Context context) {
        String spanName = "replacePermission." + this.cosmosUser.getId();
        CosmosAsyncDatabase databaseContext = this.cosmosUser.getDatabase();
        Mono responseMono = this.cosmosUser.getDatabase().getDocClientWrapper().replacePermission(ModelBridgeInternal.getPermission(permissionProperties, databaseContext.getId()), ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosPermissionResponse(response));
        return this.cosmosUser.getDatabase().getClient().getTracerProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.cosmosUser.getDatabase().getId(), this.cosmosUser.getDatabase().getClient().getServiceEndpoint());
    }

    private Mono<CosmosPermissionResponse> deleteInternal(CosmosPermissionRequestOptions options, Context context) {
        String spanName = "deletePermission." + this.cosmosUser.getId();
        Mono responseMono = this.cosmosUser.getDatabase().getDocClientWrapper().deletePermission(this.getLink(), ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosPermissionResponse(response));
        return this.cosmosUser.getDatabase().getClient().getTracerProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.cosmosUser.getDatabase().getId(), this.cosmosUser.getDatabase().getClient().getServiceEndpoint());
    }
}

