/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.CosmosAsyncPermission;
import com.azure.cosmos.implementation.Permission;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.models.CosmosPermissionProperties;
import com.azure.cosmos.models.CosmosPermissionRequestOptions;
import com.azure.cosmos.models.CosmosPermissionResponse;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.CosmosUserProperties;
import com.azure.cosmos.models.CosmosUserResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.util.CosmosPagedFlux;
import com.azure.cosmos.util.UtilBridgeInternal;
import reactor.core.publisher.Mono;

public class CosmosAsyncUser {
    private final CosmosAsyncDatabase database;
    private String id;

    CosmosAsyncUser(String id, CosmosAsyncDatabase database) {
        this.id = id;
        this.database = database;
    }

    public String getId() {
        return this.id;
    }

    CosmosAsyncUser setId(String id) {
        this.id = id;
        return this;
    }

    public Mono<CosmosUserResponse> read() {
        return FluxUtil.withContext(context -> this.readInternal((Context)context));
    }

    public Mono<CosmosUserResponse> replace(CosmosUserProperties userProperties) {
        return FluxUtil.withContext(context -> this.replaceInternal(userProperties, (Context)context));
    }

    public Mono<CosmosUserResponse> delete() {
        return FluxUtil.withContext(context -> this.deleteInternal((Context)context));
    }

    public Mono<CosmosPermissionResponse> createPermission(CosmosPermissionProperties permissionProperties, CosmosPermissionRequestOptions options) {
        CosmosPermissionRequestOptions requestOptions = options == null ? new CosmosPermissionRequestOptions() : options;
        Permission permission = ModelBridgeInternal.getPermission(permissionProperties, this.database.getId());
        return FluxUtil.withContext(context -> this.createPermissionInternal(permission, requestOptions, (Context)context));
    }

    public Mono<CosmosPermissionResponse> upsertPermission(CosmosPermissionProperties permissionProperties, CosmosPermissionRequestOptions options) {
        Permission permission = ModelBridgeInternal.getPermission(permissionProperties, this.database.getId());
        CosmosPermissionRequestOptions requestOptions = options == null ? new CosmosPermissionRequestOptions() : options;
        return FluxUtil.withContext(context -> this.upsertPermissionInternal(permission, requestOptions, (Context)context));
    }

    public CosmosPagedFlux<CosmosPermissionProperties> readAllPermissions() {
        return this.readAllPermissions(new CosmosQueryRequestOptions());
    }

    CosmosPagedFlux<CosmosPermissionProperties> readAllPermissions(CosmosQueryRequestOptions options) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            String spanName = "readAllPermissions." + this.getId();
            pagedFluxOptions.setTracerInformation(this.getDatabase().getClient().getTracerProvider(), spanName, this.getDatabase().getClient().getServiceEndpoint(), this.getDatabase().getId());
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, options);
            return this.getDatabase().getDocClientWrapper().readPermissions(this.getLink(), options).map(response -> BridgeInternal.createFeedResponse(ModelBridgeInternal.getCosmosPermissionPropertiesFromResults(response.getResults()), response.getResponseHeaders()));
        });
    }

    public CosmosPagedFlux<CosmosPermissionProperties> queryPermissions(String query) {
        return this.queryPermissions(query, new CosmosQueryRequestOptions());
    }

    public CosmosPagedFlux<CosmosPermissionProperties> queryPermissions(String query, CosmosQueryRequestOptions options) {
        CosmosQueryRequestOptions requestOptions = options == null ? new CosmosQueryRequestOptions() : options;
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            String spanName = "queryPermissions." + this.getId();
            pagedFluxOptions.setTracerInformation(this.getDatabase().getClient().getTracerProvider(), spanName, this.getDatabase().getClient().getServiceEndpoint(), this.getDatabase().getId());
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, requestOptions);
            return this.getDatabase().getDocClientWrapper().queryPermissions(this.getLink(), query, requestOptions).map(response -> BridgeInternal.createFeedResponse(ModelBridgeInternal.getCosmosPermissionPropertiesFromResults(response.getResults()), response.getResponseHeaders()));
        });
    }

    public CosmosAsyncPermission getPermission(String id) {
        return new CosmosAsyncPermission(id, this);
    }

    String getURIPathSegment() {
        return "users";
    }

    String getParentLink() {
        return this.database.getLink();
    }

    String getLink() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getParentLink());
        builder.append("/");
        builder.append(this.getURIPathSegment());
        builder.append("/");
        builder.append(this.getId());
        return builder.toString();
    }

    CosmosAsyncDatabase getDatabase() {
        return this.database;
    }

    private Mono<CosmosUserResponse> readInternal(Context context) {
        String spanName = "readUser." + this.getId();
        Mono responseMono = this.database.getDocClientWrapper().readUser(this.getLink(), null).map(response -> ModelBridgeInternal.createCosmosUserResponse(response));
        return this.database.getClient().getTracerProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.database.getId(), this.database.getClient().getServiceEndpoint());
    }

    private Mono<CosmosUserResponse> replaceInternal(CosmosUserProperties userSettings, Context context) {
        String spanName = "replaceUser." + this.getId();
        Mono responseMono = this.database.getDocClientWrapper().replaceUser(ModelBridgeInternal.getV2User(userSettings), null).map(response -> ModelBridgeInternal.createCosmosUserResponse(response));
        return this.database.getClient().getTracerProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.database.getId(), this.database.getClient().getServiceEndpoint());
    }

    private Mono<CosmosUserResponse> deleteInternal(Context context) {
        String spanName = "deleteUser." + this.getId();
        Mono responseMono = this.database.getDocClientWrapper().deleteUser(this.getLink(), null).map(response -> ModelBridgeInternal.createCosmosUserResponse(response));
        return this.database.getClient().getTracerProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.database.getId(), this.database.getClient().getServiceEndpoint());
    }

    private Mono<CosmosPermissionResponse> createPermissionInternal(Permission permission, CosmosPermissionRequestOptions options, Context context) {
        String spanName = "createPermission." + this.getId();
        Mono responseMono = this.database.getDocClientWrapper().createPermission(this.getLink(), permission, ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosPermissionResponse(response));
        return this.database.getClient().getTracerProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.database.getId(), this.database.getClient().getServiceEndpoint());
    }

    private Mono<CosmosPermissionResponse> upsertPermissionInternal(Permission permission, CosmosPermissionRequestOptions options, Context context) {
        String spanName = "upsertPermission." + this.getId();
        Mono responseMono = this.database.getDocClientWrapper().upsertPermission(this.getLink(), permission, ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosPermissionResponse(response));
        return this.database.getClient().getTracerProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.database.getId(), this.database.getClient().getServiceEndpoint());
    }
}

