/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.implementation.UserDefinedFunction;
import com.azure.cosmos.models.CosmosUserDefinedFunctionProperties;
import com.azure.cosmos.models.CosmosUserDefinedFunctionResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import reactor.core.publisher.Mono;

public class CosmosAsyncUserDefinedFunction {
    private final CosmosAsyncContainer container;
    private String id;

    CosmosAsyncUserDefinedFunction(String id, CosmosAsyncContainer container) {
        this.id = id;
        this.container = container;
    }

    public String getId() {
        return this.id;
    }

    CosmosAsyncUserDefinedFunction setId(String id) {
        this.id = id;
        return this;
    }

    public Mono<CosmosUserDefinedFunctionResponse> read() {
        return FluxUtil.withContext(context -> this.readInternal((Context)context));
    }

    public Mono<CosmosUserDefinedFunctionResponse> replace(CosmosUserDefinedFunctionProperties udfSettings) {
        return FluxUtil.withContext(context -> this.replaceInternal(udfSettings, (Context)context));
    }

    public Mono<CosmosUserDefinedFunctionResponse> delete() {
        return FluxUtil.withContext(context -> this.deleteInternal((Context)context));
    }

    String getURIPathSegment() {
        return "udfs";
    }

    String getParentLink() {
        return this.container.getLink();
    }

    String getLink() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getParentLink());
        builder.append("/");
        builder.append(this.getURIPathSegment());
        builder.append("/");
        builder.append(this.getId());
        return builder.toString();
    }

    private Mono<CosmosUserDefinedFunctionResponse> readInternal(Context context) {
        String spanName = "readUserDefinedFunction." + this.container.getId();
        Mono responseMono = this.container.getDatabase().getDocClientWrapper().readUserDefinedFunction(this.getLink(), null).map(response -> ModelBridgeInternal.createCosmosUserDefinedFunctionResponse(response));
        return this.container.getDatabase().getClient().getTracerProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.container.getDatabase().getId(), this.container.getDatabase().getClient().getServiceEndpoint());
    }

    private Mono<CosmosUserDefinedFunctionResponse> replaceInternal(CosmosUserDefinedFunctionProperties udfSettings, Context context) {
        String spanName = "replaceUserDefinedFunction." + this.container.getId();
        Mono responseMono = this.container.getDatabase().getDocClientWrapper().replaceUserDefinedFunction(new UserDefinedFunction(ModelBridgeInternal.toJsonFromJsonSerializable(ModelBridgeInternal.getResource(udfSettings))), null).map(response -> ModelBridgeInternal.createCosmosUserDefinedFunctionResponse(response)).single();
        return this.container.getDatabase().getClient().getTracerProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.container.getDatabase().getId(), this.container.getDatabase().getClient().getServiceEndpoint());
    }

    private Mono<CosmosUserDefinedFunctionResponse> deleteInternal(Context context) {
        String spanName = "deleteUserDefinedFunction." + this.container.getId();
        Mono responseMono = this.container.getDatabase().getDocClientWrapper().deleteUserDefinedFunction(this.getLink(), null).map(response -> ModelBridgeInternal.createCosmosUserDefinedFunctionResponse(response)).single();
        return this.container.getDatabase().getClient().getTracerProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.container.getDatabase().getId(), this.container.getDatabase().getClient().getServiceEndpoint());
    }
}

