/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.ClientSideRequestStatistics;
import com.azure.cosmos.implementation.FeedResponseDiagnostics;
import com.azure.cosmos.implementation.Utils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CosmosDiagnostics {
    private static final Logger LOGGER = LoggerFactory.getLogger(CosmosDiagnostics.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private ClientSideRequestStatistics clientSideRequestStatistics;
    private FeedResponseDiagnostics feedResponseDiagnostics;
    static final String USER_AGENT = Utils.getUserAgent();

    CosmosDiagnostics() {
        this.clientSideRequestStatistics = new ClientSideRequestStatistics();
    }

    CosmosDiagnostics(FeedResponseDiagnostics feedResponseDiagnostics) {
        this.feedResponseDiagnostics = feedResponseDiagnostics;
    }

    ClientSideRequestStatistics clientSideRequestStatistics() {
        return this.clientSideRequestStatistics;
    }

    CosmosDiagnostics clientSideRequestStatistics(ClientSideRequestStatistics clientSideRequestStatistics) {
        this.clientSideRequestStatistics = clientSideRequestStatistics;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.feedResponseDiagnostics != null) {
            stringBuilder.append("userAgent=").append(USER_AGENT).append(System.lineSeparator());
            stringBuilder.append(this.feedResponseDiagnostics);
        } else {
            try {
                stringBuilder.append(OBJECT_MAPPER.writeValueAsString((Object)this.clientSideRequestStatistics));
            }
            catch (JsonProcessingException e) {
                LOGGER.error("Error while parsing diagnostics " + (Object)((Object)e));
            }
        }
        return stringBuilder.toString();
    }

    public Duration getDuration() {
        if (this.feedResponseDiagnostics != null) {
            return null;
        }
        return this.clientSideRequestStatistics.getDuration();
    }
}

