/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.implementation.IRetryPolicy;
import com.azure.cosmos.implementation.ISessionToken;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.RequestChargeTracker;
import com.azure.cosmos.implementation.RetryContext;
import com.azure.cosmos.implementation.directconnectivity.StoreResponse;
import com.azure.cosmos.implementation.directconnectivity.StoreResult;
import com.azure.cosmos.implementation.directconnectivity.TimeoutHelper;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DocumentServiceRequestContext
implements Cloneable {
    public volatile boolean forceAddressRefresh;
    public volatile boolean forceRefreshAddressCache;
    public volatile RequestChargeTracker requestChargeTracker;
    public volatile TimeoutHelper timeoutHelper;
    public volatile String resolvedCollectionRid;
    public volatile ISessionToken sessionToken;
    public volatile long quorumSelectedLSN;
    public volatile long globalCommittedSelectedLSN;
    public volatile StoreResponse globalStrongWriteResponse;
    public volatile ConsistencyLevel originalRequestConsistencyLevel;
    public volatile PartitionKeyRange resolvedPartitionKeyRange;
    public volatile Integer regionIndex;
    public volatile Boolean usePreferredLocations;
    public volatile Integer locationIndexToRoute;
    public volatile URI locationEndpointToRoute;
    public volatile boolean performedBackgroundAddressRefresh;
    public volatile boolean performLocalRefreshOnGoneException;
    public volatile List<String> storeResponses;
    public volatile StoreResult quorumSelectedStoreResponse;
    public volatile PartitionKeyInternal effectivePartitionKey;
    public volatile CosmosDiagnostics cosmosDiagnostics;
    public RetryContext retryContext = new RetryContext();

    public void routeToLocation(int locationIndex, boolean usePreferredLocations) {
        this.locationIndexToRoute = locationIndex;
        this.usePreferredLocations = usePreferredLocations;
        this.locationEndpointToRoute = null;
    }

    public void routeToLocation(URI locationEndpoint) {
        this.locationEndpointToRoute = locationEndpoint;
        this.locationIndexToRoute = null;
        this.usePreferredLocations = null;
    }

    public void clearRouteToLocation() {
        this.locationIndexToRoute = null;
        this.locationEndpointToRoute = null;
        this.usePreferredLocations = null;
    }

    public void updateRetryContext(IRetryPolicy retryPolicy, boolean isGenericRetry) {
        if (isGenericRetry) {
            if (this.retryContext.directRetrySpecificStatusAndSubStatusCodes != null && this.retryContext.directRetrySpecificStatusAndSubStatusCodes.size() > 0) {
                for (int i = this.retryContext.directRetrySpecificStatusAndSubStatusCodes.size() - 1; i >= 0; --i) {
                    retryPolicy.incrementRetry();
                    retryPolicy.addStatusAndSubStatusCode(0, this.retryContext.directRetrySpecificStatusAndSubStatusCodes.get(i)[0], this.retryContext.directRetrySpecificStatusAndSubStatusCodes.get(i)[1]);
                }
                this.retryContext.directRetrySpecificStatusAndSubStatusCodes.clear();
            }
            this.retryContext.genericRetrySpecificStatusAndSubStatusCodes = retryPolicy.getStatusAndSubStatusCodes() != null ? Collections.synchronizedList(new ArrayList<int[]>(retryPolicy.getStatusAndSubStatusCodes())) : Collections.synchronizedList(new ArrayList());
            this.retryContext.retryCount = retryPolicy.getRetryCount();
            this.retryContext.statusAndSubStatusCodes = retryPolicy.getStatusAndSubStatusCodes();
            if (this.retryContext.retryStartTime == null) {
                this.retryContext.retryStartTime = retryPolicy.getStartTime();
            }
            this.retryContext.retryEndTime = retryPolicy.getEndTime();
        } else {
            if (this.retryContext.genericRetrySpecificStatusAndSubStatusCodes != null && this.retryContext.genericRetrySpecificStatusAndSubStatusCodes.size() > 0) {
                for (int i = this.retryContext.genericRetrySpecificStatusAndSubStatusCodes.size() - 1; i >= 0; --i) {
                    retryPolicy.incrementRetry();
                    retryPolicy.addStatusAndSubStatusCode(0, this.retryContext.genericRetrySpecificStatusAndSubStatusCodes.get(i)[0], this.retryContext.genericRetrySpecificStatusAndSubStatusCodes.get(i)[1]);
                }
                this.retryContext.genericRetrySpecificStatusAndSubStatusCodes.clear();
            }
            this.retryContext.directRetrySpecificStatusAndSubStatusCodes = retryPolicy.getStatusAndSubStatusCodes() != null ? Collections.synchronizedList(new ArrayList<int[]>(retryPolicy.getStatusAndSubStatusCodes())) : Collections.synchronizedList(new ArrayList());
            this.retryContext.retryCount = retryPolicy.getRetryCount();
            this.retryContext.statusAndSubStatusCodes = retryPolicy.getStatusAndSubStatusCodes();
            if (this.retryContext.retryStartTime == null) {
                this.retryContext.retryStartTime = retryPolicy.getStartTime();
            }
            this.retryContext.retryEndTime = retryPolicy.getEndTime();
        }
    }

    public DocumentServiceRequestContext clone() {
        DocumentServiceRequestContext context = new DocumentServiceRequestContext();
        context.forceAddressRefresh = this.forceAddressRefresh;
        context.forceRefreshAddressCache = this.forceRefreshAddressCache;
        context.requestChargeTracker = this.requestChargeTracker;
        context.timeoutHelper = this.timeoutHelper;
        context.resolvedCollectionRid = this.resolvedCollectionRid;
        context.sessionToken = this.sessionToken;
        context.quorumSelectedLSN = this.quorumSelectedLSN;
        context.globalCommittedSelectedLSN = this.globalCommittedSelectedLSN;
        context.globalStrongWriteResponse = this.globalStrongWriteResponse;
        context.originalRequestConsistencyLevel = this.originalRequestConsistencyLevel;
        context.resolvedPartitionKeyRange = this.resolvedPartitionKeyRange;
        context.regionIndex = this.regionIndex;
        context.usePreferredLocations = this.usePreferredLocations;
        context.locationIndexToRoute = this.locationIndexToRoute;
        context.locationEndpointToRoute = this.locationEndpointToRoute;
        context.performLocalRefreshOnGoneException = this.performLocalRefreshOnGoneException;
        context.effectivePartitionKey = this.effectivePartitionKey;
        context.performedBackgroundAddressRefresh = this.performedBackgroundAddressRefresh;
        context.cosmosDiagnostics = this.cosmosDiagnostics;
        context.retryContext = new RetryContext(this.retryContext);
        return context;
    }
}

