/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.Quadruple;
import com.azure.cosmos.implementation.Utils;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import reactor.core.publisher.Mono;

public interface IRetryPolicy {
    public Mono<ShouldRetryResult> shouldRetry(Exception var1);

    public int getRetryCount();

    public void incrementRetry();

    public void captureStartTimeIfNotSet();

    public void updateEndTime();

    public Duration getRetryLatency();

    public Instant getStartTime();

    public Instant getEndTime();

    public void addStatusAndSubStatusCode(Integer var1, int var2, int var3);

    public List<int[]> getStatusAndSubStatusCodes();

    public static class ShouldRetryResult {
        public final Duration backOffTime;
        public final Exception exception;
        public boolean shouldRetry;
        public final Quadruple<Boolean, Boolean, Duration, Integer> policyArg;

        private ShouldRetryResult(Duration dur, Exception e, boolean shouldRetry, Quadruple<Boolean, Boolean, Duration, Integer> policyArg) {
            this.backOffTime = dur;
            this.exception = e;
            this.shouldRetry = shouldRetry;
            this.policyArg = policyArg;
        }

        public static ShouldRetryResult retryAfter(Duration dur) {
            Utils.checkNotNullOrThrow(dur, "duration", "cannot be null");
            return new ShouldRetryResult(dur, null, true, null);
        }

        public static ShouldRetryResult retryAfter(Duration dur, Quadruple<Boolean, Boolean, Duration, Integer> policyArg) {
            Utils.checkNotNullOrThrow(dur, "duration", "cannot be null");
            return new ShouldRetryResult(dur, null, true, policyArg);
        }

        public static ShouldRetryResult error(Exception e) {
            Utils.checkNotNullOrThrow(e, "exception", "cannot be null");
            return new ShouldRetryResult(null, e, false, null);
        }

        public static ShouldRetryResult noRetry() {
            return new ShouldRetryResult(null, null, false, null);
        }

        public void throwIfDoneTrying(Exception capturedException) throws Exception {
            if (this.shouldRetry) {
                return;
            }
            if (this.exception == null) {
                throw capturedException;
            }
            throw this.exception;
        }
    }
}

