/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.CosmosError;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.directconnectivity.HttpUtils;
import com.azure.cosmos.implementation.http.HttpHeaders;
import java.net.URI;
import java.util.Map;

public class RequestTimeoutException
extends CosmosException {
    public RequestTimeoutException() {
        this("Request timed out.", null);
    }

    public RequestTimeoutException(CosmosError cosmosError, long lsn, String partitionKeyRangeId, Map<String, String> responseHeaders) {
        super(408, cosmosError, responseHeaders);
        BridgeInternal.setLSN(this, lsn);
        BridgeInternal.setPartitionKeyRangeId(this, partitionKeyRangeId);
    }

    public RequestTimeoutException(String message, URI requestUri) {
        this(message, null, null, requestUri);
    }

    RequestTimeoutException(String message, Exception innerException, URI requestUri, String localIpAddress) {
        this(RequestTimeoutException.message(localIpAddress, message), innerException, null, requestUri);
    }

    RequestTimeoutException(Exception innerException) {
        this("The requested resource is no longer available at the server.", innerException, (HttpHeaders)null, null);
    }

    public RequestTimeoutException(String message, HttpHeaders headers, URI requestUrl) {
        super(message, null, HttpUtils.asMap(headers), 408, requestUrl != null ? requestUrl.toString() : null);
    }

    RequestTimeoutException(String message, HttpHeaders headers, String requestUriString) {
        super(message, null, HttpUtils.asMap(headers), 408, requestUriString);
    }

    RequestTimeoutException(String message, Exception innerException, HttpHeaders headers, URI requestUrl) {
        super(message, innerException, HttpUtils.asMap(headers), 408, requestUrl != null ? requestUrl.toString() : null);
    }

    private static String message(String localIP, String baseMessage) {
        if (!Strings.isNullOrEmpty(localIP)) {
            return String.format("%s, Local IP: %s", baseMessage, localIP);
        }
        return baseMessage;
    }
}

