/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.Duration;
import java.time.Instant;
import java.util.List;

public class RetryContext {
    @JsonIgnore
    public List<int[]> directRetrySpecificStatusAndSubStatusCodes;
    @JsonIgnore
    public List<int[]> genericRetrySpecificStatusAndSubStatusCodes;
    @JsonIgnore
    public Instant retryStartTime;
    @JsonIgnore
    public Instant retryEndTime;
    public int retryCount;
    public List<int[]> statusAndSubStatusCodes;

    public RetryContext() {
    }

    public RetryContext(RetryContext retryContext) {
        if (retryContext != null) {
            this.retryCount = retryContext.retryCount;
            this.statusAndSubStatusCodes = retryContext.statusAndSubStatusCodes;
            if (this.retryStartTime == null) {
                this.retryStartTime = retryContext.retryStartTime;
            }
            this.retryEndTime = retryContext.retryEndTime;
        }
    }

    public long getRetryLatency() {
        if (this.retryStartTime != null && this.retryEndTime != null) {
            return Duration.between(this.retryStartTime, this.retryEndTime).toMillis();
        }
        return 0L;
    }
}

