/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.core.credential.AzureKeyCredential;
import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.ConnectionMode;
import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.DirectConnectionConfig;
import com.azure.cosmos.implementation.AsyncDocumentClient;
import com.azure.cosmos.implementation.AuthorizationTokenType;
import com.azure.cosmos.implementation.BaseAuthorizationTokenProvider;
import com.azure.cosmos.implementation.ChangeFeedOptions;
import com.azure.cosmos.implementation.ChangeFeedQueryImpl;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.Conflict;
import com.azure.cosmos.implementation.ConnectionPolicy;
import com.azure.cosmos.implementation.CosmosAuthorizationTokenResolver;
import com.azure.cosmos.implementation.CosmosResourceType;
import com.azure.cosmos.implementation.Database;
import com.azure.cosmos.implementation.DatabaseAccount;
import com.azure.cosmos.implementation.DatabaseAccountManagerInternal;
import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.implementation.DocumentClientRetryPolicy;
import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.GlobalEndpointManager;
import com.azure.cosmos.implementation.IAuthorizationTokenProvider;
import com.azure.cosmos.implementation.IRetryPolicyFactory;
import com.azure.cosmos.implementation.ISessionContainer;
import com.azure.cosmos.implementation.InternalObjectNode;
import com.azure.cosmos.implementation.InvalidPartitionExceptionRetryPolicy;
import com.azure.cosmos.implementation.ItemDeserializer;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.LifeCycleUtils;
import com.azure.cosmos.implementation.ObservableHelper;
import com.azure.cosmos.implementation.Offer;
import com.azure.cosmos.implementation.OfferAutoscaleAutoUpgradeProperties;
import com.azure.cosmos.implementation.OfferAutoscaleSettings;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.PartitionKeyMismatchRetryPolicy;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.PathInfo;
import com.azure.cosmos.implementation.PathParser;
import com.azure.cosmos.implementation.PathsHelper;
import com.azure.cosmos.implementation.Permission;
import com.azure.cosmos.implementation.QueryCompatibilityMode;
import com.azure.cosmos.implementation.RequestOptions;
import com.azure.cosmos.implementation.RequestVerb;
import com.azure.cosmos.implementation.ResetSessionTokenRetryPolicyFactory;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.ResourceResponse;
import com.azure.cosmos.implementation.ResourceTokenAuthorizationHelper;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RetryPolicy;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.RxDocumentServiceResponse;
import com.azure.cosmos.implementation.RxGatewayStoreModel;
import com.azure.cosmos.implementation.RxStoreModel;
import com.azure.cosmos.implementation.SerializationDiagnosticsContext;
import com.azure.cosmos.implementation.SessionContainer;
import com.azure.cosmos.implementation.StoredProcedure;
import com.azure.cosmos.implementation.StoredProcedureResponse;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.Trigger;
import com.azure.cosmos.implementation.User;
import com.azure.cosmos.implementation.UserAgentContainer;
import com.azure.cosmos.implementation.UserDefinedFunction;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.apachecommons.lang.tuple.Pair;
import com.azure.cosmos.implementation.caches.RxClientCollectionCache;
import com.azure.cosmos.implementation.caches.RxCollectionCache;
import com.azure.cosmos.implementation.caches.RxPartitionKeyRangeCache;
import com.azure.cosmos.implementation.directconnectivity.GatewayServiceConfigurationReader;
import com.azure.cosmos.implementation.directconnectivity.GlobalAddressResolver;
import com.azure.cosmos.implementation.directconnectivity.ServerStoreModel;
import com.azure.cosmos.implementation.directconnectivity.StoreClient;
import com.azure.cosmos.implementation.directconnectivity.StoreClientFactory;
import com.azure.cosmos.implementation.http.HttpClient;
import com.azure.cosmos.implementation.http.HttpClientConfig;
import com.azure.cosmos.implementation.http.SharedGatewayHttpClient;
import com.azure.cosmos.implementation.query.DocumentQueryExecutionContextFactory;
import com.azure.cosmos.implementation.query.IDocumentQueryClient;
import com.azure.cosmos.implementation.query.IDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.Paginator;
import com.azure.cosmos.implementation.query.PipelinedDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.QueryInfo;
import com.azure.cosmos.implementation.routing.CollectionRoutingMap;
import com.azure.cosmos.implementation.routing.PartitionKeyAndResourceTokenPair;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.implementation.routing.PartitionKeyInternalHelper;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.PartitionKeyDefinition;
import com.azure.cosmos.models.SqlParameter;
import com.azure.cosmos.models.SqlQuerySpec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RxDocumentClientImpl
implements AsyncDocumentClient,
IAuthorizationTokenProvider {
    private static final char PREFER_HEADER_SEPERATOR = ';';
    private static final ObjectMapper mapper = Utils.getSimpleObjectMapper();
    private final ItemDeserializer itemDeserializer = new ItemDeserializer.JsonDeserializer();
    private final Logger logger = LoggerFactory.getLogger(RxDocumentClientImpl.class);
    private final String masterKeyOrResourceToken;
    private final URI serviceEndpoint;
    private final ConnectionPolicy connectionPolicy;
    private final ConsistencyLevel consistencyLevel;
    private final BaseAuthorizationTokenProvider authorizationTokenProvider;
    private final UserAgentContainer userAgentContainer;
    private final boolean hasAuthKeyResourceToken;
    private final Configs configs;
    private final boolean connectionSharingAcrossClientsEnabled;
    private AzureKeyCredential credential;
    private CosmosAuthorizationTokenResolver cosmosAuthorizationTokenResolver;
    private SessionContainer sessionContainer;
    private String firstResourceTokenFromPermissionFeed = "";
    private RxClientCollectionCache collectionCache;
    private RxStoreModel gatewayProxy;
    private RxStoreModel storeModel;
    private GlobalAddressResolver addressResolver;
    private RxPartitionKeyRangeCache partitionKeyRangeCache;
    private Map<String, List<PartitionKeyAndResourceTokenPair>> resourceTokensMap;
    private final boolean contentResponseOnWriteEnabled;
    private IRetryPolicyFactory resetSessionTokenRetryPolicy;
    private final QueryCompatibilityMode queryCompatibilityMode = QueryCompatibilityMode.Default;
    private final HttpClient reactorHttpClient;
    private final GlobalEndpointManager globalEndpointManager;
    private final RetryPolicy retryPolicy;
    private volatile boolean useMultipleWriteLocations;
    private StoreClientFactory storeClientFactory;
    private GatewayServiceConfigurationReader gatewayConfigurationReader;

    public RxDocumentClientImpl(URI serviceEndpoint, String masterKeyOrResourceToken, List<Permission> permissionFeed, ConnectionPolicy connectionPolicy, ConsistencyLevel consistencyLevel, Configs configs, CosmosAuthorizationTokenResolver cosmosAuthorizationTokenResolver, AzureKeyCredential credential, boolean sessionCapturingOverride, boolean connectionSharingAcrossClientsEnabled, boolean contentResponseOnWriteEnabled) {
        this(serviceEndpoint, masterKeyOrResourceToken, permissionFeed, connectionPolicy, consistencyLevel, configs, credential, sessionCapturingOverride, connectionSharingAcrossClientsEnabled, contentResponseOnWriteEnabled);
        this.cosmosAuthorizationTokenResolver = cosmosAuthorizationTokenResolver;
    }

    private RxDocumentClientImpl(URI serviceEndpoint, String masterKeyOrResourceToken, List<Permission> permissionFeed, ConnectionPolicy connectionPolicy, ConsistencyLevel consistencyLevel, Configs configs, AzureKeyCredential credential, boolean sessionCapturingOverrideEnabled, boolean connectionSharingAcrossClientsEnabled, boolean contentResponseOnWriteEnabled) {
        this(serviceEndpoint, masterKeyOrResourceToken, connectionPolicy, consistencyLevel, configs, credential, sessionCapturingOverrideEnabled, connectionSharingAcrossClientsEnabled, contentResponseOnWriteEnabled);
        if (permissionFeed != null && permissionFeed.size() > 0) {
            this.resourceTokensMap = new HashMap<String, List<PartitionKeyAndResourceTokenPair>>();
            for (Permission permission : permissionFeed) {
                PartitionKey partitionKey;
                String[] segments = StringUtils.split(permission.getResourceLink(), "/".charAt(0));
                if (segments.length <= 0) {
                    throw new IllegalArgumentException("resourceLink");
                }
                List<PartitionKeyAndResourceTokenPair> partitionKeyAndResourceTokenPairs = null;
                PathInfo pathInfo = new PathInfo(false, "", "", false);
                if (!PathsHelper.tryParsePathSegments(permission.getResourceLink(), pathInfo, null)) {
                    throw new IllegalArgumentException(permission.getResourceLink());
                }
                partitionKeyAndResourceTokenPairs = this.resourceTokensMap.get(pathInfo.resourceIdOrFullName);
                if (partitionKeyAndResourceTokenPairs == null) {
                    partitionKeyAndResourceTokenPairs = new ArrayList<PartitionKeyAndResourceTokenPair>();
                    this.resourceTokensMap.put(pathInfo.resourceIdOrFullName, partitionKeyAndResourceTokenPairs);
                }
                partitionKeyAndResourceTokenPairs.add(new PartitionKeyAndResourceTokenPair((partitionKey = permission.getResourcePartitionKey()) != null ? BridgeInternal.getPartitionKeyInternal(partitionKey) : PartitionKeyInternal.Empty, permission.getToken()));
                this.logger.debug("Initializing resource token map  , with map key [{}] , partition key [{}] and resource token", new Object[]{pathInfo.resourceIdOrFullName, partitionKey != null ? partitionKey.toString() : null, permission.getToken()});
            }
            if (this.resourceTokensMap.isEmpty()) {
                throw new IllegalArgumentException("permissionFeed");
            }
            String firstToken = permissionFeed.get(0).getToken();
            if (ResourceTokenAuthorizationHelper.isResourceToken(firstToken)) {
                this.firstResourceTokenFromPermissionFeed = firstToken;
            }
        }
    }

    RxDocumentClientImpl(URI serviceEndpoint, String masterKeyOrResourceToken, ConnectionPolicy connectionPolicy, ConsistencyLevel consistencyLevel, Configs configs, AzureKeyCredential credential, boolean sessionCapturingOverrideEnabled, boolean connectionSharingAcrossClientsEnabled, boolean contentResponseOnWriteEnabled) {
        this.logger.info("Initializing DocumentClient with serviceEndpoint [{}], connectionPolicy [{}], consistencyLevel [{}], directModeProtocol [{}]", new Object[]{serviceEndpoint, connectionPolicy, consistencyLevel, configs.getProtocol()});
        this.connectionSharingAcrossClientsEnabled = connectionSharingAcrossClientsEnabled;
        this.configs = configs;
        this.masterKeyOrResourceToken = masterKeyOrResourceToken;
        this.serviceEndpoint = serviceEndpoint;
        this.credential = credential;
        this.contentResponseOnWriteEnabled = contentResponseOnWriteEnabled;
        if (this.credential != null) {
            this.hasAuthKeyResourceToken = false;
            this.authorizationTokenProvider = new BaseAuthorizationTokenProvider(this.credential);
        } else if (masterKeyOrResourceToken != null && ResourceTokenAuthorizationHelper.isResourceToken(masterKeyOrResourceToken)) {
            this.authorizationTokenProvider = null;
            this.hasAuthKeyResourceToken = true;
        } else if (masterKeyOrResourceToken != null && !ResourceTokenAuthorizationHelper.isResourceToken(masterKeyOrResourceToken)) {
            this.credential = new AzureKeyCredential(this.masterKeyOrResourceToken);
            this.hasAuthKeyResourceToken = false;
            this.authorizationTokenProvider = new BaseAuthorizationTokenProvider(this.credential);
        } else {
            this.hasAuthKeyResourceToken = false;
            this.authorizationTokenProvider = null;
        }
        this.connectionPolicy = connectionPolicy != null ? connectionPolicy : new ConnectionPolicy(DirectConnectionConfig.getDefaultConfig());
        boolean disableSessionCapturing = ConsistencyLevel.SESSION != consistencyLevel && !sessionCapturingOverrideEnabled;
        this.sessionContainer = new SessionContainer(this.serviceEndpoint.getHost(), disableSessionCapturing);
        this.consistencyLevel = consistencyLevel;
        this.userAgentContainer = new UserAgentContainer();
        String userAgentSuffix = this.connectionPolicy.getUserAgentSuffix();
        if (userAgentSuffix != null && userAgentSuffix.length() > 0) {
            this.userAgentContainer.setSuffix(userAgentSuffix);
        }
        this.reactorHttpClient = this.httpClient();
        this.globalEndpointManager = new GlobalEndpointManager(this.asDatabaseAccountManagerInternal(), this.connectionPolicy, configs);
        this.retryPolicy = new RetryPolicy(this.globalEndpointManager, this.connectionPolicy);
        this.resetSessionTokenRetryPolicy = this.retryPolicy;
    }

    private void initializeGatewayConfigurationReader() {
        this.gatewayConfigurationReader = new GatewayServiceConfigurationReader(this.globalEndpointManager);
        DatabaseAccount databaseAccount = this.globalEndpointManager.getLatestDatabaseAccount();
        assert (databaseAccount != null);
        this.useMultipleWriteLocations = this.connectionPolicy.isMultipleWriteRegionsEnabled() && BridgeInternal.isEnableMultipleWriteLocations(databaseAccount);
    }

    public void init() {
        this.gatewayProxy = this.createRxGatewayProxy(this.sessionContainer, this.consistencyLevel, this.queryCompatibilityMode, this.userAgentContainer, this.globalEndpointManager, this.reactorHttpClient);
        this.globalEndpointManager.init();
        this.initializeGatewayConfigurationReader();
        this.collectionCache = new RxClientCollectionCache(this.sessionContainer, this.gatewayProxy, this, this.retryPolicy);
        this.resetSessionTokenRetryPolicy = new ResetSessionTokenRetryPolicyFactory(this.sessionContainer, this.collectionCache, this.retryPolicy);
        this.partitionKeyRangeCache = new RxPartitionKeyRangeCache(this, this.collectionCache);
        if (this.connectionPolicy.getConnectionMode() == ConnectionMode.GATEWAY) {
            this.storeModel = this.gatewayProxy;
        } else {
            this.initializeDirectConnectivity();
        }
    }

    private void initializeDirectConnectivity() {
        this.storeClientFactory = new StoreClientFactory(this.configs, this.connectionPolicy, this.userAgentContainer, this.connectionSharingAcrossClientsEnabled);
        this.addressResolver = new GlobalAddressResolver(this.reactorHttpClient, this.globalEndpointManager, this.configs.getProtocol(), this, this.collectionCache, this.partitionKeyRangeCache, this.userAgentContainer, null, this.connectionPolicy);
        this.createStoreModel(true);
    }

    DatabaseAccountManagerInternal asDatabaseAccountManagerInternal() {
        return new DatabaseAccountManagerInternal(){

            @Override
            public URI getServiceEndpoint() {
                return RxDocumentClientImpl.this.getServiceEndpoint();
            }

            @Override
            public Flux<DatabaseAccount> getDatabaseAccountFromEndpoint(URI endpoint) {
                RxDocumentClientImpl.this.logger.info("Getting database account endpoint from {}", (Object)endpoint);
                return RxDocumentClientImpl.this.getDatabaseAccountFromEndpoint(endpoint);
            }

            @Override
            public ConnectionPolicy getConnectionPolicy() {
                return RxDocumentClientImpl.this.getConnectionPolicy();
            }
        };
    }

    RxGatewayStoreModel createRxGatewayProxy(ISessionContainer sessionContainer, ConsistencyLevel consistencyLevel, QueryCompatibilityMode queryCompatibilityMode, UserAgentContainer userAgentContainer, GlobalEndpointManager globalEndpointManager, HttpClient httpClient) {
        return new RxGatewayStoreModel(sessionContainer, consistencyLevel, queryCompatibilityMode, userAgentContainer, globalEndpointManager, httpClient);
    }

    private HttpClient httpClient() {
        HttpClientConfig httpClientConfig = new HttpClientConfig(this.configs).withMaxIdleConnectionTimeout(this.connectionPolicy.getIdleHttpConnectionTimeout()).withPoolSize(this.connectionPolicy.getMaxConnectionPoolSize()).withProxy(this.connectionPolicy.getProxy()).withRequestTimeout(this.connectionPolicy.getRequestTimeout());
        if (this.connectionSharingAcrossClientsEnabled) {
            return SharedGatewayHttpClient.getOrCreateInstance(httpClientConfig);
        }
        return HttpClient.createFixed(httpClientConfig);
    }

    private void createStoreModel(boolean subscribeRntbdStatus) {
        StoreClient storeClient = this.storeClientFactory.createStoreClient(this.addressResolver, this.sessionContainer, this.gatewayConfigurationReader, this, false);
        this.storeModel = new ServerStoreModel(storeClient);
    }

    @Override
    public URI getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    @Override
    public URI getWriteEndpoint() {
        return this.globalEndpointManager.getWriteEndpoints().stream().findFirst().orElse(null);
    }

    @Override
    public URI getReadEndpoint() {
        return this.globalEndpointManager.getReadEndpoints().stream().findFirst().orElse(null);
    }

    @Override
    public ConnectionPolicy getConnectionPolicy() {
        return this.connectionPolicy;
    }

    @Override
    public boolean isContentResponseOnWriteEnabled() {
        return this.contentResponseOnWriteEnabled;
    }

    @Override
    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    @Override
    public Mono<ResourceResponse<Database>> createDatabase(Database database, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createDatabaseInternal(database, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Database>> createDatabaseInternal(Database database, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            SerializationDiagnosticsContext serializationDiagnosticsContext;
            if (database == null) {
                throw new IllegalArgumentException("Database");
            }
            this.logger.debug("Creating a Database. id: [{}]", (Object)database.getId());
            RxDocumentClientImpl.validateResource(database);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Database, OperationType.Create);
            Instant serializationStartTimeUTC = Instant.now();
            ByteBuffer byteBuffer = ModelBridgeInternal.serializeJsonToByteBuffer(database);
            Instant serializationEndTimeUTC = Instant.now();
            SerializationDiagnosticsContext.SerializationDiagnostics serializationDiagnostics = new SerializationDiagnosticsContext.SerializationDiagnostics(serializationStartTimeUTC, serializationEndTimeUTC, SerializationDiagnosticsContext.SerializationType.DATABASE_SERIALIZATION);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Create, ResourceType.Database, "/dbs", byteBuffer, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            if ((serializationDiagnosticsContext = BridgeInternal.getSerializationDiagnosticsContext(request.requestContext.cosmosDiagnostics)) != null) {
                serializationDiagnosticsContext.addSerializationDiagnostics(serializationDiagnostics);
            }
            return this.create(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, Database.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in creating a database. due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Database>> deleteDatabase(String databaseLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteDatabaseInternal(databaseLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Database>> deleteDatabaseInternal(String databaseLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(databaseLink)) {
                throw new IllegalArgumentException("databaseLink");
            }
            this.logger.debug("Deleting a Database. databaseLink: [{}]", (Object)databaseLink);
            String path = Utils.joinPath(databaseLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Database, OperationType.Delete);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Delete, ResourceType.Database, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.delete(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, Database.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in deleting a database. due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Database>> readDatabase(String databaseLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readDatabaseInternal(databaseLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Database>> readDatabaseInternal(String databaseLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(databaseLink)) {
                throw new IllegalArgumentException("databaseLink");
            }
            this.logger.debug("Reading a Database. databaseLink: [{}]", (Object)databaseLink);
            String path = Utils.joinPath(databaseLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Database, OperationType.Read);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Read, ResourceType.Database, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, Database.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in reading a database. due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<Database>> readDatabases(CosmosQueryRequestOptions options) {
        return this.readFeed(options, ResourceType.Database, Database.class, "/dbs");
    }

    private String parentResourceLinkToQueryLink(String parentResouceLink, ResourceType resourceTypeEnum) {
        switch (resourceTypeEnum) {
            case Database: {
                return "/dbs";
            }
            case DocumentCollection: {
                return Utils.joinPath(parentResouceLink, "colls");
            }
            case Document: {
                return Utils.joinPath(parentResouceLink, "docs");
            }
            case Offer: {
                return "/offers/";
            }
            case User: {
                return Utils.joinPath(parentResouceLink, "users");
            }
            case Permission: {
                return Utils.joinPath(parentResouceLink, "permissions");
            }
            case Attachment: {
                return Utils.joinPath(parentResouceLink, "attachments");
            }
            case StoredProcedure: {
                return Utils.joinPath(parentResouceLink, "sprocs");
            }
            case Trigger: {
                return Utils.joinPath(parentResouceLink, "triggers");
            }
            case UserDefinedFunction: {
                return Utils.joinPath(parentResouceLink, "udfs");
            }
            case Conflict: {
                return Utils.joinPath(parentResouceLink, "conflicts");
            }
        }
        throw new IllegalArgumentException("resource type not supported");
    }

    private <T extends Resource> Flux<FeedResponse<T>> createQuery(String parentResourceLink, SqlQuerySpec sqlQuery, CosmosQueryRequestOptions options, Class<T> klass, ResourceType resourceTypeEnum) {
        String resourceLink = this.parentResourceLinkToQueryLink(parentResourceLink, resourceTypeEnum);
        UUID activityId = Utils.randomUUID();
        IDocumentQueryClient queryClient = this.documentQueryClientImpl(this);
        InvalidPartitionExceptionRetryPolicy invalidPartitionExceptionRetryPolicy = new InvalidPartitionExceptionRetryPolicy(this.collectionCache, null, resourceLink, options);
        return ObservableHelper.fluxInlineIfPossibleAsObs(() -> this.createQueryInternal(resourceLink, sqlQuery, options, klass, resourceTypeEnum, queryClient, activityId), invalidPartitionExceptionRetryPolicy);
    }

    private <T extends Resource> Flux<FeedResponse<T>> createQueryInternal(String resourceLink, SqlQuerySpec sqlQuery, CosmosQueryRequestOptions options, Class<T> klass, ResourceType resourceTypeEnum, IDocumentQueryClient queryClient, UUID activityId) {
        Flux<IDocumentQueryExecutionContext<T>> executionContext = DocumentQueryExecutionContextFactory.createDocumentQueryExecutionContextAsync(queryClient, resourceTypeEnum, klass, sqlQuery, options, resourceLink, false, activityId);
        return executionContext.flatMap(iDocumentQueryExecutionContext -> {
            QueryInfo queryInfo = null;
            if (iDocumentQueryExecutionContext instanceof PipelinedDocumentQueryExecutionContext) {
                queryInfo = ((PipelinedDocumentQueryExecutionContext)iDocumentQueryExecutionContext).getQueryInfo();
            }
            if (queryInfo != null && queryInfo.hasSelectValue()) {
                QueryInfo finalQueryInfo = queryInfo;
                return iDocumentQueryExecutionContext.executeAsync().map(tFeedResponse -> {
                    ModelBridgeInternal.addQueryInfoToFeedResponse(tFeedResponse, finalQueryInfo);
                    return tFeedResponse;
                });
            }
            return iDocumentQueryExecutionContext.executeAsync();
        });
    }

    @Override
    public Flux<FeedResponse<Database>> queryDatabases(String query, CosmosQueryRequestOptions options) {
        return this.queryDatabases(new SqlQuerySpec(query), options);
    }

    @Override
    public Flux<FeedResponse<Database>> queryDatabases(SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        return this.createQuery("/dbs", querySpec, options, Database.class, ResourceType.Database);
    }

    @Override
    public Mono<ResourceResponse<DocumentCollection>> createCollection(String databaseLink, DocumentCollection collection, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createCollectionInternal(databaseLink, collection, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<DocumentCollection>> createCollectionInternal(String databaseLink, DocumentCollection collection, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            SerializationDiagnosticsContext serializationDiagnosticsContext;
            if (StringUtils.isEmpty(databaseLink)) {
                throw new IllegalArgumentException("databaseLink");
            }
            if (collection == null) {
                throw new IllegalArgumentException("collection");
            }
            this.logger.debug("Creating a Collection. databaseLink: [{}], Collection id: [{}]", (Object)databaseLink, (Object)collection.getId());
            RxDocumentClientImpl.validateResource(collection);
            String path = Utils.joinPath(databaseLink, "colls");
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.DocumentCollection, OperationType.Create);
            Instant serializationStartTimeUTC = Instant.now();
            ByteBuffer byteBuffer = ModelBridgeInternal.serializeJsonToByteBuffer(collection);
            Instant serializationEndTimeUTC = Instant.now();
            SerializationDiagnosticsContext.SerializationDiagnostics serializationDiagnostics = new SerializationDiagnosticsContext.SerializationDiagnostics(serializationStartTimeUTC, serializationEndTimeUTC, SerializationDiagnosticsContext.SerializationType.CONTAINER_SERIALIZATION);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Create, ResourceType.DocumentCollection, path, byteBuffer, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            if ((serializationDiagnosticsContext = BridgeInternal.getSerializationDiagnosticsContext(request.requestContext.cosmosDiagnostics)) != null) {
                serializationDiagnosticsContext.addSerializationDiagnostics(serializationDiagnostics);
            }
            return this.create(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, DocumentCollection.class)).doOnNext(resourceResponse -> this.sessionContainer.setSessionToken(((DocumentCollection)resourceResponse.getResource()).getResourceId(), BridgeInternal.getAltLink(resourceResponse.getResource()), resourceResponse.getResponseHeaders()));
        }
        catch (Exception e) {
            this.logger.debug("Failure in creating a collection. due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<DocumentCollection>> replaceCollection(DocumentCollection collection, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceCollectionInternal(collection, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<DocumentCollection>> replaceCollectionInternal(DocumentCollection collection, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            SerializationDiagnosticsContext serializationDiagnosticsContext;
            if (collection == null) {
                throw new IllegalArgumentException("collection");
            }
            this.logger.debug("Replacing a Collection. id: [{}]", (Object)collection.getId());
            RxDocumentClientImpl.validateResource(collection);
            String path = Utils.joinPath(collection.getSelfLink(), null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.DocumentCollection, OperationType.Replace);
            Instant serializationStartTimeUTC = Instant.now();
            ByteBuffer byteBuffer = ModelBridgeInternal.serializeJsonToByteBuffer(collection);
            Instant serializationEndTimeUTC = Instant.now();
            SerializationDiagnosticsContext.SerializationDiagnostics serializationDiagnostics = new SerializationDiagnosticsContext.SerializationDiagnostics(serializationStartTimeUTC, serializationEndTimeUTC, SerializationDiagnosticsContext.SerializationType.CONTAINER_SERIALIZATION);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Replace, ResourceType.DocumentCollection, path, byteBuffer, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            if ((serializationDiagnosticsContext = BridgeInternal.getSerializationDiagnosticsContext(request.requestContext.cosmosDiagnostics)) != null) {
                serializationDiagnosticsContext.addSerializationDiagnostics(serializationDiagnostics);
            }
            return this.replace(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, DocumentCollection.class)).doOnNext(resourceResponse -> {
                if (resourceResponse.getResource() != null) {
                    this.sessionContainer.setSessionToken(((DocumentCollection)resourceResponse.getResource()).getResourceId(), BridgeInternal.getAltLink(resourceResponse.getResource()), resourceResponse.getResponseHeaders());
                }
            });
        }
        catch (Exception e) {
            this.logger.debug("Failure in replacing a collection. due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<DocumentCollection>> deleteCollection(String collectionLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteCollectionInternal(collectionLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<DocumentCollection>> deleteCollectionInternal(String collectionLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(collectionLink)) {
                throw new IllegalArgumentException("collectionLink");
            }
            this.logger.debug("Deleting a Collection. collectionLink: [{}]", (Object)collectionLink);
            String path = Utils.joinPath(collectionLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.DocumentCollection, OperationType.Delete);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Delete, ResourceType.DocumentCollection, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.delete(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, DocumentCollection.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in deleting a collection, due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    private Mono<RxDocumentServiceResponse> delete(RxDocumentServiceRequest request, DocumentClientRetryPolicy documentClientRetryPolicy) {
        this.populateHeaders(request, RequestVerb.DELETE);
        if (request.requestContext != null && documentClientRetryPolicy.getRetryCount() > 0) {
            documentClientRetryPolicy.updateEndTime();
            request.requestContext.updateRetryContext(documentClientRetryPolicy, true);
        }
        return this.getStoreProxy(request).processMessage(request);
    }

    private Mono<RxDocumentServiceResponse> read(RxDocumentServiceRequest request, DocumentClientRetryPolicy documentClientRetryPolicy) {
        this.populateHeaders(request, RequestVerb.GET);
        if (request.requestContext != null && documentClientRetryPolicy.getRetryCount() > 0) {
            documentClientRetryPolicy.updateEndTime();
            request.requestContext.updateRetryContext(documentClientRetryPolicy, true);
        }
        return this.getStoreProxy(request).processMessage(request);
    }

    Mono<RxDocumentServiceResponse> readFeed(RxDocumentServiceRequest request) {
        this.populateHeaders(request, RequestVerb.GET);
        return this.gatewayProxy.processMessage(request);
    }

    private Mono<RxDocumentServiceResponse> query(RxDocumentServiceRequest request) {
        this.populateHeaders(request, RequestVerb.POST);
        return this.getStoreProxy(request).processMessage(request).map(response -> {
            this.captureSessionToken(request, (RxDocumentServiceResponse)response);
            return response;
        });
    }

    @Override
    public Mono<ResourceResponse<DocumentCollection>> readCollection(String collectionLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readCollectionInternal(collectionLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<DocumentCollection>> readCollectionInternal(String collectionLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(collectionLink)) {
                throw new IllegalArgumentException("collectionLink");
            }
            this.logger.debug("Reading a Collection. collectionLink: [{}]", (Object)collectionLink);
            String path = Utils.joinPath(collectionLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.DocumentCollection, OperationType.Read);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Read, ResourceType.DocumentCollection, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, DocumentCollection.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in reading a collection, due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<DocumentCollection>> readCollections(String databaseLink, CosmosQueryRequestOptions options) {
        if (StringUtils.isEmpty(databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        return this.readFeed(options, ResourceType.DocumentCollection, DocumentCollection.class, Utils.joinPath(databaseLink, "colls"));
    }

    @Override
    public Flux<FeedResponse<DocumentCollection>> queryCollections(String databaseLink, String query, CosmosQueryRequestOptions options) {
        return this.createQuery(databaseLink, new SqlQuerySpec(query), options, DocumentCollection.class, ResourceType.DocumentCollection);
    }

    @Override
    public Flux<FeedResponse<DocumentCollection>> queryCollections(String databaseLink, SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        return this.createQuery(databaseLink, querySpec, options, DocumentCollection.class, ResourceType.DocumentCollection);
    }

    private static String serializeProcedureParams(List<Object> objectArray) {
        Object[] stringArray = new String[objectArray.size()];
        for (int i = 0; i < objectArray.size(); ++i) {
            Object object = objectArray.get(i);
            if (object instanceof JsonSerializable) {
                stringArray[i] = ModelBridgeInternal.toJsonFromJsonSerializable((JsonSerializable)object);
                continue;
            }
            try {
                stringArray[i] = mapper.writeValueAsString(object);
                continue;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Can't serialize the object into the json string", e);
            }
        }
        return String.format("[%s]", StringUtils.join(stringArray, ","));
    }

    private static void validateResource(Resource resource) {
        if (!StringUtils.isEmpty(resource.getId())) {
            if (resource.getId().indexOf(47) != -1 || resource.getId().indexOf(92) != -1 || resource.getId().indexOf(63) != -1 || resource.getId().indexOf(35) != -1) {
                throw new IllegalArgumentException("Id contains illegal chars.");
            }
            if (resource.getId().endsWith(" ")) {
                throw new IllegalArgumentException("Id ends with a space.");
            }
        }
    }

    private Map<String, String> getRequestHeaders(RequestOptions options, ResourceType resourceType, OperationType operationType) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.useMultipleWriteLocations) {
            headers.put("x-ms-cosmos-allow-tentative-writes", Boolean.TRUE.toString());
        }
        if (this.consistencyLevel != null) {
            headers.put("x-ms-consistency-level", this.consistencyLevel.toString());
        }
        if (resourceType.equals((Object)ResourceType.Document) && operationType.isWriteOperation() && !this.contentResponseOnWriteEnabled) {
            headers.put("Prefer", "return=minimal");
        }
        if (options == null) {
            return headers;
        }
        Map<String, String> customOptions = options.getHeaders();
        if (customOptions != null) {
            headers.putAll(customOptions);
        }
        if (options.getIfMatchETag() != null) {
            headers.put("If-Match", options.getIfMatchETag());
        }
        if (options.getIfNoneMatchETag() != null) {
            headers.put("If-NONE-Match", options.getIfNoneMatchETag());
        }
        if (options.getConsistencyLevel() != null) {
            headers.put("x-ms-consistency-level", options.getConsistencyLevel().toString());
        }
        if (options.getIndexingDirective() != null) {
            headers.put("x-ms-indexing-directive", options.getIndexingDirective().toString());
        }
        if (options.getPostTriggerInclude() != null && options.getPostTriggerInclude().size() > 0) {
            String postTriggerInclude = StringUtils.join(options.getPostTriggerInclude(), ",");
            headers.put("x-ms-documentdb-post-trigger-include", postTriggerInclude);
        }
        if (options.getPreTriggerInclude() != null && options.getPreTriggerInclude().size() > 0) {
            String preTriggerInclude = StringUtils.join(options.getPreTriggerInclude(), ",");
            headers.put("x-ms-documentdb-pre-trigger-include", preTriggerInclude);
        }
        if (!Strings.isNullOrEmpty(options.getSessionToken())) {
            headers.put("x-ms-session-token", options.getSessionToken());
        }
        if (options.getResourceTokenExpirySeconds() != null) {
            headers.put("x-ms-documentdb-expiry-seconds", String.valueOf(options.getResourceTokenExpirySeconds()));
        }
        if (options.getOfferThroughput() != null && options.getOfferThroughput() >= 0) {
            headers.put("x-ms-offer-throughput", options.getOfferThroughput().toString());
        } else if (options.getOfferType() != null) {
            headers.put("x-ms-offer-type", options.getOfferType());
        }
        if (options.getOfferThroughput() == null && options.getThroughputProperties() != null) {
            Offer offer = ModelBridgeInternal.getOfferFromThroughputProperties(options.getThroughputProperties());
            OfferAutoscaleSettings offerAutoscaleSettings = offer.getOfferAutoScaleSettings();
            OfferAutoscaleAutoUpgradeProperties autoscaleAutoUpgradeProperties = null;
            if (offerAutoscaleSettings != null) {
                autoscaleAutoUpgradeProperties = offer.getOfferAutoScaleSettings().getAutoscaleAutoUpgradeProperties();
            }
            if (offer.hasOfferThroughput() && (offerAutoscaleSettings != null && offerAutoscaleSettings.getMaxThroughput() >= 0 || autoscaleAutoUpgradeProperties != null && autoscaleAutoUpgradeProperties.getAutoscaleThroughputProperties().getIncrementPercent() >= 0)) {
                throw new IllegalArgumentException("Autoscale provisioned throughput can not be configured with fixed offer");
            }
            if (offer.hasOfferThroughput()) {
                headers.put("x-ms-offer-throughput", String.valueOf(offer.getThroughput()));
            } else if (offer.getOfferAutoScaleSettings() != null) {
                headers.put("x-ms-cosmos-offer-autopilot-settings", ModelBridgeInternal.toJsonFromJsonSerializable(offer.getOfferAutoScaleSettings()));
            }
        }
        if (options.isQuotaInfoEnabled()) {
            headers.put("x-ms-documentdb-populatequotainfo", String.valueOf(true));
        }
        if (options.isScriptLoggingEnabled()) {
            headers.put("x-ms-documentdb-script-enable-logging", String.valueOf(true));
        }
        return headers;
    }

    private Mono<RxDocumentServiceRequest> addPartitionKeyInformation(RxDocumentServiceRequest request, ByteBuffer contentAsByteBuffer, Document document, RequestOptions options) {
        Mono<Utils.ValueHolder<DocumentCollection>> collectionObs = this.collectionCache.resolveCollectionAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), request);
        return collectionObs.map(collectionValueHolder -> {
            this.addPartitionKeyInformation(request, contentAsByteBuffer, (Object)document, options, (DocumentCollection)collectionValueHolder.v);
            return request;
        });
    }

    private Mono<RxDocumentServiceRequest> addPartitionKeyInformation(RxDocumentServiceRequest request, ByteBuffer contentAsByteBuffer, Object document, RequestOptions options, Mono<Utils.ValueHolder<DocumentCollection>> collectionObs) {
        return collectionObs.map(collectionValueHolder -> {
            this.addPartitionKeyInformation(request, contentAsByteBuffer, document, options, (DocumentCollection)collectionValueHolder.v);
            return request;
        });
    }

    private void addPartitionKeyInformation(RxDocumentServiceRequest request, ByteBuffer contentAsByteBuffer, Object objectDoc, RequestOptions options, DocumentCollection collection) {
        PartitionKeyDefinition partitionKeyDefinition = collection.getPartitionKey();
        PartitionKeyInternal partitionKeyInternal = null;
        if (options != null && options.getPartitionKey() != null && options.getPartitionKey().equals(PartitionKey.NONE)) {
            partitionKeyInternal = ModelBridgeInternal.getNonePartitionKey(partitionKeyDefinition);
        } else if (options != null && options.getPartitionKey() != null) {
            partitionKeyInternal = BridgeInternal.getPartitionKeyInternal(options.getPartitionKey());
        } else if (partitionKeyDefinition == null || partitionKeyDefinition.getPaths().size() == 0) {
            partitionKeyInternal = PartitionKeyInternal.getEmpty();
        } else if (contentAsByteBuffer != null) {
            InternalObjectNode internalObjectNode;
            if (objectDoc instanceof InternalObjectNode) {
                internalObjectNode = (InternalObjectNode)objectDoc;
            } else {
                contentAsByteBuffer.rewind();
                internalObjectNode = new InternalObjectNode(contentAsByteBuffer);
            }
            Instant serializationStartTime = Instant.now();
            partitionKeyInternal = RxDocumentClientImpl.extractPartitionKeyValueFromDocument(internalObjectNode, partitionKeyDefinition);
            Instant serializationEndTime = Instant.now();
            SerializationDiagnosticsContext.SerializationDiagnostics serializationDiagnostics = new SerializationDiagnosticsContext.SerializationDiagnostics(serializationStartTime, serializationEndTime, SerializationDiagnosticsContext.SerializationType.PARTITION_KEY_FETCH_SERIALIZATION);
            SerializationDiagnosticsContext serializationDiagnosticsContext = BridgeInternal.getSerializationDiagnosticsContext(request.requestContext.cosmosDiagnostics);
            if (serializationDiagnosticsContext != null) {
                serializationDiagnosticsContext.addSerializationDiagnostics(serializationDiagnostics);
            }
        } else {
            throw new UnsupportedOperationException("PartitionKey value must be supplied for this operation.");
        }
        request.setPartitionKeyInternal(partitionKeyInternal);
        request.getHeaders().put("x-ms-documentdb-partitionkey", Utils.escapeNonAscii(partitionKeyInternal.toJson()));
    }

    private static PartitionKeyInternal extractPartitionKeyValueFromDocument(InternalObjectNode document, PartitionKeyDefinition partitionKeyDefinition) {
        String path;
        List<String> parts;
        if (partitionKeyDefinition != null && (parts = PathParser.getPathParts(path = partitionKeyDefinition.getPaths().iterator().next())).size() >= 1) {
            Object value = ModelBridgeInternal.getObjectByPathFromJsonSerializable(document, parts);
            if (value == null || value.getClass() == ObjectNode.class) {
                value = ModelBridgeInternal.getNonePartitionKey(partitionKeyDefinition);
            }
            if (value instanceof PartitionKeyInternal) {
                return (PartitionKeyInternal)value;
            }
            return PartitionKeyInternal.fromObjectArray(Collections.singletonList(value), false);
        }
        return null;
    }

    private Mono<RxDocumentServiceRequest> getCreateDocumentRequest(DocumentClientRetryPolicy requestRetryPolicy, String documentCollectionLink, Object document, RequestOptions options, boolean disableAutomaticIdGeneration, OperationType operationType) {
        SerializationDiagnosticsContext serializationDiagnosticsContext;
        if (StringUtils.isEmpty(documentCollectionLink)) {
            throw new IllegalArgumentException("documentCollectionLink");
        }
        if (document == null) {
            throw new IllegalArgumentException("document");
        }
        Instant serializationStartTimeUTC = Instant.now();
        ByteBuffer content = BridgeInternal.serializeJsonToByteBuffer(document, mapper);
        Instant serializationEndTimeUTC = Instant.now();
        SerializationDiagnosticsContext.SerializationDiagnostics serializationDiagnostics = new SerializationDiagnosticsContext.SerializationDiagnostics(serializationStartTimeUTC, serializationEndTimeUTC, SerializationDiagnosticsContext.SerializationType.ITEM_SERIALIZATION);
        String path = Utils.joinPath(documentCollectionLink, "docs");
        Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Document, operationType);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create(operationType, ResourceType.Document, path, requestHeaders, options, content);
        if (requestRetryPolicy != null) {
            requestRetryPolicy.onBeforeSendRequest(request);
        }
        if ((serializationDiagnosticsContext = BridgeInternal.getSerializationDiagnosticsContext(request.requestContext.cosmosDiagnostics)) != null) {
            serializationDiagnosticsContext.addSerializationDiagnostics(serializationDiagnostics);
        }
        Mono<Utils.ValueHolder<DocumentCollection>> collectionObs = this.collectionCache.resolveCollectionAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), request);
        return this.addPartitionKeyInformation(request, content, document, options, collectionObs);
    }

    private void populateHeaders(RxDocumentServiceRequest request, RequestVerb httpMethod) {
        request.getHeaders().put("x-ms-date", Utils.nowAsRFC1123());
        if (this.masterKeyOrResourceToken != null || this.resourceTokensMap != null || this.cosmosAuthorizationTokenResolver != null || this.credential != null) {
            String resourceName = request.getResourceAddress();
            String authorization = this.getUserAuthorizationToken(resourceName, request.getResourceType(), httpMethod, request.getHeaders(), AuthorizationTokenType.PrimaryMasterKey, request.properties);
            try {
                authorization = URLEncoder.encode(authorization, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("Failed to encode authtoken.", e);
            }
            request.getHeaders().put("authorization", authorization);
        }
        if ((RequestVerb.POST.equals((Object)httpMethod) || RequestVerb.PUT.equals((Object)httpMethod)) && !request.getHeaders().containsKey("Content-Type")) {
            request.getHeaders().put("Content-Type", "application/json");
        }
        if (!request.getHeaders().containsKey("Accept")) {
            request.getHeaders().put("Accept", "application/json");
        }
    }

    @Override
    public String getUserAuthorizationToken(String resourceName, ResourceType resourceType, RequestVerb requestVerb, Map<String, String> headers, AuthorizationTokenType tokenType, Map<String, Object> properties) {
        if (this.cosmosAuthorizationTokenResolver != null) {
            return this.cosmosAuthorizationTokenResolver.getAuthorizationToken(requestVerb, resourceName, this.resolveCosmosResourceType(resourceType), properties != null ? Collections.unmodifiableMap(properties) : null);
        }
        if (this.credential != null) {
            return this.authorizationTokenProvider.generateKeyAuthorizationSignature(requestVerb, resourceName, resourceType, headers);
        }
        if (this.masterKeyOrResourceToken != null && this.hasAuthKeyResourceToken && this.resourceTokensMap == null) {
            return this.masterKeyOrResourceToken;
        }
        assert (this.resourceTokensMap != null);
        if (resourceType.equals((Object)ResourceType.DatabaseAccount)) {
            return this.firstResourceTokenFromPermissionFeed;
        }
        return ResourceTokenAuthorizationHelper.getAuthorizationTokenUsingResourceTokens(this.resourceTokensMap, requestVerb, resourceName, headers);
    }

    private CosmosResourceType resolveCosmosResourceType(ResourceType resourceType) {
        CosmosResourceType cosmosResourceType = ModelBridgeInternal.fromServiceSerializedFormat(resourceType.toString());
        if (cosmosResourceType == null) {
            return CosmosResourceType.SYSTEM;
        }
        return cosmosResourceType;
    }

    void captureSessionToken(RxDocumentServiceRequest request, RxDocumentServiceResponse response) {
        this.sessionContainer.setSessionToken(request, response.getResponseHeaders());
    }

    private Mono<RxDocumentServiceResponse> create(RxDocumentServiceRequest request, DocumentClientRetryPolicy retryPolicy) {
        this.populateHeaders(request, RequestVerb.POST);
        RxStoreModel storeProxy = this.getStoreProxy(request);
        if (request.requestContext != null && retryPolicy.getRetryCount() > 0) {
            retryPolicy.updateEndTime();
            request.requestContext.updateRetryContext(retryPolicy, true);
        }
        return storeProxy.processMessage(request);
    }

    private Mono<RxDocumentServiceResponse> upsert(RxDocumentServiceRequest request, DocumentClientRetryPolicy documentClientRetryPolicy) {
        this.populateHeaders(request, RequestVerb.POST);
        Map<String, String> headers = request.getHeaders();
        assert (headers != null);
        headers.put("x-ms-documentdb-is-upsert", "true");
        if (request.requestContext != null && documentClientRetryPolicy.getRetryCount() > 0) {
            documentClientRetryPolicy.updateEndTime();
            request.requestContext.updateRetryContext(documentClientRetryPolicy, true);
        }
        return this.getStoreProxy(request).processMessage(request).map(response -> {
            this.captureSessionToken(request, (RxDocumentServiceResponse)response);
            return response;
        });
    }

    private Mono<RxDocumentServiceResponse> replace(RxDocumentServiceRequest request, DocumentClientRetryPolicy documentClientRetryPolicy) {
        this.populateHeaders(request, RequestVerb.PUT);
        if (request.requestContext != null && documentClientRetryPolicy.getRetryCount() > 0) {
            documentClientRetryPolicy.updateEndTime();
            request.requestContext.updateRetryContext(documentClientRetryPolicy, true);
        }
        return this.getStoreProxy(request).processMessage(request);
    }

    @Override
    public Mono<ResourceResponse<Document>> createDocument(String collectionLink, Object document, RequestOptions options, boolean disableAutomaticIdGeneration) {
        DocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        if (options == null || options.getPartitionKey() == null) {
            requestRetryPolicy = new PartitionKeyMismatchRetryPolicy(this.collectionCache, requestRetryPolicy, collectionLink, options);
        }
        DocumentClientRetryPolicy finalRetryPolicyInstance = requestRetryPolicy;
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createDocumentInternal(collectionLink, document, options, disableAutomaticIdGeneration, finalRetryPolicyInstance), requestRetryPolicy);
    }

    private Mono<ResourceResponse<Document>> createDocumentInternal(String collectionLink, Object document, RequestOptions options, boolean disableAutomaticIdGeneration, DocumentClientRetryPolicy requestRetryPolicy) {
        try {
            this.logger.debug("Creating a Document. collectionLink: [{}]", (Object)collectionLink);
            Mono<RxDocumentServiceRequest> requestObs = this.getCreateDocumentRequest(requestRetryPolicy, collectionLink, document, options, disableAutomaticIdGeneration, OperationType.Create);
            Mono responseObservable = requestObs.flatMap(request -> this.create((RxDocumentServiceRequest)request, requestRetryPolicy));
            return responseObservable.map(serviceResponse -> BridgeInternal.toResourceResponse(serviceResponse, Document.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in creating a document due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Document>> upsertDocument(String collectionLink, Object document, RequestOptions options, boolean disableAutomaticIdGeneration) {
        DocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        if (options == null || options.getPartitionKey() == null) {
            requestRetryPolicy = new PartitionKeyMismatchRetryPolicy(this.collectionCache, requestRetryPolicy, collectionLink, options);
        }
        DocumentClientRetryPolicy finalRetryPolicyInstance = requestRetryPolicy;
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.upsertDocumentInternal(collectionLink, document, options, disableAutomaticIdGeneration, finalRetryPolicyInstance), finalRetryPolicyInstance);
    }

    private Mono<ResourceResponse<Document>> upsertDocumentInternal(String collectionLink, Object document, RequestOptions options, boolean disableAutomaticIdGeneration, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            this.logger.debug("Upserting a Document. collectionLink: [{}]", (Object)collectionLink);
            Mono<RxDocumentServiceRequest> reqObs = this.getCreateDocumentRequest(retryPolicyInstance, collectionLink, document, options, disableAutomaticIdGeneration, OperationType.Upsert);
            Mono responseObservable = reqObs.flatMap(request -> this.upsert((RxDocumentServiceRequest)request, retryPolicyInstance));
            return responseObservable.map(serviceResponse -> BridgeInternal.toResourceResponse(serviceResponse, Document.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in upserting a document due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Document>> replaceDocument(String documentLink, Object document, RequestOptions options) {
        DocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        if (options == null || options.getPartitionKey() == null) {
            String collectionLink = Utils.getCollectionName(documentLink);
            requestRetryPolicy = new PartitionKeyMismatchRetryPolicy(this.collectionCache, requestRetryPolicy, collectionLink, options);
        }
        DocumentClientRetryPolicy finalRequestRetryPolicy = requestRetryPolicy;
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceDocumentInternal(documentLink, document, options, finalRequestRetryPolicy), requestRetryPolicy);
    }

    private Mono<ResourceResponse<Document>> replaceDocumentInternal(String documentLink, Object document, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(documentLink)) {
                throw new IllegalArgumentException("documentLink");
            }
            if (document == null) {
                throw new IllegalArgumentException("document");
            }
            Document typedDocument = BridgeInternal.documentFromObject(document, mapper);
            return this.replaceDocumentInternal(documentLink, typedDocument, options, retryPolicyInstance);
        }
        catch (Exception e) {
            this.logger.debug("Failure in replacing a document due to [{}]", (Object)e.getMessage());
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Document>> replaceDocument(Document document, RequestOptions options) {
        DocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        if (options == null || options.getPartitionKey() == null) {
            String collectionLink = document.getSelfLink();
            requestRetryPolicy = new PartitionKeyMismatchRetryPolicy(this.collectionCache, requestRetryPolicy, collectionLink, options);
        }
        DocumentClientRetryPolicy finalRequestRetryPolicy = requestRetryPolicy;
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceDocumentInternal(document, options, finalRequestRetryPolicy), requestRetryPolicy);
    }

    private Mono<ResourceResponse<Document>> replaceDocumentInternal(Document document, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (document == null) {
                throw new IllegalArgumentException("document");
            }
            return this.replaceDocumentInternal(document.getSelfLink(), document, options, retryPolicyInstance);
        }
        catch (Exception e) {
            this.logger.debug("Failure in replacing a database due to [{}]", (Object)e.getMessage());
            return Mono.error((Throwable)e);
        }
    }

    private Mono<ResourceResponse<Document>> replaceDocumentInternal(String documentLink, Document document, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        SerializationDiagnosticsContext serializationDiagnosticsContext;
        if (document == null) {
            throw new IllegalArgumentException("document");
        }
        this.logger.debug("Replacing a Document. documentLink: [{}]", (Object)documentLink);
        String path = Utils.joinPath(documentLink, null);
        Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Document, OperationType.Replace);
        Instant serializationStartTimeUTC = Instant.now();
        ByteBuffer content = ModelBridgeInternal.serializeJsonToByteBuffer(document);
        Instant serializationEndTime = Instant.now();
        SerializationDiagnosticsContext.SerializationDiagnostics serializationDiagnostics = new SerializationDiagnosticsContext.SerializationDiagnostics(serializationStartTimeUTC, serializationEndTime, SerializationDiagnosticsContext.SerializationType.ITEM_SERIALIZATION);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Replace, ResourceType.Document, path, requestHeaders, options, content);
        if (retryPolicyInstance != null) {
            retryPolicyInstance.onBeforeSendRequest(request);
        }
        if ((serializationDiagnosticsContext = BridgeInternal.getSerializationDiagnosticsContext(request.requestContext.cosmosDiagnostics)) != null) {
            serializationDiagnosticsContext.addSerializationDiagnostics(serializationDiagnostics);
        }
        Mono<Utils.ValueHolder<DocumentCollection>> collectionObs = this.collectionCache.resolveCollectionAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), request);
        Mono<RxDocumentServiceRequest> requestObs = this.addPartitionKeyInformation(request, content, (Object)document, options, collectionObs);
        return requestObs.flatMap(req -> this.replace(request, retryPolicyInstance).map(resp -> BridgeInternal.toResourceResponse(resp, Document.class)));
    }

    @Override
    public Mono<ResourceResponse<Document>> deleteDocument(String documentLink, RequestOptions options) {
        DocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteDocumentInternal(documentLink, options, requestRetryPolicy), requestRetryPolicy);
    }

    private Mono<ResourceResponse<Document>> deleteDocumentInternal(String documentLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(documentLink)) {
                throw new IllegalArgumentException("documentLink");
            }
            this.logger.debug("Deleting a Document. documentLink: [{}]", (Object)documentLink);
            String path = Utils.joinPath(documentLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Document, OperationType.Delete);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Delete, ResourceType.Document, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            Mono<Utils.ValueHolder<DocumentCollection>> collectionObs = this.collectionCache.resolveCollectionAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), request);
            Mono<RxDocumentServiceRequest> requestObs = this.addPartitionKeyInformation(request, null, null, options, collectionObs);
            return requestObs.flatMap(req -> this.delete((RxDocumentServiceRequest)req, retryPolicyInstance).map(serviceResponse -> BridgeInternal.toResourceResponse(serviceResponse, Document.class)));
        }
        catch (Exception e) {
            this.logger.debug("Failure in deleting a document due to [{}]", (Object)e.getMessage());
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Document>> readDocument(String documentLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readDocumentInternal(documentLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Document>> readDocumentInternal(String documentLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(documentLink)) {
                throw new IllegalArgumentException("documentLink");
            }
            this.logger.debug("Reading a Document. documentLink: [{}]", (Object)documentLink);
            String path = Utils.joinPath(documentLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Document, OperationType.Read);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Read, ResourceType.Document, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            Mono<Utils.ValueHolder<DocumentCollection>> collectionObs = this.collectionCache.resolveCollectionAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), request);
            Mono<RxDocumentServiceRequest> requestObs = this.addPartitionKeyInformation(request, null, null, options, collectionObs);
            return requestObs.flatMap(req -> {
                if (retryPolicyInstance != null) {
                    retryPolicyInstance.onBeforeSendRequest(request);
                }
                return this.read(request, retryPolicyInstance).map(serviceResponse -> BridgeInternal.toResourceResponse(serviceResponse, Document.class));
            });
        }
        catch (Exception e) {
            this.logger.debug("Failure in reading a document due to [{}]", (Object)e.getMessage());
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<Document>> readDocuments(String collectionLink, CosmosQueryRequestOptions options) {
        if (StringUtils.isEmpty(collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        return this.queryDocuments(collectionLink, "SELECT * FROM r", options);
    }

    @Override
    public <T> Mono<FeedResponse<T>> readMany(List<Pair<String, PartitionKey>> itemKeyList, String collectionLink, CosmosQueryRequestOptions options, Class<T> klass) {
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Query, ResourceType.Document, collectionLink, null);
        Mono<Utils.ValueHolder<DocumentCollection>> collectionObs = this.collectionCache.resolveCollectionAsync(null, request);
        return collectionObs.flatMap(documentCollectionResourceResponse -> {
            DocumentCollection collection = (DocumentCollection)documentCollectionResourceResponse.v;
            if (collection == null) {
                throw new IllegalStateException("Collection cannot be null");
            }
            Mono<Utils.ValueHolder<CollectionRoutingMap>> valueHolderMono = this.partitionKeyRangeCache.tryLookupAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), collection.getResourceId(), null, null);
            return valueHolderMono.flatMap(collectionRoutingMapValueHolder -> {
                HashMap<PartitionKeyRange, List<Pair<String, PartitionKey>>> partitionRangeItemKeyMap = new HashMap<PartitionKeyRange, List<Pair<String, PartitionKey>>>();
                CollectionRoutingMap routingMap = (CollectionRoutingMap)collectionRoutingMapValueHolder.v;
                if (routingMap == null) {
                    throw new IllegalStateException("Failed to get routing map.");
                }
                itemKeyList.forEach(stringPartitionKeyPair -> {
                    String effectivePartitionKeyString = PartitionKeyInternalHelper.getEffectivePartitionKeyString(BridgeInternal.getPartitionKeyInternal((PartitionKey)stringPartitionKeyPair.getRight()), collection.getPartitionKey());
                    PartitionKeyRange range = routingMap.getRangeByEffectivePartitionKey(effectivePartitionKeyString);
                    if (partitionRangeItemKeyMap.get(range) == null) {
                        ArrayList<Pair> list = new ArrayList<Pair>();
                        list.add((Pair)stringPartitionKeyPair);
                        partitionRangeItemKeyMap.put(range, list);
                    } else {
                        List pairs = (List)partitionRangeItemKeyMap.get(range);
                        pairs.add(stringPartitionKeyPair);
                        partitionRangeItemKeyMap.put(range, pairs);
                    }
                });
                Set partitionKeyRanges = partitionRangeItemKeyMap.keySet();
                ArrayList ranges = new ArrayList();
                ranges.addAll(partitionKeyRanges);
                Map<PartitionKeyRange, SqlQuerySpec> rangeQueryMap = this.getRangeQueryMap(partitionRangeItemKeyMap, collection.getPartitionKey());
                String sqlQuery = "this is dummy and only used in creating ParallelDocumentQueryExecutioncontext, but not used";
                return this.createReadManyQuery(collectionLink, new SqlQuerySpec(sqlQuery), options, Document.class, ResourceType.Document, collection, Collections.unmodifiableMap(rangeQueryMap)).collectList().map(feedList -> {
                    ArrayList finalList = new ArrayList();
                    HashMap<String, String> headers = new HashMap<String, String>();
                    double requestCharge = 0.0;
                    for (FeedResponse page : feedList) {
                        requestCharge += page.getRequestCharge();
                        finalList.addAll(page.getResults().stream().map(document -> ModelBridgeInternal.toObjectFromJsonSerializable(document, klass)).collect(Collectors.toList()));
                    }
                    headers.put("x-ms-request-charge", Double.toString(requestCharge));
                    FeedResponse frp = BridgeInternal.createFeedResponse(finalList, headers);
                    return frp;
                });
            });
        });
    }

    private Map<PartitionKeyRange, SqlQuerySpec> getRangeQueryMap(Map<PartitionKeyRange, List<Pair<String, PartitionKey>>> partitionRangeItemKeyMap, PartitionKeyDefinition partitionKeyDefinition) {
        HashMap<PartitionKeyRange, SqlQuerySpec> rangeQueryMap = new HashMap<PartitionKeyRange, SqlQuerySpec>();
        String partitionKeySelector = this.createPkSelector(partitionKeyDefinition);
        for (Map.Entry<PartitionKeyRange, List<Pair<String, PartitionKey>>> entry : partitionRangeItemKeyMap.entrySet()) {
            SqlQuerySpec sqlQuerySpec = partitionKeySelector.equals("[\"id\"]") ? this.createReadManyQuerySpecPartitionKeyIdSame(entry.getValue(), partitionKeySelector) : this.createReadManyQuerySpec(entry.getValue(), partitionKeySelector);
            rangeQueryMap.put(entry.getKey(), sqlQuerySpec);
        }
        return rangeQueryMap;
    }

    private SqlQuerySpec createReadManyQuerySpecPartitionKeyIdSame(List<Pair<String, PartitionKey>> idPartitionKeyPairList, String partitionKeySelector) {
        StringBuilder queryStringBuilder = new StringBuilder();
        ArrayList<SqlParameter> parameters = new ArrayList<SqlParameter>();
        queryStringBuilder.append("SELECT * FROM c WHERE c.id IN ( ");
        for (int i = 0; i < idPartitionKeyPairList.size(); ++i) {
            Pair<String, PartitionKey> pair = idPartitionKeyPairList.get(i);
            String idValue = pair.getLeft();
            String idParamName = "@param" + i;
            PartitionKey pkValueAsPartitionKey = pair.getRight();
            Object pkValue = ModelBridgeInternal.getPartitionKeyObject(pkValueAsPartitionKey);
            if (!Objects.equals(idValue, pkValue)) continue;
            parameters.add(new SqlParameter(idParamName, idValue));
            queryStringBuilder.append(idParamName);
            if (i >= idPartitionKeyPairList.size() - 1) continue;
            queryStringBuilder.append(", ");
        }
        queryStringBuilder.append(" )");
        return new SqlQuerySpec(queryStringBuilder.toString(), parameters);
    }

    private SqlQuerySpec createReadManyQuerySpec(List<Pair<String, PartitionKey>> idPartitionKeyPairList, String partitionKeySelector) {
        StringBuilder queryStringBuilder = new StringBuilder();
        ArrayList<SqlParameter> parameters = new ArrayList<SqlParameter>();
        queryStringBuilder.append("SELECT * FROM c WHERE ( ");
        for (int i = 0; i < idPartitionKeyPairList.size(); ++i) {
            Pair<String, PartitionKey> pair = idPartitionKeyPairList.get(i);
            PartitionKey pkValueAsPartitionKey = pair.getRight();
            Object pkValue = ModelBridgeInternal.getPartitionKeyObject(pkValueAsPartitionKey);
            String pkParamName = "@param" + 2 * i;
            parameters.add(new SqlParameter(pkParamName, pkValue));
            String idValue = pair.getLeft();
            String idParamName = "@param" + (2 * i + 1);
            parameters.add(new SqlParameter(idParamName, idValue));
            queryStringBuilder.append("(");
            queryStringBuilder.append("c.id = ");
            queryStringBuilder.append(idParamName);
            queryStringBuilder.append(" AND ");
            queryStringBuilder.append(" c");
            queryStringBuilder.append(partitionKeySelector);
            queryStringBuilder.append(" = ");
            queryStringBuilder.append(pkParamName);
            queryStringBuilder.append(" )");
            if (i >= idPartitionKeyPairList.size() - 1) continue;
            queryStringBuilder.append(" OR ");
        }
        queryStringBuilder.append(" )");
        return new SqlQuerySpec(queryStringBuilder.toString(), parameters);
    }

    private String createPkSelector(PartitionKeyDefinition partitionKeyDefinition) {
        return partitionKeyDefinition.getPaths().stream().map(pathPart -> StringUtils.substring(pathPart, 1)).map(pathPart -> StringUtils.replace(pathPart, "\"", "\\")).map(part -> "[\"" + part + "\"]").collect(Collectors.joining());
    }

    private <T extends Resource> Flux<FeedResponse<T>> createReadManyQuery(String parentResourceLink, SqlQuerySpec sqlQuery, CosmosQueryRequestOptions options, Class<T> klass, ResourceType resourceTypeEnum, DocumentCollection collection, Map<PartitionKeyRange, SqlQuerySpec> rangeQueryMap) {
        UUID activityId = Utils.randomUUID();
        IDocumentQueryClient queryClient = this.documentQueryClientImpl(this);
        Flux<IDocumentQueryExecutionContext<T>> executionContext = DocumentQueryExecutionContextFactory.createReadManyQueryAsync(queryClient, collection.getResourceId(), sqlQuery, rangeQueryMap, options, collection.getResourceId(), parentResourceLink, activityId, klass, resourceTypeEnum);
        return executionContext.flatMap(IDocumentQueryExecutionContext::executeAsync);
    }

    @Override
    public Flux<FeedResponse<Document>> queryDocuments(String collectionLink, String query, CosmosQueryRequestOptions options) {
        return this.queryDocuments(collectionLink, new SqlQuerySpec(query), options);
    }

    private IDocumentQueryClient documentQueryClientImpl(RxDocumentClientImpl rxDocumentClientImpl) {
        return new IDocumentQueryClient(){

            @Override
            public RxCollectionCache getCollectionCache() {
                return RxDocumentClientImpl.this.collectionCache;
            }

            @Override
            public RxPartitionKeyRangeCache getPartitionKeyRangeCache() {
                return RxDocumentClientImpl.this.partitionKeyRangeCache;
            }

            @Override
            public IRetryPolicyFactory getResetSessionTokenRetryPolicy() {
                return RxDocumentClientImpl.this.resetSessionTokenRetryPolicy;
            }

            @Override
            public ConsistencyLevel getDefaultConsistencyLevelAsync() {
                return RxDocumentClientImpl.this.gatewayConfigurationReader.getDefaultConsistencyLevel();
            }

            @Override
            public ConsistencyLevel getDesiredConsistencyLevelAsync() {
                return RxDocumentClientImpl.this.consistencyLevel;
            }

            @Override
            public Mono<RxDocumentServiceResponse> executeQueryAsync(RxDocumentServiceRequest request) {
                return RxDocumentClientImpl.this.query(request);
            }

            @Override
            public IDocumentQueryClient.QueryCompatibilityMode getQueryCompatibilityMode() {
                return IDocumentQueryClient.QueryCompatibilityMode.Default;
            }

            @Override
            public Mono<RxDocumentServiceResponse> readFeedAsync(RxDocumentServiceRequest request) {
                return null;
            }
        };
    }

    @Override
    public Flux<FeedResponse<Document>> queryDocuments(String collectionLink, SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        return this.createQuery(collectionLink, querySpec, options, Document.class, ResourceType.Document);
    }

    @Override
    public Flux<FeedResponse<Document>> queryDocumentChangeFeed(String collectionLink, ChangeFeedOptions changeFeedOptions) {
        if (StringUtils.isEmpty(collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        ChangeFeedQueryImpl<Document> changeFeedQueryImpl = new ChangeFeedQueryImpl<Document>(this, ResourceType.Document, Document.class, collectionLink, changeFeedOptions);
        return changeFeedQueryImpl.executeAsync();
    }

    @Override
    public Flux<FeedResponse<PartitionKeyRange>> readPartitionKeyRanges(String collectionLink, CosmosQueryRequestOptions options) {
        if (StringUtils.isEmpty(collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        return this.readFeed(options, ResourceType.PartitionKeyRange, PartitionKeyRange.class, Utils.joinPath(collectionLink, "pkranges"));
    }

    private RxDocumentServiceRequest getStoredProcedureRequest(String collectionLink, StoredProcedure storedProcedure, RequestOptions options, OperationType operationType) {
        if (StringUtils.isEmpty(collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (storedProcedure == null) {
            throw new IllegalArgumentException("storedProcedure");
        }
        RxDocumentClientImpl.validateResource(storedProcedure);
        String path = Utils.joinPath(collectionLink, "sprocs");
        Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.StoredProcedure, operationType);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create(operationType, ResourceType.StoredProcedure, path, (Resource)storedProcedure, requestHeaders, (Object)options);
        return request;
    }

    private RxDocumentServiceRequest getUserDefinedFunctionRequest(String collectionLink, UserDefinedFunction udf, RequestOptions options, OperationType operationType) {
        if (StringUtils.isEmpty(collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (udf == null) {
            throw new IllegalArgumentException("udf");
        }
        RxDocumentClientImpl.validateResource(udf);
        String path = Utils.joinPath(collectionLink, "udfs");
        Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.UserDefinedFunction, operationType);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create(operationType, ResourceType.UserDefinedFunction, path, (Resource)udf, requestHeaders, (Object)options);
        return request;
    }

    @Override
    public Mono<ResourceResponse<StoredProcedure>> createStoredProcedure(String collectionLink, StoredProcedure storedProcedure, RequestOptions options) {
        DocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createStoredProcedureInternal(collectionLink, storedProcedure, options, requestRetryPolicy), requestRetryPolicy);
    }

    private Mono<ResourceResponse<StoredProcedure>> createStoredProcedureInternal(String collectionLink, StoredProcedure storedProcedure, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            this.logger.debug("Creating a StoredProcedure. collectionLink: [{}], storedProcedure id [{}]", (Object)collectionLink, (Object)storedProcedure.getId());
            RxDocumentServiceRequest request = this.getStoredProcedureRequest(collectionLink, storedProcedure, options, OperationType.Create);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.create(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, StoredProcedure.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in creating a StoredProcedure due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<StoredProcedure>> upsertStoredProcedure(String collectionLink, StoredProcedure storedProcedure, RequestOptions options) {
        DocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.upsertStoredProcedureInternal(collectionLink, storedProcedure, options, requestRetryPolicy), requestRetryPolicy);
    }

    private Mono<ResourceResponse<StoredProcedure>> upsertStoredProcedureInternal(String collectionLink, StoredProcedure storedProcedure, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            this.logger.debug("Upserting a StoredProcedure. collectionLink: [{}], storedProcedure id [{}]", (Object)collectionLink, (Object)storedProcedure.getId());
            RxDocumentServiceRequest request = this.getStoredProcedureRequest(collectionLink, storedProcedure, options, OperationType.Upsert);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.upsert(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, StoredProcedure.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in upserting a StoredProcedure due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<StoredProcedure>> replaceStoredProcedure(StoredProcedure storedProcedure, RequestOptions options) {
        DocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceStoredProcedureInternal(storedProcedure, options, requestRetryPolicy), requestRetryPolicy);
    }

    private Mono<ResourceResponse<StoredProcedure>> replaceStoredProcedureInternal(StoredProcedure storedProcedure, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (storedProcedure == null) {
                throw new IllegalArgumentException("storedProcedure");
            }
            this.logger.debug("Replacing a StoredProcedure. storedProcedure id [{}]", (Object)storedProcedure.getId());
            RxDocumentClientImpl.validateResource(storedProcedure);
            String path = Utils.joinPath(storedProcedure.getSelfLink(), null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.StoredProcedure, OperationType.Replace);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Replace, ResourceType.StoredProcedure, path, (Resource)storedProcedure, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.replace(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, StoredProcedure.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in replacing a StoredProcedure due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<StoredProcedure>> deleteStoredProcedure(String storedProcedureLink, RequestOptions options) {
        DocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteStoredProcedureInternal(storedProcedureLink, options, requestRetryPolicy), requestRetryPolicy);
    }

    private Mono<ResourceResponse<StoredProcedure>> deleteStoredProcedureInternal(String storedProcedureLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(storedProcedureLink)) {
                throw new IllegalArgumentException("storedProcedureLink");
            }
            this.logger.debug("Deleting a StoredProcedure. storedProcedureLink [{}]", (Object)storedProcedureLink);
            String path = Utils.joinPath(storedProcedureLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.StoredProcedure, OperationType.Delete);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Delete, ResourceType.StoredProcedure, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.delete(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, StoredProcedure.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in deleting a StoredProcedure due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<StoredProcedure>> readStoredProcedure(String storedProcedureLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readStoredProcedureInternal(storedProcedureLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<StoredProcedure>> readStoredProcedureInternal(String storedProcedureLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(storedProcedureLink)) {
                throw new IllegalArgumentException("storedProcedureLink");
            }
            this.logger.debug("Reading a StoredProcedure. storedProcedureLink [{}]", (Object)storedProcedureLink);
            String path = Utils.joinPath(storedProcedureLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.StoredProcedure, OperationType.Read);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Read, ResourceType.StoredProcedure, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, StoredProcedure.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in reading a StoredProcedure due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<StoredProcedure>> readStoredProcedures(String collectionLink, CosmosQueryRequestOptions options) {
        if (StringUtils.isEmpty(collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        return this.readFeed(options, ResourceType.StoredProcedure, StoredProcedure.class, Utils.joinPath(collectionLink, "sprocs"));
    }

    @Override
    public Flux<FeedResponse<StoredProcedure>> queryStoredProcedures(String collectionLink, String query, CosmosQueryRequestOptions options) {
        return this.queryStoredProcedures(collectionLink, new SqlQuerySpec(query), options);
    }

    @Override
    public Flux<FeedResponse<StoredProcedure>> queryStoredProcedures(String collectionLink, SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        return this.createQuery(collectionLink, querySpec, options, StoredProcedure.class, ResourceType.StoredProcedure);
    }

    @Override
    public Mono<StoredProcedureResponse> executeStoredProcedure(String storedProcedureLink, List<Object> procedureParams) {
        return this.executeStoredProcedure(storedProcedureLink, null, procedureParams);
    }

    @Override
    public Mono<StoredProcedureResponse> executeStoredProcedure(String storedProcedureLink, RequestOptions options, List<Object> procedureParams) {
        DocumentClientRetryPolicy documentClientRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.executeStoredProcedureInternal(storedProcedureLink, options, procedureParams, documentClientRetryPolicy), documentClientRetryPolicy);
    }

    private Mono<StoredProcedureResponse> executeStoredProcedureInternal(String storedProcedureLink, RequestOptions options, List<Object> procedureParams, DocumentClientRetryPolicy retryPolicy) {
        try {
            this.logger.debug("Executing a StoredProcedure. storedProcedureLink [{}]", (Object)storedProcedureLink);
            String path = Utils.joinPath(storedProcedureLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.StoredProcedure, OperationType.ExecuteJavaScript);
            requestHeaders.put("Accept", "application/json");
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.ExecuteJavaScript, ResourceType.StoredProcedure, path, procedureParams != null && !procedureParams.isEmpty() ? RxDocumentClientImpl.serializeProcedureParams(procedureParams) : "", requestHeaders, (Object)options);
            if (retryPolicy != null) {
                retryPolicy.onBeforeSendRequest(request);
            }
            Mono<RxDocumentServiceRequest> reqObs = this.addPartitionKeyInformation(request, null, null, options);
            return reqObs.flatMap(req -> this.create(request, retryPolicy).map(response -> {
                this.captureSessionToken(request, (RxDocumentServiceResponse)response);
                return BridgeInternal.toStoredProcedureResponse(response);
            }));
        }
        catch (Exception e) {
            this.logger.debug("Failure in executing a StoredProcedure due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Trigger>> createTrigger(String collectionLink, Trigger trigger, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createTriggerInternal(collectionLink, trigger, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Trigger>> createTriggerInternal(String collectionLink, Trigger trigger, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            this.logger.debug("Creating a Trigger. collectionLink [{}], trigger id [{}]", (Object)collectionLink, (Object)trigger.getId());
            RxDocumentServiceRequest request = this.getTriggerRequest(collectionLink, trigger, options, OperationType.Create);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.create(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, Trigger.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in creating a Trigger due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Trigger>> upsertTrigger(String collectionLink, Trigger trigger, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.upsertTriggerInternal(collectionLink, trigger, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Trigger>> upsertTriggerInternal(String collectionLink, Trigger trigger, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            this.logger.debug("Upserting a Trigger. collectionLink [{}], trigger id [{}]", (Object)collectionLink, (Object)trigger.getId());
            RxDocumentServiceRequest request = this.getTriggerRequest(collectionLink, trigger, options, OperationType.Upsert);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.upsert(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, Trigger.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in upserting a Trigger due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    private RxDocumentServiceRequest getTriggerRequest(String collectionLink, Trigger trigger, RequestOptions options, OperationType operationType) {
        if (StringUtils.isEmpty(collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (trigger == null) {
            throw new IllegalArgumentException("trigger");
        }
        RxDocumentClientImpl.validateResource(trigger);
        String path = Utils.joinPath(collectionLink, "triggers");
        Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Trigger, operationType);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create(operationType, ResourceType.Trigger, path, (Resource)trigger, requestHeaders, (Object)options);
        return request;
    }

    @Override
    public Mono<ResourceResponse<Trigger>> replaceTrigger(Trigger trigger, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceTriggerInternal(trigger, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Trigger>> replaceTriggerInternal(Trigger trigger, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (trigger == null) {
                throw new IllegalArgumentException("trigger");
            }
            this.logger.debug("Replacing a Trigger. trigger id [{}]", (Object)trigger.getId());
            RxDocumentClientImpl.validateResource(trigger);
            String path = Utils.joinPath(trigger.getSelfLink(), null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Trigger, OperationType.Replace);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Replace, ResourceType.Trigger, path, (Resource)trigger, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.replace(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, Trigger.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in replacing a Trigger due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Trigger>> deleteTrigger(String triggerLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteTriggerInternal(triggerLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Trigger>> deleteTriggerInternal(String triggerLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(triggerLink)) {
                throw new IllegalArgumentException("triggerLink");
            }
            this.logger.debug("Deleting a Trigger. triggerLink [{}]", (Object)triggerLink);
            String path = Utils.joinPath(triggerLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Trigger, OperationType.Delete);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Delete, ResourceType.Trigger, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.delete(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, Trigger.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in deleting a Trigger due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Trigger>> readTrigger(String triggerLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readTriggerInternal(triggerLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Trigger>> readTriggerInternal(String triggerLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(triggerLink)) {
                throw new IllegalArgumentException("triggerLink");
            }
            this.logger.debug("Reading a Trigger. triggerLink [{}]", (Object)triggerLink);
            String path = Utils.joinPath(triggerLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Trigger, OperationType.Read);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Read, ResourceType.Trigger, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, Trigger.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in reading a Trigger due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<Trigger>> readTriggers(String collectionLink, CosmosQueryRequestOptions options) {
        if (StringUtils.isEmpty(collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        return this.readFeed(options, ResourceType.Trigger, Trigger.class, Utils.joinPath(collectionLink, "triggers"));
    }

    @Override
    public Flux<FeedResponse<Trigger>> queryTriggers(String collectionLink, String query, CosmosQueryRequestOptions options) {
        return this.queryTriggers(collectionLink, new SqlQuerySpec(query), options);
    }

    @Override
    public Flux<FeedResponse<Trigger>> queryTriggers(String collectionLink, SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        return this.createQuery(collectionLink, querySpec, options, Trigger.class, ResourceType.Trigger);
    }

    @Override
    public Mono<ResourceResponse<UserDefinedFunction>> createUserDefinedFunction(String collectionLink, UserDefinedFunction udf, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createUserDefinedFunctionInternal(collectionLink, udf, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<UserDefinedFunction>> createUserDefinedFunctionInternal(String collectionLink, UserDefinedFunction udf, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            this.logger.debug("Creating a UserDefinedFunction. collectionLink [{}], udf id [{}]", (Object)collectionLink, (Object)udf.getId());
            RxDocumentServiceRequest request = this.getUserDefinedFunctionRequest(collectionLink, udf, options, OperationType.Create);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.create(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, UserDefinedFunction.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in creating a UserDefinedFunction due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<UserDefinedFunction>> upsertUserDefinedFunction(String collectionLink, UserDefinedFunction udf, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.upsertUserDefinedFunctionInternal(collectionLink, udf, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<UserDefinedFunction>> upsertUserDefinedFunctionInternal(String collectionLink, UserDefinedFunction udf, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            this.logger.debug("Upserting a UserDefinedFunction. collectionLink [{}], udf id [{}]", (Object)collectionLink, (Object)udf.getId());
            RxDocumentServiceRequest request = this.getUserDefinedFunctionRequest(collectionLink, udf, options, OperationType.Upsert);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.upsert(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, UserDefinedFunction.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in upserting a UserDefinedFunction due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<UserDefinedFunction>> replaceUserDefinedFunction(UserDefinedFunction udf, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceUserDefinedFunctionInternal(udf, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<UserDefinedFunction>> replaceUserDefinedFunctionInternal(UserDefinedFunction udf, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (udf == null) {
                throw new IllegalArgumentException("udf");
            }
            this.logger.debug("Replacing a UserDefinedFunction. udf id [{}]", (Object)udf.getId());
            RxDocumentClientImpl.validateResource(udf);
            String path = Utils.joinPath(udf.getSelfLink(), null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.UserDefinedFunction, OperationType.Replace);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Replace, ResourceType.UserDefinedFunction, path, (Resource)udf, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.replace(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, UserDefinedFunction.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in replacing a UserDefinedFunction due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<UserDefinedFunction>> deleteUserDefinedFunction(String udfLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteUserDefinedFunctionInternal(udfLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<UserDefinedFunction>> deleteUserDefinedFunctionInternal(String udfLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(udfLink)) {
                throw new IllegalArgumentException("udfLink");
            }
            this.logger.debug("Deleting a UserDefinedFunction. udfLink [{}]", (Object)udfLink);
            String path = Utils.joinPath(udfLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.UserDefinedFunction, OperationType.Delete);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Delete, ResourceType.UserDefinedFunction, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.delete(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, UserDefinedFunction.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in deleting a UserDefinedFunction due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<UserDefinedFunction>> readUserDefinedFunction(String udfLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readUserDefinedFunctionInternal(udfLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<UserDefinedFunction>> readUserDefinedFunctionInternal(String udfLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(udfLink)) {
                throw new IllegalArgumentException("udfLink");
            }
            this.logger.debug("Reading a UserDefinedFunction. udfLink [{}]", (Object)udfLink);
            String path = Utils.joinPath(udfLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.UserDefinedFunction, OperationType.Read);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Read, ResourceType.UserDefinedFunction, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, UserDefinedFunction.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in reading a UserDefinedFunction due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<UserDefinedFunction>> readUserDefinedFunctions(String collectionLink, CosmosQueryRequestOptions options) {
        if (StringUtils.isEmpty(collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        return this.readFeed(options, ResourceType.UserDefinedFunction, UserDefinedFunction.class, Utils.joinPath(collectionLink, "udfs"));
    }

    @Override
    public Flux<FeedResponse<UserDefinedFunction>> queryUserDefinedFunctions(String collectionLink, String query, CosmosQueryRequestOptions options) {
        return this.queryUserDefinedFunctions(collectionLink, new SqlQuerySpec(query), options);
    }

    @Override
    public Flux<FeedResponse<UserDefinedFunction>> queryUserDefinedFunctions(String collectionLink, SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        return this.createQuery(collectionLink, querySpec, options, UserDefinedFunction.class, ResourceType.UserDefinedFunction);
    }

    @Override
    public Mono<ResourceResponse<Conflict>> readConflict(String conflictLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readConflictInternal(conflictLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Conflict>> readConflictInternal(String conflictLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(conflictLink)) {
                throw new IllegalArgumentException("conflictLink");
            }
            this.logger.debug("Reading a Conflict. conflictLink [{}]", (Object)conflictLink);
            String path = Utils.joinPath(conflictLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Conflict, OperationType.Read);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Read, ResourceType.Conflict, path, requestHeaders, options);
            Mono<RxDocumentServiceRequest> reqObs = this.addPartitionKeyInformation(request, null, null, options);
            return reqObs.flatMap(req -> {
                if (retryPolicyInstance != null) {
                    retryPolicyInstance.onBeforeSendRequest(request);
                }
                return this.read(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, Conflict.class));
            });
        }
        catch (Exception e) {
            this.logger.debug("Failure in reading a Conflict due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<Conflict>> readConflicts(String collectionLink, CosmosQueryRequestOptions options) {
        if (StringUtils.isEmpty(collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        return this.readFeed(options, ResourceType.Conflict, Conflict.class, Utils.joinPath(collectionLink, "conflicts"));
    }

    @Override
    public Flux<FeedResponse<Conflict>> queryConflicts(String collectionLink, String query, CosmosQueryRequestOptions options) {
        return this.queryConflicts(collectionLink, new SqlQuerySpec(query), options);
    }

    @Override
    public Flux<FeedResponse<Conflict>> queryConflicts(String collectionLink, SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        return this.createQuery(collectionLink, querySpec, options, Conflict.class, ResourceType.Conflict);
    }

    @Override
    public Mono<ResourceResponse<Conflict>> deleteConflict(String conflictLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteConflictInternal(conflictLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Conflict>> deleteConflictInternal(String conflictLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(conflictLink)) {
                throw new IllegalArgumentException("conflictLink");
            }
            this.logger.debug("Deleting a Conflict. conflictLink [{}]", (Object)conflictLink);
            String path = Utils.joinPath(conflictLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Conflict, OperationType.Delete);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Delete, ResourceType.Conflict, path, requestHeaders, options);
            Mono<RxDocumentServiceRequest> reqObs = this.addPartitionKeyInformation(request, null, null, options);
            return reqObs.flatMap(req -> {
                if (retryPolicyInstance != null) {
                    retryPolicyInstance.onBeforeSendRequest(request);
                }
                return this.delete(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, Conflict.class));
            });
        }
        catch (Exception e) {
            this.logger.debug("Failure in deleting a Conflict due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<User>> createUser(String databaseLink, User user, RequestOptions options) {
        DocumentClientRetryPolicy documentClientRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createUserInternal(databaseLink, user, options, documentClientRetryPolicy), documentClientRetryPolicy);
    }

    private Mono<ResourceResponse<User>> createUserInternal(String databaseLink, User user, RequestOptions options, DocumentClientRetryPolicy documentClientRetryPolicy) {
        try {
            this.logger.debug("Creating a User. databaseLink [{}], user id [{}]", (Object)databaseLink, (Object)user.getId());
            RxDocumentServiceRequest request = this.getUserRequest(databaseLink, user, options, OperationType.Create);
            return this.create(request, documentClientRetryPolicy).map(response -> BridgeInternal.toResourceResponse(response, User.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in creating a User due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<User>> upsertUser(String databaseLink, User user, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.upsertUserInternal(databaseLink, user, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<User>> upsertUserInternal(String databaseLink, User user, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            this.logger.debug("Upserting a User. databaseLink [{}], user id [{}]", (Object)databaseLink, (Object)user.getId());
            RxDocumentServiceRequest request = this.getUserRequest(databaseLink, user, options, OperationType.Upsert);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.upsert(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, User.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in upserting a User due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    private RxDocumentServiceRequest getUserRequest(String databaseLink, User user, RequestOptions options, OperationType operationType) {
        if (StringUtils.isEmpty(databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        if (user == null) {
            throw new IllegalArgumentException("user");
        }
        RxDocumentClientImpl.validateResource(user);
        String path = Utils.joinPath(databaseLink, "users");
        Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.User, operationType);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create(operationType, ResourceType.User, path, (Resource)user, requestHeaders, (Object)options);
        return request;
    }

    @Override
    public Mono<ResourceResponse<User>> replaceUser(User user, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceUserInternal(user, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<User>> replaceUserInternal(User user, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (user == null) {
                throw new IllegalArgumentException("user");
            }
            this.logger.debug("Replacing a User. user id [{}]", (Object)user.getId());
            RxDocumentClientImpl.validateResource(user);
            String path = Utils.joinPath(user.getSelfLink(), null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.User, OperationType.Replace);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Replace, ResourceType.User, path, (Resource)user, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.replace(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, User.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in replacing a User due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<User>> deleteUser(String userLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteUserInternal(userLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<User>> deleteUserInternal(String userLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(userLink)) {
                throw new IllegalArgumentException("userLink");
            }
            this.logger.debug("Deleting a User. userLink [{}]", (Object)userLink);
            String path = Utils.joinPath(userLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.User, OperationType.Delete);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Delete, ResourceType.User, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.delete(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, User.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in deleting a User due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<User>> readUser(String userLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readUserInternal(userLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<User>> readUserInternal(String userLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(userLink)) {
                throw new IllegalArgumentException("userLink");
            }
            this.logger.debug("Reading a User. userLink [{}]", (Object)userLink);
            String path = Utils.joinPath(userLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.User, OperationType.Read);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Read, ResourceType.User, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, User.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in reading a User due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<User>> readUsers(String databaseLink, CosmosQueryRequestOptions options) {
        if (StringUtils.isEmpty(databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        return this.readFeed(options, ResourceType.User, User.class, Utils.joinPath(databaseLink, "users"));
    }

    @Override
    public Flux<FeedResponse<User>> queryUsers(String databaseLink, String query, CosmosQueryRequestOptions options) {
        return this.queryUsers(databaseLink, new SqlQuerySpec(query), options);
    }

    @Override
    public Flux<FeedResponse<User>> queryUsers(String databaseLink, SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        return this.createQuery(databaseLink, querySpec, options, User.class, ResourceType.User);
    }

    @Override
    public Mono<ResourceResponse<Permission>> createPermission(String userLink, Permission permission, RequestOptions options) {
        DocumentClientRetryPolicy documentClientRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createPermissionInternal(userLink, permission, options, documentClientRetryPolicy), this.resetSessionTokenRetryPolicy.getRequestPolicy());
    }

    private Mono<ResourceResponse<Permission>> createPermissionInternal(String userLink, Permission permission, RequestOptions options, DocumentClientRetryPolicy documentClientRetryPolicy) {
        try {
            this.logger.debug("Creating a Permission. userLink [{}], permission id [{}]", (Object)userLink, (Object)permission.getId());
            RxDocumentServiceRequest request = this.getPermissionRequest(userLink, permission, options, OperationType.Create);
            return this.create(request, documentClientRetryPolicy).map(response -> BridgeInternal.toResourceResponse(response, Permission.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in creating a Permission due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Permission>> upsertPermission(String userLink, Permission permission, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.upsertPermissionInternal(userLink, permission, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Permission>> upsertPermissionInternal(String userLink, Permission permission, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            this.logger.debug("Upserting a Permission. userLink [{}], permission id [{}]", (Object)userLink, (Object)permission.getId());
            RxDocumentServiceRequest request = this.getPermissionRequest(userLink, permission, options, OperationType.Upsert);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.upsert(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, Permission.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in upserting a Permission due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    private RxDocumentServiceRequest getPermissionRequest(String userLink, Permission permission, RequestOptions options, OperationType operationType) {
        if (StringUtils.isEmpty(userLink)) {
            throw new IllegalArgumentException("userLink");
        }
        if (permission == null) {
            throw new IllegalArgumentException("permission");
        }
        RxDocumentClientImpl.validateResource(permission);
        String path = Utils.joinPath(userLink, "permissions");
        Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Permission, operationType);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create(operationType, ResourceType.Permission, path, (Resource)permission, requestHeaders, (Object)options);
        return request;
    }

    @Override
    public Mono<ResourceResponse<Permission>> replacePermission(Permission permission, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replacePermissionInternal(permission, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Permission>> replacePermissionInternal(Permission permission, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (permission == null) {
                throw new IllegalArgumentException("permission");
            }
            this.logger.debug("Replacing a Permission. permission id [{}]", (Object)permission.getId());
            RxDocumentClientImpl.validateResource(permission);
            String path = Utils.joinPath(permission.getSelfLink(), null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Permission, OperationType.Replace);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Replace, ResourceType.Permission, path, (Resource)permission, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.replace(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, Permission.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in replacing a Permission due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Permission>> deletePermission(String permissionLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deletePermissionInternal(permissionLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Permission>> deletePermissionInternal(String permissionLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(permissionLink)) {
                throw new IllegalArgumentException("permissionLink");
            }
            this.logger.debug("Deleting a Permission. permissionLink [{}]", (Object)permissionLink);
            String path = Utils.joinPath(permissionLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Permission, OperationType.Delete);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Delete, ResourceType.Permission, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.delete(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, Permission.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in deleting a Permission due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Permission>> readPermission(String permissionLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readPermissionInternal(permissionLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Permission>> readPermissionInternal(String permissionLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(permissionLink)) {
                throw new IllegalArgumentException("permissionLink");
            }
            this.logger.debug("Reading a Permission. permissionLink [{}]", (Object)permissionLink);
            String path = Utils.joinPath(permissionLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Permission, OperationType.Read);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Read, ResourceType.Permission, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, Permission.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in reading a Permission due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<Permission>> readPermissions(String userLink, CosmosQueryRequestOptions options) {
        if (StringUtils.isEmpty(userLink)) {
            throw new IllegalArgumentException("userLink");
        }
        return this.readFeed(options, ResourceType.Permission, Permission.class, Utils.joinPath(userLink, "permissions"));
    }

    @Override
    public Flux<FeedResponse<Permission>> queryPermissions(String userLink, String query, CosmosQueryRequestOptions options) {
        return this.queryPermissions(userLink, new SqlQuerySpec(query), options);
    }

    @Override
    public Flux<FeedResponse<Permission>> queryPermissions(String userLink, SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        return this.createQuery(userLink, querySpec, options, Permission.class, ResourceType.Permission);
    }

    @Override
    public Mono<ResourceResponse<Offer>> replaceOffer(Offer offer) {
        DocumentClientRetryPolicy documentClientRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceOfferInternal(offer, documentClientRetryPolicy), documentClientRetryPolicy);
    }

    private Mono<ResourceResponse<Offer>> replaceOfferInternal(Offer offer, DocumentClientRetryPolicy documentClientRetryPolicy) {
        try {
            if (offer == null) {
                throw new IllegalArgumentException("offer");
            }
            this.logger.debug("Replacing an Offer. offer id [{}]", (Object)offer.getId());
            RxDocumentClientImpl.validateResource(offer);
            String path = Utils.joinPath(offer.getSelfLink(), null);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Replace, ResourceType.Offer, path, (Resource)offer, null, null);
            return this.replace(request, documentClientRetryPolicy).map(response -> BridgeInternal.toResourceResponse(response, Offer.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in replacing an Offer due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Offer>> readOffer(String offerLink) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readOfferInternal(offerLink, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Offer>> readOfferInternal(String offerLink, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(offerLink)) {
                throw new IllegalArgumentException("offerLink");
            }
            this.logger.debug("Reading an Offer. offerLink [{}]", (Object)offerLink);
            String path = Utils.joinPath(offerLink, null);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Read, ResourceType.Offer, path, (Map<String, String>)null, null);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, Offer.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in reading an Offer due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<Offer>> readOffers(CosmosQueryRequestOptions options) {
        return this.readFeed(options, ResourceType.Offer, Offer.class, Utils.joinPath("offers", null));
    }

    private <T extends Resource> Flux<FeedResponse<T>> readFeed(CosmosQueryRequestOptions options, ResourceType resourceType, Class<T> klass, String resourceLink) {
        Integer maxItemCount;
        if (options == null) {
            options = new CosmosQueryRequestOptions();
        }
        int maxPageSize = (maxItemCount = ModelBridgeInternal.getMaxItemCountFromQueryRequestOptions(options)) != null ? maxItemCount : -1;
        CosmosQueryRequestOptions finalCosmosQueryRequestOptions = options;
        BiFunction<String, Integer, RxDocumentServiceRequest> createRequestFunc = (continuationToken, pageSize) -> {
            HashMap<String, String> requestHeaders = new HashMap<String, String>();
            if (continuationToken != null) {
                requestHeaders.put("x-ms-continuation", (String)continuationToken);
            }
            requestHeaders.put("x-ms-max-item-count", Integer.toString(pageSize));
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.ReadFeed, resourceType, resourceLink, requestHeaders, finalCosmosQueryRequestOptions);
            return request;
        };
        Function executeFunc = request -> ObservableHelper.inlineIfPossibleAsObs(() -> this.readFeed((RxDocumentServiceRequest)request).map(response -> BridgeInternal.toFeedResponsePage(response, klass)), this.resetSessionTokenRetryPolicy.getRequestPolicy());
        return Paginator.getPaginatedQueryResultAsObservable(options, createRequestFunc, executeFunc, klass, maxPageSize);
    }

    @Override
    public Flux<FeedResponse<Offer>> queryOffers(String query, CosmosQueryRequestOptions options) {
        return this.queryOffers(new SqlQuerySpec(query), options);
    }

    @Override
    public Flux<FeedResponse<Offer>> queryOffers(SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        return this.createQuery(null, querySpec, options, Offer.class, ResourceType.Offer);
    }

    @Override
    public Mono<DatabaseAccount> getDatabaseAccount() {
        DocumentClientRetryPolicy documentClientRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.getDatabaseAccountInternal(documentClientRetryPolicy), documentClientRetryPolicy);
    }

    private Mono<DatabaseAccount> getDatabaseAccountInternal(DocumentClientRetryPolicy documentClientRetryPolicy) {
        try {
            this.logger.debug("Getting Database Account");
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Read, ResourceType.DatabaseAccount, "", (Map<String, String>)null, null);
            return this.read(request, documentClientRetryPolicy).map(response -> ModelBridgeInternal.toDatabaseAccount(response));
        }
        catch (Exception e) {
            this.logger.debug("Failure in getting Database Account due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    public Object getSession() {
        return this.sessionContainer;
    }

    public void setSession(Object sessionContainer) {
        this.sessionContainer = (SessionContainer)sessionContainer;
    }

    public RxPartitionKeyRangeCache getPartitionKeyRangeCache() {
        return this.partitionKeyRangeCache;
    }

    public Flux<DatabaseAccount> getDatabaseAccountFromEndpoint(URI endpoint) {
        return Flux.defer(() -> {
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Read, ResourceType.DatabaseAccount, "", null, null);
            this.populateHeaders(request, RequestVerb.GET);
            request.setEndpointOverride(endpoint);
            return this.gatewayProxy.processMessage(request).doOnError(e -> {
                String message = String.format("Failed to retrieve database account information. %s", e.getCause() != null ? e.getCause().toString() : e.toString());
                this.logger.warn(message);
            }).map(rsp -> rsp.getResource(DatabaseAccount.class)).doOnNext(databaseAccount -> {
                this.useMultipleWriteLocations = this.connectionPolicy.isMultipleWriteRegionsEnabled() && BridgeInternal.isEnableMultipleWriteLocations(databaseAccount);
            });
        });
    }

    private RxStoreModel getStoreProxy(RxDocumentServiceRequest request) {
        if (request.UseGatewayMode) {
            return this.gatewayProxy;
        }
        ResourceType resourceType = request.getResourceType();
        OperationType operationType = request.getOperationType();
        if (resourceType == ResourceType.Offer || resourceType.isScript() && operationType != OperationType.ExecuteJavaScript || resourceType == ResourceType.PartitionKeyRange) {
            return this.gatewayProxy;
        }
        if (operationType == OperationType.Create || operationType == OperationType.Upsert) {
            if (resourceType == ResourceType.Database || resourceType == ResourceType.User || resourceType == ResourceType.DocumentCollection || resourceType == ResourceType.Permission) {
                return this.gatewayProxy;
            }
            return this.storeModel;
        }
        if (operationType == OperationType.Delete) {
            if (resourceType == ResourceType.Database || resourceType == ResourceType.User || resourceType == ResourceType.DocumentCollection) {
                return this.gatewayProxy;
            }
            return this.storeModel;
        }
        if (operationType == OperationType.Replace) {
            if (resourceType == ResourceType.DocumentCollection) {
                return this.gatewayProxy;
            }
            return this.storeModel;
        }
        if (operationType == OperationType.Read) {
            if (resourceType == ResourceType.DocumentCollection) {
                return this.gatewayProxy;
            }
            return this.storeModel;
        }
        if ((request.getOperationType() == OperationType.Query || request.getOperationType() == OperationType.SqlQuery) && Utils.isCollectionChild(request.getResourceType()) && request.getPartitionKeyRangeIdentity() == null) {
            return this.gatewayProxy;
        }
        return this.storeModel;
    }

    @Override
    public void close() {
        this.logger.info("Shutting down ...");
        this.logger.info("Closing Global Endpoint Manager ...");
        LifeCycleUtils.closeQuietly(this.globalEndpointManager);
        this.logger.info("Closing StoreClientFactory ...");
        LifeCycleUtils.closeQuietly(this.storeClientFactory);
        this.logger.info("Shutting down reactorHttpClient ...");
        try {
            this.reactorHttpClient.shutdown();
        }
        catch (Exception e) {
            this.logger.warn("shutting down reactorHttpClient failed", (Throwable)e);
        }
        this.logger.info("Shutting down completed.");
    }

    @Override
    public ItemDeserializer getItemDeserializer() {
        return this.itemDeserializer;
    }
}

