/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.caches;

import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

class AsyncLazy<TValue> {
    private static final Logger logger = LoggerFactory.getLogger(AsyncLazy.class);
    private final Mono<TValue> single;
    private volatile boolean succeeded;
    private volatile boolean failed;

    public AsyncLazy(Callable<Mono<TValue>> func) {
        this(Mono.defer(() -> {
            logger.debug("using Function<Mono<TValue>> {}", (Object)func);
            try {
                return (Mono)func.call();
            }
            catch (Exception e) {
                return Mono.error((Throwable)e);
            }
        }));
    }

    public AsyncLazy(TValue value) {
        this.single = Mono.just(value);
        this.succeeded = true;
        this.failed = false;
    }

    private AsyncLazy(Mono<TValue> single) {
        logger.debug("constructor");
        this.single = single.doOnSuccess(v -> {
            this.succeeded = true;
        }).doOnError(e -> {
            this.failed = true;
        }).cache();
    }

    public Mono<TValue> single() {
        return this.single;
    }

    public boolean isSucceeded() {
        return this.succeeded;
    }

    public boolean isFaulted() {
        return this.failed;
    }
}

