/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.rntbd;

import com.azure.cosmos.implementation.UserAgentContainer;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdConstants;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdObjectMapper;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequestFrame;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdToken;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdTokenStream;
import com.azure.cosmos.implementation.guava27.Strings;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.CorruptedFrameException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;

public final class RntbdContextRequest {
    @JsonProperty
    private final UUID activityId;
    @JsonProperty
    private final Headers headers;

    RntbdContextRequest(UUID activityId, UserAgentContainer userAgent) {
        this(activityId, new Headers(userAgent));
    }

    private RntbdContextRequest(UUID activityId, Headers headers) {
        this.activityId = activityId;
        this.headers = headers;
    }

    public UUID getActivityId() {
        return this.activityId;
    }

    public String getClientVersion() {
        return this.headers.clientVersion.getValue(String.class);
    }

    public static RntbdContextRequest decode(ByteBuf in) {
        int resourceOperationTypeCode = in.getInt(in.readerIndex() + 4);
        if (resourceOperationTypeCode != 0) {
            String reason = String.format("resourceOperationCode=0x%08X", resourceOperationTypeCode);
            throw new IllegalStateException(reason);
        }
        int start = in.readerIndex();
        int expectedLength = in.readIntLE();
        RntbdRequestFrame header = RntbdRequestFrame.decode(in);
        Headers headers = Headers.decode(in.readSlice(expectedLength - (in.readerIndex() - start)));
        int observedLength = in.readerIndex() - start;
        if (observedLength != expectedLength) {
            String reason = Strings.lenientFormat("expectedLength=%s, observedLength=%s", expectedLength, observedLength);
            throw new IllegalStateException(reason);
        }
        in.discardReadBytes();
        return new RntbdContextRequest(header.getActivityId(), headers);
    }

    public void encode(ByteBuf out) {
        int expectedLength = 24 + this.headers.computeLength();
        int start = out.writerIndex();
        out.writeIntLE(expectedLength);
        RntbdRequestFrame header = new RntbdRequestFrame(this.getActivityId(), RntbdConstants.RntbdOperationType.Connection, RntbdConstants.RntbdResourceType.Connection);
        header.encode(out);
        this.headers.encode(out);
        int observedLength = out.writerIndex() - start;
        if (observedLength != expectedLength) {
            String reason = Strings.lenientFormat("expectedLength=%s, observedLength=%s", expectedLength, observedLength);
            throw new IllegalStateException(reason);
        }
    }

    public String toString() {
        ObjectWriter writer = RntbdObjectMapper.writer();
        try {
            return writer.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException error) {
            throw new CorruptedFrameException((Throwable)error);
        }
    }

    private static final class Headers
    extends RntbdTokenStream<RntbdConstants.RntbdContextRequestHeader> {
        private static final byte[] ClientVersion = "2018-12-31".getBytes(StandardCharsets.UTF_8);
        @JsonProperty
        RntbdToken clientVersion = this.get(RntbdConstants.RntbdContextRequestHeader.ClientVersion);
        @JsonProperty
        RntbdToken protocolVersion = this.get(RntbdConstants.RntbdContextRequestHeader.ProtocolVersion);
        @JsonProperty
        RntbdToken userAgent = this.get(RntbdConstants.RntbdContextRequestHeader.UserAgent);

        Headers(UserAgentContainer container) {
            this(Unpooled.EMPTY_BUFFER);
            this.clientVersion.setValue(ClientVersion);
            this.userAgent.setValue(container.getUserAgent());
            this.protocolVersion.setValue(1);
        }

        private Headers(ByteBuf in) {
            super(RntbdConstants.RntbdContextRequestHeader.set, RntbdConstants.RntbdContextRequestHeader.map, in);
        }

        static Headers decode(ByteBuf in) {
            return Headers.decode(new Headers(in));
        }
    }
}

