/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.DocumentClientRetryPolicy;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.QueryMetrics;
import com.azure.cosmos.implementation.RequestChargeTracker;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.NotImplementedException;
import com.azure.cosmos.implementation.apachecommons.lang.tuple.ImmutablePair;
import com.azure.cosmos.implementation.query.CompositeContinuationToken;
import com.azure.cosmos.implementation.query.IDocumentQueryClient;
import com.azure.cosmos.implementation.query.IDocumentQueryExecutionComponent;
import com.azure.cosmos.implementation.query.OrderByContinuationToken;
import com.azure.cosmos.implementation.query.OrderByDocumentProducer;
import com.azure.cosmos.implementation.query.OrderByUtils;
import com.azure.cosmos.implementation.query.ParallelDocumentQueryExecutionContextBase;
import com.azure.cosmos.implementation.query.PipelinedDocumentQueryParams;
import com.azure.cosmos.implementation.query.QueryItem;
import com.azure.cosmos.implementation.query.SortOrder;
import com.azure.cosmos.implementation.query.TriFunction;
import com.azure.cosmos.implementation.query.orderbyquery.OrderByRowResult;
import com.azure.cosmos.implementation.query.orderbyquery.OrderbyRowComparer;
import com.azure.cosmos.implementation.routing.Range;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.SqlQuerySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class OrderByDocumentQueryExecutionContext<T extends Resource>
extends ParallelDocumentQueryExecutionContextBase<T> {
    private static final String FormatPlaceHolder = "{documentdb-formattableorderbyquery-filter}";
    private static final String True = "true";
    private final String collectionRid;
    private final OrderbyRowComparer<T> consumeComparer;
    private final RequestChargeTracker tracker;
    private final ConcurrentMap<String, QueryMetrics> queryMetricMap;
    private Flux<OrderByRowResult<T>> orderByObservable;
    private final Map<String, OrderByContinuationToken> targetRangeToOrderByContinuationTokenMap;

    private OrderByDocumentQueryExecutionContext(IDocumentQueryClient client, List<PartitionKeyRange> partitionKeyRanges, ResourceType resourceTypeEnum, Class<T> klass, SqlQuerySpec query, CosmosQueryRequestOptions cosmosQueryRequestOptions, String resourceLink, String rewrittenQuery, boolean isContinuationExpected, boolean getLazyFeedResponse, OrderbyRowComparer<T> consumeComparer, String collectionRid, UUID correlatedActivityId) {
        super(client, partitionKeyRanges, resourceTypeEnum, klass, query, cosmosQueryRequestOptions, resourceLink, rewrittenQuery, isContinuationExpected, getLazyFeedResponse, correlatedActivityId);
        this.collectionRid = collectionRid;
        this.consumeComparer = consumeComparer;
        this.tracker = new RequestChargeTracker();
        this.queryMetricMap = new ConcurrentHashMap<String, QueryMetrics>();
        this.targetRangeToOrderByContinuationTokenMap = new HashMap<String, OrderByContinuationToken>();
    }

    public static <T extends Resource> Flux<IDocumentQueryExecutionComponent<T>> createAsync(IDocumentQueryClient client, PipelinedDocumentQueryParams<T> initParams) {
        OrderByDocumentQueryExecutionContext<T> context = new OrderByDocumentQueryExecutionContext<T>(client, initParams.getPartitionKeyRanges(), initParams.getResourceTypeEnum(), initParams.getResourceType(), initParams.getQuery(), initParams.getCosmosQueryRequestOptions(), initParams.getResourceLink(), initParams.getQueryInfo().getRewrittenQuery(), initParams.isContinuationExpected(), initParams.isGetLazyResponseFeed(), new OrderbyRowComparer(initParams.getQueryInfo().getOrderBy()), initParams.getCollectionRid(), initParams.getCorrelatedActivityId());
        context.setTop(initParams.getTop());
        try {
            super.initialize(initParams.getPartitionKeyRanges(), initParams.getQueryInfo().getOrderBy(), initParams.getQueryInfo().getOrderByExpressions(), initParams.getInitialPageSize(), ModelBridgeInternal.getRequestContinuationFromQueryRequestOptions(initParams.getCosmosQueryRequestOptions()));
            return Flux.just(context);
        }
        catch (CosmosException dce) {
            return Flux.error((Throwable)((Object)dce));
        }
    }

    private void initialize(List<PartitionKeyRange> partitionKeyRanges, List<SortOrder> sortOrders, Collection<String> orderByExpressions, int initialPageSize, String continuationToken) throws CosmosException {
        if (continuationToken == null) {
            HashMap<PartitionKeyRange, String> partitionKeyRangeToContinuationToken = new HashMap<PartitionKeyRange, String>();
            for (PartitionKeyRange partitionKeyRange : partitionKeyRanges) {
                partitionKeyRangeToContinuationToken.put(partitionKeyRange, null);
            }
            super.initialize(this.collectionRid, partitionKeyRangeToContinuationToken, initialPageSize, new SqlQuerySpec(this.querySpec.getQueryText().replace(FormatPlaceHolder, True), this.querySpec.getParameters()));
        } else {
            Utils.ValueHolder<OrderByContinuationToken> outOrderByContinuationToken = new Utils.ValueHolder<OrderByContinuationToken>();
            if (!OrderByContinuationToken.tryParse(continuationToken, outOrderByContinuationToken)) {
                String message = String.format("INVALID JSON in continuation token %s for OrderBy~Context", continuationToken);
                throw BridgeInternal.createCosmosException(400, message);
            }
            OrderByContinuationToken orderByContinuationToken = (OrderByContinuationToken)outOrderByContinuationToken.v;
            CompositeContinuationToken compositeContinuationToken = orderByContinuationToken.getCompositeContinuationToken();
            if (compositeContinuationToken.getRange().isEmpty()) {
                String message = String.format("INVALID RANGE in the continuation token %s for OrderBy~Context.", continuationToken);
                throw BridgeInternal.createCosmosException(400, message);
            }
            ImmutablePair<Integer, FormattedFilterInfo> targetIndexAndFilters = this.getFiltersForPartitions(orderByContinuationToken, partitionKeyRanges, sortOrders, orderByExpressions);
            int targetIndex = (Integer)targetIndexAndFilters.left;
            this.targetRangeToOrderByContinuationTokenMap.put(partitionKeyRanges.get(targetIndex).getId(), orderByContinuationToken);
            FormattedFilterInfo formattedFilterInfo = (FormattedFilterInfo)targetIndexAndFilters.right;
            String filterForRangesLeftOfTheTargetRange = formattedFilterInfo.getFilterForRangesLeftOfTheTargetRange();
            this.initializeRangeWithContinuationTokenAndFilter(partitionKeyRanges, 0, targetIndex, null, filterForRangesLeftOfTheTargetRange, initialPageSize);
            String filterForTargetRange = formattedFilterInfo.getFilterForTargetRange();
            this.initializeRangeWithContinuationTokenAndFilter(partitionKeyRanges, targetIndex, targetIndex + 1, null, filterForTargetRange, initialPageSize);
            String filterForRangesRightOfTheTargetRange = formattedFilterInfo.getFilterForRangesRightOfTheTargetRange();
            this.initializeRangeWithContinuationTokenAndFilter(partitionKeyRanges, targetIndex + 1, partitionKeyRanges.size(), null, filterForRangesRightOfTheTargetRange, initialPageSize);
        }
        this.orderByObservable = OrderByUtils.orderedMerge(this.resourceType, this.consumeComparer, this.tracker, this.documentProducers, this.queryMetricMap, this.targetRangeToOrderByContinuationTokenMap);
    }

    private void initializeRangeWithContinuationTokenAndFilter(List<PartitionKeyRange> partitionKeyRanges, int startInclusive, int endExclusive, String continuationToken, String filter, int initialPageSize) {
        HashMap<PartitionKeyRange, String> partitionKeyRangeToContinuationToken = new HashMap<PartitionKeyRange, String>();
        for (int i = startInclusive; i < endExclusive; ++i) {
            PartitionKeyRange partitionKeyRange = partitionKeyRanges.get(i);
            partitionKeyRangeToContinuationToken.put(partitionKeyRange, continuationToken);
        }
        super.initialize(this.collectionRid, partitionKeyRangeToContinuationToken, initialPageSize, new SqlQuerySpec(this.querySpec.getQueryText().replace(FormatPlaceHolder, filter), this.querySpec.getParameters()));
    }

    private ImmutablePair<Integer, FormattedFilterInfo> getFiltersForPartitions(OrderByContinuationToken orderByContinuationToken, List<PartitionKeyRange> partitionKeyRanges, List<SortOrder> sortOrders, Collection<String> orderByExpressions) {
        int startIndex = this.findTargetRangeAndExtractContinuationTokens(partitionKeyRanges, orderByContinuationToken.getCompositeContinuationToken().getRange());
        FormattedFilterInfo formattedFilterInfo = this.getFormattedFilters(orderByExpressions, orderByContinuationToken.getOrderByItems(), sortOrders, orderByContinuationToken.getInclusive());
        return new ImmutablePair<Integer, FormattedFilterInfo>(startIndex, formattedFilterInfo);
    }

    private FormattedFilterInfo getFormattedFilters(Collection<String> orderByExpressionCollection, QueryItem[] orderByItems, Collection<SortOrder> sortOrderCollection, boolean inclusive) {
        String orderByItemToString;
        SortOrder sortOrder;
        String expression;
        SortOrder[] sortOrders = new SortOrder[sortOrderCollection.size()];
        sortOrderCollection.toArray(sortOrders);
        String[] expressions = new String[orderByExpressionCollection.size()];
        orderByExpressionCollection.toArray(expressions);
        if (expressions.length != sortOrders.length) {
            throw new IllegalArgumentException("expressions.size() != sortOrders.size()");
        }
        if (expressions.length != orderByItems.length) {
            throw new IllegalArgumentException("expressions.size() != orderByItems.length");
        }
        int numOrderByItems = expressions.length;
        boolean isSingleOrderBy = numOrderByItems == 1;
        StringBuilder left = new StringBuilder();
        StringBuilder target = new StringBuilder();
        StringBuilder right = new StringBuilder();
        if (isSingleOrderBy) {
            expression = expressions[0];
            sortOrder = sortOrders[0];
            QueryItem orderByItem = orderByItems[0];
            Object rawItem = orderByItem.getItem();
            orderByItemToString = rawItem instanceof String ? "\"" + rawItem.toString().replaceAll("\"", "\\\"") + "\"" : rawItem.toString();
            left.append(String.format("%s %s %s", expression, sortOrder == SortOrder.Descending ? "<" : ">", orderByItemToString));
            if (inclusive) {
                target.append(String.format("%s %s %s", expression, sortOrder == SortOrder.Descending ? "<=" : ">=", orderByItemToString));
            } else {
                target.append(String.format("%s %s %s", expression, sortOrder == SortOrder.Descending ? "<" : ">", orderByItemToString));
            }
        } else {
            throw new NotImplementedException("Resuming a multi order by query from a continuation token is not supported yet.");
        }
        right.append(String.format("%s %s %s", expression, sortOrder == SortOrder.Descending ? "<=" : ">=", orderByItemToString));
        return new FormattedFilterInfo(left.toString(), target.toString(), right.toString());
    }

    @Override
    protected OrderByDocumentProducer<T> createDocumentProducer(String collectionRid, PartitionKeyRange targetRange, String continuationToken, int initialPageSize, CosmosQueryRequestOptions cosmosQueryRequestOptions, SqlQuerySpec querySpecForInit, Map<String, String> commonRequestHeaders, TriFunction<PartitionKeyRange, String, Integer, RxDocumentServiceRequest> createRequestFunc, Function<RxDocumentServiceRequest, Mono<FeedResponse<T>>> executeFunc, Callable<DocumentClientRetryPolicy> createRetryPolicyFunc) {
        return new OrderByDocumentProducer<T>(this.consumeComparer, this.client, collectionRid, cosmosQueryRequestOptions, createRequestFunc, executeFunc, targetRange, collectionRid, () -> this.client.getResetSessionTokenRetryPolicy().getRequestPolicy(), this.resourceType, this.correlatedActivityId, initialPageSize, continuationToken, this.top, this.targetRangeToOrderByContinuationTokenMap);
    }

    @Override
    public Flux<FeedResponse<T>> drainAsync(int maxPageSize) {
        return this.orderByObservable.compose(new ItemToPageTransformer(this.tracker, maxPageSize, this.queryMetricMap, this::getContinuationToken));
    }

    @Override
    public Flux<FeedResponse<T>> executeAsync() {
        return this.drainAsync(ModelBridgeInternal.getMaxItemCountFromQueryRequestOptions(this.cosmosQueryRequestOptions));
    }

    private String getContinuationToken(OrderByRowResult<T> orderByRowResult) {
        String rid = orderByRowResult.getResourceId();
        String backendContinuationToken = orderByRowResult.getSourceBackendContinuationToken();
        Range<String> range = orderByRowResult.getSourcePartitionKeyRange().toRange();
        boolean inclusive = true;
        CompositeContinuationToken compositeContinuationToken = new CompositeContinuationToken(backendContinuationToken, range);
        QueryItem[] orderByItems = new QueryItem[orderByRowResult.getOrderByItems().size()];
        orderByRowResult.getOrderByItems().toArray(orderByItems);
        return new OrderByContinuationToken(compositeContinuationToken, orderByItems, rid, inclusive).toJson();
    }

    private final class FormattedFilterInfo {
        private final String filterForRangesLeftOfTheTargetRange;
        private final String filterForTargetRange;
        private final String filterForRangesRightOfTheTargetRange;

        public FormattedFilterInfo(String filterForRangesLeftOfTheTargetRange, String filterForTargetRange, String filterForRangesRightOfTheTargetRange) {
            if (filterForRangesLeftOfTheTargetRange == null) {
                throw new IllegalArgumentException("filterForRangesLeftOfTheTargetRange must not be null.");
            }
            if (filterForTargetRange == null) {
                throw new IllegalArgumentException("filterForTargetRange must not be null.");
            }
            if (filterForRangesRightOfTheTargetRange == null) {
                throw new IllegalArgumentException("filterForRangesRightOfTheTargetRange must not be null.");
            }
            this.filterForRangesLeftOfTheTargetRange = filterForRangesLeftOfTheTargetRange;
            this.filterForTargetRange = filterForTargetRange;
            this.filterForRangesRightOfTheTargetRange = filterForRangesRightOfTheTargetRange;
        }

        public String getFilterForRangesLeftOfTheTargetRange() {
            return this.filterForRangesLeftOfTheTargetRange;
        }

        public String getFilterForTargetRange() {
            return this.filterForTargetRange;
        }

        public String getFilterForRangesRightOfTheTargetRange() {
            return this.filterForRangesRightOfTheTargetRange;
        }
    }

    private static class ItemToPageTransformer<T extends Resource>
    implements Function<Flux<OrderByRowResult<T>>, Flux<FeedResponse<T>>> {
        private static final int DEFAULT_PAGE_SIZE = 100;
        private final RequestChargeTracker tracker;
        private final int maxPageSize;
        private final ConcurrentMap<String, QueryMetrics> queryMetricMap;
        private final Function<OrderByRowResult<T>, String> orderByContinuationTokenCallback;
        private volatile FeedResponse<OrderByRowResult<T>> previousPage;

        public ItemToPageTransformer(RequestChargeTracker tracker, int maxPageSize, ConcurrentMap<String, QueryMetrics> queryMetricsMap, Function<OrderByRowResult<T>, String> orderByContinuationTokenCallback) {
            this.tracker = tracker;
            this.maxPageSize = maxPageSize > 0 ? maxPageSize : 100;
            this.queryMetricMap = queryMetricsMap;
            this.orderByContinuationTokenCallback = orderByContinuationTokenCallback;
            this.previousPage = null;
        }

        private static Map<String, String> headerResponse(double requestCharge) {
            return Utils.immutableMapOf("x-ms-request-charge", String.valueOf(requestCharge));
        }

        private FeedResponse<OrderByRowResult<T>> addOrderByContinuationToken(FeedResponse<OrderByRowResult<T>> page, String orderByContinuationToken) {
            HashMap<String, String> headers = new HashMap<String, String>(page.getResponseHeaders());
            headers.put("x-ms-continuation", orderByContinuationToken);
            return BridgeInternal.createFeedResponseWithQueryMetrics(page.getResults(), headers, BridgeInternal.queryMetricsFromFeedResponse(page));
        }

        @Override
        public Flux<FeedResponse<T>> apply(Flux<OrderByRowResult<T>> source) {
            return source.window(this.maxPageSize).map(Flux::collectList).flatMap(resultListObs -> resultListObs, 1).map(orderByRowResults -> {
                FeedResponse feedResponse = BridgeInternal.createFeedResponse(orderByRowResults, ItemToPageTransformer.headerResponse(this.tracker.getAndResetCharge()));
                if (!this.queryMetricMap.isEmpty()) {
                    for (Map.Entry entry : this.queryMetricMap.entrySet()) {
                        BridgeInternal.putQueryMetricsIntoMap(feedResponse, (String)entry.getKey(), (QueryMetrics)entry.getValue());
                    }
                }
                return feedResponse;
            }).concatWith((Publisher)Flux.defer(() -> Flux.just(BridgeInternal.createFeedResponse(Utils.immutableListOf(), null)))).map(orderByRowResults -> {
                ImmutablePair<FeedResponse<OrderByRowResult<T>>, FeedResponse> previousCurrent = new ImmutablePair<FeedResponse<OrderByRowResult<T>>, FeedResponse>(this.previousPage, (FeedResponse)orderByRowResults);
                this.previousPage = orderByRowResults;
                return previousCurrent;
            }).skip(1L).map(currentNext -> {
                FeedResponse<OrderByRowResult<T>> page;
                FeedResponse<OrderByRowResult<T>> current = (FeedResponse<OrderByRowResult<T>>)currentNext.left;
                FeedResponse next = (FeedResponse)currentNext.right;
                if (next.getResults().size() == 0) {
                    page = current;
                    page = this.addOrderByContinuationToken(page, null);
                } else {
                    page = current;
                    List results = next.getResults();
                    OrderByRowResult firstElementInNextPage = (OrderByRowResult)results.get(0);
                    String orderByContinuationToken = this.orderByContinuationTokenCallback.apply(firstElementInNextPage);
                    page = this.addOrderByContinuationToken(page, orderByContinuationToken);
                }
                return page;
            }).map(feedOfOrderByRowResults -> {
                ArrayList<Resource> unwrappedResults = new ArrayList<Resource>();
                for (OrderByRowResult orderByRowResult : feedOfOrderByRowResults.getResults()) {
                    unwrappedResults.add((Resource)orderByRowResult.getPayload());
                }
                return BridgeInternal.createFeedResponseWithQueryMetrics(unwrappedResults, feedOfOrderByRowResults.getResponseHeaders(), BridgeInternal.queryMetricsFromFeedResponse(feedOfOrderByRowResults));
            }).switchIfEmpty((Publisher)Flux.defer(() -> Flux.just(BridgeInternal.createFeedResponse(Utils.immutableListOf(), ItemToPageTransformer.headerResponse(this.tracker.getAndResetCharge())))));
        }
    }
}

