/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.models.CompositePathSortOrder;
import com.fasterxml.jackson.databind.node.ObjectNode;

public final class CompositePath {
    private JsonSerializable jsonSerializable;

    public CompositePath() {
        this.jsonSerializable = new JsonSerializable();
    }

    CompositePath(String jsonString) {
        this.jsonSerializable = new JsonSerializable(jsonString);
    }

    CompositePath(ObjectNode objectNode) {
        this.jsonSerializable = new JsonSerializable(objectNode);
    }

    public String getPath() {
        return this.jsonSerializable.getString("path");
    }

    public CompositePath setPath(String path) {
        this.jsonSerializable = new JsonSerializable();
        this.jsonSerializable.set("path", path);
        return this;
    }

    public CompositePathSortOrder getOrder() {
        String strValue = this.jsonSerializable.getString("order");
        if (!StringUtils.isEmpty(strValue)) {
            try {
                return CompositePathSortOrder.valueOf(StringUtils.upperCase(this.jsonSerializable.getString("order")));
            }
            catch (IllegalArgumentException e) {
                this.jsonSerializable.getLogger().warn("INVALID getIndexingMode getValue {}.", (Object)this.jsonSerializable.getString("order"));
                return CompositePathSortOrder.ASCENDING;
            }
        }
        return CompositePathSortOrder.ASCENDING;
    }

    public CompositePath setOrder(CompositePathSortOrder order) {
        this.jsonSerializable.set("order", order.toString());
        return this;
    }

    void populatePropertyBag() {
        this.jsonSerializable.populatePropertyBag();
    }

    JsonSerializable getJsonSerializable() {
        return this.jsonSerializable;
    }
}

