/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.core.credential.AzureKeyCredential;
import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.implementation.ChangeFeedOptions;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.Conflict;
import com.azure.cosmos.implementation.ConnectionPolicy;
import com.azure.cosmos.implementation.CosmosAuthorizationTokenResolver;
import com.azure.cosmos.implementation.Database;
import com.azure.cosmos.implementation.DatabaseAccount;
import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.ItemDeserializer;
import com.azure.cosmos.implementation.Offer;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.Permission;
import com.azure.cosmos.implementation.RequestOptions;
import com.azure.cosmos.implementation.ResourceResponse;
import com.azure.cosmos.implementation.RxDocumentClientImpl;
import com.azure.cosmos.implementation.StoredProcedure;
import com.azure.cosmos.implementation.StoredProcedureResponse;
import com.azure.cosmos.implementation.Trigger;
import com.azure.cosmos.implementation.User;
import com.azure.cosmos.implementation.UserDefinedFunction;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.apachecommons.lang.tuple.Pair;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.SqlQuerySpec;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface AsyncDocumentClient {
    public URI getServiceEndpoint();

    public URI getWriteEndpoint();

    public URI getReadEndpoint();

    public ConsistencyLevel getConsistencyLevel();

    public boolean isContentResponseOnWriteEnabled();

    public ConnectionPolicy getConnectionPolicy();

    public Mono<ResourceResponse<Database>> createDatabase(Database var1, RequestOptions var2);

    public Mono<ResourceResponse<Database>> deleteDatabase(String var1, RequestOptions var2);

    public Mono<ResourceResponse<Database>> readDatabase(String var1, RequestOptions var2);

    public Flux<FeedResponse<Database>> readDatabases(CosmosQueryRequestOptions var1);

    public Flux<FeedResponse<Database>> queryDatabases(String var1, CosmosQueryRequestOptions var2);

    public Flux<FeedResponse<Database>> queryDatabases(SqlQuerySpec var1, CosmosQueryRequestOptions var2);

    public Mono<ResourceResponse<DocumentCollection>> createCollection(String var1, DocumentCollection var2, RequestOptions var3);

    public Mono<ResourceResponse<DocumentCollection>> replaceCollection(DocumentCollection var1, RequestOptions var2);

    public Mono<ResourceResponse<DocumentCollection>> deleteCollection(String var1, RequestOptions var2);

    public Mono<ResourceResponse<DocumentCollection>> readCollection(String var1, RequestOptions var2);

    public Flux<FeedResponse<DocumentCollection>> readCollections(String var1, CosmosQueryRequestOptions var2);

    public Flux<FeedResponse<DocumentCollection>> queryCollections(String var1, String var2, CosmosQueryRequestOptions var3);

    public Flux<FeedResponse<DocumentCollection>> queryCollections(String var1, SqlQuerySpec var2, CosmosQueryRequestOptions var3);

    public Mono<ResourceResponse<Document>> createDocument(String var1, Object var2, RequestOptions var3, boolean var4);

    public Mono<ResourceResponse<Document>> upsertDocument(String var1, Object var2, RequestOptions var3, boolean var4);

    public Mono<ResourceResponse<Document>> replaceDocument(String var1, Object var2, RequestOptions var3);

    public Mono<ResourceResponse<Document>> replaceDocument(Document var1, RequestOptions var2);

    public Mono<ResourceResponse<Document>> deleteDocument(String var1, RequestOptions var2);

    public Mono<ResourceResponse<Document>> readDocument(String var1, RequestOptions var2);

    public Flux<FeedResponse<Document>> readDocuments(String var1, CosmosQueryRequestOptions var2);

    public Flux<FeedResponse<Document>> queryDocuments(String var1, String var2, CosmosQueryRequestOptions var3);

    public Flux<FeedResponse<Document>> queryDocuments(String var1, SqlQuerySpec var2, CosmosQueryRequestOptions var3);

    public Flux<FeedResponse<Document>> queryDocumentChangeFeed(String var1, ChangeFeedOptions var2);

    public Flux<FeedResponse<PartitionKeyRange>> readPartitionKeyRanges(String var1, CosmosQueryRequestOptions var2);

    public Mono<ResourceResponse<StoredProcedure>> createStoredProcedure(String var1, StoredProcedure var2, RequestOptions var3);

    public Mono<ResourceResponse<StoredProcedure>> upsertStoredProcedure(String var1, StoredProcedure var2, RequestOptions var3);

    public Mono<ResourceResponse<StoredProcedure>> replaceStoredProcedure(StoredProcedure var1, RequestOptions var2);

    public Mono<ResourceResponse<StoredProcedure>> deleteStoredProcedure(String var1, RequestOptions var2);

    public Mono<ResourceResponse<StoredProcedure>> readStoredProcedure(String var1, RequestOptions var2);

    public Flux<FeedResponse<StoredProcedure>> readStoredProcedures(String var1, CosmosQueryRequestOptions var2);

    public Flux<FeedResponse<StoredProcedure>> queryStoredProcedures(String var1, String var2, CosmosQueryRequestOptions var3);

    public Flux<FeedResponse<StoredProcedure>> queryStoredProcedures(String var1, SqlQuerySpec var2, CosmosQueryRequestOptions var3);

    public Mono<StoredProcedureResponse> executeStoredProcedure(String var1, List<Object> var2);

    public Mono<StoredProcedureResponse> executeStoredProcedure(String var1, RequestOptions var2, List<Object> var3);

    public Mono<ResourceResponse<Trigger>> createTrigger(String var1, Trigger var2, RequestOptions var3);

    public Mono<ResourceResponse<Trigger>> upsertTrigger(String var1, Trigger var2, RequestOptions var3);

    public Mono<ResourceResponse<Trigger>> replaceTrigger(Trigger var1, RequestOptions var2);

    public Mono<ResourceResponse<Trigger>> deleteTrigger(String var1, RequestOptions var2);

    public Mono<ResourceResponse<Trigger>> readTrigger(String var1, RequestOptions var2);

    public Flux<FeedResponse<Trigger>> readTriggers(String var1, CosmosQueryRequestOptions var2);

    public Flux<FeedResponse<Trigger>> queryTriggers(String var1, String var2, CosmosQueryRequestOptions var3);

    public Flux<FeedResponse<Trigger>> queryTriggers(String var1, SqlQuerySpec var2, CosmosQueryRequestOptions var3);

    public Mono<ResourceResponse<UserDefinedFunction>> createUserDefinedFunction(String var1, UserDefinedFunction var2, RequestOptions var3);

    public Mono<ResourceResponse<UserDefinedFunction>> upsertUserDefinedFunction(String var1, UserDefinedFunction var2, RequestOptions var3);

    public Mono<ResourceResponse<UserDefinedFunction>> replaceUserDefinedFunction(UserDefinedFunction var1, RequestOptions var2);

    public Mono<ResourceResponse<UserDefinedFunction>> deleteUserDefinedFunction(String var1, RequestOptions var2);

    public Mono<ResourceResponse<UserDefinedFunction>> readUserDefinedFunction(String var1, RequestOptions var2);

    public Flux<FeedResponse<UserDefinedFunction>> readUserDefinedFunctions(String var1, CosmosQueryRequestOptions var2);

    public Flux<FeedResponse<UserDefinedFunction>> queryUserDefinedFunctions(String var1, String var2, CosmosQueryRequestOptions var3);

    public Flux<FeedResponse<UserDefinedFunction>> queryUserDefinedFunctions(String var1, SqlQuerySpec var2, CosmosQueryRequestOptions var3);

    public Mono<ResourceResponse<Conflict>> readConflict(String var1, RequestOptions var2);

    public Flux<FeedResponse<Conflict>> readConflicts(String var1, CosmosQueryRequestOptions var2);

    public Flux<FeedResponse<Conflict>> queryConflicts(String var1, String var2, CosmosQueryRequestOptions var3);

    public Flux<FeedResponse<Conflict>> queryConflicts(String var1, SqlQuerySpec var2, CosmosQueryRequestOptions var3);

    public Mono<ResourceResponse<Conflict>> deleteConflict(String var1, RequestOptions var2);

    public Mono<ResourceResponse<User>> createUser(String var1, User var2, RequestOptions var3);

    public Mono<ResourceResponse<User>> upsertUser(String var1, User var2, RequestOptions var3);

    public Mono<ResourceResponse<User>> replaceUser(User var1, RequestOptions var2);

    public Mono<ResourceResponse<User>> deleteUser(String var1, RequestOptions var2);

    public Mono<ResourceResponse<User>> readUser(String var1, RequestOptions var2);

    public Flux<FeedResponse<User>> readUsers(String var1, CosmosQueryRequestOptions var2);

    public Flux<FeedResponse<User>> queryUsers(String var1, String var2, CosmosQueryRequestOptions var3);

    public Flux<FeedResponse<User>> queryUsers(String var1, SqlQuerySpec var2, CosmosQueryRequestOptions var3);

    public Mono<ResourceResponse<Permission>> createPermission(String var1, Permission var2, RequestOptions var3);

    public Mono<ResourceResponse<Permission>> upsertPermission(String var1, Permission var2, RequestOptions var3);

    public Mono<ResourceResponse<Permission>> replacePermission(Permission var1, RequestOptions var2);

    public Mono<ResourceResponse<Permission>> deletePermission(String var1, RequestOptions var2);

    public Mono<ResourceResponse<Permission>> readPermission(String var1, RequestOptions var2);

    public Flux<FeedResponse<Permission>> readPermissions(String var1, CosmosQueryRequestOptions var2);

    public Flux<FeedResponse<Permission>> queryPermissions(String var1, String var2, CosmosQueryRequestOptions var3);

    public Flux<FeedResponse<Permission>> queryPermissions(String var1, SqlQuerySpec var2, CosmosQueryRequestOptions var3);

    public Mono<ResourceResponse<Offer>> replaceOffer(Offer var1);

    public Mono<ResourceResponse<Offer>> readOffer(String var1);

    public Flux<FeedResponse<Offer>> readOffers(CosmosQueryRequestOptions var1);

    public Flux<FeedResponse<Offer>> queryOffers(String var1, CosmosQueryRequestOptions var2);

    public Flux<FeedResponse<Offer>> queryOffers(SqlQuerySpec var1, CosmosQueryRequestOptions var2);

    public Mono<DatabaseAccount> getDatabaseAccount();

    public <T> Mono<FeedResponse<T>> readMany(List<Pair<String, PartitionKey>> var1, String var2, CosmosQueryRequestOptions var3, Class<T> var4);

    public void close();

    public ItemDeserializer getItemDeserializer();

    public static class Builder {
        Configs configs = new Configs();
        ConnectionPolicy connectionPolicy;
        ConsistencyLevel desiredConsistencyLevel;
        List<Permission> permissionFeed;
        String masterKeyOrResourceToken;
        URI serviceEndpoint;
        CosmosAuthorizationTokenResolver cosmosAuthorizationTokenResolver;
        AzureKeyCredential credential;
        boolean sessionCapturingOverride;
        boolean transportClientSharing;
        boolean contentResponseOnWriteEnabled;

        public Builder withServiceEndpoint(String serviceEndpoint) {
            try {
                this.serviceEndpoint = new URI(serviceEndpoint);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            return this;
        }

        @Deprecated
        public Builder withMasterKey(String masterKeyOrResourceToken) {
            this.masterKeyOrResourceToken = masterKeyOrResourceToken;
            return this;
        }

        public Builder withMasterKeyOrResourceToken(String masterKeyOrResourceToken) {
            this.masterKeyOrResourceToken = masterKeyOrResourceToken;
            return this;
        }

        public Builder withPermissionFeed(List<Permission> permissionFeed) {
            this.permissionFeed = permissionFeed;
            return this;
        }

        public Builder withConsistencyLevel(ConsistencyLevel desiredConsistencyLevel) {
            this.desiredConsistencyLevel = desiredConsistencyLevel;
            return this;
        }

        public Builder withConfigs(Configs configs) {
            this.configs = configs;
            return this;
        }

        public Builder withSessionCapturingOverride(boolean sessionCapturingOverride) {
            this.sessionCapturingOverride = sessionCapturingOverride;
            return this;
        }

        public Builder withConnectionPolicy(ConnectionPolicy connectionPolicy) {
            this.connectionPolicy = connectionPolicy;
            return this;
        }

        public Builder withTransportClientSharing(boolean transportClientSharing) {
            this.transportClientSharing = transportClientSharing;
            return this;
        }

        public Builder withCredential(AzureKeyCredential credential) {
            if (credential != null && StringUtils.isEmpty(credential.getKey())) {
                throw new IllegalArgumentException("Cannot buildAsyncClient client with empty key credential");
            }
            this.credential = credential;
            return this;
        }

        public Builder withContentResponseOnWriteEnabled(boolean contentResponseOnWriteEnabled) {
            this.contentResponseOnWriteEnabled = contentResponseOnWriteEnabled;
            return this;
        }

        public Builder withTokenResolver(CosmosAuthorizationTokenResolver cosmosAuthorizationTokenResolver) {
            this.cosmosAuthorizationTokenResolver = cosmosAuthorizationTokenResolver;
            return this;
        }

        private void ifThrowIllegalArgException(boolean value, String error) {
            if (value) {
                throw new IllegalArgumentException(error);
            }
        }

        public AsyncDocumentClient build() {
            this.ifThrowIllegalArgException(this.serviceEndpoint == null, "cannot buildAsyncClient client without service endpoint");
            this.ifThrowIllegalArgException(this.masterKeyOrResourceToken == null && (this.permissionFeed == null || this.permissionFeed.isEmpty()) && this.credential == null, "cannot buildAsyncClient client without any one of masterKey, resource token, permissionFeed and azure key credential");
            this.ifThrowIllegalArgException(this.credential != null && StringUtils.isEmpty(this.credential.getKey()), "cannot buildAsyncClient client without key credential");
            RxDocumentClientImpl client = new RxDocumentClientImpl(this.serviceEndpoint, this.masterKeyOrResourceToken, this.permissionFeed, this.connectionPolicy, this.desiredConsistencyLevel, this.configs, this.cosmosAuthorizationTokenResolver, this.credential, this.sessionCapturingOverride, this.transportClientSharing, this.contentResponseOnWriteEnabled);
            client.init();
            return client;
        }

        public Configs getConfigs() {
            return this.configs;
        }

        public void setConfigs(Configs configs) {
            this.configs = configs;
        }

        public ConnectionPolicy getConnectionPolicy() {
            return this.connectionPolicy;
        }

        public void setConnectionPolicy(ConnectionPolicy connectionPolicy) {
            this.connectionPolicy = connectionPolicy;
        }

        public ConsistencyLevel getDesiredConsistencyLevel() {
            return this.desiredConsistencyLevel;
        }

        public void setDesiredConsistencyLevel(ConsistencyLevel desiredConsistencyLevel) {
            this.desiredConsistencyLevel = desiredConsistencyLevel;
        }

        public List<Permission> getPermissionFeed() {
            return this.permissionFeed;
        }

        public void setPermissionFeed(List<Permission> permissionFeed) {
            this.permissionFeed = permissionFeed;
        }

        public String getMasterKeyOrResourceToken() {
            return this.masterKeyOrResourceToken;
        }

        public void setMasterKeyOrResourceToken(String masterKeyOrResourceToken) {
            this.masterKeyOrResourceToken = masterKeyOrResourceToken;
        }

        public URI getServiceEndpoint() {
            return this.serviceEndpoint;
        }

        public void setServiceEndpoint(URI serviceEndpoint) {
            this.serviceEndpoint = serviceEndpoint;
        }

        public CosmosAuthorizationTokenResolver getCosmosAuthorizationTokenResolver() {
            return this.cosmosAuthorizationTokenResolver;
        }

        public void setCosmosAuthorizationTokenResolver(CosmosAuthorizationTokenResolver cosmosAuthorizationTokenResolver) {
            this.cosmosAuthorizationTokenResolver = cosmosAuthorizationTokenResolver;
        }

        public AzureKeyCredential getCredential() {
            return this.credential;
        }
    }
}

